/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import java.util.Optional;
import org.compiere.model.I_C_Project;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.eevolution.model.MProjectMember;
import org.eevolution.process.ProcessingUserSelectionAbstract;

public class ProcessingUserSelection
extends ProcessingUserSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MUser> users = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getProcessInfo().getTable_ID() == I_C_Project.Table_ID) {
            this.createProjectMembers(users);
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.updatingUserProperties(users);
        }
        return "";
    }

    private void updatingUserProperties(List<MUser> users) {
        users.stream().filter(user -> user != null).forEach(user -> {
            int columns = user.get_ColumnCount();
            for (int index = 0; index < columns; ++index) {
                String columnName = user.get_ColumnName(index);
                Optional.ofNullable(this.getSelection(user.get_ID(), this.getPrefixAliasForTableSelection() + columnName)).ifPresent(value -> user.set_ValueOfColumn(columnName, value));
            }
            if (user.is_Changed()) {
                user.saveEx();
            }
        });
    }

    private void createProjectMembers(List<MUser> users) {
        users.stream().filter(user -> user != null).forEach(user -> {
            List projectMembers = new Query(this.getCtx(), "C_ProjectMember", "C_Project_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getRecord_ID()).list();
            if (!projectMembers.stream().anyMatch(projectMember -> projectMember.getAD_User_ID() == user.get_ID())) {
                MProjectMember projectMember2 = new MProjectMember(this.getCtx(), 0, this.get_TrxName());
                projectMember2.setC_Project_ID(this.getRecord_ID());
                projectMember2.setIsActive(true);
                projectMember2.setAD_User_ID(user.get_ID());
                projectMember2.setNotificationType(user.getNotificationType());
                projectMember2.saveEx();
            }
        });
    }
}

