/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MQuery;
import org.compiere.model.MSession;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Session;
import org.compiere.model.X_C_Invoice;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.I_HR_Employee;
import org.eevolution.model.I_HR_Process;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.X_HR_Movement;
import org.eevolution.process.HRGenerateInvoiceFromProcessAbstract;

public class HRGenerateInvoiceFromProcess
extends HRGenerateInvoiceFromProcessAbstract {
    private int count = 0;
    private HashMap<Integer, MInvoice> invoices = new HashMap();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        Serializable serializable;
        Object object;
        PO pO2;
        MBPartner mBPartner = null;
        if (this.getBPartnerId() > 0) {
            mBPartner = new MBPartner(this.getCtx(), this.getBPartnerId(), this.get_TrxName());
        }
        List<?> list = this.getInstancesForSelection(this.get_TrxName());
        for (PO pO2 : list) {
            if (this.getBPartnerId() <= 0) {
                mBPartner = MBPartner.get(this.getCtx(), ((X_HR_Movement)pO2).getC_BPartner_ID());
            }
            if (((X_HR_Movement)pO2).getC_BP_Relation_ID() > 0) {
                object = ((X_HR_Movement)pO2).getC_BP_Relation();
                mBPartner = MBPartner.get(this.getCtx(), object.getC_BPartnerRelation_ID());
            }
            object = ((X_HR_Movement)pO2).getHR_Employee();
            if (!this.invoices.containsKey(mBPartner.get_ID())) {
                serializable = this.createInvoice(((X_HR_Movement)pO2).getHR_Process(), mBPartner, (I_HR_Employee)object, this.getDocTypeId(), this.getDateInvoiced());
                this.invoices.put(((X_C_Invoice)serializable).getC_BPartner_ID(), (MInvoice)serializable);
            }
            this.createInvoiceLine(this.invoices.get(mBPartner.get_ID()), (I_HR_Employee)object, (MHRMovement)pO2, this.getChargeId());
        }
        if ("CO".equals(this.getDocAction())) {
            this.invoices.entrySet().forEach(entry -> {
                MInvoice mInvoice = (MInvoice)entry.getValue();
                mInvoice.processIt(this.getDocAction());
                mInvoice.saveEx();
            });
        }
        int n = Env.getContextAsInt(this.getCtx(), "AD_Session_ID");
        pO2 = new MSession(this.getCtx(), n, null);
        if ((((X_AD_Session)pO2).getWebSession() == null || ((X_AD_Session)pO2).getWebSession().length() == 0) && this.invoices.size() > 0) {
            this.commitEx();
            object = new StringBuilder();
            this.invoices.entrySet().forEach(arg_0 -> HRGenerateInvoiceFromProcess.lambda$doIt$1((StringBuilder)object, arg_0));
            serializable = new StringBuilder("C_Invoice_ID IN (");
            ((StringBuilder)serializable).append(((StringBuilder)object).substring(0, ((StringBuilder)object).length() - 1)).append(")");
            MTable mTable = new MTable(this.getCtx(), MInvoice.Table_ID, this.get_TrxName());
            MQuery mQuery = new MQuery();
            mQuery.addRestriction(((StringBuilder)serializable).toString());
            mQuery.setRecordCount(this.count);
            int n2 = mTable.getPO_Window_ID();
            this.zoom(n2, mQuery);
        }
        return "@OK@";
    }

    private MInvoice createInvoice(I_HR_Process i_HR_Process, MBPartner mBPartner, I_HR_Employee i_HR_Employee, int n, Timestamp timestamp) {
        Object object;
        int n2 = 0;
        if (this.getBPartnerLocationId() > 0) {
            n2 = this.getBPartnerLocationId();
        } else {
            object = this.getLocationBill(mBPartner);
            if (object == null) {
                this.log.log(Level.SEVERE, " @C_BPartner_Location_ID@ @NotFound@ : " + mBPartner.getName());
                this.addLog(0, i_HR_Process.getDateAcct(), null, "@Bill_Location_ID@ @NotFound@ " + i_HR_Process.getDocumentNo() + " " + mBPartner.getName());
                return null;
            }
            n2 = ((PO)object).get_ID();
        }
        Object object2 = object = i_HR_Employee != null ? i_HR_Employee.getPaymentRule() : null;
        if (object == null || ((String)object).isEmpty()) {
            object = mBPartner.getPaymentRulePO();
        }
        if (object == null) {
            this.log.log(Level.SEVERE, " @PaymentRule@ @NotFound@ : " + mBPartner.getName());
            this.addLog(0, i_HR_Process.getDateAcct(), null, "@PaymentRule@ @NotFound@ " + i_HR_Process.getDocumentNo() + " " + i_HR_Process.getName() + " " + mBPartner.getValue() + " " + mBPartner.getName());
            return null;
        }
        this.log.info("New Invoice for ");
        MDocType mDocType = MDocType.get(this.getCtx(), n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Msg.parseTranslation(this.getCtx(), "@HR_Process_ID@ " + i_HR_Process.getName() + " @DocumentNo@ " + i_HR_Process.getDocumentNo() + " @HR_Employee_ID@ " + i_HR_Employee.getName()));
        MInvoice mInvoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        mInvoice.setAD_Org_ID(i_HR_Process.getAD_Org_ID());
        mInvoice.setIsSOTrx(mDocType.isSOTrx());
        mInvoice.setPaymentRule((String)object);
        mInvoice.setC_DocTypeTarget_ID(n);
        mInvoice.setC_DocType_ID(n);
        mInvoice.setDescription(stringBuilder.toString());
        mInvoice.setDateOrdered(timestamp);
        mInvoice.setDateInvoiced(timestamp);
        mInvoice.setDateAcct(timestamp);
        mInvoice.setBPartner(mBPartner);
        mInvoice.setC_BPartner_Location_ID(n2);
        MPaymentTerm mPaymentTerm = MPaymentTerm.getPaymentTermByDefault(this.getCtx(), mBPartner.get_TrxName());
        if (mPaymentTerm != null) {
            mInvoice.setC_PaymentTerm_ID(mPaymentTerm.getC_PaymentTerm_ID());
        }
        if (i_HR_Employee != null && i_HR_Employee.getC_Activity_ID() != 0) {
            mInvoice.setC_Activity_ID(i_HR_Employee.getC_Activity_ID());
        }
        mInvoice.setDocStatus("DR");
        mInvoice.setDocAction("--");
        mInvoice.setSalesRep_ID(this.getAD_User_ID());
        mInvoice.saveEx();
        this.count = this.count++;
        this.addLog(0, mInvoice.getDateInvoiced(), mInvoice.getGrandTotal(), "@C_Invoice_ID@ " + mInvoice.getDocumentNo() + " @C_BPartner_ID@  @TaxId@ " + mInvoice.getC_BPartner().getValue() + " @Name@ " + mInvoice.getC_BPartner().getName());
        return mInvoice;
    }

    private MInvoiceLine createInvoiceLine(MInvoice mInvoice, I_HR_Employee i_HR_Employee, MHRMovement mHRMovement, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Msg.parseTranslation(mInvoice.getCtx(), "@HR_Employee_ID@ " + i_HR_Employee.getName() + " @HR_Concept_ID@ " + mHRMovement.getHR_Concept().getName()));
        MInvoiceLine mInvoiceLine = new MInvoiceLine(mInvoice);
        mInvoiceLine.setC_Charge_ID(n);
        mInvoiceLine.setQty(BigDecimal.ONE);
        mInvoiceLine.setDescription(stringBuilder.toString());
        mInvoiceLine.setC_Activity_ID(mHRMovement.getC_Activity_ID());
        mInvoiceLine.setC_Campaign_ID(mHRMovement.getC_Campaign_ID());
        mInvoiceLine.setAD_OrgTrx_ID(mHRMovement.getAD_OrgTrx_ID());
        mInvoiceLine.setC_Project_ID(mHRMovement.getC_Project_ID());
        mInvoiceLine.setC_ProjectPhase_ID(mHRMovement.getC_ProjectPhase_ID());
        mInvoiceLine.setC_ProjectTask_ID(mHRMovement.getC_ProjectTask_ID());
        mInvoiceLine.setUser1_ID(mHRMovement.getUser1_ID());
        mInvoiceLine.setUser2_ID(mHRMovement.getUser2_ID());
        mInvoiceLine.setUser3_ID(mHRMovement.getUser3_ID());
        mInvoiceLine.setUser4_ID(mHRMovement.getUser4_ID());
        mInvoiceLine.setPrice(mHRMovement.getAmount());
        mInvoiceLine.setTax();
        mInvoiceLine.saveEx();
        this.addLog(mInvoiceLine.getLine(), mInvoice.getDateInvoiced(), mInvoiceLine.getLineNetAmt(), stringBuilder.toString());
        mHRMovement.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
        mHRMovement.saveEx();
        return mInvoiceLine;
    }

    private MBPartnerLocation getLocationBill(MBPartner mBPartner) {
        String string = "C_BPartner_ID=? AND IsBillTo=? AND IsActive=?";
        return (MBPartnerLocation)new Query(mBPartner.getCtx(), "C_BPartner_Location", string, mBPartner.get_TrxName()).setClient_ID().setParameters(mBPartner.getC_BPartner_ID(), true, true).first();
    }

    protected void zoom(int n, MQuery mQuery) {
        final AWindow aWindow = new AWindow();
        if (!aWindow.initWindow(n, mQuery)) {
            return;
        }
        AEnv.addToWindowManager(aWindow);
        new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AEnv.showCenterScreen(aWindow);
            }
        }.start();
    }

    private static /* synthetic */ void lambda$doIt$1(StringBuilder stringBuilder, Map.Entry entry) {
        stringBuilder.append(entry.getKey()).append(",");
    }
}

