/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MStorage;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.eevolution.model.I_DD_Order;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.process.GenerateShipmentOutBoundAbstract;
import org.eevolution.process.MovementGenerate;
import org.eevolution.service.dsl.ProcessBuilder;

public class GenerateShipmentOutBound
extends GenerateShipmentOutBoundAbstract {
    private Hashtable<Integer, MInOut> shipments = new Hashtable();
    private Hashtable<Integer, I_DD_Order> distributionOrders = new Hashtable();
    private Hashtable<Integer, MPPCostCollector> manufacturingIssues = new Hashtable();
    private int documentCreated = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.getProcessInfo().setTableSelectionId(MWMInOutBoundLine.Table_ID);
        List<?> outBoundLines = this.getInstancesForSelection(this.get_TrxName());
        outBoundLines.stream().filter(outBoundLine -> outBoundLine.getQtyToDeliver().signum() > 0 || this.isIncludeNotAvailable()).forEach(outboindLine -> {
            int locatorId;
            int attributeSetInstanceId = this.getSelectionAsInt(outboindLine.getWM_InOutBoundLine_ID(), "WM_InOutBoundLine_M_AttributeSetInstance_ID");
            if (attributeSetInstanceId > 0 && outboindLine.getM_AttributeSetInstance_ID() <= 0) {
                outboindLine.setM_AttributeSetInstance_ID(attributeSetInstanceId);
            }
            if ((locatorId = this.getSelectionAsInt(outboindLine.getWM_InOutBoundLine_ID(), "WM_InOutBoundLine_M_LocatorTo_ID")) > 0) {
                outboindLine.setM_LocatorTo_ID(locatorId);
            }
            this.createShipment((MWMInOutBoundLine)outboindLine);
        });
        this.processingShipments();
        this.processingMovements();
        this.processingIssues();
        StringBuilder documentGenerated = new StringBuilder();
        this.shipments.forEach((key, value) -> documentGenerated.append(" , ").append(value.getDocumentInfo()));
        return "@Created@ " + this.documentCreated + documentGenerated.toString();
    }

    private void createShipment(MWMInOutBoundLine outboundLine) {
        if (outboundLine.getC_OrderLine_ID() > 0) {
            MOrderLine orderLine = outboundLine.getOrderLine();
            if (orderLine.getQtyOrdered().subtract(orderLine.getQtyDelivered()).subtract(outboundLine.getPickedQty()).signum() < 0 && !this.isIncludeNotAvailable()) {
                return;
            }
            BigDecimal qtyDelivered = outboundLine.getPickedQty();
            MInOut shipment = this.getShipment(orderLine, outboundLine.getParent());
            MInOutLine shipmentLine = new MInOutLine(outboundLine.getCtx(), 0, outboundLine.get_TrxName());
            shipmentLine.setM_InOut_ID(shipment.getM_InOut_ID());
            shipmentLine.setM_Locator_ID(outboundLine.getM_LocatorTo_ID());
            shipmentLine.setM_Product_ID(outboundLine.getM_Product_ID());
            shipmentLine.setC_UOM_ID(outboundLine.getC_UOM_ID());
            shipmentLine.setQtyEntered(qtyDelivered);
            shipmentLine.setMovementQty(qtyDelivered);
            shipmentLine.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
            shipmentLine.setM_Shipper_ID(outboundLine.getM_Shipper_ID());
            shipmentLine.setM_FreightCategory_ID(outboundLine.getM_FreightCategory_ID());
            shipmentLine.setFreightAmt(outboundLine.getFreightAmt());
            shipmentLine.setM_AttributeSetInstance_ID(outboundLine.getM_AttributeSetInstance_ID());
            shipmentLine.setWM_InOutBoundLine_ID(outboundLine.getWM_InOutBoundLine_ID());
            shipmentLine.saveEx();
        }
        if (outboundLine.getDD_OrderLine_ID() > 0) {
            MDDOrderLine distributionOrderLine = (MDDOrderLine)outboundLine.getDD_OrderLine();
            if (this.distributionOrders.get(distributionOrderLine.getDD_Order_ID()) == null) {
                this.distributionOrders.put(distributionOrderLine.getDD_Order_ID(), distributionOrderLine.getDD_Order());
            }
            distributionOrderLine.setConfirmedQty(outboundLine.getPickedQty());
            distributionOrderLine.saveEx();
        }
        if (outboundLine.getPP_Order_BOMLine_ID() > 0) {
            MPPOrderBOMLine orderBOMLine = (MPPOrderBOMLine)outboundLine.getPP_Order_BOMLine();
            if (outboundLine.getPickedQty().subtract(orderBOMLine.getQtyDelivered()).signum() < 0 && !this.isIncludeNotAvailable()) {
                return;
            }
            MStorage[] storage = MStorage.getAll(this.getCtx(), orderBOMLine.getM_Product_ID(), outboundLine.getM_LocatorTo_ID(), this.get_TrxName());
            BigDecimal qtyDelivered = outboundLine.getPickedQty();
            List<MPPCostCollector> issues = MPPOrder.createIssue(orderBOMLine.getParent(), orderBOMLine, this.getMovementDate(), qtyDelivered, BigDecimal.ZERO, BigDecimal.ZERO, storage, true);
            issues.forEach(costCollector -> {
                if (this.manufacturingIssues.get(costCollector.getPP_Cost_Collector_ID()) == null) {
                    this.manufacturingIssues.put(costCollector.getPP_Cost_Collector_ID(), (MPPCostCollector)costCollector);
                }
            });
        }
    }

    private BigDecimal getQtyDelivered(MWMInOutBoundLine outBoundLine, BigDecimal qtyDemandDelivered) {
        BigDecimal qtyDelivered = this.isIncludeNotAvailable() ? outBoundLine.getQtyToPick().subtract(qtyDemandDelivered) : outBoundLine.getPickedQty().subtract(qtyDemandDelivered);
        return qtyDelivered;
    }

    private void processingIssues() {
        this.manufacturingIssues.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            MPPCostCollector issue = (MPPCostCollector)entry.getValue();
            if ("DR".equals(issue.getDocStatus()) || "IP".equals(issue.getDocStatus())) {
                if (!issue.processIt("CO")) {
                    this.addLog("@ProcessFailed@ : " + issue.getDocumentInfo());
                    this.log.warning("@ProcessFailed@ :" + issue.getDocumentInfo());
                }
                issue.saveEx();
            }
        });
    }

    private void processingShipments() {
        ArrayList shipmentsToPrint = new ArrayList();
        this.shipments.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            MInOut shipment = (MInOut)entry.getValue();
            if (!shipment.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + shipment.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + shipment.getDocumentInfo());
            }
            shipment.saveEx();
            ++this.documentCreated;
            this.addLog(shipment.getDocumentInfo());
            shipmentsToPrint.add(shipment);
        });
    }

    private void processingMovements() {
        this.distributionOrders.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            I_DD_Order distributionOrder = (I_DD_Order)entry.getValue();
            ArrayList<Integer> orderIds = new ArrayList<Integer>();
            orderIds.add(distributionOrder.getDD_Order_ID());
            ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(MovementGenerate.getProcessId()).withSelectedRecordsIds(MDDOrder.Table_ID, orderIds).withParameter("M_Warehouse_ID", distributionOrder.getM_Warehouse_ID()).withParameter("MovementDate", this.getMovementDate()).withoutTransactionClose().execute(this.get_TrxName());
            if (processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            this.addLog(processInfo.getSummary());
            Arrays.stream(processInfo.getIDs()).forEach(recordId -> {
                Optional<MMovement> maybeMovement = Optional.ofNullable(new MMovement(this.getCtx(), recordId, this.get_TrxName()));
                maybeMovement.ifPresent(movement -> {
                    ++this.documentCreated;
                    this.printDocument((PO)movement, true);
                });
            });
        });
    }

    private MInOut getShipment(MOrderLine orderLine, MWMInOutBound outbound) {
        MInOut shipment = this.shipments.get(orderLine.getC_Order_ID());
        if (shipment != null) {
            return shipment;
        }
        MOrder order = orderLine.getParent();
        MDocType orderDocumentType = (MDocType)order.getC_DocType();
        int docTypeId = orderDocumentType.getC_DocTypeShipment_ID();
        if (docTypeId == 0) {
            docTypeId = MDocType.getDocType("MMS", orderLine.getAD_Org_ID());
        }
        shipment = new MInOut(order, docTypeId, this.getMovementDate());
        shipment.setIsSOTrx(true);
        shipment.setM_Shipper_ID(outbound.getM_Shipper_ID());
        shipment.setM_FreightCategory_ID(outbound.getM_FreightCategory_ID());
        shipment.setFreightCostRule(outbound.getFreightCostRule());
        shipment.setFreightAmt(outbound.getFreightAmt());
        shipment.setDocAction("CO");
        shipment.setDocStatus("DR");
        shipment.saveEx();
        this.shipments.put(order.getC_Order_ID(), shipment);
        return shipment;
    }
}

