/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.PO;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.process.GenerateMovementMaterialAbstract;

public class GenerateMovementMaterial
extends GenerateMovementMaterialAbstract {
    protected MMovement movement = null;
    protected String result;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<?> orderLines = this.getInstancesForSelection(this.get_TrxName());
        orderLines.stream().filter(orderLine -> orderLine != null).forEach(orderLine -> {
            this.createMovement((MDDOrderLine)orderLine);
            MMovementLine line = new MMovementLine(this.movement);
            BigDecimal qtyDeliver = this.getSelectionAsBigDecimal(orderLine.get_ID(), "LINE_QtyInTransit");
            if (qtyDeliver == null | qtyDeliver.compareTo(orderLine.getQtyInTransit()) > 0) {
                throw new AdempiereException("Error @QtyInTransit@");
            }
            line.setOrderLine((MDDOrderLine)orderLine, qtyDeliver, true);
            line.saveEx();
        });
        this.movement.processIt("CO");
        this.movement.saveEx();
        this.printDocument((PO)this.movement, "Inventory Move Hdr (Example)");
        return this.result;
    }

    private void createMovement(MDDOrderLine orderLine) {
        if (this.movement != null && this.movement.get_ID() > 0) {
            return;
        }
        this.movement = new MMovement(orderLine.getParent(), this.getMovementDate());
        int docTypeDO_ID = MDocType.getDocType("MMM", orderLine.getAD_Org_ID());
        if (docTypeDO_ID <= 0) {
            throw new AdempiereException("@C_DocType_ID@ @NotFound@");
        }
        this.movement.setC_DocType_ID(docTypeDO_ID);
        this.movement.saveEx();
    }
}

