/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.Arrays;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MMovement;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDOrder;
import org.eevolution.process.GenerateMovementAbstract;
import org.eevolution.process.MovementGenerate;
import org.eevolution.service.dsl.ProcessBuilder;

public class GenerateMovement
extends GenerateMovementAbstract {
    private String result;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(MovementGenerate.getProcessId()).withTitle(GenerateMovement.getProcessName()).withRecordId(MDDOrder.Table_ID, 0).withSelectedRecordsIds(MDDOrder.Table_ID, this.getSelectionKeys()).withParameter("MovementDate", this.getMovementDate()).withParameter("DocAction", "CO").execute();
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        this.result = processInfo.getSummary();
        int[] movementProcessedIds = processInfo.getIDs();
        if (movementProcessedIds != null && movementProcessedIds.length > 0) {
            Arrays.stream(movementProcessedIds).filter(movementId -> movementId > 0).forEach(movementId -> {
                MMovement movement = new MMovement(this.getCtx(), movementId, null);
                StringBuffer resultText = new StringBuffer(Msg.translate(Env.getCtx(), "DocumentNo") + " : " + movement.getDocumentNo());
                this.result = this.result == null ? " " + resultText.toString() : this.result + " " + resultText.toString();
                this.printDocument((PO)movement, "Inventory Move Hdr (Example)");
            });
        }
        return this.result;
    }
}

