/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.CostingMethodFactory;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.engine.StandardCostingMethod;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.process.GenerateCostDetailAbstract;
import org.eevolution.process.TransactionsToProcess;

public class GenerateCostDetail
extends GenerateCostDetailAbstract {
    private ArrayList<Object> deleteParameters;
    private ArrayList<Object> resetCostParameters;
    private List<MAcctSchema> acctSchemas = new ArrayList<MAcctSchema>();
    private List<MCostType> costTypes = new ArrayList<MCostType>();
    private List<MCostElement> costElements = new ArrayList<MCostElement>();
    private StringBuffer deleteCostDetailWhereClause;
    private StringBuffer resetCostWhereClause;
    private AtomicInteger processed = new AtomicInteger();
    private List<TransactionsToProcess> transactionsToProcess = new ArrayList<TransactionsToProcess>();
    private boolean isResetAccount = false;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDateAcct() != null) {
            this.setup();
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.generateCostDetail();
        return "@Processed@: " + this.processed;
    }

    private void deleteCostDetail(String trxName) throws SQLException {
        StringBuffer sqlDelete = new StringBuffer("DELETE FROM M_CostDetail WHERE ");
        sqlDelete.append(this.deleteCostDetailWhereClause);
        DB.executeUpdateEx(sqlDelete.toString(), this.deleteParameters.toArray(), trxName);
    }

    private void resetCostDimension(String costingMethod, String trxName) throws SQLException {
        StringBuffer sqlReset = new StringBuffer("UPDATE M_Cost SET ");
        if ("I".equals(costingMethod)) {
            sqlReset.append("CurrentCostPrice").append("=0.0,");
            sqlReset.append("CurrentCostPriceLL").append("= 0.0,");
        }
        sqlReset.append("CurrentQty").append("= 0.0,");
        sqlReset.append("CumulatedAmt").append("= 0.0,");
        sqlReset.append("CumulatedAmtLL").append("= 0.0,");
        sqlReset.append("CumulatedQty").append("= 0.0 ");
        sqlReset.append(" WHERE ").append(this.resetCostWhereClause);
        DB.executeUpdateEx(sqlReset.toString(), this.resetCostParameters.toArray(), trxName);
    }

    private void setup() {
        if (this.getAcctSchemaId() > 0) {
            this.acctSchemas.add(MAcctSchema.get(this.getCtx(), this.getAcctSchemaId(), this.get_TrxName()));
        } else {
            this.acctSchemas = Arrays.asList(MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName()));
        }
        if (this.getCostTypeId() > 0) {
            this.costTypes.add(new MCostType(this.getCtx(), this.getCostTypeId(), this.get_TrxName()));
        } else {
            this.costTypes = MCostType.get(this.getCtx(), this.get_TrxName());
        }
        if (this.getCostElementId() > 0) {
            this.costElements.add(MCostElement.get(this.getCtx(), this.getCostElementId()));
        } else {
            this.costElements = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        }
        this.isResetAccount = this.getParameterAsBoolean("IsResetAccount");
    }

    private void applyCriteria(int accountSchemaId, int costTypeId, int costElementId, int productId, Timestamp dateAccount, Timestamp dateAccountTo) {
        this.deleteParameters = new ArrayList();
        this.resetCostParameters = new ArrayList();
        this.deleteCostDetailWhereClause = new StringBuffer("1=1");
        this.resetCostWhereClause = new StringBuffer("1=1");
        if (accountSchemaId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            this.deleteParameters.add(accountSchemaId);
            this.resetCostWhereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            this.resetCostParameters.add(accountSchemaId);
        }
        if (costTypeId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_CostType_ID").append("=? ");
            this.deleteParameters.add(costTypeId);
            this.resetCostWhereClause.append(" AND ").append("M_CostType_ID").append("=? ");
            this.resetCostParameters.add(costTypeId);
        }
        if (costElementId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_CostElement_ID").append("=? ");
            this.deleteParameters.add(costElementId);
            this.resetCostWhereClause.append(" AND ").append("M_CostElement_ID").append("=? ");
            this.resetCostParameters.add(costElementId);
        }
        if (productId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_Product_ID").append("=? ");
            this.deleteParameters.add(productId);
            this.resetCostWhereClause.append(" AND ").append("M_Product_ID").append("=? ");
            this.resetCostParameters.add(productId);
        }
        if (dateAccount != null) {
            this.deleteCostDetailWhereClause.append(" AND ").append("DateAcct").append(">=? ");
            this.deleteParameters.add(dateAccount);
        }
        if (dateAccountTo != null) {
            this.deleteCostDetailWhereClause.append(" AND ").append("DateAcct").append("<=? ");
            this.deleteParameters.add(dateAccountTo);
        }
        this.resetCostWhereClause.append(" AND EXISTS ( SELECT 1 FROM RV_Transaction WHERE M_Product_ID=? AND TRUNC(DateAcct)>=? AND TRUNC(DateAcct)<=?)");
        this.resetCostParameters.add(productId);
        this.resetCostParameters.add(dateAccount);
        this.resetCostParameters.add(dateAccountTo);
    }

    public void generateCostDetail() {
        this.transactionsToProcess = this.getTransactionIdsByDateAcct();
        HashMap productMap = new HashMap();
        this.transactionsToProcess.stream().map(productTransactions -> productTransactions.getProductId()).distinct().forEach(productTransactionId -> {
            int transactionProductId = productTransactionId;
            Trx.run(transactionName -> {
                this.acctSchemas.forEach(accountSchema -> this.costTypes.forEach(costType -> this.costElements.forEach(costElement -> {
                    this.applyCriteria(accountSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), transactionProductId, this.getDateAcct(), this.getDateAcctTo());
                    try {
                        this.deleteCostDetail(transactionName);
                        this.resetCostDimension(costType.getCostingMethod(), transactionName);
                        this.generateCostCollectorNotTransaction((MAcctSchema)accountSchema, (MCostType)costType, transactionProductId, transactionName);
                    }
                    catch (Exception e) {
                        throw new AdempiereException(e);
                    }
                })));
                MProduct product = MProduct.get(this.getCtx(), transactionProductId);
                this.addLog(transactionProductId, new Timestamp(System.currentTimeMillis()), null, "@M_Product_ID@: " + product.getValue() + " - " + product.getName() + " @Deleted@");
            });
        });
        List<TransactionsToProcess> TransactionsToProcessCopy = this.transactionsToProcess.stream().filter(transaction -> transaction.getMovementType().equals("V+") && transaction.getInOutLineId() > 0).collect(Collectors.toList());
        TransactionsToProcessCopy.forEach(transaction -> this.addLandedAndAdjustmentsCosts((TransactionsToProcess)transaction));
        this.transactionsToProcess.stream().sorted(Comparator.comparing(TransactionsToProcess::getProductId).thenComparing(TransactionsToProcess::getDateAcct)).forEach(productTransaction -> {
            int transactionProductId = productTransaction.getProductId();
            Trx.run(transactionName -> this.acctSchemas.forEach(accountSchema -> this.costTypes.forEach(costType -> this.costElements.forEach(costElement -> {
                try {
                    productTransaction.getTransaction().set_TrxName(transactionName);
                    this.generateCostDetail((MAcctSchema)accountSchema, (MCostType)costType, (MCostElement)costElement, (TransactionsToProcess)productTransaction);
                }
                catch (Exception e) {
                    throw new AdempiereException(e);
                }
            }))));
            productMap.put(transactionProductId, new Timestamp(System.currentTimeMillis()));
        });
        productMap.entrySet().forEach(products -> {
            MProduct product = MProduct.get(this.getCtx(), (Integer)products.getKey());
            this.addLog((Integer)products.getKey(), (Timestamp)products.getValue(), null, "@M_Product_ID@: " + product.getValue() + " - " + product.getName() + " @Processed@");
            this.processed.incrementAndGet();
        });
    }

    private void addLandedAndAdjustmentsCosts(TransactionsToProcess transaction) {
        MInOutLine line = MInOutLine.get(this.getCtx(), transaction.getInOutLineId());
        List<MMatchPO> orderMatches = MMatchPO.getInOutLine(line);
        orderMatches.stream().forEach(match -> {
            if (match.getM_Product_ID() == transaction.getProductId() && match.getDateAcct().after(this.getDateAcct()) && match.getDateAcct().before(this.getDateAcctTo())) {
                this.transactionsToProcess.add(new TransactionsToProcess(transaction.getTransaction(), (IDocumentLine)match, this.get_TrxName()));
            }
        });
        List<MMatchInv> invoiceMatches = MMatchInv.getInOutLine(line);
        invoiceMatches.forEach(match -> {
            if (match.getM_Product_ID() == transaction.getProductId() && match.getDateAcct().after(this.getDateAcct()) && match.getDateAcct().before(this.getDateAcctTo())) {
                this.transactionsToProcess.add(new TransactionsToProcess(transaction.getTransaction(), (IDocumentLine)match, this.get_TrxName()));
            }
        });
        List<MLandedCostAllocation> landedCostAllocations = this.getCostElementId() > 0 ? MLandedCostAllocation.getOfInOutline(line, this.getCostElementId()) : MLandedCostAllocation.getOfInOutline(line);
        landedCostAllocations.stream().forEach(allocation -> {
            if (allocation.getDateAcct().after(this.getDateAcct()) && allocation.getDateAcct().before(this.getDateAcctTo())) {
                this.transactionsToProcess.add(new TransactionsToProcess(transaction.getTransaction(), (IDocumentLine)allocation, this.get_TrxName()));
            }
        });
    }

    public void generateCostDetail(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, TransactionsToProcess transaction) {
        MTransaction inventoryTransaction = transaction.getTransaction();
        if (transaction.isInventory()) {
            CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, inventoryTransaction, inventoryTransaction.getDocumentLine(), true);
        }
        if (this.isResetAccount) {
            CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).clearAccounting(accountSchema, inventoryTransaction);
        }
        if ("V+".equals(inventoryTransaction.getMovementType())) {
            MLandedCostAllocation landedCostAllocation;
            if ("M".equals(costElement.getCostElementType()) && (transaction.getModel() instanceof MMatchInv || transaction.getModel() instanceof MMatchPO)) {
                CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, inventoryTransaction, transaction.getModel(), true);
            }
            if (transaction.getModel() instanceof MLandedCostAllocation && (landedCostAllocation = (MLandedCostAllocation)transaction.getModel()).getM_CostElement_ID() == costElement.getM_CostElement_ID()) {
                CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, inventoryTransaction, landedCostAllocation, true);
            }
        }
    }

    private void generateCostCollectorNotTransaction(MAcctSchema accountSchema, MCostType costType, int productId, String trxName) throws SQLException {
        List<MPPCostCollector> costCollectors = MPPCostCollector.getCostCollectorNotTransaction(this.getCtx(), productId, this.getDateAcct(), this.getDateAcctTo(), trxName);
        for (MPPCostCollector costCollector : costCollectors) {
            for (MCostDetail costDetail : MCostDetail.getByCollectorCost(costCollector)) {
                costDetail.deleteEx(true);
            }
            CostEngineFactory.getCostEngine(this.getAD_Client_ID()).clearAccounting(accountSchema, costType, costCollector, productId, costCollector.getDateAcct());
            StandardCostingMethod standardCostingMethod = (StandardCostingMethod)CostingMethodFactory.get().getCostingMethod("S");
            if ("120".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createUsageVariances(costCollector);
                continue;
            }
            if ("130".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createMethodVariances(costCollector);
                continue;
            }
            if ("140".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createRateVariances(costCollector);
                continue;
            }
            if (!"160".equals(costCollector.getCostCollectorType())) continue;
            standardCostingMethod.createActivityControl(costCollector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TransactionsToProcess> getTransactionIdsByDateAcct() {
        StringBuilder sql = new StringBuilder();
        StringBuilder whereClause = new StringBuilder("WHERE ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<TransactionsToProcess> list = new ArrayList<TransactionsToProcess>();
        try {
            whereClause.append("AD_Client_ID").append("=").append(this.getAD_Client_ID()).append(" AND ");
            if (this.getProductId() > 0) {
                whereClause.append("M_Product_ID").append("=?").append(" AND ");
            }
            if (this.getProductCategoryId() > 0) {
                whereClause.append("M_Product_Category_ID").append("=?").append(" AND ");
            }
            whereClause.append("TRUNC(").append("DateAcct").append(")>=?");
            if (this.getDateAcctTo() != null) {
                whereClause.append(" AND TRUNC(").append("DateAcct").append(")<=?");
            }
            sql.append("SELECT M_Transaction_ID , M_Product_ID, DateAcct, MovementType, M_InOutLine_ID FROM RV_Transaction ").append((CharSequence)whereClause).append(" ORDER BY lowlevel desc, M_Product_ID ,  TRUNC( DateAcct ) , M_Transaction_ID , SUBSTR(MovementType,2,1) , IsReversed");
            int index = 1;
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            if (this.getProductId() > 0) {
                pstmt.setInt(index++, this.getProductId());
            }
            if (this.getProductCategoryId() > 0) {
                pstmt.setInt(index++, this.getProductCategoryId());
            }
            pstmt.setTimestamp(index++, this.getDateAcct());
            if (this.getDateAcctTo() != null) {
                pstmt.setTimestamp(index++, this.getDateAcctTo());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new TransactionsToProcess(rs.getInt("M_Transaction_ID"), rs.getInt("M_Product_ID"), rs.getTimestamp("DateAcct"), rs.getString("MovementType"), Optional.ofNullable(rs.getInt("M_InOutLine_ID")).orElse(0), this.get_TrxName()));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }
}

