/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.adempiere.engine.CostDimension;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Trx;
import org.eevolution.process.CopyCostTypeToCostTypeAbstract;

public class CopyCostTypeToCostType
extends CopyCostTypeToCostTypeAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getCostTypeId() == this.getCostTypeIdTo()) {
            throw new AdempiereException("@M_CostType_ID@ @NotValid@");
        }
        MAcctSchema accountSchema = MAcctSchema.get(this.getCtx(), this.getAcctSchemaId());
        MCostType costTypeFrom = MCostType.get(this.getCtx(), this.getCostTypeId());
        MCostType costTypeTo = MCostType.get(this.getCtx(), this.getCostTypeIdTo());
        MCostElement costElementFrom = MCostElement.get(this.getCtx(), this.getCostElementId());
        MCostElement costElementTo = MCostElement.get(this.getCtx(), this.getCostElementIdTo());
        Arrays.stream(this.getProductIds()).filter(productId -> productId > 0).forEach(productId -> Trx.run(trxName -> this.copyCostTypeToCostType(productId, accountSchema, costTypeFrom, costTypeTo, costElementFrom, costElementTo, trxName)));
        return "@Ok@";
    }

    private void copyCostTypeToCostType(int productId, MAcctSchema accountSchema, MCostType costTypeFrom, MCostType costTypeTo, MCostElement costElementFrom, MCostElement costElementTo, String trxName) {
        MProduct product = MProduct.get(this.getCtx(), productId);
        CostDimension costDimensionFrom = new CostDimension(product, accountSchema, costTypeFrom.get_ID(), this.getOrgId(), this.getWarehouseId(), 0, costElementFrom.get_ID());
        Optional<MCost> costDimensionFromOptional = Optional.ofNullable(costDimensionFrom.toQuery(MCost.class, trxName).first());
        CostDimension costDimensionTo = new CostDimension(product, accountSchema, costTypeTo.get_ID(), this.getOrgId(), this.getWarehouseId(), 0, costElementTo.get_ID());
        Optional costDimensionToOptional = Optional.ofNullable(costDimensionTo.toQuery(MCost.class, trxName).first());
        if (this.isUpdateCosting()) {
            if (costDimensionToOptional.isPresent() && costDimensionFromOptional.isPresent()) {
                MCost costTo = (MCost)costDimensionToOptional.get();
                if (!"S".equals(costTypeFrom.getCostingMethod()) || !costTo.isCostFrozen()) {
                    costTo.setCurrentCostPrice(((MCost)costDimensionFromOptional.get()).getCurrentCostPrice());
                    costTo.saveEx();
                }
            } else if (!costDimensionToOptional.isPresent() && costDimensionFromOptional.isPresent()) {
                MCost costTo = MCost.getOrCreate(product, 0, accountSchema, this.getOrgId(), this.getWarehouseId(), costTypeTo.get_ID(), costElementTo.get_ID());
                if (!"S".equals(costTypeFrom.getCostingMethod()) || !costTo.isCostFrozen()) {
                    costDimensionFromOptional.ifPresent(costFrom -> costTo.setCurrentCostPrice(costFrom.getCurrentCostPrice()));
                    costTo.saveEx();
                }
            } else if (costDimensionToOptional.isPresent() && !costDimensionFromOptional.isPresent()) {
                MCost costTo = (MCost)costDimensionToOptional.get();
                costTo.setCurrentCostPrice(BigDecimal.ZERO);
                costTo.saveEx();
            } else if (!costDimensionToOptional.isPresent() && !costDimensionFromOptional.isPresent()) {
                MCost costTo = MCost.getOrCreate(product, 0, accountSchema, this.getOrgId(), this.getWarehouseId(), costTypeTo.get_ID(), costElementTo.get_ID());
                costTo.setCurrentCostPrice(BigDecimal.ZERO);
                costTo.saveEx();
            }
        } else if (!costDimensionToOptional.isPresent()) {
            MCost costTo = MCost.getOrCreate(product, 0, accountSchema, this.getOrgId(), this.getWarehouseId(), costTypeTo.get_ID(), costElementTo.get_ID());
            costDimensionFromOptional.ifPresent(costFrom -> costTo.setCurrentCostPrice(costFrom.getCurrentCostPrice()));
            costTo.saveEx();
        }
    }

    private int[] getProductIds() {
        StringBuilder whereClause = new StringBuilder("1=1 ");
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (this.getProductId() > 0) {
            whereClause.append(" AND ").append("M_Product_ID").append("=? ");
            parameters.add(this.getProductId());
        }
        if (this.getProductCategoryId() > 0) {
            whereClause.append(" AND ").append("M_Product_Category_ID").append("=? ");
            parameters.add(this.getProductCategoryId());
        }
        if (this.getProductGroupId() > 0) {
            whereClause.append(" AND ").append("M_Product_Group_ID").append("=? ");
            parameters.add(this.getProductGroupId());
        }
        if (this.getProductClassId() > 0) {
            whereClause.append(" AND ").append("M_Product_Class_ID").append("=? ");
            parameters.add(this.getProductClassId());
        }
        if (this.getProductClassificationId() > 0) {
            whereClause.append(" AND ").append("M_Product_Classification_ID").append("=? ");
            parameters.add(this.getProductClassificationId());
        }
        return new Query(this.getCtx(), "M_Product", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).getIDs();
    }
}

