/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.Timestamp;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.process.BankTransferAbstract;

public class BankTransfer
extends BankTransferAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (Util.isEmpty(this.getTenderType())) {
            this.setTenderType("A");
        }
    }

    @Override
    protected String doIt() throws Exception {
        return this.generateBankTransfer();
    }

    private String generateBankTransfer() {
        MBankStatementLine bsl;
        Timestamp statementDate = this.getStatementDate();
        Timestamp dateAcct = this.getDateAcct();
        String documentNoTo = this.getDocumentNoTo();
        if (documentNoTo == null || documentNoTo.trim().length() == 0) {
            documentNoTo = this.getDocumentNo();
        }
        if (statementDate == null) {
            statementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (statementDate == null) {
            statementDate = new Timestamp(System.currentTimeMillis());
        }
        if (dateAcct == null) {
            dateAcct = statementDate;
        }
        MBankAccount mBankFrom = MBankAccount.get(this.getCtx(), this.getCBankAccountId());
        MBankAccount mBankTo = MBankAccount.get(this.getCtx(), this.getBankAccountToId());
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(mBankFrom.getC_BankAccount_ID());
        paymentBankFrom.setDocumentNo(this.getDocumentNo());
        paymentBankFrom.setDateAcct(dateAcct);
        paymentBankFrom.setDateTrx(statementDate);
        paymentBankFrom.setTenderType(this.getTenderType());
        paymentBankFrom.setDescription(this.getDescription());
        paymentBankFrom.setC_BPartner_ID(this.getBPartnerId());
        paymentBankFrom.setC_Currency_ID(this.getCurrencyId());
        if (this.getConversionTypeId() > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.getConversionTypeId());
        }
        paymentBankFrom.setPayAmt(this.getAmount());
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        if (this.getWithdrawalDocumentTypeId() != 0) {
            paymentBankFrom.setC_DocType_ID(this.getWithdrawalDocumentTypeId());
        } else {
            paymentBankFrom.setC_DocType_ID(false);
        }
        paymentBankFrom.setC_Charge_ID(this.getChargeId());
        paymentBankFrom.saveEx();
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(mBankTo.getC_BankAccount_ID());
        paymentBankTo.setDocumentNo(documentNoTo);
        paymentBankTo.setDateAcct(dateAcct);
        paymentBankTo.setDateTrx(statementDate);
        paymentBankTo.setTenderType(this.getTenderType());
        paymentBankTo.setDescription(this.getDescription());
        paymentBankTo.setC_BPartner_ID(this.getBPartnerId());
        paymentBankTo.setC_Currency_ID(this.getCurrencyId());
        if (this.getConversionTypeId() > 0) {
            paymentBankTo.setC_ConversionType_ID(this.getConversionTypeId());
        }
        if (this.getParameterAsInt("C_POS_ID") > 0) {
            paymentBankFrom.setC_POS_ID(this.getParameterAsInt("C_POS_ID"));
            paymentBankTo.setC_POS_ID(this.getParameterAsInt("C_POS_ID"));
        }
        paymentBankTo.setPayAmt(this.getAmount());
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        if (this.getDepositDocumentTypeId() != 0) {
            paymentBankTo.setC_DocType_ID(this.getDepositDocumentTypeId());
        } else {
            paymentBankTo.setC_DocType_ID(true);
        }
        paymentBankTo.setC_Charge_ID(this.getChargeId());
        paymentBankTo.saveEx();
        paymentBankFrom.setRelatedPayment_ID(paymentBankTo.getC_Payment_ID());
        paymentBankFrom.saveEx();
        paymentBankFrom.processIt("CO");
        paymentBankFrom.saveEx();
        this.addLog("@C_Payment_ID@ @IsReceipt@: ");
        if (this.isAutoReconciled() && (bsl = MBankStatement.addPayment(paymentBankFrom)) != null) {
            this.addLog("@C_Payment_ID@: " + paymentBankFrom.getDocumentNo() + " @Added@ @to@ [@AccountNo@ " + paymentBankFrom.getC_BankAccount().getAccountNo() + " @C_BankStatement_ID@ " + bsl.getC_BankStatement().getName() + "]");
        }
        paymentBankTo.setRelatedPayment_ID(paymentBankFrom.getC_Payment_ID());
        paymentBankTo.saveEx();
        paymentBankTo.processIt("CO");
        paymentBankTo.saveEx();
        if (this.isAutoReconciled() && (bsl = MBankStatement.addPayment(paymentBankTo)) != null) {
            this.addLog("@C_Payment_ID@: " + paymentBankTo.getDocumentNo() + " @Added@ @to@ [@AccountNo@ " + paymentBankTo.getC_BankAccount().getAccountNo() + " @C_BankStatement_ID@ " + bsl.getC_BankStatement().getName() + "]");
        }
        return "@Created@ (1) @From@ " + mBankFrom.getAccountNo() + " @To@ " + mBankTo.getAccountNo() + " @Amt@ " + DisplayType.getNumberFormat(12).format(this.getAmount());
    }
}

