/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.eevolution.model.I_DD_OrderLine;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.X_WM_InOutBoundLine;

public class MWMInOutBoundLine
extends X_WM_InOutBoundLine {
    private static final long serialVersionUID = 8397162302198048638L;
    private static CLogger s_log = CLogger.getCLogger(MWMInOutBoundLine.class);
    private MWMInOutBound parent = null;
    private MProduct product = null;
    private MOrderLine orderLine = null;
    private MInvoiceLine invoiceLine = null;
    private MBPartner partner = null;

    public static MWMInOutBoundLine getByInvoiceLine(MInvoiceLine invoiceLine) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_InvoiceLine_ID").append("=?");
        return (MWMInOutBoundLine)new Query(invoiceLine.getCtx(), "WM_InOutBoundLine", whereClause.toString(), invoiceLine.get_TrxName()).setClient_ID().setParameters(invoiceLine.getC_InvoiceLine_ID()).first();
    }

    public static MWMInOutBoundLine getByOrderLine(MOrderLine orderLine) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_OrderLine_ID").append("=?");
        return (MWMInOutBoundLine)new Query(orderLine.getCtx(), "WM_InOutBoundLine", whereClause.toString(), orderLine.get_TrxName()).setClient_ID().setParameters(orderLine.getC_OrderLine_ID()).first();
    }

    public MWMInOutBoundLine(Properties ctx, int M_InOutBoundLine_ID, String trxName) {
        super(ctx, M_InOutBoundLine_ID, trxName);
        if (M_InOutBoundLine_ID == 0) {
            this.setProcessed(false);
        }
    }

    public MWMInOutBoundLine(Properties ctx, int M_InOutBoundLine_ID) {
        this(ctx, M_InOutBoundLine_ID, null);
    }

    public MWMInOutBoundLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWMInOutBoundLine(MWMInOutBound inOutBound) {
        this(inOutBound.getCtx(), 0, inOutBound.get_TrxName());
        this.setWM_InOutBound_ID(inOutBound.getWM_InOutBound_ID());
    }

    public MWMInOutBoundLine(MWMInOutBound inOutBound, MInvoiceLine invoiceLine) {
        this(inOutBound.getCtx(), 0, inOutBound.get_TrxName());
        this.setWM_InOutBound_ID(inOutBound.get_ID());
        this.setC_Invoice_ID(invoiceLine.getC_Invoice_ID());
        this.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
        this.setMovementQty(invoiceLine.getQtyInvoiced());
        this.setM_Product_ID(invoiceLine.getM_Product_ID());
        this.setC_Charge_ID(invoiceLine.getC_Charge_ID());
        this.setC_UOM_ID(invoiceLine.getC_UOM_ID());
    }

    public MWMInOutBoundLine(MWMInOutBound inOutBound, MOrderLine orderLine) {
        this(inOutBound.getCtx(), 0, inOutBound.get_TrxName());
        this.setWM_InOutBound_ID(inOutBound.get_ID());
        this.setC_Order_ID(orderLine.getC_Order_ID());
        this.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
        this.setMovementQty(this.getQtyToDeliver());
        this.setM_Product_ID(orderLine.getM_Product_ID());
        this.setC_Charge_ID(orderLine.getC_Charge_ID());
        this.setC_UOM_ID(orderLine.getC_UOM_ID());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutBoundLine[").append(this.get_ID()).append("-").append("").append("]");
        return sb.toString();
    }

    public MWMInOutBound getParent() {
        return Optional.ofNullable(this.parent).orElseGet(() -> new MWMInOutBound(this.getCtx(), this.getWM_InOutBound_ID(), this.get_TrxName()));
    }

    public MProduct getProduct() {
        return Optional.ofNullable(this.product).orElseGet(() -> MProduct.get(this.getCtx(), this.getM_Product_ID()));
    }

    public MOrderLine getOrderLine() {
        return Optional.ofNullable(this.orderLine).orElseGet(() -> new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName()));
    }

    public MInvoiceLine getInvoiceLine() {
        return Optional.ofNullable(this.invoiceLine).orElseGet(() -> new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName()));
    }

    public MBPartner getBPartner() {
        return Optional.ofNullable(this.partner).orElseGet(() -> (MBPartner)this.getOrderLine().getC_BPartner());
    }

    public BigDecimal getQtyToPick() {
        return this.getMovementQty().subtract(this.getPickedQty());
    }

    public BigDecimal getQtyToDeliver() {
        if (this.getC_OrderLine_ID() > 0) {
            Optional<MOrderLine> maybeOrderLine = Optional.ofNullable(this.getOrderLine());
            AtomicReference<BigDecimal> quantityToDeliver = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            maybeOrderLine.ifPresent(orderLine -> {
                BigDecimal convertedQuantity = MUOMConversion.convertProductFrom(this.getCtx(), orderLine.getM_Product_ID(), orderLine.getC_UOM_ID(), orderLine.getQtyOrdered().subtract(orderLine.getQtyDelivered()));
                quantityToDeliver.set(convertedQuantity);
            });
            return quantityToDeliver.get();
        }
        if (this.getDD_OrderLine_ID() != 0) {
            Optional<I_DD_OrderLine> maybeOrderLine = Optional.ofNullable(this.getDD_OrderLine());
            AtomicReference<BigDecimal> quantityToDeliver = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            maybeOrderLine.ifPresent(orderLine -> {
                BigDecimal convertedQuantity = MUOMConversion.convertProductFrom(this.getCtx(), orderLine.getM_Product_ID(), orderLine.getC_UOM_ID(), orderLine.getQtyOrdered().subtract(orderLine.getQtyDelivered()));
                quantityToDeliver.set(convertedQuantity);
            });
            return quantityToDeliver.get();
        }
        return Env.ZERO;
    }

    public int getM_Warehouse_ID() {
        return this.getParent().getM_Warehouse_ID();
    }
}

