/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.model.X_WM_InOutBound;

public class MWMInOutBound
extends X_WM_InOutBound
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -7216075035497599383L;
    private List<MWMInOutBoundLine> inOutBoundLines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MWMInOutBound(Properties ctx, int M_InOutBound_ID, String trxName) {
        super(ctx, M_InOutBound_ID, trxName);
        if (M_InOutBound_ID == 0) {
            this.setIsApproved(false);
            this.setIsInTransit(false);
            this.setIsPrinted(false);
            this.setSendEMail(false);
        }
    }

    public MWMInOutBound(Properties ctx, int M_InOutBound_ID) {
        this(ctx, M_InOutBound_ID, null);
    }

    public MWMInOutBound(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutBound[").append(this.get_ID()).append("-").append("").append("]");
        return sb.toString();
    }

    @Override
    public boolean approveIt() {
        this.setIsApproved(true);
        return true;
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        return "" + this.getDocumentNo() + "/";
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType documentType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.isSOTrx() ? this.getPickDate() : this.getDateTrx(), documentType.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        List<MWMInOutBoundLine> lines = this.getLines(true, "Line");
        if (lines.size() == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("D")) {
            for (MWMInOutBoundLine line : lines) {
                MProduct product = line.getProduct();
                if (product == null || !product.isExcludeAutoDelivery()) continue;
                this.m_processMsg = "@M_Product_ID@ " + product.getValue() + " @IsExcludeAutoDelivery@";
                return "IN";
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        for (MWMInOutBoundLine line : this.getLines(true, null)) {
            line.deleteEx(true);
        }
        return true;
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.setProcessed(true);
        if (!this.isSOTrx()) {
            this.generateReceipt();
        }
        this.setDocAction("CL");
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        return "CO";
    }

    @Override
    public void setProcessed(boolean Processed) {
        super.setProcessed(Processed);
        for (MWMInOutBoundLine line : this.getLines(true, "Line")) {
            line.setProcessed(Processed);
            line.saveEx();
        }
    }

    private void reverseReceipt() {
        new Query(this.getCtx(), "M_InOut", "DocStatus = 'CO' AND EXISTS(SELECT 1 FROM M_InOutLine iol \t\tINNER JOIN WM_InOutBoundLine iobl ON(iobl.WM_InOutBoundLine_ID = iol.WM_InOutBoundLine_ID) \t\tWHERE iobl.WM_InOutBound_ID = ? AND iol.M_InOut_ID = M_InOut.M_InOut_ID)", this.get_TrxName()).setParameters(this.getWM_InOutBound_ID()).list().forEach(receipt -> {
            if (!receipt.processIt("RC")) {
                throw new AdempiereException("@Error@ " + receipt.getProcessMsg());
            }
            receipt.saveEx();
        });
    }

    private void generateReceipt() {
        Hashtable<Integer, MInOut> receipts = new Hashtable<Integer, MInOut>();
        for (MWMInOutBoundLine inboundLine : this.getLines(true, null)) {
            if (inboundLine.getC_OrderLine_ID() <= 0) continue;
            MOrderLine orderLine = inboundLine.getOrderLine();
            BigDecimal qtyToReceipt = inboundLine.getMovementQty();
            MInOut receipt = (MInOut)receipts.get(orderLine.getC_Order_ID());
            if (receipt == null) {
                receipt = this.createReceipt(orderLine, inboundLine.getParent());
                receipts.put(orderLine.getC_Order_ID(), receipt);
            }
            MInOutLine receiptLine = new MInOutLine(inboundLine.getCtx(), 0, inboundLine.get_TrxName());
            receiptLine.setM_InOut_ID(receipt.getM_InOut_ID());
            int locatorId = inboundLine.getM_Locator_ID();
            if (locatorId == 0) {
                locatorId = this.getM_Locator_ID();
            }
            MProduct product = MProduct.get(this.getCtx(), inboundLine.getM_Product_ID());
            receiptLine.setM_Locator_ID(locatorId);
            receiptLine.setProduct(product);
            receiptLine.setQtyEntered(qtyToReceipt);
            receiptLine.setMovementQty(qtyToReceipt);
            receiptLine.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
            receiptLine.setM_Shipper_ID(inboundLine.getM_Shipper_ID());
            receiptLine.setM_FreightCategory_ID(inboundLine.getM_FreightCategory_ID());
            receiptLine.setFreightAmt(inboundLine.getFreightAmt());
            receiptLine.setWM_InOutBoundLine_ID(inboundLine.getWM_InOutBoundLine_ID());
            receiptLine.saveEx();
        }
        receipts.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MInOut shipment = (MInOut)entry.getValue();
            shipment.setDocAction(this.getDocAction());
            if (!shipment.processIt(this.getDocAction())) {
                this.log.warning("@ProcessFailed@ :" + shipment.getDocumentInfo());
            }
            shipment.saveEx();
        });
    }

    private MInOut createReceipt(MOrderLine orderLine, MWMInOutBound outbound) {
        MOrder order = orderLine.getParent();
        MDocType orderDocumentType = MDocType.get(this.getCtx(), order.getC_DocTypeTarget_ID());
        int docTypeId = 0;
        docTypeId = orderDocumentType.getC_DocTypeShipment_ID() > 0 ? orderDocumentType.getC_DocTypeShipment_ID() : MDocType.getDocType("MMR", orderLine.getAD_Org_ID());
        MInOut shipment = new MInOut(order, docTypeId, this.getDateTrx());
        shipment.setIsSOTrx(false);
        shipment.setM_Shipper_ID(outbound.getM_Shipper_ID());
        shipment.setM_FreightCategory_ID(outbound.getM_FreightCategory_ID());
        shipment.setFreightCostRule(outbound.getFreightCostRule());
        shipment.setFreightAmt(outbound.getFreightAmt());
        shipment.setM_Warehouse_ID(outbound.getM_Warehouse_ID());
        shipment.saveEx();
        return shipment;
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.getLines(true, null).forEach(inoutLine -> {
            if (inoutLine.getMovementQty().signum() != 0) {
                inoutLine.setDescription(Optional.ofNullable(inoutLine.getDescription()).orElse("") + " " + Msg.getMsg(this.getCtx(), "Voided") + " @MovementQty@ = (" + inoutLine.getMovementQty() + ")");
                inoutLine.setMovementQty(BigDecimal.ZERO);
                inoutLine.setProcessed(true);
                inoutLine.saveEx();
            }
        });
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        if (!this.isSOTrx()) {
            this.reverseReceipt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.getLines(true, null).forEach(inoutLine -> {
            if (inoutLine.getMovementQty().compareTo(inoutLine.getPickedQty()) != 0) {
                inoutLine.setDescription(Optional.ofNullable(inoutLine.getDescription()).orElse("") + " " + Msg.getMsg(this.getCtx(), "@closed@ @MovementQty@ = (" + inoutLine.getMovementQty() + ")"));
                inoutLine.setMovementQty(inoutLine.getPickedQty());
                inoutLine.setProcessed(true);
                inoutLine.saveEx();
            }
        });
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public List<MWMInOutBoundLine> getLines(boolean requery, String orderBy) {
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? orderClause + orderBy : orderClause + "Line";
        this.inOutBoundLines = this.getLines(null, orderClause);
        return this.inOutBoundLines;
    }

    public List<MWMInOutBoundLine> getLines(String where, String orderClause) {
        StringBuffer whereClause = new StringBuffer("WM_InOutBound_ID=?");
        if (!Util.isEmpty(where, true)) {
            whereClause.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        return new Query(this.getCtx(), "WM_InOutBoundLine", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOrderBy(orderClause).list();
    }
}

