/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.eevolution.model.MProjectProcessorLog;
import org.eevolution.model.X_C_ProjectProcessor;

public class MProjectProcessor
extends X_C_ProjectProcessor
implements AdempiereProcessor {
    private static final long serialVersionUID = -3149710397208186523L;

    public MProjectProcessor(Properties ctx, int C_ProjectProcessor_ID, String trxName) {
        super(ctx, C_ProjectProcessor_ID, trxName);
    }

    public MProjectProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MProjectProcessor[] getActive(Properties ctx) {
        List<MProjectProcessor> processors = new Query(ctx, "C_ProjectProcessor", "IsActive='Y'", null).list();
        MProjectProcessor[] retValue = new MProjectProcessor[processors.size()];
        processors.toArray(retValue);
        return retValue;
    }

    public MProjectProcessor(MClient parent, int supervisorId) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setName(parent.getName() + " - " + Msg.translate(this.getCtx(), "C_ProjectProcessor_ID"));
        this.setSupervisor_ID(supervisorId);
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MProjectProcessorLog> list = new ArrayList<MProjectProcessorLog>();
        String sql = "SELECT * FROM C_ProjectProcessorLog WHERE C_ProjectProcessor_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_ProjectProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProjectProcessorLog(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MProjectProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE C_ProjectProcessorLog WHERE C_ProjectProcessor_ID=" + this.getC_ProjectProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public String getServerID() {
        return "ProjectProcessor" + this.get_ID();
    }

    public MProjectProcessorLog[] getProcessorLogs(String whereClause) {
        whereClause = whereClause + " AND C_ProjectProcessor_ID = ? ";
        List<MProjectProcessorLog> logs = new Query(this.getCtx(), "C_ProjectProcessorLog", whereClause, this.get_TrxName()).setParameters(this.getC_ProjectProcessor_ID()).list();
        MProjectProcessorLog[] retValue = new MProjectProcessorLog[logs.size()];
        logs.toArray(retValue);
        return retValue;
    }
}

