/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.X_PP_Product_BOM;

public class MPPProductBOM
extends X_PP_Product_BOM {
    private static final long serialVersionUID = 1561124355655122911L;
    private static CCache<Integer, MPPProductBOM> s_cache = new CCache("PP_Product_BOM", 40, 5);
    private List<MPPProductBOMLine> m_lines = null;

    public static boolean isProductMakeToOrder(Properties ctx, int productId, String trxName) {
        String whereClause = "BOMType IN (?,?) AND BOMUse=? AND M_Product_ID=?";
        return new Query(ctx, "PP_Product_BOM", "BOMType IN (?,?) AND BOMUse=? AND M_Product_ID=?", trxName).setClient_ID().setParameters("O", "K", "M", productId).match();
    }

    public static List<MPPProductBOM> getProductBOMs(MProduct product) {
        String whereClause = "Value=? AND M_Product_ID=?";
        return new Query(product.getCtx(), "PP_Product_BOM", whereClause, product.get_TrxName()).setClient_ID().setParameters(product.getValue(), product.getM_Product_ID()).setOnlyActiveRecords(true).setOnlyActiveRecords(true).list();
    }

    public static MPPProductBOM get(Properties ctx, int PP_Product_BOM_ID) {
        if (PP_Product_BOM_ID <= 0) {
            return null;
        }
        MPPProductBOM bom = s_cache.get(PP_Product_BOM_ID);
        if (bom != null) {
            return bom;
        }
        bom = new MPPProductBOM(ctx, PP_Product_BOM_ID, null);
        if (bom.get_ID() == PP_Product_BOM_ID) {
            s_cache.put(PP_Product_BOM_ID, bom);
        } else {
            bom = null;
        }
        return bom;
    }

    public static int getBOMSearchKey(MProduct product) {
        int AD_Client_ID = Env.getAD_Client_ID(product.getCtx());
        String sql = "SELECT PP_Product_BOM_ID FROM PP_Product_BOM WHERE Value=? AND M_Product_ID=? AND AD_Client_ID=?";
        return DB.getSQLValueEx(null, sql, product.getValue(), product.get_ID(), AD_Client_ID);
    }

    public static MPPProductBOM getDefault(MProduct product, String trxName) {
        MPPProductBOM bom = (MPPProductBOM)new Query(product.getCtx(), "PP_Product_BOM", "M_Product_ID=? AND IsDefault = 'Y'", trxName).setParameters(product.getM_Product_ID()).setOnlyActiveRecords(true).setClient_ID().firstOnly();
        if (bom != null && trxName == null) {
            s_cache.put(bom.get_ID(), bom);
        }
        return bom;
    }

    public static MPPProductBOM get(MProduct product, int ad_org_id, String trxName) {
        MPPProductPlanning pp;
        MPPProductBOM bom = null;
        Properties ctx = product.getCtx();
        if (ad_org_id > 0 && (pp = MPPProductPlanning.get(ctx, product.getAD_Client_ID(), ad_org_id, product.getM_Product_ID(), trxName)) != null && pp.getPP_Product_BOM_ID() > 0) {
            bom = new MPPProductBOM(ctx, pp.getPP_Product_BOM_ID(), trxName);
        }
        if (bom == null) {
            bom = MPPProductBOM.getDefault(product, trxName);
        }
        return bom;
    }

    public static MPPProductBOM get(MProduct product, int ad_org_id, Timestamp valid, String trxName) {
        MPPProductBOM bom = MPPProductBOM.get(product, ad_org_id, trxName);
        if (bom != null && bom.isValidFromTo(valid)) {
            return bom;
        }
        return null;
    }

    public MPPProductBOM(Properties ctx, int PP_Product_BOM_ID, String trxName) {
        super(ctx, PP_Product_BOM_ID, trxName);
    }

    public MPPProductBOM(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPProductBOMLine[] getLines(Timestamp valid) {
        ArrayList<MPPProductBOMLine> list = new ArrayList<MPPProductBOMLine>();
        for (MPPProductBOMLine bl : this.getLines(true)) {
            if (!bl.isValidFromTo(valid)) continue;
            list.add(bl);
        }
        return list.toArray(new MPPProductBOMLine[list.size()]);
    }

    public MPPProductBOMLine[] getLines() {
        return this.getLines(false);
    }

    public MPPProductBOMLine[] getLines(boolean reload) {
        if (this.m_lines == null || reload) {
            String whereClause = "PP_Product_BOM_ID=?";
            this.m_lines = new Query(this.getCtx(), "PP_Product_BOMLine", "PP_Product_BOM_ID=?", this.get_TrxName()).setParameters(this.getPP_Product_BOM_ID()).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Line").list();
        }
        return this.m_lines.toArray(new MPPProductBOMLine[this.m_lines.size()]);
    }

    public boolean isValidFromTo(Timestamp date) {
        Timestamp validFrom = this.getValidFrom();
        Timestamp validTo = this.getValidTo();
        if (validFrom != null && date.before(validFrom)) {
            return false;
        }
        return validTo == null || !date.after(validTo);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        this.updateProduct();
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if (newRecord || this.is_ValueChanged("IsActive")) {
            this.updateProduct();
        }
        return true;
    }

    private void updateProduct() {
        int count = new Query(this.getCtx(), "PP_Product_BOM", "M_Product_ID=?", this.get_TrxName()).setParameters(this.getM_Product_ID()).setClient_ID().setOnlyActiveRecords(true).count();
        MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        product.setIsBOM(count > 0);
        product.saveEx();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPPProductBOM[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(", Value=").append(this.getValue()).append("]");
        return sb.toString();
    }
}

