/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MCalendar;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.X_HR_Payroll;

public class MHRPayroll
extends X_HR_Payroll {
    private static final long serialVersionUID = -1407037967021019961L;
    private static CCache<Integer, MHRPayroll> payrollCacheIds = new CCache("HR_Payroll", 10);
    private static CCache<String, MHRPayroll> payrollCacheValues = new CCache("HR_Payroll_Value", 10);

    public MHRPayroll(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setProcessing(false);
        }
    }

    public MHRPayroll(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRPayroll(MCalendar mCalendar) {
        this(mCalendar.getCtx(), 0, mCalendar.get_TrxName());
        this.setClientOrg(mCalendar);
    }

    @Deprecated
    public static MHRPayroll forValue(Properties properties, String string) {
        return MHRPayroll.getByValue(properties, string, null);
    }

    public static MHRPayroll getByValue(Properties properties, String string, String string2) {
        if (Util.isEmpty(string, true)) {
            return null;
        }
        int n = Env.getAD_Client_ID(properties);
        String string3 = n + "#" + string;
        MHRPayroll mHRPayroll = payrollCacheValues.get(string3);
        if (mHRPayroll != null && mHRPayroll.get_ID() > 0) {
            return mHRPayroll;
        }
        mHRPayroll = (MHRPayroll)new Query(properties, "HR_Payroll", "Value=?", string2).setClient_ID().setParameters(string).setOnlyActiveRecords(true).first();
        if (mHRPayroll != null && mHRPayroll.get_ID() > 0) {
            payrollCacheValues.put(string3, mHRPayroll);
            payrollCacheIds.put(mHRPayroll.get_ID(), mHRPayroll);
        }
        return mHRPayroll;
    }

    @Deprecated
    public static MHRPayroll get(Properties properties, int n) {
        return MHRPayroll.getById(properties, n, null);
    }

    public static MHRPayroll getById(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        MHRPayroll mHRPayroll = payrollCacheIds.get(n);
        if (mHRPayroll != null && mHRPayroll.get_ID() > 0) {
            return mHRPayroll;
        }
        mHRPayroll = (MHRPayroll)new Query(properties, "HR_Payroll", "HR_Payroll_ID=?", string).setClient_ID().setParameters(n).first();
        if (mHRPayroll != null && mHRPayroll.get_ID() > 0) {
            int n2 = Env.getAD_Client_ID(properties);
            String string2 = n2 + "#" + mHRPayroll.getValue();
            payrollCacheIds.put(mHRPayroll.get_ID(), mHRPayroll);
            payrollCacheValues.put(string2, mHRPayroll);
        }
        return mHRPayroll;
    }

    public int countPeriods() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HR_Payroll_ID").append("=?");
        return new Query(this.getCtx(), "HR_Period", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setParameters(this.getHR_Payroll_ID()).count();
    }

    public MHRPeriod getPeriodByDate(Timestamp timestamp) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HR_Payroll_ID").append("=? AND ");
        stringBuilder.append("?").append(" BETWEEN ").append("StartDate").append(" AND ").append("EndDate");
        return (MHRPeriod)new Query(this.getCtx(), "HR_Period", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setParameters(this.getHR_Payroll_ID(), timestamp).firstOnly();
    }

    public List<MHRPeriod> getPeriods(Timestamp timestamp, Timestamp timestamp2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HR_Payroll_ID").append("=? AND ");
        stringBuilder.append("StartDate").append(">=?  AND  ");
        stringBuilder.append("EndDate").append("<=?");
        return new Query(this.getCtx(), "HR_Period", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setParameters(this.getHR_Payroll_ID(), timestamp, timestamp2).list();
    }

    public MHRPeriod[] getPeriodsAsArray(Timestamp timestamp, Timestamp timestamp2) {
        List<MHRPeriod> list = this.getPeriods(timestamp, timestamp2);
        MHRPeriod[] mHRPeriodArray = new MHRPeriod[list.size()];
        list.toArray(mHRPeriodArray);
        return mHRPeriodArray;
    }

    public MHRPeriod getPeriodByPeriodNo(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HR_Payroll_ID").append("=? AND ").append("PeriodNo").append("=? AND ").append("EXISTS (SELECT 1 FROM ").append("C_Period").append(" period ").append(" INNER JOIN ").append("C_Year").append(" year ON (period.").append("C_Year_ID").append("=").append("year.").append("C_Year_ID").append(") WHERE period.").append("C_Period_ID").append("=").append("HR_Period").append(".").append("C_Period_ID").append(" AND year.").append("FiscalYear").append("=?)");
        return (MHRPeriod)new Query(this.getCtx(), "HR_Period", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setParameters(this.getHR_Payroll_ID(), n, string).firstOnly();
    }
}

