/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRDepartment;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRJob;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Movement;
import org.eevolution.model.X_I_HR_Movement;

public class MHRMovement
extends X_HR_Movement {
    private static CCache<String, MHRMovement> movementsHistory = new CCache("HR_Movement_Movements", 40, 0);
    private static CCache<String, BigDecimal> amountsHistory = new CCache("HR_Movement_Amounts", 40, 0);
    private static final long serialVersionUID = 9100478676337821603L;

    public static List<MHRMovement> findByProcessAndConceptValueAndPartnerId(MHRProcess process, String conceptValue, int partnerId) {
        return MHRMovement.findByProcessAndConceptValueAndPartnerId(process, conceptValue, partnerId, null, null);
    }

    public static List<MHRMovement> findByProcessAndConceptValueAndPartnerId(MHRProcess process, String conceptValue, int partnerId, String referenceNo, String description) {
        ArrayList<MHRMovement> movements = new ArrayList<MHRMovement>();
        MHRConcept concept = MHRConcept.getByValue(process.getCtx(), conceptValue, process.get_TrxName());
        if (concept == null) {
            return movements;
        }
        return MHRMovement.findByProcessAndConceptIdAndPartnerId(process, concept.getHR_Concept_ID(), partnerId, referenceNo, description);
    }

    public static List<MHRMovement> findByProcessAndConceptIdAndPartnerId(MHRProcess process, int conceptId, int partnerId, String referenceNo, String description) {
        List<MHRMovement> movements = new ArrayList<MHRMovement>();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (conceptId < 0) {
            return movements;
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("HR_Process_ID").append("=? AND ");
        parameters.add(process.getHR_Process_ID());
        whereClause.append("HR_Concept_ID").append("=? AND ");
        parameters.add(conceptId);
        whereClause.append("C_BPartner_ID").append("=?");
        parameters.add(partnerId);
        if (referenceNo != null && referenceNo.length() > 0) {
            whereClause.append(" AND ").append("ReferenceNo").append("=?");
            parameters.add(referenceNo);
        }
        if (description != null && description.length() > 0) {
            whereClause.append(" AND ").append("Description").append("=?");
            parameters.add(description);
        }
        movements = new Query(process.getCtx(), "HR_Movement", whereClause.toString(), process.get_TrxName()).setClient_ID().setParameters(parameters).list();
        return movements;
    }

    public static List<MHRMovement> findByConceptValueAndPartnerId(Properties ctx, String conceptValue, Integer partnerId, String referenceNo, String description, String trxName) {
        return MHRMovement.findByConceptValueAndPartnerId(ctx, conceptValue, partnerId, referenceNo, description, null, null, trxName);
    }

    public static List<MHRMovement> findByConceptValueAndPartnerId(Properties ctx, String conceptValue, Integer partnerId, String referenceNo, String description, Timestamp from, Timestamp to, String trxName) {
        List<MHRMovement> movements = new ArrayList<MHRMovement>();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (conceptValue == null) {
            return movements;
        }
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return movements;
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("HR_Concept_ID").append("=?");
        parameters.add(concept.getHR_Concept_ID());
        if (partnerId > 0) {
            whereClause.append(" AND ").append("C_BPartner_ID").append("=?");
            parameters.add(partnerId);
        }
        if (referenceNo != null && referenceNo.length() > 0) {
            whereClause.append(" AND ").append("ReferenceNo").append("=?");
            parameters.add(referenceNo);
        }
        if (description != null && description.length() > 0) {
            whereClause.append(" AND ").append("Description").append("=?");
            parameters.add(description);
        }
        if (from != null) {
            whereClause.append(" AND ").append("ValidFrom").append("=>?");
            parameters.add(from);
        }
        if (to != null) {
            whereClause.append(" AND ").append("ValidTo").append("<=?");
            parameters.add(to);
        }
        movements = new Query(ctx, "HR_Movement", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).list();
        return movements;
    }

    public static double getConceptSum(Properties ctx, String conceptValue, int payrollId, int partnerId, Timestamp from, Timestamp to, String trxName) {
        return MHRMovement.getConceptSum(ctx, conceptValue, payrollId, partnerId, from, to, false, trxName);
    }

    public static double getConceptSum(Properties ctx, String conceptValue, int payrollId, int partnerId, Timestamp from, Timestamp to, boolean includeInProcess, String trxName) {
        String fieldName;
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return 0.0;
        }
        String key = "SUM|" + concept.getHR_Concept_ID() + "|" + payrollId + "|" + partnerId + "|" + from + "|" + to + "|" + includeInProcess;
        BigDecimal value = amountsHistory.get(key);
        if (value != null) {
            return value.doubleValue();
        }
        if ("Q".equals(concept.getColumnType())) {
            fieldName = "Qty";
        } else if ("A".equals(concept.getColumnType())) {
            fieldName = "Amount";
        } else {
            return 0.0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Concept_ID=?");
        params.add(concept.get_ID());
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(partnerId);
        whereClause.append(" AND validTo BETWEEN ? AND ?");
        params.add(from);
        params.add(to);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND " + (includeInProcess ? "p.DocStatus IN('DR','IP', 'CO', 'CL')" : "p.DocStatus IN('CO', 'CL')") + " AND p.HR_Payroll_ID=?");
        params.add(payrollId);
        whereClause.append(")");
        StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM(").append(fieldName).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(whereClause);
        value = DB.getSQLValueBDEx(null, sql.toString(), params);
        amountsHistory.put(key, value);
        return value.doubleValue();
    }

    public static double getConceptAvg(Properties ctx, String conceptValue, int payrollId, int partnerId, Timestamp from, Timestamp to, String trxName) {
        return MHRMovement.getConceptAvg(ctx, conceptValue, payrollId, partnerId, from, to, true, trxName);
    }

    public static double getConceptAvg(Properties ctx, String conceptValue, int payrollId, int partnerId, Timestamp from, Timestamp to, boolean includeInProcess, String trxName) {
        String fieldName;
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return 0.0;
        }
        String key = "AVG|" + concept.getHR_Concept_ID() + "|" + payrollId + "|" + partnerId + "|" + from + "|" + to + "|" + includeInProcess;
        if (amountsHistory.containsKey(key)) {
            return Optional.ofNullable(amountsHistory.get(key)).orElse(Env.ZERO).doubleValue();
        }
        if ("Q".equals(concept.getColumnType())) {
            fieldName = "Qty";
        } else if ("A".equals(concept.getColumnType())) {
            fieldName = "Amount";
        } else {
            return 0.0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Concept_ID=?");
        params.add(concept.get_ID());
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(partnerId);
        whereClause.append(" AND validTo BETWEEN ? AND ?");
        params.add(from);
        params.add(to);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND " + (includeInProcess ? "p.DocStatus IN('DR', 'IP', 'CO', 'CL')" : "p.DocStatus IN('CO', 'CL')") + " AND p.HR_Payroll_ID=?");
        params.add(payrollId);
        whereClause.append(")");
        StringBuffer sql = new StringBuffer("SELECT COALESCE(AVG(").append(fieldName).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(whereClause);
        BigDecimal value = DB.getSQLValueBDEx(null, sql.toString(), params);
        amountsHistory.put(key, value);
        return value.doubleValue();
    }

    public static double getConceptSum(Properties ctx, String conceptValue, int payrollId, int partnerId, int periodId, int periodFrom, int periodTo, String trxName) {
        return MHRMovement.getConceptSum(ctx, conceptValue, payrollId, partnerId, periodId, periodFrom, periodTo, true, trxName);
    }

    public static double getConceptSum(Properties ctx, String conceptValue, int payrollId, int partnerId, int periodId, int periodFrom, int periodTo, boolean includeInProcess, String trxName) {
        String fieldName;
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return 0.0;
        }
        String key = "SUM|" + concept.getHR_Concept_ID() + "|" + payrollId + "|" + partnerId + "|" + periodId + "|" + periodFrom + "|" + periodTo + "|" + includeInProcess;
        if (amountsHistory.containsKey(key)) {
            return Optional.ofNullable(amountsHistory.get(key)).orElse(Env.ZERO).doubleValue();
        }
        if ("Q".equals(concept.getColumnType())) {
            fieldName = "Qty";
        } else if ("A".equals(concept.getColumnType())) {
            fieldName = "Amount";
        } else {
            return 0.0;
        }
        MHRPeriod period = MHRPeriod.getById(ctx, periodId, trxName);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Concept_ID=?");
        params.add(concept.get_ID());
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(partnerId);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND " + (includeInProcess ? "p.DocStatus IN('DR', 'IP', 'CO', 'CL')" : "p.DocStatus IN('CO', 'CL')") + " AND p.HR_Payroll_ID=?");
        params.add(payrollId);
        if (periodFrom < 0) {
            whereClause.append(" AND pr.PeriodNo >= ?");
            params.add(period.getPeriodNo() + periodFrom);
        }
        if (periodTo > 0) {
            whereClause.append(" AND pr.PeriodNo <= ?");
            params.add(period.getPeriodNo() + periodTo);
        }
        whereClause.append(")");
        StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM(").append(fieldName).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(whereClause);
        BigDecimal value = DB.getSQLValueBDEx(null, sql.toString(), params);
        amountsHistory.put(key, value);
        return value.doubleValue();
    }

    public static MHRMovement getLastMovement(Properties ctx, String conceptValue, int payrollId, int partnerId, Timestamp breakDate, String trxName) {
        return MHRMovement.getLastMovement(ctx, conceptValue, payrollId, partnerId, breakDate, false, trxName);
    }

    public static MHRMovement getLastMovement(Properties ctx, String conceptValue, String payrollValue, int partnerId, Timestamp breakDate, boolean isWithValidFrom, String trxName) {
        if (Util.isEmpty(payrollValue)) {
            return null;
        }
        if (Util.isEmpty(conceptValue)) {
            return null;
        }
        if (partnerId <= 0) {
            return null;
        }
        MHRPayroll payroll = MHRPayroll.getByValue(ctx, payrollValue, trxName);
        if (payroll == null) {
            return null;
        }
        return MHRMovement.getLastMovement(ctx, conceptValue, payroll.getHR_Payroll_ID(), partnerId, breakDate, isWithValidFrom, trxName);
    }

    public static MHRMovement getLastMovement(Properties ctx, String conceptValue, int payrollId, int partnerId, Timestamp breakDate, boolean isWithValidFrom, String trxName) {
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return null;
        }
        String key = concept.getHR_Concept_ID() + "|" + payrollId + "|" + partnerId + "|" + breakDate + "|" + isWithValidFrom;
        if (movementsHistory.containsKey(key)) {
            return movementsHistory.get(key);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Concept_ID=?");
        params.add(concept.get_ID());
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(partnerId);
        whereClause.append(" AND ").append(isWithValidFrom ? "ValidFrom" : "ValidTo").append(" <= ?");
        params.add(breakDate);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND p.DocStatus IN('CO', 'CL') AND p.HR_Payroll_ID=?");
        params.add(payrollId);
        whereClause.append(")");
        MHRMovement value = (MHRMovement)new Query(ctx, "HR_Movement", whereClause.toString(), trxName).setParameters(params).setOrderBy("ValidFrom DESC, Updated DESC").first();
        if (value != null) {
            value.set_TrxName(null);
        }
        movementsHistory.put(key, value);
        return value;
    }

    public static double getLastConcept(Properties ctx, String conceptValue, int payrollId, int partnerId, Timestamp breakDate, String trxName) {
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return 0.0;
        }
        if (!"Q".equals(concept.getColumnType()) && !"A".equals(concept.getColumnType())) {
            return 0.0;
        }
        MHRMovement lastMovement = MHRMovement.getLastMovement(ctx, conceptValue, payrollId, partnerId, breakDate, trxName);
        if (lastMovement == null) {
            return 0.0;
        }
        if ("Q".equals(concept.getColumnType())) {
            if (lastMovement.getQty() != null) {
                return lastMovement.getQty().doubleValue();
            }
        } else if ("A".equals(concept.getColumnType()) && lastMovement.getAmount() != null) {
            return lastMovement.getAmount().doubleValue();
        }
        return 0.0;
    }

    public static Timestamp getLastConceptDate(Properties ctx, String conceptValue, int payrollId, int partnerId, Timestamp breakDate, String trxName) {
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return null;
        }
        if (!"D".equals(concept.getColumnType())) {
            return null;
        }
        MHRMovement lastMovement = MHRMovement.getLastMovement(ctx, conceptValue, payrollId, partnerId, breakDate, trxName);
        if (lastMovement == null) {
            return null;
        }
        return lastMovement.getServiceDate();
    }

    public static double getConceptAvg(Properties ctx, String conceptValue, int payrollId, int partnerId, int periodId, int periodFrom, int periodTo, String trxName) {
        return MHRMovement.getConceptAvg(ctx, conceptValue, payrollId, partnerId, periodId, periodFrom, periodTo, true, trxName);
    }

    public static double getConceptAvg(Properties ctx, String conceptValue, int payrollId, int partnerId, int periodId, int periodFrom, int periodTo, boolean includeInProcess, String trxName) {
        String fieldName;
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return 0.0;
        }
        String key = "AVG|" + concept.getHR_Concept_ID() + "|" + payrollId + "|" + partnerId + "|" + periodId + "|" + periodFrom + "|" + periodTo + "|" + includeInProcess;
        if (amountsHistory.containsKey(key)) {
            return Optional.ofNullable(amountsHistory.get(key)).orElse(Env.ZERO).doubleValue();
        }
        if ("Q".equals(concept.getColumnType())) {
            fieldName = "Qty";
        } else if ("A".equals(concept.getColumnType())) {
            fieldName = "Amount";
        } else {
            return 0.0;
        }
        MHRPeriod period = MHRPeriod.getById(ctx, periodId, trxName);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Concept_ID=?");
        params.add(concept.get_ID());
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(partnerId);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND " + (includeInProcess ? "p.DocStatus IN('DR', 'IP', 'CO', 'CL')" : "p.DocStatus IN('CO', 'CL')") + " AND p.HR_Payroll_ID=?");
        params.add(payrollId);
        if (periodFrom < 0) {
            whereClause.append(" AND pr.PeriodNo >= ?");
            params.add(period.getPeriodNo() + periodFrom);
        }
        if (periodTo > 0) {
            whereClause.append(" AND pr.PeriodNo <= ?");
            params.add(period.getPeriodNo() + periodTo);
        }
        whereClause.append(")");
        StringBuffer sql = new StringBuffer("SELECT COALESCE(AVG(").append(fieldName).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(whereClause);
        BigDecimal value = DB.getSQLValueBDEx(null, sql.toString(), params);
        amountsHistory.put(key, value);
        return value.doubleValue();
    }

    public static List<MHRMovement> findByProcess(MHRProcess process) {
        String whereClause = "HR_Process_ID=?";
        return new Query(process.getCtx(), "HR_Movement", "HR_Process_ID=?", process.get_TrxName()).setClient_ID().setParameters(process.getHR_Process_ID()).list();
    }

    public MHRMovement(Properties ctx, int movementId, String trxName) {
        super(ctx, movementId, trxName);
    }

    public MHRMovement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRMovement(X_I_HR_Movement importPayrollMovement) {
        this(importPayrollMovement.getCtx(), 0, importPayrollMovement.get_TrxName());
        MHRConcept concept = new MHRConcept(this.getCtx(), importPayrollMovement.getHR_Concept_ID(), this.get_TrxName());
        MHREmployee employee = Optional.ofNullable(MHREmployee.getActiveEmployee(this.getCtx(), importPayrollMovement.getC_BPartner_ID(), this.get_TrxName())).orElseThrow(() -> new AdempiereException("@HR_Employee_ID@ @NotFound@"));
        this.setAD_Org_ID(employee.getAD_Org_ID());
        this.setUpdatedBy(importPayrollMovement.getUpdatedBy());
        this.setHR_Process_ID(importPayrollMovement.getHR_Process_ID());
        this.setC_BPartner_ID(importPayrollMovement.getC_BPartner_ID());
        this.setHR_Concept_ID(importPayrollMovement.getHR_Concept_ID());
        this.setHR_Concept_Category_ID(concept.getHR_Concept_Category_ID());
        this.setHR_Concept_Type_ID(concept.getHR_Concept_Type_ID());
        this.setDescription(importPayrollMovement.getDescription());
        this.setHR_Job_ID(employee.getHR_Job_ID());
        this.setHR_Department_ID(employee.getHR_Department_ID());
        this.setC_Activity_ID(employee.getC_Activity_ID());
        this.setValidFrom(importPayrollMovement.getValidFrom());
        this.setValidTo(importPayrollMovement.getValidTo());
        this.setIsManual(concept.isManual());
        this.setIsPrinted(concept.isPrinted());
        this.setAmount(null);
        this.setQty(null);
        this.setServiceDate(null);
        this.setTextMsg(null);
        if (concept.getColumnType().equals("Q")) {
            this.setQty(importPayrollMovement.getQty());
        } else if (concept.getColumnType().equals("A")) {
            this.setAmount(importPayrollMovement.getAmount());
        } else if (concept.getColumnType().equals("D")) {
            this.setServiceDate(importPayrollMovement.getServiceDate());
        } else if (concept.getColumnType().equals("T")) {
            this.setTextMsg(importPayrollMovement.getTextMsg());
        }
    }

    public MHRMovement(MHRProcess process, I_HR_Concept concept) {
        this(process.getCtx(), 0, process.get_TrxName());
        this.setSeqNo(concept.getSeqNo());
        this.setHR_Process_ID(process.getHR_Process_ID());
        this.setHR_Payroll_ID(process.getHR_Payroll_ID());
        this.setHR_Concept_Category_ID(concept.getHR_Concept_Category_ID());
        this.setHR_Concept_Type_ID(concept.getHR_Concept_Type_ID());
        this.setHR_Concept_ID(concept.getHR_Concept_ID());
    }

    public void addAmount(BigDecimal amount) {
        this.setAmount(this.getAmount().add(amount == null ? Env.ZERO : amount));
    }

    public void addQty(BigDecimal qty) {
        this.setQty(this.getAmount().add(qty == null ? Env.ZERO : qty));
    }

    public boolean isEmpty() {
        return this.getQty().signum() == 0 && this.getAmount().signum() == 0 && Util.isEmpty(this.getTextMsg()) && this.getServiceDate() == null;
    }

    public void setColumnValue(Object value) {
        block15: {
            if (value == null) {
                return;
            }
            MHRConcept concept = MHRConcept.getById(this.getCtx(), this.getHR_Concept_ID(), this.get_TrxName());
            if (concept == null) {
                throw new AdempiereException("@HR_Concept_ID@ @NotFound@");
            }
            try {
                String columnType = concept.getColumnType();
                int precision = MCurrency.getStdPrecision(this.getCtx(), Env.getContextAsInt(this.p_ctx, "#C_Currency_ID"));
                if (concept.getStdPrecision() > 0) {
                    precision = concept.getStdPrecision();
                }
                if ("T".equals(columnType)) {
                    this.setTextMsg(value.toString().trim());
                    break block15;
                }
                if ("D".equals(columnType)) {
                    if (value instanceof Timestamp) {
                        this.setServiceDate((Timestamp)value);
                    } else {
                        this.setServiceDate(Timestamp.valueOf(value.toString().trim().substring(0, 10) + " 00:00:00.0"));
                    }
                    break block15;
                }
                if ("Q".equals(columnType) || "A".equals(columnType)) {
                    double doubleValue = 0.0;
                    try {
                        doubleValue = Double.parseDouble(value.toString());
                    }
                    catch (Exception e) {
                        String businessPartnerName = "";
                        if (this.getC_BPartner_ID() != 0) {
                            MBPartner businessPartner = (MBPartner)this.getC_BPartner();
                            businessPartnerName = businessPartner.getValue() + " - " + businessPartner.getName();
                        }
                        throw new AdempiereException(businessPartnerName + " [" + concept.getValue() + " @Error@ " + value + "]");
                    }
                    if ("A".equals(columnType)) {
                        BigDecimal amount = new BigDecimal(doubleValue).setScale(precision, 4);
                        this.setAmount(amount);
                        this.setQty(Env.ZERO);
                    } else {
                        BigDecimal qty = new BigDecimal(doubleValue);
                        this.setQty(qty);
                        this.setAmount(Env.ZERO);
                    }
                    break block15;
                }
                throw new AdempiereException("@NotSupported@ @ColumnType@ - " + columnType);
            }
            catch (Exception e) {
                throw new AdempiereException(concept.getValue() + " - " + concept.getName() + " @Script Error@ " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getHR_Employee_ID() > 0) {
            return true;
        }
        MHREmployee employee = MHREmployee.getActiveEmployee(Env.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        if (employee != null) {
            this.setEmployee(employee);
        }
        return true;
    }

    public void setEmployee(MHREmployee employee) {
        this.setAD_Org_ID(employee.getAD_Org_ID());
        this.setHR_Department_ID(employee.getHR_Department_ID());
        this.setHR_Job_ID(employee.getHR_Job_ID());
        this.setC_Activity_ID(employee.getC_Activity_ID() > 0 ? employee.getC_Activity_ID() : employee.getHR_Department().getC_Activity_ID());
        this.setHR_Employee_ID(employee.getHR_Employee_ID());
        this.setHR_EmployeeType_ID(employee.getHR_EmployeeType_ID());
        this.setHR_SkillType_ID(employee.getHR_SkillType_ID());
        this.setHR_Payroll_ID(employee.getHR_Payroll_ID());
        this.setC_Project_ID(employee.getC_Project_ID());
        if (employee.getHR_Payroll_ID() > 0) {
            this.setHR_Contract_ID(employee.getHR_Payroll().getHR_Contract_ID());
        }
        this.setAD_Org_ID(employee.getAD_Org_ID());
        int activityId = employee.getC_Activity_ID();
        int user1Id = employee.getUser1_ID();
        int user2Id = employee.getUser2_ID();
        int user3Id = employee.getUser3_ID();
        int user4Id = employee.getUser4_ID();
        if (employee.getHR_Job_ID() > 0 && (activityId <= 0 || user1Id <= 0 || user2Id <= 0 || user3Id <= 0 || user4Id <= 0)) {
            MHRJob job = MHRJob.getById(this.getCtx(), employee.getHR_Job_ID(), this.get_TrxName());
            if (activityId <= 0) {
                activityId = job.getC_Activity_ID();
            }
            if (user1Id <= 0) {
                user1Id = job.getUser1_ID();
            }
            if (user2Id <= 0) {
                user2Id = job.getUser2_ID();
            }
            if (user3Id <= 0) {
                user3Id = job.getUser3_ID();
            }
            if (user4Id <= 0) {
                user4Id = job.getUser4_ID();
            }
        }
        if (employee.getHR_Department_ID() > 0 && (activityId <= 0 || user1Id <= 0 || user2Id <= 0 || user3Id <= 0 || user4Id <= 0)) {
            MHRDepartment department = MHRDepartment.getById(this.getCtx(), employee.getHR_Department_ID(), this.get_TrxName());
            if (activityId <= 0) {
                activityId = department.getC_Activity_ID();
            }
            if (user1Id <= 0) {
                user1Id = department.getUser1_ID();
            }
            if (user2Id <= 0) {
                user2Id = department.getUser2_ID();
            }
            if (user3Id <= 0) {
                user3Id = department.getUser3_ID();
            }
            if (user4Id <= 0) {
                user4Id = department.getUser4_ID();
            }
        }
        if (activityId > 0) {
            this.setC_Activity_ID(activityId);
        }
        if (user1Id > 0) {
            this.setUser1_ID(user1Id);
        }
        if (user2Id > 0) {
            this.setUser2_ID(user2Id);
        }
        if (user3Id > 0) {
            this.setUser3_ID(user3Id);
        }
        if (user4Id > 0) {
            this.setUser4_ID(user4Id);
        }
    }
}

