/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_DocType;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MPeriod;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.MStorage;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.X_DD_Order;
import org.eevolution.process.GenerateMovement;
import org.eevolution.process.GenerateMovementMaterial;
import org.eevolution.service.dsl.ProcessBuilder;

public class MDDOrder
extends X_DD_Order
implements DocAction {
    private static final long serialVersionUID = -5997157712614274458L;
    private List<MDDOrderLine> orderLines = null;
    private boolean m_forceCreation = false;
    private String processMessage = null;
    private boolean justPrepared = false;

    public static MDDOrder copyFrom(MDDOrder from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, boolean copyASI, String trxName) {
        MDDOrder to = new MDDOrder(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("DD_Order_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setIsSOTrx(isSOTrx);
        to.setIsSelected(false);
        to.setDateOrdered(dateDoc);
        to.setDatePromised(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setIsDelivered(false);
        to.setPosted(false);
        to.setProcessed(false);
        if (counter) {
            to.setRef_Order_ID(from.getDD_Order_ID());
        } else {
            to.setRef_Order_ID(0);
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Order");
        }
        if (counter) {
            from.setRef_Order_ID(to.getDD_Order_ID());
        }
        if (to.copyLinesFrom(from, counter, copyASI) == 0) {
            throw new IllegalStateException("Could not create Order Lines");
        }
        return to;
    }

    public MDDOrder(Properties ctx, int DD_Order_ID, String trxName) {
        super(ctx, DD_Order_ID, trxName);
        if (DD_Order_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
            this.setDeliveryRule("A");
            this.setFreightCostRule("I");
            this.setPriorityRule("5");
            this.setDeliveryViaRule("P");
            this.setIsSelected(false);
            this.setIsSOTrx(true);
            this.setIsDropShip(false);
            this.setSendEMail(false);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setIsDelivered(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setDatePromised(new Timestamp(System.currentTimeMillis()));
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setFreightAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
        }
    }

    public MDDOrder(MProject project, boolean IsSOTrx, String DocSubTypeSO) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setSalesRep_ID(project.getSalesRep_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setDescription(project.getName());
        Timestamp ts = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if ((ts = project.getDateFinish()) != null) {
            this.setDatePromised(ts);
        }
        this.setC_BPartner_ID(project.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(project.getC_BPartner_Location_ID());
        this.setAD_User_ID(project.getAD_User_ID());
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setIsSOTrx(IsSOTrx);
    }

    public MDDOrder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setShip_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
    }

    public void setShip_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
    }

    public void setShip_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
    }

    public void setBPartner(MBPartner bp) {
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID();
        String ss = bp.getDeliveryRule();
        if (ss != null) {
            this.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null) {
            this.setDeliveryViaRule(ss);
        }
        ss = bp.getInvoiceRule();
        if (this.getSalesRep_ID() == 0 && (ii = Env.getAD_User_ID(this.getCtx())) != 0) {
            this.setSalesRep_ID(ii);
        }
        List<MBPartnerLocation> partnerLocations = Arrays.asList(bp.getLocations(false));
        MBPartnerLocation partnerLocation = partnerLocations.stream().filter(pl -> pl.isShipTo()).reduce((first, last) -> last).orElseGet(() -> (MBPartnerLocation)partnerLocations.stream().findFirst().orElseThrow(() -> new AdempiereException("@IsShipTo@ @NotFound@")));
        this.setC_BPartner_Location_ID(partnerLocation.getC_BPartner_Location_ID());
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "MDDOrder.setBPartner - Has no Ship To Address: " + bp);
        }
        Arrays.asList(bp.getContacts(false)).stream().findFirst().ifPresent(user -> this.setAD_User_ID(user.getAD_User_ID()));
    }

    public int copyLinesFrom(MDDOrder otherOrder, boolean counter, boolean copyASI) {
        if (this.isProcessed() || this.isPosted() || otherOrder == null) {
            return 0;
        }
        List<MDDOrderLine> otherOrderLines = otherOrder.getLines(false, null);
        otherOrderLines.stream().forEach(otherOrderLine -> {
            MDDOrderLine orderLine = new MDDOrderLine(this);
            PO.copyValues(otherOrderLine, orderLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            orderLine.setDD_Order_ID(this.getDD_Order_ID());
            orderLine.setOrder(this);
            if (!copyASI) {
                orderLine.setM_AttributeSetInstance_ID(0);
            }
            orderLine.setQtyDelivered(Env.ZERO);
            orderLine.setQtyReserved(Env.ZERO);
            orderLine.setDateDelivered(null);
            orderLine.setProcessed(false);
            orderLine.saveEx(this.get_TrxName());
            this.orderLines.add(orderLine);
        });
        if (otherOrderLines.size() != this.orderLines.size()) {
            this.log.log(Level.SEVERE, "Line difference - From=" + otherOrderLines.size() + " <> Saved=" + this.orderLines.size());
        }
        return this.orderLines.size();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MDDOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        I_C_DocType docType = this.getC_DocType();
        return docType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return Optional.ofNullable(ReportEngine.get(this.getCtx(), 9, this.getDD_Order_ID())).orElseThrow(() -> new AdempiereException("@AD_PrintFormat_ID@ @NotFound@")).getPDF();
    }

    public List<MDDOrderLine> getLines(String whereClause, String orderClause) {
        StringBuffer whereClauseFinal = new StringBuffer("DD_Order_ID").append("=?");
        if (!Util.isEmpty(whereClause, true)) {
            whereClauseFinal.append(" AND (").append(whereClause).append(")");
        }
        return new Query(this.getCtx(), "DD_OrderLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(this.getDD_Order_ID()).setOrderBy(orderClause).list();
    }

    public List<MDDOrderLine> getLines(boolean reQuery, String orderBy) {
        if (this.orderLines != null && !reQuery) {
            this.orderLines.stream().forEach(orderLine -> orderLine.set_TrxName(this.get_TrxName()));
            return this.orderLines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? orderClause + orderBy : orderClause + "Line";
        this.orderLines = this.getLines(null, orderClause);
        return this.orderLines;
    }

    public List<MDDOrderLine> getLines() {
        return this.getLines(false, null);
    }

    public void renumberLines(int step) {
        AtomicInteger number = new AtomicInteger(0);
        this.orderLines = this.getLines(true, null);
        this.orderLines.stream().forEach(orderLine -> {
            orderLine.setLine(number.updateAndGet(lineNo -> lineNo + 10));
            orderLine.save(this.get_TrxName());
        });
        this.orderLines = null;
    }

    public List<MMovement> getMovement() {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("DD_Order_ID").append("=?");
        return new Query(this.getCtx(), "M_Movement", whereClause.toString(), this.get_TrxName()).setClient_ID().setOrderBy("Created").setParameters(this.getDD_Order_ID()).list();
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    @Override
    public void setDocAction(String DocAction2) {
        this.setDocAction(DocAction2, false);
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        this.getLines().stream().forEach(orderLine -> {
            orderLine.setProcessed(processed);
            orderLine.saveEx();
        });
        this.orderLines = null;
        this.log.fine("setProcessed - " + processed + " - Lines=" + this.getLines().size());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int userId;
        int contextOrgId;
        if (this.getAD_Org_ID() == 0 && (contextOrgId = Env.getAD_Org_ID(this.getCtx())) != 0) {
            this.setAD_Org_ID(contextOrgId);
            this.log.warning("Changed Org to Context=" + contextOrgId);
        }
        if (this.getAD_Client_ID() == 0) {
            this.processMessage = "AD_Client_ID = 0";
            return false;
        }
        if (newRecord && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getM_Warehouse_ID() == 0) {
            int warehouseId = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
            if (warehouseId != 0) {
                this.setM_Warehouse_ID(warehouseId);
            } else {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "M_Warehouse_ID"));
                return false;
            }
        }
        if (!newRecord && this.is_ValueChanged("M_Warehouse_ID") && !this.getLines().stream().anyMatch(orderLine -> orderLine.canChangeWarehouse())) {
            return false;
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getSalesRep_ID() == 0 && (userId = Env.getContextAsInt(this.getCtx(), "#AD_User_ID")) != 0) {
            this.setSalesRep_ID(userId);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("Description") || this.is_ValueChanged("POReference")) {
            this.getMovement().stream().filter(movement -> !movement.getDocStatus().endsWith("RE")).filter(movement -> !movement.getDocStatus().endsWith("CL")).forEach(movement -> {
                movement.setDescription(this.getDescription());
                movement.setPOReference(this.getPOReference());
                movement.saveEx();
            });
        }
        this.afterSaveSync("AD_Org_ID");
        this.afterSaveSync("C_BPartner_ID");
        this.afterSaveSync("C_BPartner_Location_ID");
        this.afterSaveSync("DateOrdered");
        this.afterSaveSync("DatePromised");
        this.afterSaveSync("M_Shipper_ID");
        return true;
    }

    private void afterSaveSync(String columnName) {
        if (this.is_ValueChanged(columnName)) {
            String whereClause = "DD_Order_ID=?";
            List orderLines = new Query(this.getCtx(), "DD_OrderLine", "DD_Order_ID=?", this.get_TrxName()).setParameters(this.getDD_Order_ID()).list();
            orderLines.stream().forEach(orderLine -> {
                orderLine.set_ValueOfColumn(columnName, this.get_Value(columnName));
                orderLine.saveEx();
                this.log.fine(columnName + " Lines -> #" + this.get_Value(columnName));
            });
        }
    }

    public void setDocAction(String DocAction2, boolean forceCreation) {
        super.setDocAction(DocAction2);
        this.m_forceCreation = forceCreation;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        this.getLines().stream().forEach(orderLine -> orderLine.deleteEx(true));
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.processMessage = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMessage != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateOrdered(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.processMessage = "@PeriodClosed@";
            return "IN";
        }
        List<MDDOrderLine> orderLines = this.getLines(true, "M_Product_ID");
        if (orderLines.isEmpty()) {
            this.processMessage = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("O")) {
            orderLines.stream().filter(orderLine -> orderLine.getProduct() != null && orderLine.getProduct().isExcludeAutoDelivery()).map(orderLine -> {
                this.processMessage = "@M_Product_ID@ " + orderLine.getProduct().getValue() + " @IsExcludeAutoDelivery@";
                return "IN";
            });
        }
        String mandatoryType = "='Y'";
        String sql = "SELECT COUNT(*) FROM DD_OrderLine ol INNER JOIN M_Product p ON (ol.M_Product_ID=p.M_Product_ID) INNER JOIN M_AttributeSet pas ON (p.M_AttributeSet_ID=pas.M_AttributeSet_ID) WHERE pas.MandatoryType" + mandatoryType + " AND ol.M_AttributeSetInstance_ID IS NULL AND ol.DD_Order_ID=?";
        int no = DB.getSQLValue(this.get_TrxName(), sql, this.getDD_Order_ID());
        if (no != 0) {
            this.processMessage = "@LinesWithoutProductAttribute@ (" + no + ")";
            return "IN";
        }
        this.reserveStock(orderLines);
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMessage != null) {
            return "IN";
        }
        this.justPrepared = true;
        return "IP";
    }

    public void reserveStock(List<MDDOrderLine> orderLines) {
        orderLines.stream().filter(orderLine -> orderLine.getCalculateQtyReserved().signum() != 0).filter(orderLine -> orderLine.getProduct() != null && orderLine.getProduct().isStocked()).forEach(orderLine -> {
            MLocator locatorFrom = MLocator.get(this.getCtx(), orderLine.getM_Locator_ID());
            MLocator locatorTo = MLocator.get(this.getCtx(), orderLine.getM_LocatorTo_ID());
            this.log.fine("Line=" + orderLine.getLine() + " - Ordered=" + orderLine.getQtyOrdered() + ",Reserved=" + orderLine.getQtyReserved() + ",Delivered=" + orderLine.getQtyDelivered());
            if (!MStorage.add(this.getCtx(), locatorTo.getM_Warehouse_ID(), locatorTo.getM_Locator_ID(), orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID(), orderLine.getM_AttributeSetInstance_ID(), Env.ZERO, Env.ZERO, orderLine.getCalculateQtyReserved(), this.get_TrxName())) {
                throw new AdempiereException("@M_Storage_ID@ @Error@ @To@ @QtyReserved@");
            }
            if (!MStorage.add(this.getCtx(), locatorFrom.getM_Warehouse_ID(), locatorFrom.getM_Locator_ID(), orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstanceTo_ID(), orderLine.getM_AttributeSetInstance_ID(), Env.ZERO, orderLine.getCalculateQtyReserved(), Env.ZERO, this.get_TrxName())) {
                throw new AdempiereException("@M_Storage_ID@ @Error@ @To@ @QtyReserved@");
            }
            orderLine.setQtyReserved(orderLine.getQtyReserved().add(orderLine.getCalculateQtyReserved()));
            orderLine.saveEx();
        });
        this.updateVolume();
        this.updateWeight();
    }

    public BigDecimal updateWeight() {
        BigDecimal weight = this.getLines().stream().filter(orderLine -> orderLine.getProduct() != null && orderLine.getProduct().isStocked()).map(MDDOrderLine::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setWeight(weight);
        this.saveEx();
        return weight;
    }

    public BigDecimal updateVolume() {
        BigDecimal volume = this.getLines().stream().filter(orderLine -> orderLine.getProduct() != null && orderLine.getProduct().isStocked()).map(MDDOrderLine::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setVolume(volume);
        this.saveEx();
        return volume;
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMessage != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.getLines(true, null);
        this.renumberLines(10);
        if (this.isDropShip()) {
            this.createDropShip();
        }
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            if (info.length() > 0) {
                info.append(" - ");
            }
            info.append(valid);
            this.processMessage = info.toString();
            return "IN";
        }
        this.setProcessed(true);
        this.processMessage = info.toString();
        this.setDocAction("CL");
        return "CO";
    }

    private void createDropShip() {
        Date date = Date.from(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Timestamp today = new Timestamp(date.getTime());
        ArrayList<Integer> recordIds = new ArrayList<Integer>();
        recordIds.add(this.getDD_Order_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(GenerateMovement.getProcessId()).withTitle(GenerateMovement.getProcessName()).withRecordId(Table_ID, 0).withSelectedRecordsIds(Table_ID, recordIds).withParameter("MovementDate", today).withParameter("DocAction", "CO").withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        ArrayList<Integer> orderLinesIds = new ArrayList<Integer>();
        LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection = new LinkedHashMap<Integer, LinkedHashMap<String, Object>>();
        this.getLines().stream().filter(orderLine -> orderLine != null).forEach(orderLine -> {
            orderLinesIds.add(orderLine.get_ID());
            LinkedHashMap<String, BigDecimal> values = new LinkedHashMap<String, BigDecimal>();
            values.put("LINE_QtyInTransit", orderLine.getQtyInTransit());
            selection.put(orderLine.get_ID(), values);
        });
        processInfo = ProcessBuilder.create(this.getCtx()).process(GenerateMovementMaterial.getProcessId()).withTitle(GenerateMovementMaterial.getProcessName()).withRecordId(MDDOrderLine.Table_ID, 0).withSelectedRecordsIds(MDDOrderLine.Table_ID, orderLinesIds, selection).withParameter("MovementDate", today).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.processMessage != null) {
            return false;
        }
        List<MDDOrderLine> lines = this.getLines(true, "M_Product_ID");
        lines.stream().filter(orderLine -> orderLine.getQtyOrdered().signum() != 0).forEach(orderLine -> {
            orderLine.setDescription(Optional.ofNullable(orderLine.getDescription()).orElse("") + " " + Msg.parseTranslation(this.getCtx(), "@Voided@  @QtyOrdered@ (" + orderLine.getQtyOrdered() + ")"));
            orderLine.save(this.get_TrxName());
        });
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.reserveStock(lines);
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.processMessage != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.processMessage != null) {
            return false;
        }
        List<MDDOrderLine> lines = this.getLines(true, "M_Product_ID");
        lines.stream().filter(orderLine -> orderLine.getQtyOrdered().compareTo(orderLine.getQtyDelivered()) != 0).forEach(orderLine -> {
            orderLine.setQtyOrdered(orderLine.getQtyDelivered());
            orderLine.setDescription(Optional.ofNullable(orderLine.getDescription()).orElse("") + " " + Msg.parseTranslation(this.getCtx(), "@close@  @QtyOrdered@ (" + orderLine.getQtyOrdered() + ")"));
            orderLine.save(this.get_TrxName());
        });
        this.reserveStock(lines);
        this.setProcessed(true);
        this.setDocAction("--");
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.processMessage == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMessage != null) {
            return false;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.processMessage != null) {
            return false;
        }
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMessage != null) {
            return false;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.processMessage != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMessage != null) {
            return false;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.processMessage != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.orderLines != null) {
            sb.append(" (#").append(this.orderLines.size()).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMessage;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

