/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.grid;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.adempiere.model.MBrowseField;
import org.compiere.model.GridField;
import org.compiere.model.MRule;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.eevolution.grid.BrowserCallOut;
import org.eevolution.grid.IBrowserTable;

public class BrowserRow {
    private static CLogger log = CLogger.getCLogger(BrowserRow.class);
    private Integer noViewColumns = 0;
    private LinkedHashMap<Integer, LinkedHashMap<Integer, GridField>> rows;
    private LinkedHashMap<Integer, MBrowseField> browserFields;
    private LinkedHashMap<Integer, Integer> fieldIndexes;
    private LinkedHashMap<Integer, Integer> displayIndex;
    private LinkedHashMap<String, Integer> columnNamesIndex;
    private IBrowserTable m_Table;
    private int m_CurrentRow = 0;
    private List<String> activeCallOuts = new ArrayList<String>();
    private List<BrowserCallOut> activeCallOutInstance = new ArrayList<BrowserCallOut>();

    public BrowserRow(IBrowserTable table2) {
        this.m_Table = table2;
        this.rows = new LinkedHashMap();
        this.browserFields = new LinkedHashMap();
        this.fieldIndexes = new LinkedHashMap();
        this.displayIndex = new LinkedHashMap();
        this.columnNamesIndex = new LinkedHashMap();
    }

    public void addBrowserField(MBrowseField field, int column) {
        if (field.isDisplayed()) {
            this.displayIndex.put(column, this.noViewColumns);
            this.fieldIndexes.put(this.noViewColumns, column);
            Integer n = this.noViewColumns;
            Integer n2 = this.noViewColumns = Integer.valueOf(this.noViewColumns + 1);
        }
        this.columnNamesIndex.put(field.getAD_View_Column().getColumnName(), column);
        this.browserFields.put(column, field);
    }

    public MBrowseField getBrowserField(int col) {
        return this.browserFields.get(col);
    }

    public void setValue(int row, int col, GridField gridField) {
        LinkedHashMap<Integer, GridField> values = this.rows.get(row);
        if (values == null) {
            values = new LinkedHashMap();
        }
        values.put(col, gridField);
        this.rows.put(row, values);
    }

    public GridField getValue(int row, int col) {
        if (this.rows.size() > row) {
            LinkedHashMap<Integer, GridField> values = this.rows.get(row);
            return values.get(col);
        }
        return null;
    }

    public LinkedHashMap<Integer, MBrowseField> getBrowserFields() {
        return this.browserFields;
    }

    public LinkedHashMap<Integer, LinkedHashMap<Integer, GridField>> getRows() {
        return this.rows;
    }

    public int size() {
        return this.rows.size();
    }

    public void clear() {
        this.rows.clear();
    }

    public int getColumnCount() {
        return this.browserFields.size();
    }

    public Integer getNoViewColumns() {
        return this.noViewColumns;
    }

    public int getDisplayIndex(int index) {
        return this.displayIndex.get(index);
    }

    public int getTableIndex(int display) {
        return this.fieldIndexes.get(display);
    }

    public IBrowserTable getTable() {
        return this.m_Table;
    }

    public void setTable(IBrowserTable table2) {
        this.m_Table = table2;
    }

    public int getSelectedRow() {
        if (this.m_Table == null) {
            return -1;
        }
        return this.m_Table.getSelectedRow();
    }

    public int getSelectedColumn() {
        if (this.m_Table == null) {
            return -1;
        }
        return this.m_Table.getSelectedColumn();
    }

    public Object getValueOfSelectedCell() {
        if (this.m_Table != null) {
            return this.getValue(this.getSelectedRow(), this.getTableIndex(this.getSelectedColumn()));
        }
        return null;
    }

    public void setValueOfSelectedCell(GridField gridField) {
        if (this.m_Table != null && gridField != null) {
            this.m_Table.setValueAt(this.getSelectedRow(), this.getSelectedColumn(), gridField);
        }
    }

    public Object getValueOfColumn(int col) {
        if (this.m_Table != null) {
            return this.getValue(this.getSelectedRow(), col);
        }
        return null;
    }

    public void setValueOfColumn(int row, String ColumnName, GridField gridField) {
        if (this.m_Table != null && this.columnNamesIndex.get(ColumnName) != null && gridField != null) {
            this.m_Table.setValueAt(row, this.getDisplayIndex(this.columnNamesIndex.get(ColumnName)), gridField);
        }
    }

    public void setValue(int p_Row, String p_ColumnName, Object p_Value) {
        if (this.m_Table == null) {
            return;
        }
        Integer columnIndex = this.columnNamesIndex.get(p_ColumnName);
        if (columnIndex == null) {
            return;
        }
        GridField gridField = this.getValue(p_Row, columnIndex);
        gridField.setValue(p_Value, true);
        if (gridField.isDisplayed()) {
            this.m_Table.setValueAt(p_Row, this.getDisplayIndex(columnIndex), gridField);
        } else {
            this.setValue(p_Row, columnIndex, gridField);
        }
    }

    public void setValue(String p_ColumnName, Object p_Value) {
        this.setValue(this.getCurrentRow(), p_ColumnName, p_Value);
    }

    public Object getValue(int p_Row, String p_ColumnName) {
        Integer columnIndex = this.columnNamesIndex.get(p_ColumnName);
        if (columnIndex == null) {
            return null;
        }
        GridField gridField = this.getValue(p_Row, columnIndex);
        if (gridField == null) {
            return null;
        }
        return gridField.getValue();
    }

    public Object getValue(String p_ColumnName) {
        return this.getValue(this.getCurrentRow(), p_ColumnName);
    }

    public Object getValueOfColumn(int row, String ColumnName) {
        if (this.m_Table != null) {
            int index;
            int n = index = this.columnNamesIndex.get(ColumnName) == null ? -1 : this.columnNamesIndex.get(ColumnName);
            if (index >= 0) {
                return this.getValue(row, index);
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            result.append(this.rows.get(i2) + "\n");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCallOut(Properties ctx, int WindowNo, GridField field, Object value, Object oldValue, int currentRow, int currentColumn) {
        this.setCurrentRow(currentRow);
        String callout = field.getCallout();
        if (callout.length() == 0) {
            return "";
        }
        log.fine(field.getColumnName() + "=" + value + " (" + callout + ") - old=" + oldValue);
        StringTokenizer st = new StringTokenizer(callout, ";,", false);
        while (st.hasMoreTokens()) {
            String cmd = st.nextToken().trim();
            if (this.activeCallOuts.contains(cmd)) continue;
            String retValue = "";
            if (cmd.toLowerCase().startsWith("@script:")) {
                MRule rule = MRule.get(ctx, cmd.substring("@script:".length()));
                if (rule == null) {
                    retValue = "Callout " + cmd + " not found";
                    log.log(Level.SEVERE, retValue);
                    return retValue;
                }
                if (!rule.getEventType().equals("C") || !rule.getRuleType().equals("S")) {
                    retValue = "Callout " + cmd + " must be of type JSR 223 and event Callout";
                    log.log(Level.SEVERE, retValue);
                    return retValue;
                }
                ScriptEngine engine = rule.getScriptEngine();
                MRule.setContext(engine, ctx, WindowNo);
                engine.put("A_WindowNo", WindowNo);
                engine.put("A_Tab", this);
                engine.put("A_Field", field);
                engine.put("A_Value", value);
                engine.put("A_OldValue", oldValue);
                engine.put("A_currentRow", currentRow);
                engine.put("A_currentColumn", currentColumn);
                engine.put("A_Ctx", ctx);
                try {
                    this.activeCallOuts.add(cmd);
                    retValue = engine.eval(rule.getScript()).toString();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "", e);
                    String string = retValue = "Callout Invalid: " + e.toString();
                    return string;
                }
                finally {
                    this.activeCallOuts.remove(cmd);
                }
            }
            BrowserCallOut call = null;
            String method = null;
            int methodStart = cmd.lastIndexOf(46);
            try {
                if (methodStart != -1) {
                    Class<?> cClass = Class.forName(cmd.substring(0, methodStart));
                    call = (BrowserCallOut)cClass.newInstance();
                    method = cmd.substring(methodStart + 1);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "class", e);
                return "Callout Invalid: " + cmd + " (" + e.toString() + ")";
            }
            if (call == null || method == null || method.length() == 0) {
                return "Callout Invalid: " + method;
            }
            try {
                this.activeCallOuts.add(cmd);
                this.activeCallOutInstance.add(call);
                retValue = call.start(ctx, method, WindowNo, this, field, value, oldValue, currentRow, currentColumn);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "start", e);
                String string = retValue = "Callout Invalid: " + e.toString();
                return string;
            }
            finally {
                this.activeCallOuts.remove(cmd);
                this.activeCallOutInstance.remove(call);
            }
            if (Util.isEmpty(retValue)) continue;
            log.severe(retValue);
            return retValue;
        }
        return "";
    }

    public void setCurrentRow(int p_CurrentRow) {
        this.m_CurrentRow = p_CurrentRow;
        log.fine("Row=" + this.m_CurrentRow);
        if (this.m_CurrentRow < 0) {
            return;
        }
        int size = this.getColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            GridField mField = this.getValue(this.m_CurrentRow, i2);
            if (mField == null) continue;
            mField.updateContext();
        }
    }

    public int getCurrentRow() {
        return this.m_CurrentRow;
    }
}

