/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.action;

import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.eevolution.form.action.PopupAction;
import org.eevolution.model.wrapper.AbstractPOWrapper;

public class ZoomMenuAction
extends PopupAction {
    public static final String COMMAND = "zoom";
    protected Object target;
    protected int tableID;
    protected String tableName;

    public ZoomMenuAction(int tableID, String tableName) {
        super(COMMAND);
        this.setActionCommand(COMMAND);
        this.tableID = tableID;
        this.tableName = tableName;
    }

    public ZoomMenuAction(Object target) throws Exception {
        super(COMMAND);
        this.setActionCommand(COMMAND);
        if (target != null && !(target instanceof JTree)) {
            throw new Exception("Unsupported target component: " + target.getClass().getName());
        }
        this.target = target;
    }

    @Override
    protected String getCommand() {
        return COMMAND;
    }

    @Override
    protected String validateAction() {
        return null;
    }

    @Override
    protected void doAction(ActionEvent e) {
        if (this.target != null) {
            this.zoom(this.target);
        } else {
            this.zoom();
        }
    }

    @Override
    protected boolean successful() {
        return true;
    }

    public Object getTarget() {
        return this.target;
    }

    private void zoom(Object obj) {
        if (obj instanceof JTree) {
            JTree tree = (JTree)obj;
            Object node = tree.getSelectionPath().getLastPathComponent();
            int tableId = 0;
            int recordId = 0;
            try {
                tableId = this.getTableID((DefaultMutableTreeNode)node);
                recordId = this.getRecordID((DefaultMutableTreeNode)node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            AEnv.zoom(tableId, recordId);
        }
    }

    private int getTableID(DefaultMutableTreeNode tn) throws Exception {
        PO po = null;
        if (tn.getUserObject() instanceof PO) {
            po = (PO)tn.getUserObject();
        } else if (tn.getUserObject() instanceof AbstractPOWrapper) {
            po = ((AbstractPOWrapper)tn.getUserObject()).get();
        } else {
            return -1;
        }
        Field f = po.getClass().getField("Table_ID");
        return f.getInt(null);
    }

    private int getRecordID(DefaultMutableTreeNode tn) {
        PO po = null;
        if (tn.getUserObject() instanceof PO) {
            po = (PO)tn.getUserObject();
        } else if (tn.getUserObject() instanceof AbstractPOWrapper) {
            po = ((AbstractPOWrapper)tn.getUserObject()).get();
        }
        return po == null ? -1 : po.get_ID();
    }

    private void zoom() {
        String tablename = this.tableName;
        int tableid = this.tableID;
        MQuery query = new MQuery();
        query.setTableName(tablename);
        AWindow window = new AWindow();
        if (window.initWindow(tableid, query)) {
            AEnv.showCenterScreen(window);
        }
        window = null;
    }
}

