/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAdvertisement;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MInOut;
import org.compiere.model.MInterestArea;
import org.compiere.model.MInvoice;
import org.compiere.model.MNote;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MRegistration;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MTimeExpense;
import org.compiere.model.X_A_Asset;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.WebUser;
import org.compiere.wf.MWFActivity;

public class WebInfo {
    private static WebInfo m_general = null;
    public static final String NAME = "info";
    private static CLogger log = CLogger.getCLogger(WebInfo.class);
    private Properties m_ctx = null;
    private WebUser m_wu = null;
    private String m_infoMessage = null;
    private int m_id = 0;

    public static WebInfo getGeneral() {
        if (m_general == null) {
            m_general = new WebInfo(new Properties(), null);
        }
        return m_general;
    }

    public WebInfo(Properties ctx, WebUser wu) {
        this.m_ctx = ctx;
        this.m_wu = wu;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WebInfo[");
        sb.append(this.getC_BPartner_ID());
        sb.append("]");
        return sb.toString();
    }

    public String getMessage() {
        String retValue = this.m_infoMessage;
        this.m_infoMessage = null;
        return retValue;
    }

    public String getInfo() {
        return this.m_infoMessage;
    }

    public void setMessage(String msg) {
        this.m_infoMessage = msg;
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(String id) {
        try {
            this.setId(Integer.parseInt(id));
        }
        catch (NumberFormatException ex) {
            log.log(Level.SEVERE, "ID=" + id + " - " + ex.toString());
            this.m_id = 0;
        }
    }

    public void setId(int id) {
        log.info("ID=" + id);
        this.m_id = id;
    }

    public int getAD_Client_ID() {
        if (this.m_wu == null) {
            return -1;
        }
        return this.m_wu.getAD_Client_ID();
    }

    public int getC_BPartner_ID() {
        if (this.m_wu == null) {
            return -1;
        }
        return this.m_wu.getC_BPartner_ID();
    }

    public int getAD_User_ID() {
        if (this.m_wu == null) {
            return -1;
        }
        return this.m_wu.getAD_User_ID();
    }

    public int getUser_ID() {
        return this.getAD_User_ID();
    }

    public WebUser getWebUser() {
        return this.m_wu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MOrder> getOrders() {
        this.m_infoMessage = null;
        ArrayList<MOrder> list = new ArrayList<MOrder>();
        if (this.m_wu != null && !this.m_wu.hasBPAccess("B", new Object[]{"POO", "SOO"})) {
            log.info("No Access");
            return list;
        }
        String sql = "SELECT * FROM C_Order WHERE Bill_BPartner_ID=? AND DocStatus NOT IN ('DR','IN') ORDER BY DocumentNo DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MOrder(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MOrder getOrder() {
        ResultSet rs;
        CPreparedStatement pstmt;
        MOrder retValue;
        block5: {
            this.m_infoMessage = null;
            retValue = null;
            if (this.m_wu != null && !this.m_wu.hasBPAccess("B", new Object[]{"POO", "SOO"})) {
                log.info("No Access");
                return null;
            }
            String sql = "SELECT * FROM C_Order WHERE Bill_BPartner_ID=? AND C_Order_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getC_BPartner_ID());
                pstmt.setInt(2, this.m_id);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                retValue = new MOrder(this.m_ctx, rs, null);
            }
            catch (Exception e) {
                try {
                    log.log(Level.SEVERE, "C_Order_ID=" + this.m_id, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.fine("C_Order_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MInOut> getShipments() {
        this.m_infoMessage = null;
        ArrayList<MInOut> list = new ArrayList<MInOut>();
        if (this.m_wu != null && !this.m_wu.hasBPAccess("B", new Object[]{"MMR", "MMS"})) {
            log.info("No Access");
            return list;
        }
        String sql = "SELECT * FROM M_InOut WHERE C_BPartner_ID=? AND DocStatus NOT IN ('DR','IN')  ORDER BY DocumentNo DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInOut(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    public ArrayList<MRequest> getRequestsOwn() {
        return this.getRequests(true);
    }

    public ArrayList<MRequest> getRequestsAssigned() {
        return this.getRequests(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MRequest> getRequests(boolean own) {
        this.m_infoMessage = null;
        ArrayList<MRequest> list = new ArrayList<MRequest>();
        String sql = null;
        sql = own ? "SELECT * FROM R_Request r WHERE r.C_BPartner_ID=? AND (r.AD_User_ID=? OR EXISTS (SELECT * FROM AD_User u WHERE u.AD_User_ID=? AND r.C_BPartner_ID=u.C_BPartner_ID AND IsFullBPAccess='Y') OR EXISTS (SELECT * FROM AD_User u INNER JOIN AD_UserBPAccess a ON (u.AD_User_ID=a.AD_User_ID) WHERE u.AD_User_ID=? AND r.C_BPartner_ID=u.C_BPartner_ID AND a.BPAccessType='R' AND (a.R_RequestType_ID IS NULL OR a.R_RequestType_ID=r.R_RequestType_ID)) ) ORDER BY r.DocumentNo DESC" : "SELECT * FROM R_Request WHERE SalesRep_ID IN (SELECT AD_User_ID FROM AD_User WHERE C_BPartner_ID=?) AND R_Status_ID IN (SELECT R_Status_ID FROM R_Status WHERE IsClosed='N')ORDER BY DocumentNo DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            if (own) {
                pstmt.setInt(2, this.getAD_User_ID());
                pstmt.setInt(3, this.getAD_User_ID());
                pstmt.setInt(4, this.getAD_User_ID());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRequest(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("Own=" + own + " #" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRequest getRequest() {
        this.m_infoMessage = null;
        MRequest retValue = null;
        String sql = "SELECT * FROM R_Request WHERE R_Request_ID=? AND (C_BPartner_ID=? OR SalesRep_ID IN (SELECT AD_User_ID FROM AD_User WHERE C_BPartner_ID=?))";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_id);
            pstmt.setInt(2, this.getC_BPartner_ID());
            pstmt.setInt(3, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MRequest(this.m_ctx, rs, null);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "R_Request_ID=" + this.m_id, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("R_Request_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MRequestType> getRequestTypes() {
        this.m_infoMessage = null;
        ArrayList<MRequestType> list = new ArrayList<MRequestType>();
        String sql = "SELECT * FROM R_RequestType WHERE IsSelfService='Y' AND AD_Client_ID=? ORDER BY Name";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_Client_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRequestType(this.m_ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRequestType getRequestType() {
        this.m_infoMessage = null;
        MRequestType retValue = null;
        String sql = "SELECT * FROM R_RequestType WHERE IsSelfService='Y' AND R_RequestType_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MRequestType(this.m_ctx, rs, null);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("R_RequestType_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MInvoice> getInvoices() {
        this.m_infoMessage = null;
        ArrayList<MInvoice> list = new ArrayList<MInvoice>();
        if (this.m_wu != null && !this.m_wu.hasBPAccess("B", new Object[]{"API", "APC", "ARI", "ARC"})) {
            log.info("No Access");
            return list;
        }
        String sql = "SELECT * FROM C_Invoice WHERE C_BPartner_ID=? AND DocStatus NOT IN ('DR','IN') ORDER BY DocumentNo DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInvoice(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MInvoice getInvoice() {
        ResultSet rs;
        CPreparedStatement pstmt;
        MInvoice retValue;
        block5: {
            this.m_infoMessage = null;
            retValue = null;
            if (this.m_wu != null && !this.m_wu.hasBPAccess("B", new Object[]{"API", "APC", "ARI", "ARC"})) {
                log.info("No Access");
                return null;
            }
            String sql = "SELECT * FROM C_Invoice WHERE C_BPartner_ID=? AND C_Invoice_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getC_BPartner_ID());
                pstmt.setInt(2, this.m_id);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                retValue = new MInvoice(this.m_ctx, rs, null);
            }
            catch (Exception e) {
                try {
                    log.log(Level.SEVERE, "C_Invoice_ID=" + this.m_id, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.fine("C_Invoice_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MPayment> getPayments() {
        this.m_infoMessage = null;
        ArrayList<MPayment> list = new ArrayList<MPayment>();
        if (this.m_wu != null && !this.m_wu.hasBPAccess("B", new Object[]{"APP", "ARR"})) {
            log.info("No Access");
            return list;
        }
        String sql = "SELECT * FROM C_Payment WHERE C_BPartner_ID=? AND DocStatus NOT IN ('DR','IN') ORDER BY DocumentNo DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPayment(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<X_A_Asset> getAssets() {
        this.m_infoMessage = null;
        ArrayList<X_A_Asset> list = new ArrayList<X_A_Asset>();
        if (this.m_wu != null) {
            if (this.m_wu.isCreditStopHold()) {
                return list;
            }
            if (!this.m_wu.isEMailVerified()) {
                return list;
            }
        }
        if (this.m_wu != null && !this.m_wu.hasBPAccess("A", null)) {
            log.info("No Access");
            return list;
        }
        String sql = "SELECT * FROM A_Asset WHERE C_BPartner_ID=? AND IsActive='Y' ORDER BY Name";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new X_A_Asset(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MInterestArea> getInterests() {
        this.m_infoMessage = null;
        int AD_Client_ID = Env.getAD_Client_ID(this.m_ctx);
        ArrayList<MInterestArea> list = new ArrayList<MInterestArea>();
        String sql = "SELECT * FROM R_InterestArea WHERE IsActive='Y' AND IsSelfService='Y' AND AD_Client_ID=? ORDER BY Name";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MInterestArea ia = new MInterestArea(this.m_ctx, rs, null);
                ia.setSubscriptionInfo(this.getAD_User_ID());
                list.add(ia);
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MAdvertisement> getAdvertisements() {
        this.m_infoMessage = null;
        ArrayList<MAdvertisement> list = new ArrayList<MAdvertisement>();
        String sql = "SELECT * FROM W_Advertisement WHERE C_BPartner_ID=? ORDER BY ValidFrom DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAdvertisement(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MAdvertisement> getAllAds() {
        this.m_infoMessage = null;
        ArrayList<MAdvertisement> list = new ArrayList<MAdvertisement>();
        String sql = "SELECT * FROM W_Advertisement WHERE IsActive='Y' ORDER BY Description";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAdvertisement(this.m_ctx, rs, null));
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MInvoice> getCommissionedInvoices() {
        this.m_infoMessage = null;
        ArrayList<MInvoice> list = new ArrayList<MInvoice>();
        String sql = "SELECT * FROM C_Invoice WHERE (C_Invoice.SalesRep_ID=? OR EXISTS (SELECT * FROM C_BPartner bp WHERE C_Invoice.C_BPartner_ID=bp.C_BPartner_ID AND bp.SalesRep_ID=?) OR EXISTS (SELECT * FROM C_InvoiceLine il INNER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID)  WHERE C_Invoice.C_Invoice_ID=il.C_Invoice_ID AND p.SalesRep_ID=?)) AND DocStatus NOT IN ('DR','IN') ORDER BY DocumentNo DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_User_ID());
            pstmt.setInt(2, this.getAD_User_ID());
            pstmt.setInt(3, this.getAD_User_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInvoice(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MCommissionRun> getCommissionRuns() {
        this.m_infoMessage = null;
        ArrayList<MCommissionRun> list = new ArrayList<MCommissionRun>();
        String sql = "SELECT * FROM C_CommissionRun WHERE EXISTS (SELECT * FROM C_Commission c WHERE C_CommissionRun.C_Commission_ID=c.C_Commission_ID AND c.C_BPartner_ID=?) ORDER BY DocumentNo";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCommissionRun(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MNote> getNotes() {
        ArrayList<MNote> list = new ArrayList<MNote>();
        String sql = "SELECT * FROM AD_Note WHERE AD_User_ID=? AND (Processed='N' OR Processed IS NULL) ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_User_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MNote(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MNote getNote() {
        ResultSet rs;
        CPreparedStatement pstmt;
        MNote retValue;
        block4: {
            this.m_infoMessage = null;
            retValue = null;
            String sql = "SELECT * FROM AD_Note WHERE AD_User_ID=? AND AD_Note_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getAD_User_ID());
                pstmt.setInt(2, this.m_id);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                retValue = new MNote(this.m_ctx, rs, null);
            }
            catch (Exception e) {
                try {
                    log.log(Level.SEVERE, "AD_Note_ID=" + this.m_id, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.fine("AD_Note_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MWFActivity> getActivities() {
        ArrayList<MWFActivity> list = new ArrayList<MWFActivity>();
        String sql = "SELECT * FROM AD_WF_Activity WHERE AD_User_ID=? AND Processed='N' ORDER BY Priority DESC, Created";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_User_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MWFActivity(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWFActivity getActivity() {
        ResultSet rs;
        CPreparedStatement pstmt;
        MWFActivity retValue;
        block4: {
            this.m_infoMessage = null;
            retValue = null;
            String sql = "SELECT * FROM AD_WF_Activity WHERE AD_User_ID=? AND AD_WF_Activity_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getAD_User_ID());
                pstmt.setInt(2, this.m_id);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                retValue = new MWFActivity(this.m_ctx, rs, null);
            }
            catch (Exception e) {
                try {
                    log.log(Level.SEVERE, "AD_WF_Activity_ID=" + this.m_id, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.fine("AD_WF_Activity_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MTimeExpense> getExpenses() {
        this.m_infoMessage = null;
        ArrayList<MTimeExpense> list = new ArrayList<MTimeExpense>();
        String sql = "SELECT * FROM S_TimeExpense WHERE C_BPartner_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTimeExpense(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTimeExpense getExpense() {
        ResultSet rs;
        CPreparedStatement pstmt;
        MTimeExpense retValue;
        block5: {
            this.m_infoMessage = null;
            retValue = null;
            String sql = "SELECT * FROM S_TimeExpense WHERE C_BPartner_ID=? AND S_TimeExpense_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getC_BPartner_ID());
                pstmt.setInt(2, this.m_id);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                retValue = new MTimeExpense(this.m_ctx, rs, null);
            }
            catch (Exception e) {
                try {
                    log.log(Level.SEVERE, "S_TimeExpense_ID=" + this.m_id, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue == null) {
            retValue = new MTimeExpense(this.m_ctx, 0, null);
        }
        log.fine("S_TimeExpense_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MRegistration> getRegistrations() {
        this.m_infoMessage = null;
        ArrayList<MRegistration> list = new ArrayList<MRegistration>();
        String sql = "SELECT * FROM A_Registration WHERE C_BPartner_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRegistration(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRegistration getRegistration() {
        ResultSet rs;
        CPreparedStatement pstmt;
        MRegistration retValue;
        block5: {
            this.m_infoMessage = null;
            retValue = null;
            String sql = "SELECT * FROM A_Registration WHERE C_BPartner_ID=? AND A_Registration_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getC_BPartner_ID());
                pstmt.setInt(2, this.m_id);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                retValue = new MRegistration(this.m_ctx, rs, null);
            }
            catch (Exception e) {
                try {
                    log.log(Level.SEVERE, "A_Registration_ID=" + this.m_id, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue == null) {
            retValue = new MRegistration(this.m_ctx, 0, null);
        }
        log.fine("A_Registration_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MRfQ> getRfQs() {
        this.m_infoMessage = null;
        ArrayList<MRfQ> list = new ArrayList<MRfQ>();
        String sql = "SELECT * FROM C_RfQ r WHERE r.IsRfQResponseAccepted='Y' AND r.IsSelfService='Y' AND r.IsActive='Y' AND r.Processed='N' AND (r.IsInvitedVendorsOnly='N' OR EXISTS (SELECT * FROM C_RfQResponse rr  WHERE r.C_RfQ_ID=rr.C_RfQ_ID AND rr.C_BPartner_ID=?)) ORDER BY r.Name";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_BPartner_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRfQ(this.m_ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        log.fine("#" + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRfQResponse getRfQResponse() {
        MRfQ rfq;
        ResultSet rs;
        CPreparedStatement pstmt;
        MRfQResponse retValue;
        block5: {
            this.m_infoMessage = null;
            retValue = null;
            String sql = "SELECT * FROM C_RfQResponse WHERE C_RfQ_ID=? AND C_BPartner_ID=? AND IsActive='Y'";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_id);
                pstmt.setInt(2, this.getC_BPartner_ID());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                retValue = new MRfQResponse(this.m_ctx, rs, null);
            }
            catch (Exception e) {
                try {
                    log.log(Level.SEVERE, "C_RfQResponse_ID=" + this.m_id, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue == null && (rfq = new MRfQ(this.m_ctx, this.m_id, null)).get_ID() != 0 && rfq.isSelfService() && rfq.isRfQResponseAccepted() && !rfq.isInvitedVendorsOnly() && this.getC_BPartner_ID() > 0 && this.getAD_User_ID() > 0) {
            MBPartner bp = new MBPartner(this.m_ctx, this.getC_BPartner_ID(), null);
            bp.setPrimaryAD_User_ID(this.getAD_User_ID());
            retValue = new MRfQResponse(rfq, bp);
            retValue.saveEx();
        }
        log.fine("C_RfQResponse_ID=" + this.m_id + " - " + retValue);
        return retValue;
    }
}

