/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MProject;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectProcessorChange;
import org.compiere.model.MProjectProcessorQueued;
import org.compiere.model.MProjectTask;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.util.DisplayType;
import org.eevolution.model.MProjectMember;
import org.eevolution.model.MProjectProcessor;
import org.eevolution.model.MProjectProcessorLog;

public class ProjectProcessorUtils {
    private static POInfo p_info = null;
    public static String[] LISTEN_COLUMNS = new String[]{"ProjectManager_ID", "Name", "Description", "Note", "C_ProjectStatus_ID", "DateLastAction", "PriorityRule", "DateStartSchedule", "DateFinishSchedule", "DateStart", "DateFinish", "DateDeadline", "DateContract", "IsIndefinite", "IsActive", "DateLastAlert", "M_PriceList_Version_ID", "ProjInvoiceRule", "C_BPartner_ID", "PlannedAmt", "PlannedQty", "Help", "Responsible_ID", "PercentageCompleted", "DurationEstimated", "DurationReal", "IsRecurrent", "FrequencyType", "Frequency", "RunsMax", "RunsRemaining", "DateNextRun", "DateLastRun", "StartDate", "EndDate", "IsMilestone", "DateFinish", "C_ProjectTaskCategory_ID"};
    public static String[] EXCLUDE_COLUMNS = new String[]{"DateLastAlert"};
    public static String[] RESPONSIBLE_COLUMNS = new String[]{"ProjectManager_ID", "Responsible_ID"};
    public static String[] INFO_COLUMNS = new String[]{"CreatedBy", "C_ProjectStatus_ID", "PriorityRule", "DueType", "C_ProjectCategory_ID", "C_ProjectClass_ID", "C_ProjectGroup_ID"};
    public static String[] TIME_COLUMNS = new String[]{"DateStartSchedule", "DateFinishSchedule", "DateStart", "DateFinish", "StartDate", "EndDate", "DateDeadline", "PercentageCompleted"};

    public static String get_DisplayValue(String columnName, PO entity) {
        Lookup lookup;
        if (entity == null) {
            return "--";
        }
        Object value = entity.get_Value(columnName);
        if (value == null) {
            return "--";
        }
        if (p_info == null || p_info != null && p_info.getAD_Table_ID() != entity.get_Table_ID()) {
            p_info = POInfo.getPOInfo(entity.getCtx(), entity.get_Table_ID(), entity.get_TrxName());
        }
        if (p_info == null) {
            return entity.get_ValueAsString(columnName);
        }
        String retValue = value.toString();
        int index = entity.get_ColumnIndex(columnName);
        if (index < 0) {
            return retValue;
        }
        int displayType = p_info.getColumnDisplayType(index);
        if (DisplayType.isText(displayType) || 20 == displayType) {
            return retValue;
        }
        if (DisplayType.isDate(displayType)) {
            SimpleDateFormat format = DisplayType.getDateFormat(displayType);
            return format.format(value);
        }
        if (DisplayType.isNumeric(displayType)) {
            DecimalFormat format = DisplayType.getNumberFormat(displayType);
            format.format(value);
        }
        if ((lookup = p_info.getColumnLookup(index)) != null) {
            return lookup.getDisplay(value);
        }
        return retValue;
    }

    public static MProjectProcessorLog runProjectProcessor(PO entity, MProjectProcessor currentProcessor, String m_summary, String eventChangeLog) {
        MProject project = null;
        MProjectPhase projectPhase = null;
        MProjectTask projectTask = null;
        MProjectProcessorLog pLog = null;
        if (entity instanceof MProject) {
            project = (MProject)entity;
        } else if (entity instanceof MProjectPhase) {
            projectPhase = (MProjectPhase)entity;
            project = (MProject)projectPhase.getC_Project();
        } else if (entity instanceof MProjectTask) {
            projectTask = (MProjectTask)entity;
            projectPhase = (MProjectPhase)projectTask.getC_ProjectPhase();
            project = (MProject)projectPhase.getC_Project();
        }
        if (currentProcessor == null) {
            List processor = new Query(entity.getCtx(), "C_ProjectProcessor", "", entity.get_TrxName()).setOrderBy("C_ProjectType_ID,C_ProjectTaskCategory_ID").list();
            for (MProjectProcessor mProjectProcessor : processor) {
                if (project != null && currentProcessor == null && project.getAD_Client_ID() == mProjectProcessor.getAD_Client_ID()) {
                    currentProcessor = mProjectProcessor;
                }
                if (project != null && project.getAD_Client_ID() == mProjectProcessor.getAD_Client_ID() && project.get_ValueAsInt("C_ProjectType_ID") == mProjectProcessor.getC_ProjectType_ID()) {
                    currentProcessor = mProjectProcessor;
                }
                if (project == null || projectTask == null || project.getAD_Client_ID() != mProjectProcessor.getAD_Client_ID() || projectTask.getC_ProjectTaskCategory_ID() != mProjectProcessor.getC_ProjectTaskCategory_ID()) continue;
                currentProcessor = mProjectProcessor;
                break;
            }
        }
        if (currentProcessor != null) {
            int no = currentProcessor.deleteLog();
            m_summary = m_summary + "Logs deleted=" + no;
            pLog = new MProjectProcessorLog(currentProcessor, m_summary);
            pLog.setEventChangeLog(eventChangeLog);
            if (!pLog.save()) {
                throw new AdempiereException("@SaveError@ @C_ProjectProcessorLog_ID@");
            }
            int addQueued = 0;
            if (entity.get_Table_ID() == MProject.Table_ID && project != null && project.getProjectManager_ID() != 0 && ProjectProcessorUtils.addQueued(pLog, entity.getUpdatedBy(), project.getProjectManager_ID())) {
                ++addQueued;
            }
            if (entity.get_Table_ID() == MProjectPhase.Table_ID) {
                if (projectPhase != null && projectPhase.getResponsible_ID() != 0 && ProjectProcessorUtils.addQueued(pLog, entity.getUpdatedBy(), projectPhase.getResponsible_ID())) {
                    ++addQueued;
                }
                if (project != null && project.getProjectManager_ID() != 0 && ProjectProcessorUtils.addQueued(pLog, entity.getUpdatedBy(), project.getProjectManager_ID())) {
                    ++addQueued;
                }
            }
            if (entity.get_Table_ID() == MProjectTask.Table_ID) {
                if (projectTask != null && projectTask.getResponsible_ID() != 0 && ProjectProcessorUtils.addQueued(pLog, entity.getUpdatedBy(), projectTask.getResponsible_ID())) {
                    ++addQueued;
                }
                if (projectPhase != null && projectPhase.getResponsible_ID() != 0 && ProjectProcessorUtils.addQueued(pLog, entity.getUpdatedBy(), projectPhase.getResponsible_ID())) {
                    ++addQueued;
                }
                if (project != null && project.getProjectManager_ID() != 0 && ProjectProcessorUtils.addQueued(pLog, entity.getUpdatedBy(), project.getProjectManager_ID())) {
                    ++addQueued;
                }
            }
            if (project != null) {
                List<MProjectMember> members = MProjectMember.getMembers(project);
                for (MProjectMember mProjectMember : members) {
                    if (!ProjectProcessorUtils.addQueued(pLog, entity.getUpdatedBy(), mProjectMember.getAD_User_ID(), mProjectMember.getNotificationType())) continue;
                    ++addQueued;
                }
            }
            if (addQueued > 0) {
                ProjectProcessorUtils.addChanges(pLog, entity);
            }
        }
        return pLog;
    }

    private static boolean addQueued(MProjectProcessorLog pLog, int updatedById, int userId, String NotificationType) {
        MUser user = MUser.get(pLog.getCtx(), userId);
        if (user.getAD_User_ID() == updatedById && !user.isIncludeOwnChanges()) {
            return false;
        }
        MProjectProcessorQueued queued = new MProjectProcessorQueued(pLog, userId);
        if (NotificationType != null && !NotificationType.equals(queued.getNotificationType())) {
            queued.setNotificationType(NotificationType);
        }
        if (NotificationType == null && queued.getNotificationType() == null) {
            queued.setNotificationType("X");
        }
        if ((queued.is_new() || queued.is_Changed()) && !queued.save()) {
            throw new AdempiereException("@SaveError@ @C_ProjectProcessorQueued_ID@");
        }
        return true;
    }

    private static boolean addQueued(MProjectProcessorLog pLog, int updatedById, int userId) {
        return ProjectProcessorUtils.addQueued(pLog, updatedById, userId, null);
    }

    private static int addChanges(MProjectProcessorLog log, PO entity) {
        int columnChanges = 0;
        for (int i2 = 0; i2 < entity.get_ColumnCount(); ++i2) {
            String columnName = entity.get_ColumnName(i2);
            if ((!entity.is_ValueChanged(i2) || !ProjectProcessorUtils.isListenColumn(columnName)) && (!log.getEventChangeLog().equals("I") || !columnName.equals("Created") && !columnName.equals("CreatedBy"))) continue;
            MProjectProcessorChange change = new MProjectProcessorChange(log);
            change.setAD_Table_ID(entity.get_Table_ID());
            change.setRecord_ID(entity.get_ID());
            change.setAD_Column_ID(MColumn.getColumn_ID(entity.get_TableName(), columnName));
            change.setNewValue(ProjectProcessorUtils.get_DisplayValue(columnName, entity));
            if (!change.save()) {
                throw new AdempiereException("@SaveError@ @C_ProjectProcessorQueued_ID@");
            }
            ++columnChanges;
        }
        return columnChanges;
    }

    public static boolean isListenColumn(String column) {
        if (column != null) {
            for (String column_listen : LISTEN_COLUMNS) {
                if (!column_listen.equals(column)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExcludeColumn(String column) {
        if (column != null) {
            for (String column_exclude : EXCLUDE_COLUMNS) {
                if (!column_exclude.equals(column)) continue;
                return true;
            }
        }
        return false;
    }
}

