/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.util.AmtInWords;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;

public final class Msg {
    private static final int MAP_SIZE = 1500;
    private static final String SEPARATOR = Env.NL + Env.NL;
    private static Msg s_msg = null;
    private static CLogger s_log = CLogger.getCLogger(Msg.class);
    private CCache<String, CCache<String, String>> m_languages = new CCache("msg_lang", 2, 0);

    private static synchronized Msg get() {
        if (s_msg == null) {
            s_msg = new Msg();
        }
        return s_msg;
    }

    private Msg() {
    }

    private CCache<String, String> getMsgMap(String ad_language) {
        CCache<String, String> retValue;
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retValue = this.m_languages.get(AD_Language)) != null && retValue.size() > 0) {
            return retValue;
        }
        retValue = this.initMsg(AD_Language);
        if (retValue != null) {
            this.m_languages.put(AD_Language, retValue);
            return retValue;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CCache<String, String> initMsg(String AD_Language) {
        CCache<String, String> msg = new CCache<String, String>("AD_Message", 1500, 0);
        if (!DB.isConnected()) {
            s_log.log(Level.SEVERE, "No DB Connection");
            return null;
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (AD_Language == null || AD_Language.length() == 0 || Env.isBaseLanguage(AD_Language, "AD_Language")) {
                pstmt = DB.prepareStatement("SELECT Value, MsgText, MsgTip FROM AD_Message", null);
            } else {
                pstmt = DB.prepareStatement("SELECT m.Value, t.MsgText, t.MsgTip FROM AD_Message_Trl t, AD_Message m WHERE m.AD_Message_ID=t.AD_Message_ID AND t.AD_Language=?", null);
                pstmt.setString(1, AD_Language);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String AD_Message = rs.getString(1);
                StringBuffer MsgText = new StringBuffer();
                MsgText.append(rs.getString(2));
                String MsgTip = rs.getString(3);
                if (MsgTip != null) {
                    MsgText.append(" ").append(SEPARATOR).append(MsgTip);
                }
                msg.put(AD_Message, MsgText.toString());
            }
        }
        catch (SQLException e) {
            CCache<String, String> cCache;
            try {
                s_log.log(Level.SEVERE, "initMsg", e);
                cCache = null;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return cCache;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (msg.size() < 100) {
            s_log.log(Level.SEVERE, "Too few (" + msg.size() + ") Records found for " + AD_Language);
            return null;
        }
        s_log.info("Records=" + msg.size() + " - " + AD_Language);
        return msg;
    }

    public void reset() {
        if (this.m_languages == null) {
            return;
        }
        for (CCache<String, String> hm : this.m_languages.values()) {
            hm.reset();
        }
        this.m_languages.clear();
    }

    public String[] getLanguages() {
        if (this.m_languages == null) {
            return null;
        }
        String[] retValue = new String[this.m_languages.size()];
        this.m_languages.keySet().toArray(retValue);
        return retValue;
    }

    public boolean isLoaded(String language) {
        if (this.m_languages == null) {
            return false;
        }
        return this.m_languages.containsKey(language);
    }

    private String lookup(String AD_Language, String text) {
        if (text == null) {
            return null;
        }
        if (AD_Language == null || AD_Language.length() == 0) {
            return text;
        }
        if (text.equals("/") || text.equals("\\")) {
            return File.separator;
        }
        if (text.equals(";") || text.equals(":")) {
            return File.pathSeparator;
        }
        if (text.equals("ADEMPIERE_HOME")) {
            return Adempiere.getAdempiereHome();
        }
        if (text.equals("bat") || text.equals("sh")) {
            if (System.getProperty("os.name").startsWith("Win")) {
                return "bat";
            }
            return "sh";
        }
        if (text.equals("CopyRight")) {
            return "\u00a9 1999-2019 ADempiere\u00ae";
        }
        CCache<String, String> langMap = this.getMsgMap(AD_Language);
        if (langMap == null) {
            return null;
        }
        return langMap.get(text);
    }

    public static String getMsg(String ad_language, String AD_Message) {
        String retStr;
        if (AD_Message == null || AD_Message.length() == 0) {
            return "";
        }
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retStr = Msg.get().lookup(AD_Language, AD_Message)) == null || retStr.length() == 0) {
            s_log.warning("NOT found: " + AD_Message);
            return AD_Message;
        }
        return retStr;
    }

    public static String getMsg(Properties ctx, String AD_Message) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message);
    }

    public static String getMsg(Language language, String AD_Message) {
        return Msg.getMsg(language.getAD_Language(), AD_Message);
    }

    public static String getMsg(String ad_language, String AD_Message, boolean getText) {
        String retStr = Msg.getMsg(ad_language, AD_Message);
        int pos = retStr.indexOf(SEPARATOR);
        if (pos == -1) {
            if (getText) {
                return retStr;
            }
            return "";
        }
        if (getText) {
            retStr = retStr.substring(0, pos);
        } else {
            int start = pos + SEPARATOR.length();
            retStr = retStr.substring(start);
        }
        return retStr;
    }

    public static String getMsg(Properties ctx, String AD_Message, boolean getText) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message, getText);
    }

    public static String getMsg(Language language, String AD_Message, boolean getText) {
        return Msg.getMsg(language.getAD_Language(), AD_Message, getText);
    }

    public static String getMsg(Properties ctx, String AD_Message, Object[] args) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message, args);
    }

    public static String getMsg(Language language, String AD_Message, Object[] args) {
        return Msg.getMsg(language.getAD_Language(), AD_Message, args);
    }

    public static String getMsg(String ad_language, String AD_Message, Object[] args) {
        String msg;
        String retStr = msg = Msg.getMsg(ad_language, AD_Message);
        try {
            retStr = MessageFormat.format(msg, args);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, msg, e);
        }
        return retStr;
    }

    public static String getAmtInWords(Language language, String amount) {
        if (amount == null || language == null) {
            return amount;
        }
        String className = "org.compiere.util.AmtInWords_";
        try {
            className = className + language.getLanguageCode().toUpperCase();
            Class<?> clazz = Class.forName(className);
            AmtInWords aiw = (AmtInWords)clazz.newInstance();
            return aiw.getAmtInWords(amount);
        }
        catch (ClassNotFoundException e) {
            s_log.log(Level.FINER, "Class not found: " + className);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, className, e);
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        for (int i2 = 0; i2 < amount.length(); ++i2) {
            if (pos == i2) {
                String cents = amount.substring(i2 + 1);
                sb.append(' ').append(cents).append("/100");
                break;
            }
            char c = amount.charAt(i2);
            if (c == ',' || c == '.') continue;
            if (sb.length() > 0) {
                sb.append("*");
            }
            sb.append(Msg.getMsg(language, String.valueOf(c)));
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public static String getElement(String ad_language, String ColumnName, boolean isSOTrx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 0[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getElement(Properties ctx, String ColumnName) {
        return Msg.getElement(Env.getAD_Language(ctx), ColumnName, true);
    }

    public static String getElement(Properties ctx, String ColumnName, boolean isSOTrx) {
        return Msg.getElement(Env.getAD_Language(ctx), ColumnName, isSOTrx);
    }

    public static String translate(String ad_language, boolean isSOTrx, String text) {
        String retStr;
        if (text == null || text.equals("")) {
            return "";
        }
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retStr = Msg.get().lookup(AD_Language, text)) != null) {
            return retStr;
        }
        retStr = Msg.getElement(AD_Language, text, isSOTrx);
        if (!retStr.equals("")) {
            return retStr.trim();
        }
        if (!text.startsWith("*")) {
            s_log.warning("NOT found: " + text);
        }
        return text;
    }

    public static String translate(String ad_language, String text) {
        return Msg.translate(ad_language, true, text);
    }

    public static String translate(Properties ctx, String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String s = ctx.getProperty(text);
        if (s != null && s.length() > 0) {
            return s;
        }
        return Msg.translate(Env.getAD_Language(ctx), Env.isSOTrx(ctx), text);
    }

    public static String translate(Language language, String text) {
        return Msg.translate(language.getAD_Language(), false, text);
    }

    public static String parseTranslation(Properties ctx, String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String inStr = text;
        StringBuffer outStr = new StringBuffer();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                inStr = "@" + inStr;
                break;
            }
            String token = inStr.substring(0, j);
            outStr.append(Msg.translate(ctx, token));
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }
}

