/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.Security;
import org.apache.commons.codec.binary.Base64;
import sun.security.provider.Sun;

public class DigestOfFile {
    private MessageDigest digestAgent;
    private byte[] buffer = new byte[4096];

    public DigestOfFile(String mode) throws Exception {
        this.digestAgent = MessageDigest.getInstance(mode, "SUN");
    }

    public synchronized byte[] digestAsByteArray(File file) throws Exception {
        this.digestAgent.reset();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        int bytesRead = 0;
        while ((bytesRead = ((InputStream)is).read(this.buffer)) >= 0) {
            this.digestAgent.update(this.buffer, 0, bytesRead);
        }
        ((InputStream)is).close();
        byte[] digest = this.digestAgent.digest();
        return digest;
    }

    public synchronized byte[] digestAsByteArray(byte[] input2) throws Exception {
        this.digestAgent.reset();
        byte[] digest = this.digestAgent.digest(input2);
        return digest;
    }

    public synchronized String digestAsBase64(File file) throws Exception {
        byte[] digest = this.digestAsByteArray(file);
        Base64 encoder = new Base64();
        String digestAsBase64 = new String(encoder.encode(digest), "ASCII");
        return digestAsBase64;
    }

    public synchronized String digestAsBase64(byte[] input2) throws Exception {
        byte[] digest = this.digestAsByteArray(input2);
        Base64 encoder = new Base64();
        String digestAsBase64 = new String(encoder.encode(digest), "ASCII");
        return digestAsBase64;
    }

    public static void main(String[] args) {
        try {
            Security.addProvider(new Sun());
            DigestOfFile md5DigestAgent = new DigestOfFile("MD5");
            for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                String base64Digest = md5DigestAgent.digestAsBase64(new File(args[argIndex]));
                System.out.println("Base64 MD5 of " + args[argIndex] + " = [" + base64Digest + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static boolean md5localHashCompare(File file1, File file2) {
        Security.addProvider(new Sun());
        try {
            DigestOfFile md5DigestAgent = new DigestOfFile("MD5");
            String hashFile1 = md5DigestAgent.digestAsBase64(file1);
            String hashFile2 = md5DigestAgent.digestAsBase64(file2);
            return hashFile1.equals(hashFile2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String GetLocalMD5Hash(File file) {
        Security.addProvider(new Sun());
        try {
            DigestOfFile md5DigestAgent = new DigestOfFile("MD5");
            String hash = md5DigestAgent.digestAsBase64(file);
            return hash;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMD5Hash(byte[] input2) {
        Security.addProvider(new Sun());
        try {
            DigestOfFile md5DigestAgent = new DigestOfFile("MD5");
            String hash = md5DigestAgent.digestAsBase64(input2);
            return hash;
        }
        catch (Exception e) {
            return null;
        }
    }
}

