/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_FA
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", "\u0647\u0632\u0627\u0631", "\u0645\u064a\u0644\u064a\u0648\u0646", "\u0645\u064a\u0644\u064a\u0627\u0631\u062f", "\u062a\u0631\u064a\u0644\u064a\u0648\u0646", "\u06a9\u0648\u0622\u062f\u0631\u064a\u0644\u064a\u0648\u0646", "\u0647\u0632\u0627\u0631 \u06a9\u0648\u0622\u062f\u0631\u064a\u0644\u064a\u0648\u0646"};
    private static final String[] hundredsNames = new String[]{"", "\u064a\u06a9\u0635\u062f", "\u062f\u0648\u064a\u0633\u062a", "\u0633\u064a\u0635\u062f", "\u0686\u0647\u0627\u0631\u0635\u062f", "\u067e\u0627\u0646\u0635\u062f", "\u0634\u0634\u0635\u062f", "\u0647\u0641\u062a\u0635\u062f", "\u0647\u0634\u062a\u0635\u062f", "\u0646\u0647\u0635\u062f"};
    private static final String[] tensNames = new String[]{"", "\u062f\u0647", "\u0628\u064a\u0633\u062a", "\u0633\u064a", "\u0686\u0647\u0644", "\u067e\u0646\u062c\u0627\u0647", "\u0634\u0635\u062a", "\u0647\u0641\u062a\u0627\u062f", "\u0647\u0634\u062a\u0627\u062f", "\u0646\u0648\u062f"};
    private static final String[] numNames = new String[]{"", "\u064a\u06a9", "\u062f\u0648", "\u0633\u0647", "\u0686\u0647\u0627\u0631", "\u067e\u0646\u062c", "\u0634\u0634", "\u0647\u0641\u062a", "\u0647\u0634\u062a", "\u0646\u0647", "\u062f\u0647", "\u064a\u0627\u0632\u062f\u0647", "\u062f\u0648\u0627\u0632\u062f\u0647", "\u0633\u064a\u0632\u062f\u0647", "\u0686\u0647\u0627\u0631\u062f\u0647", "\u067e\u0627\u0646\u0632\u062f\u0647", "\u0634\u0627\u0646\u0632\u062f\u0647", "\u0647\u0641\u062f\u0647", "\u0647\u062c\u062f\u0647", "\u0646\u0648\u0632\u062f\u0647"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            soFar = hundredsNames[number /= 100] + ("".equals(soFar) || hundredsNames[number].equals("") ? soFar : " \u0648 " + soFar);
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + (tensNames[number % 10].equals("") ? soFar : " \u0648 " + soFar);
            soFar = hundredsNames[(number /= 10) % 10] + (hundredsNames[number % 10].equals("") ? soFar : " \u0648 " + soFar);
        }
        return soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "\u0635\u0641\u0631";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "\u0645\u0646\u0641\u064a ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                soFar = !soFar.equals("") ? s + " " + majorNames[place] + (s.equals("") || majorNames[place].equals("") ? soFar : " \u0648 " + soFar) : s + " " + majorNames[place];
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != i2) continue;
            String cents = oldamt.substring(i2 + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_FA aiw = new AmtInWords_FA();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("103.00");
        aiw.print("100.00");
        aiw.print("523.45");
        aiw.print("1000.00");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("123457.89");
        aiw.print("1,234,578.90");
    }
}

