/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.util.logging.Logger;
import javax.swing.plaf.ColorUIResource;

public class ColorBlind {
    public static final String[] COLORBLIND_TYPE = new String[]{"", "Protanopia", "Deuteranopia", "Tritanopia"};
    public static final int NORMAL = 0;
    public static final int PROTANOPIA = 1;
    public static final int DEUTERANOPIA = 2;
    public static final int TRITANOPIA = 3;
    private static final double[][] confusionPoints = new double[][]{{0.735, 0.265}, {1.14, -0.14}, {0.171, -0.003}};
    private static final double[][][] colorAxes = new double[][][]{new double[][]{{0.115807, 0.073581}, {0.471899, 0.527051}}, new double[][]{{0.102776, 0.102864}, {0.505845, 0.493211}}, new double[][]{{0.045391, 0.294976}, {0.665764, 0.334011}}};
    private static final double[][] RGBtoXYZMatrix = new double[][]{{0.430574, 0.34155, 0.178325}, {0.222015, 0.706655, 0.07133}, {0.020183, 0.129553, 0.93918}};
    private static final double[][] XYZtoRGBMatrix = new double[][]{{3.063218, -1.393325, -0.475802}, {-0.969243, 1.875966, 0.041555}, {0.067871, -0.228834, 1.069251}};
    private static final double[] whitePoint = new double[]{0.312713, 0.329016, 0.358271};
    private static final double gamma = 2.2;
    private static int s_colorType = 0;
    private static Logger log = Logger.getLogger(ColorBlind.class.getName());

    public static void setColorType(int colorType) {
        s_colorType = colorType > 0 && colorType < 4 ? colorType : 0;
        if (s_colorType != 0) {
            log.config(COLORBLIND_TYPE[colorType]);
        }
    }

    public static int getColorType() {
        return s_colorType;
    }

    public static ColorUIResource getDichromatColorUIResource(ColorUIResource color) {
        if (s_colorType == 0) {
            return color;
        }
        return new ColorUIResource(ColorBlind.getDichromatColorUIResource(color, s_colorType));
    }

    public static Color getDichromatColorUIResource(ColorUIResource color, int colorType) {
        if (s_colorType == 0) {
            return color;
        }
        return new ColorUIResource(ColorBlind.getDichromatColor(color, s_colorType));
    }

    public static Color getDichromatColor(Color color) {
        if (s_colorType == 0) {
            return color;
        }
        return ColorBlind.getDichromatColor(color, s_colorType);
    }

    public static Color getDichromatColor(Color color, int colorType) {
        int type = 0;
        if (colorType > 0 && colorType < 4) {
            type = colorType;
        }
        if (type == 0 || color == null) {
            return color;
        }
        --type;
        if (color.equals(Color.black) || color.equals(Color.white)) {
            return color;
        }
        double red = color.getRed();
        double green = color.getGreen();
        double blue = color.getBlue();
        double X = RGBtoXYZMatrix[0][0] * Math.pow(red / 255.0, 2.2) + RGBtoXYZMatrix[0][1] * Math.pow(green / 255.0, 2.2) + RGBtoXYZMatrix[0][2] * Math.pow(blue / 255.0, 2.2);
        double Y = RGBtoXYZMatrix[1][0] * Math.pow(red / 255.0, 2.2) + RGBtoXYZMatrix[1][1] * Math.pow(green / 255.0, 2.2) + RGBtoXYZMatrix[1][2] * Math.pow(blue / 255.0, 2.2);
        double Z = RGBtoXYZMatrix[2][0] * Math.pow(red / 255.0, 2.2) + RGBtoXYZMatrix[2][1] * Math.pow(green / 255.0, 2.2) + RGBtoXYZMatrix[2][2] * Math.pow(blue / 255.0, 2.2);
        double x = 0.0;
        double y = 0.0;
        if (X + Y + Z != 0.0) {
            x = X / (X + Y + Z);
            y = Y / (X + Y + Z);
        }
        double Yn = Y;
        double Xn = whitePoint[0] * Yn / whitePoint[1];
        double Zn = whitePoint[2] * Yn / whitePoint[1];
        double xc = confusionPoints[type][0];
        double yc = confusionPoints[type][1];
        double x1 = colorAxes[type][0][0];
        double y1 = colorAxes[type][0][1];
        double x2 = colorAxes[type][1][0];
        double y2 = colorAxes[type][1][1];
        double ap = (y2 - y1) / (x2 - x1);
        double bp = y1 - x1 * ap;
        double a2 = x < xc ? (yc - y) / (xc - x) : (y - yc) / (x - xc);
        double b2 = y - x * a2;
        x = (bp - b2) / (a2 - ap);
        y = a2 * x + b2;
        X = 0.0;
        Z = 0.0;
        if (y != 0.0) {
            X = x * (Y / y);
            Z = (1.0 - x - y) * (Y / y);
        }
        red = XYZtoRGBMatrix[0][0] * X + XYZtoRGBMatrix[0][1] * Y + XYZtoRGBMatrix[0][2] * Z;
        green = XYZtoRGBMatrix[1][0] * X + XYZtoRGBMatrix[1][1] * Y + XYZtoRGBMatrix[1][2] * Z;
        blue = XYZtoRGBMatrix[2][0] * X + XYZtoRGBMatrix[2][1] * Y + XYZtoRGBMatrix[2][2] * Z;
        double reddiff = XYZtoRGBMatrix[0][0] * (Xn - X) + XYZtoRGBMatrix[0][1] * (Yn - Y) + XYZtoRGBMatrix[0][2] * (Zn - Z);
        double greendiff = XYZtoRGBMatrix[1][0] * (Xn - X) + XYZtoRGBMatrix[1][1] * (Yn - Y) + XYZtoRGBMatrix[1][2] * (Zn - Z);
        double bluediff = XYZtoRGBMatrix[2][0] * (Xn - X) + XYZtoRGBMatrix[2][1] * (Yn - Y) + XYZtoRGBMatrix[2][2] * (Zn - Z);
        double cr = ((red < 0.0 ? 0.0 : 1.0) - red) / reddiff;
        double cg = ((green < 0.0 ? 0.0 : 1.0) - green) / greendiff;
        double cb = ((blue < 0.0 ? 0.0 : 1.0) - blue) / bluediff;
        double c1 = cr < 0.0 || cr > 1.0 ? 0.0 : cr;
        double c2 = cg < 0.0 || cg > 1.0 ? 0.0 : cg;
        double c3 = cb < 0.0 || cb > 1.0 ? 0.0 : cb;
        double c = Math.max(c1, Math.max(c2, c3));
        red += c * reddiff;
        green += c * greendiff;
        blue += c * bluediff;
        red = Math.pow(red, 0.45454545454545453);
        green = Math.pow(green, 0.45454545454545453);
        blue = Math.pow(blue, 0.45454545454545453);
        Color retValue = new Color((float)red, (float)green, (float)blue);
        log.fine("Color " + color.getRed() + "-" + color.getGreen() + "-" + color.getBlue() + " -> " + retValue.getRed() + "-" + retValue.getGreen() + "-" + retValue.getBlue() + " <- " + COLORBLIND_TYPE[colorType]);
        return retValue;
    }
}

