/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import it.sauronsoftware.cron4j.Predictor;
import it.sauronsoftware.cron4j.SchedulingPattern;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MNote;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.server.AdempiereServer;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.eevolution.service.dsl.ProcessBuilder;

public class Scheduler
extends AdempiereServer {
    private MScheduler schedulerConfiguration = null;
    private StringBuffer m_summary = new StringBuffer();
    private Trx m_trx = null;
    private it.sauronsoftware.cron4j.Scheduler cronScheduler;
    private Predictor predictor;
    Properties m_schedulerctx = new Properties();

    public Scheduler(MScheduler model) {
        super((AdempiereProcessor)model, 240);
        this.schedulerConfiguration = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        MOrgInfo schedorg;
        this.m_summary = new StringBuffer(this.schedulerConfiguration.toString()).append(" - ");
        this.m_schedulerctx.clear();
        MClient schedclient = MClient.get(this.getCtx(), this.schedulerConfiguration.getAD_Client_ID());
        Env.setContext(this.m_schedulerctx, "#AD_Client_ID", schedclient.getAD_Client_ID());
        Env.setContext(this.m_schedulerctx, "#AD_Language", schedclient.getAD_Language());
        Env.setContext(this.m_schedulerctx, "#AD_Org_ID", this.schedulerConfiguration.getAD_Org_ID());
        if (this.schedulerConfiguration.getAD_Org_ID() != 0 && (schedorg = MOrgInfo.get(this.getCtx(), this.schedulerConfiguration.getAD_Org_ID(), null)).getM_Warehouse_ID() > 0) {
            Env.setContext(this.m_schedulerctx, "#M_Warehouse_ID", schedorg.getM_Warehouse_ID());
        }
        Env.setContext(this.m_schedulerctx, "#AD_User_ID", this.getAD_User_ID());
        Env.setContext(this.m_schedulerctx, "#SalesRep_ID", this.getAD_User_ID());
        MUser scheduser = MUser.get(this.getCtx(), this.getAD_User_ID());
        MRole[] schedroles = scheduser.getRoles(this.schedulerConfiguration.getAD_Org_ID());
        if (schedroles != null && schedroles.length > 0) {
            Env.setContext(this.m_schedulerctx, "#AD_Role_ID", schedroles[0].getAD_Role_ID());
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
        Env.setContext(this.m_schedulerctx, "#Date", dateFormat4Timestamp.format(ts) + " 00:00:00");
        Properties currentctx = Env.getCtx();
        Env.setCtx(this.m_schedulerctx);
        MProcess process = new MProcess(this.m_schedulerctx, this.schedulerConfiguration.getAD_Process_ID(), null);
        try {
            this.m_trx = Trx.get(Trx.createTrxName("Scheduler"), true);
            this.m_summary.append(this.runProcess(process));
            this.m_trx.commit(true);
        }
        catch (Exception e) {
            if (this.m_trx != null) {
                this.m_trx.rollback();
            }
            this.log.log(Level.WARNING, process.toString(), e);
            this.m_summary.append(e.toString());
        }
        finally {
            if (this.m_trx != null) {
                this.m_trx.close();
            }
        }
        Env.setCtx(currentctx);
        int no = this.schedulerConfiguration.deleteLog();
        this.m_summary.append(" Logs deleted=").append(no);
        MSchedulerLog pLog = new MSchedulerLog(this.schedulerConfiguration, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.saveEx();
    }

    private String runProcess(MProcess process) throws Exception {
        ProcessInfo info;
        block14: {
            MUser from;
            int Record_ID;
            int AD_Table_ID;
            boolean isReport;
            block13: {
                this.log.info(process.toString());
                isReport = process.isReport() || process.getAD_ReportView_ID() > 0;
                AD_Table_ID = this.schedulerConfiguration.get_Table_ID();
                Record_ID = this.schedulerConfiguration.getRecord_ID();
                ProcessBuilder builder = ProcessBuilder.create(this.getCtx()).process(process.getAD_Process_ID()).withClientId(this.schedulerConfiguration.getAD_Client_ID()).withUserId(this.getAD_User_ID()).withTitle(process.getName()).withRecordId(this.schedulerConfiguration.getAD_Table_ID(), this.schedulerConfiguration.getRecord_ID());
                this.fillParameter(builder);
                try {
                    builder.execute();
                }
                catch (Exception e) {
                    this.log.severe(e.getLocalizedMessage());
                }
                info = builder.getProcessInfo();
                from = new MUser(this.getCtx(), this.getAD_User_ID(), null);
                if (!info.isError()) break block13;
                int supervisor = this.schedulerConfiguration.getSupervisor_ID();
                if (supervisor <= 0) break block14;
                MUser user = new MUser(this.getCtx(), supervisor, null);
                boolean email = user.isNotificationEMail();
                boolean notice = user.isNotificationNote();
                if (email || notice) {
                    ProcessInfoUtil.setLogFromDB(info);
                }
                if (email) {
                    MClient client = MClient.get(this.schedulerConfiguration.getCtx(), this.schedulerConfiguration.getAD_Client_ID());
                    client.sendEMail(from, user, process.getName(), info.getSummary() + " " + info.getLogInfo(), null);
                }
                if (!notice) break block14;
                int AD_Message_ID = 442;
                MNote note = new MNote(this.getCtx(), AD_Message_ID, supervisor, null);
                note.setClientOrg(this.schedulerConfiguration.getAD_Client_ID(), this.schedulerConfiguration.getAD_Org_ID());
                note.setTextMsg(info.getSummary());
                note.setRecord(MPInstance.Table_ID, info.getAD_PInstance_ID());
                note.saveEx();
                break block14;
            }
            Integer[] userIDs = this.schedulerConfiguration.getRecipientAD_User_IDs();
            if (userIDs.length > 0) {
                ProcessInfoUtil.setLogFromDB(info);
                for (int i = 0; i < userIDs.length; ++i) {
                    MUser user = new MUser(this.getCtx(), userIDs[i], null);
                    boolean email = user.isNotificationEMail();
                    boolean notice = user.isNotificationNote();
                    File report = null;
                    if (isReport) {
                        report = info.getPDFReport();
                    }
                    if (notice) {
                        int AD_Message_ID = 441;
                        if (isReport) {
                            AD_Message_ID = 884;
                        }
                        MNote note = new MNote(this.getCtx(), AD_Message_ID, (int)userIDs[i], null);
                        note.setClientOrg(this.schedulerConfiguration.getAD_Client_ID(), this.schedulerConfiguration.getAD_Org_ID());
                        if (isReport) {
                            note.setTextMsg(this.schedulerConfiguration.getName());
                            note.setDescription(this.schedulerConfiguration.getDescription());
                            note.setRecord(AD_Table_ID, Record_ID);
                        } else {
                            note.setTextMsg(info.getSummary());
                            note.setRecord(MPInstance.Table_ID, info.getAD_PInstance_ID());
                        }
                        if (note.save() && isReport) {
                            MAttachment attachment = new MAttachment(this.getCtx(), MNote.Table_ID, note.getAD_Note_ID(), null);
                            attachment.setClientOrg(this.schedulerConfiguration.getAD_Client_ID(), this.schedulerConfiguration.getAD_Org_ID());
                            attachment.addEntry(report);
                            attachment.setTextMsg(this.schedulerConfiguration.getName());
                            attachment.saveEx();
                        }
                    }
                    if (!email) continue;
                    MClient client = MClient.get(this.schedulerConfiguration.getCtx(), this.schedulerConfiguration.getAD_Client_ID());
                    if (isReport) {
                        client.sendEMail(from, user, this.schedulerConfiguration.getName(), this.schedulerConfiguration.getDescription(), report);
                        continue;
                    }
                    client.sendEMail(from, user, process.getName(), info.getSummary() + " " + info.getLogInfo(), null);
                }
            }
        }
        return info.getSummary();
    }

    private int getAD_User_ID() {
        int AD_User_ID = this.schedulerConfiguration.getSupervisor_ID() > 0 ? this.schedulerConfiguration.getSupervisor_ID() : (this.schedulerConfiguration.getCreatedBy() > 0 ? this.schedulerConfiguration.getCreatedBy() : (this.schedulerConfiguration.getUpdatedBy() > 0 ? this.schedulerConfiguration.getUpdatedBy() : 100));
        return AD_User_ID;
    }

    private void fillParameter(ProcessBuilder builder) {
        Arrays.asList(this.schedulerConfiguration.getParameters(false)).forEach(schedulerParameter -> {
            String variable = schedulerParameter.getParameterDefault();
            this.log.fine(schedulerParameter.getColumnName() + " = " + variable);
            String value = variable;
            if (variable == null || variable != null && variable.length() == 0) {
                value = null;
            } else if (variable.indexOf(64) != -1 && variable.indexOf(64) != variable.lastIndexOf(64)) {
                int index = variable.indexOf(64);
                String columnName = variable.substring(index + 1);
                if ((index = columnName.indexOf(64)) != -1) {
                    String env = Env.getContext(this.m_schedulerctx, columnName = columnName.substring(0, index));
                    if (env == null || env.length() == 0) {
                        env = Env.getContext(this.getCtx(), columnName);
                    }
                    if (env.length() == 0) {
                        this.log.warning(schedulerParameter.getColumnName() + " - not in environment =" + columnName + "(" + variable + ")");
                    } else {
                        value = env;
                    }
                }
            }
            if (value != null) {
                Object parameterOfProcess = null;
                try {
                    if (DisplayType.isNumeric(schedulerParameter.getDisplayType()) || DisplayType.isID(schedulerParameter.getDisplayType())) {
                        BigDecimal decimalValue = null;
                        decimalValue = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                        parameterOfProcess = decimalValue;
                        this.log.fine(schedulerParameter.getColumnName() + " = " + variable + " (=" + decimalValue + "=)");
                    } else if (20 == schedulerParameter.getDisplayType()) {
                        boolean booleanValue = false;
                        booleanValue = value instanceof Boolean ? ((Boolean)((Object)value)).booleanValue() : value.toString().replaceAll("'", "").equals("Y");
                        parameterOfProcess = booleanValue;
                        this.log.fine(schedulerParameter.getColumnName() + " = " + variable + " (=" + booleanValue + "=)");
                    } else if (DisplayType.isDate(schedulerParameter.getDisplayType())) {
                        Timestamp dateValue = null;
                        dateValue = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                        parameterOfProcess = dateValue;
                        this.log.fine(schedulerParameter.getColumnName() + " = " + variable + " (=" + dateValue + "=)");
                    } else {
                        parameterOfProcess = value.toString().replaceAll("'", "");
                        this.log.fine(schedulerParameter.getColumnName() + " = " + variable + " (=" + value + "=) " + value.getClass().getName());
                    }
                    if (parameterOfProcess != null) {
                        this.log.fine("ColumnName=" + schedulerParameter.getColumnName() + ", Value=" + parameterOfProcess);
                        builder.withParameter(schedulerParameter.getColumnName(), parameterOfProcess);
                    }
                }
                catch (Exception e) {
                    this.log.warning(schedulerParameter.getColumnName() + " = " + variable + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                }
            }
        });
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    public void run() {
        String cronPattern = this.schedulerConfiguration.getCronPattern();
        if (cronPattern != null && cronPattern.trim().length() > 0 && SchedulingPattern.validate((String)cronPattern)) {
            this.cronScheduler = new it.sauronsoftware.cron4j.Scheduler();
            this.cronScheduler.schedule(cronPattern, new Runnable(){

                @Override
                public void run() {
                    Scheduler.this.runNow();
                    long next = Scheduler.this.predictor.nextMatchingTime();
                    Scheduler.this.p_model.setDateNextRun(new Timestamp(next));
                    Scheduler.this.p_model.saveEx();
                }
            });
            this.predictor = new Predictor(cronPattern);
            long next = this.predictor.nextMatchingTime();
            this.p_model.setDateNextRun(new Timestamp(next));
            this.p_model.saveEx();
            this.cronScheduler.start();
            do {
                if (this.sleep()) continue;
                this.cronScheduler.stop();
                break;
            } while (this.cronScheduler.isStarted());
        } else {
            super.run();
        }
    }
}

