/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.X_PA_ReportSource;
import org.compiere.report.MReportTree;

public class MReportSource
extends X_PA_ReportSource {
    private static final long serialVersionUID = 6085437491271873555L;

    public MReportSource(Properties ctx, int reportSourceId, String trxName) {
        super(ctx, reportSourceId, trxName);
        if (reportSourceId == 0) {
            // empty if block
        }
    }

    public MReportSource(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getWhereClause(int hierarchyId) {
        String elementType = this.getElementType();
        int dimensionId = 0;
        if ("AC".equals(elementType)) {
            dimensionId = this.getC_ElementValue_ID();
        } else if ("AY".equals(elementType)) {
            dimensionId = this.getC_Activity_ID();
        } else if ("BP".equals(elementType)) {
            dimensionId = this.getC_BPartner_ID();
        } else if ("MC".equals(elementType)) {
            dimensionId = this.getC_Campaign_ID();
        } else if ("LF".equals(elementType)) {
            dimensionId = this.getC_Location_ID();
        } else if ("LT".equals(elementType)) {
            dimensionId = this.getC_Location_ID();
        } else if ("OO".equals(elementType)) {
            dimensionId = this.getOrg_ID();
        } else if ("PR".equals(elementType)) {
            dimensionId = this.getM_Product_ID();
        } else if ("PJ".equals(elementType)) {
            dimensionId = this.getC_Project_ID();
        } else if ("SR".equals(elementType)) {
            dimensionId = this.getC_SalesRegion_ID();
        } else if ("OT".equals(elementType)) {
            dimensionId = this.getAD_OrgTrx_ID();
        } else if ("U1".equals(elementType)) {
            dimensionId = this.getUser1_ID();
        } else if ("U2".equals(elementType)) {
            dimensionId = this.getUser2_ID();
        } else if ("U3".equals(elementType)) {
            dimensionId = this.getUser3_ID();
        } else if ("U4".equals(elementType)) {
            dimensionId = this.getUser4_ID();
        } else {
            if ("X1".equals(elementType)) {
                return "UserElement1_ID=" + this.getUserElement1_ID();
            }
            if ("X2".equals(elementType)) {
                return "UserElement2_ID=" + this.getUserElement2_ID();
            }
            if ("CO".equals(elementType)) {
                return this.getWhereCombination(hierarchyId);
            }
        }
        return MReportTree.getWhereClause(this.getCtx(), hierarchyId, elementType, dimensionId);
    }

    private String getWhereCombination(int hierarchyId) {
        String whtree;
        StringBuffer whcomb = new StringBuffer();
        if (this.getC_ElementValue_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "AC", this.getC_ElementValue_ID());
            if (this.isIncludeNullsElementValue()) {
                whcomb.append(" AND (Account_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsElementValue()) {
            whcomb.append(" AND Account_ID IS NULL");
        }
        if (this.getC_Activity_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "AY", this.getC_Activity_ID());
            if (this.isIncludeNullsActivity()) {
                whcomb.append(" AND (C_Activity_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsActivity()) {
            whcomb.append(" AND C_Activity_ID IS NULL");
        }
        if (this.getC_BPartner_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "BP", this.getC_BPartner_ID());
            if (this.isIncludeNullsBPartner()) {
                whcomb.append(" AND (C_BPartner_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsBPartner()) {
            whcomb.append(" AND C_BPartner_ID IS NULL");
        }
        if (this.getC_Campaign_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "MC", this.getC_Campaign_ID());
            if (this.isIncludeNullsCampaign()) {
                whcomb.append(" AND (C_Campaign_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsCampaign()) {
            whcomb.append(" AND C_Campaign_ID IS NULL");
        }
        if (this.getC_Location_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "LF", this.getC_Location_ID());
            if (this.isIncludeNullsLocation()) {
                whcomb.append(" AND (C_LocFrom_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsLocation()) {
            whcomb.append(" AND C_LocFrom_ID IS NULL");
        }
        if (this.getOrg_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "OO", this.getOrg_ID());
            if (this.isIncludeNullsOrg()) {
                whcomb.append(" AND (AD_Org_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsOrg()) {
            whcomb.append(" AND AD_Org_ID IS NULL");
        }
        if (this.getAD_OrgTrx_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "OT", this.getAD_OrgTrx_ID());
            if (this.isIncludeNullsOrgTrx()) {
                whcomb.append(" AND (AD_OrgTrx_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsOrgTrx()) {
            whcomb.append(" AND AD_OrgTrx_ID IS NULL");
        }
        if (this.getM_Product_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "PR", this.getM_Product_ID());
            if (this.isIncludeNullsProduct()) {
                whcomb.append(" AND (M_Product_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsProduct()) {
            whcomb.append(" AND M_Product_ID IS NULL");
        }
        if (this.getC_Project_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "PJ", this.getC_Project_ID());
            if (this.isIncludeNullsProject()) {
                whcomb.append(" AND (C_Project_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsProject()) {
            whcomb.append(" AND C_Project_ID IS NULL");
        }
        if (this.getC_SalesRegion_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "SR", this.getC_SalesRegion_ID());
            if (this.isIncludeNullsSalesRegion()) {
                whcomb.append(" AND (C_SalesRegion_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsSalesRegion()) {
            whcomb.append(" AND C_SalesRegion_ID IS NULL");
        }
        if (this.getUserElement1_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "X1", this.getUserElement1_ID());
            if (this.isIncludeNullsUserElement1()) {
                whcomb.append(" AND (UserElement1_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUserElement1()) {
            whcomb.append(" AND UserElement1_ID IS NULL");
        }
        if (this.getUserElement2_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "X2", this.getUserElement2_ID());
            if (this.isIncludeNullsUserElement2()) {
                whcomb.append(" AND (UserElement2_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUserElement2()) {
            whcomb.append(" AND UserElement2_ID IS NULL");
        }
        if (this.getUser1_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "U1", this.getUser1_ID());
            if (this.isIncludeNullsUser1()) {
                whcomb.append(" AND (User1_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUser1()) {
            whcomb.append(" AND User1_ID IS NULL");
        }
        if (this.getUser2_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "U2", this.getUser2_ID());
            if (this.isIncludeNullsUserElement2()) {
                whcomb.append(" AND (User2_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUser2()) {
            whcomb.append(" AND User2_ID IS NULL");
        }
        if (this.getUser3_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "U3", this.getUser3_ID());
            if (this.isIncludeNullsUser3()) {
                whcomb.append(" AND (User3_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUser3()) {
            whcomb.append(" AND User3_ID IS NULL");
        }
        if (this.getUser4_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), hierarchyId, "U4", this.getUser4_ID());
            if (this.isIncludeNullsUser4()) {
                whcomb.append(" AND (User4_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUser4()) {
            whcomb.append(" AND User4_ID IS NULL");
        }
        if (whcomb.length() > 5 && whcomb.toString().startsWith(" AND ")) {
            whcomb.delete(0, 5);
        }
        return whcomb.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MReportSource[").append(this.get_ID()).append(" - ").append(this.getDescription()).append(" - ").append(this.getElementType());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static MReportSource copy(Properties ctx, int clientId, int orgId, int reportLineId, MReportSource source, String trxName) {
        MReportSource retValue = new MReportSource(ctx, 0, trxName);
        MReportSource.copyValues(source, retValue, clientId, orgId);
        retValue.setPA_ReportLine_ID(reportLineId);
        return retValue;
    }

    public String getCombinationKey() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isIncludeNullsElementValue()) {
            stringBuffer.append("A");
        }
        if (this.getOrg_ID() != 0) {
            stringBuffer.append("B");
        }
        if (this.isIncludeNullsOrg()) {
            stringBuffer.append("C");
        }
        if (this.getAD_OrgTrx_ID() != 0) {
            stringBuffer.append("D");
        }
        if (this.isIncludeNullsOrgTrx()) {
            stringBuffer.append("E");
        }
        if (this.getC_BPartner_ID() != 0) {
            stringBuffer.append("F");
        }
        if (this.isIncludeNullsBPartner()) {
            stringBuffer.append("G");
        }
        if (this.getM_Product_ID() != 0) {
            stringBuffer.append("H");
        }
        if (this.isIncludeNullsProduct()) {
            stringBuffer.append("I");
        }
        if (this.getC_Location_ID() != 0) {
            stringBuffer.append("J");
        }
        if (this.isIncludeNullsLocation()) {
            stringBuffer.append("K");
        }
        if (this.getC_Project_ID() != 0) {
            stringBuffer.append("L");
        }
        if (this.isIncludeNullsProject()) {
            stringBuffer.append("M");
        }
        if (this.getC_SalesRegion_ID() != 0) {
            stringBuffer.append("N");
        }
        if (this.isIncludeNullsSalesRegion()) {
            stringBuffer.append("O");
        }
        if (this.getC_Activity_ID() != 0) {
            stringBuffer.append("P");
        }
        if (this.isIncludeNullsActivity()) {
            stringBuffer.append("Q");
        }
        if (this.getC_Campaign_ID() != 0) {
            stringBuffer.append("R");
        }
        if (this.isIncludeNullsCampaign()) {
            stringBuffer.append("S");
        }
        if (this.getUserElement1_ID() != 0) {
            stringBuffer.append("T");
        }
        if (this.isIncludeNullsUserElement1()) {
            stringBuffer.append("U");
        }
        if (this.get_ValueAsInt("User1_ID") != 0) {
            stringBuffer.append("V");
        }
        if (this.get_ValueAsBoolean("IsIncludeNullsUserList1")) {
            stringBuffer.append("W");
        }
        if (this.get_ValueAsInt("User2_ID") != 0) {
            stringBuffer.append("X");
        }
        if (this.get_ValueAsBoolean("IsIncludeNullsUserList2")) {
            stringBuffer.append("Y");
        }
        if (this.getC_ElementValue_ID() != 0) {
            stringBuffer.append("Z");
        }
        return stringBuffer.toString();
    }
}

