/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.Query;
import org.compiere.model.X_PA_ReportLine;
import org.compiere.report.MReportSource;
import org.compiere.util.Util;

public class MReportLine
extends X_PA_ReportLine {
    private static final long serialVersionUID = -3957315092529097396L;
    private MReportSource[] sources = null;
    private String whereClause = null;
    private String m_selectClauseCombination = null;
    List<String> combinationGroupBy = new ArrayList<String>();
    private Stroke underline_Stroke;
    private BasicStroke overline_Stroke;

    public MReportLine(Properties ctx, int PA_ReportLine_ID, String trxName) {
        super(ctx, PA_ReportLine_ID, trxName);
        if (PA_ReportLine_ID == 0) {
            this.setSeqNo(0);
            this.setIsPrinted(false);
        } else {
            this.loadSources();
        }
    }

    public MReportLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadSources();
    }

    private void loadSources() {
        List<MReportSource> list = new Query(this.getCtx(), "PA_ReportSource", "PA_ReportLine_ID = ?", this.get_TrxName()).setParameters(this.getPA_ReportLine_ID()).setClient_ID().setOnlyActiveRecords(true).list();
        this.sources = new MReportSource[list.size()];
        list.toArray(this.sources);
        this.log.finest("ID=" + this.getPA_ReportLine_ID() + " - Size=" + list.size());
    }

    public MReportSource[] getSources() {
        return this.sources;
    }

    public void list() {
        System.out.println("- " + this.toString());
        if (this.sources == null) {
            return;
        }
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            System.out.println("  - " + this.sources[i2].toString());
        }
    }

    public String getSourceColumnName() {
        String ColumnName = null;
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            String col = null;
            col = this.sources[i2].getElementType().equals("CO") ? this.sources[i2].getCombinationKey() : MAcctSchemaElement.getColumnName(this.sources[i2].getElementType());
            if (ColumnName == null || ColumnName.length() == 0) {
                ColumnName = col;
                continue;
            }
            if (ColumnName.equals(col)) continue;
            this.log.config("More than one: " + ColumnName + " - " + col);
            return null;
        }
        return ColumnName;
    }

    public String getSourceValueQuery() {
        if (this.sources != null && this.sources.length > 0) {
            return MAcctSchemaElement.getValueQuery(this.sources[0].getElementType());
        }
        return null;
    }

    public String getSelectClause(boolean withSum) {
        String at = this.getPAAmountType().substring(0, 1);
        StringBuffer sb = new StringBuffer();
        if (withSum) {
            sb.append("SUM(");
        }
        if ("B".equals(at)) {
            sb.append("acctBalance(Account_ID,AmtAcctDr,AmtAcctCr)");
        } else if ("S".equals(at)) {
            sb.append("AmtAcctDr-AmtAcctCr");
        } else if ("C".equals(at)) {
            sb.append("AmtAcctCr");
        } else if ("D".equals(at)) {
            sb.append("AmtAcctDr");
        } else if ("R".equals(at)) {
            sb.append("Qty");
        } else if ("Q".equals(at)) {
            sb.append("acctBalance(Account_ID,Qty,0)");
        } else {
            this.log.log(Level.SEVERE, "AmountType=" + this.getPAAmountType() + ", at=" + at);
            return "NULL";
        }
        if (withSum) {
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isPeriod() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "P".equals(pt);
    }

    public boolean isYear() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "Y".equals(pt);
    }

    public boolean isTotal() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "T".equals(pt);
    }

    public boolean isNatural() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "N".equals(pt);
    }

    public String getWhereClause(int PA_Hierarchy_ID, String optionalPostingType) {
        if (this.sources == null) {
            return "";
        }
        if (this.whereClause == null) {
            if (this.sources.length == 0) {
                this.whereClause = "";
            } else if (this.sources.length == 1) {
                this.whereClause = this.sources[0].getWhereClause(PA_Hierarchy_ID);
            } else {
                StringBuffer sb = new StringBuffer("(");
                for (int i2 = 0; i2 < this.sources.length; ++i2) {
                    if (i2 > 0) {
                        sb.append(" OR ");
                    }
                    sb.append(this.sources[i2].getWhereClause(PA_Hierarchy_ID));
                }
                sb.append(")");
                this.whereClause = sb.toString();
            }
            if (!Util.isEmpty(optionalPostingType)) {
                if (this.whereClause.length() > 0) {
                    this.whereClause = this.whereClause + " AND ";
                }
                this.whereClause = this.whereClause + optionalPostingType;
            } else if (!Util.isEmpty(this.getPostingType())) {
                if (this.whereClause.length() > 0) {
                    this.whereClause = this.whereClause + " AND ";
                }
                this.whereClause = this.whereClause + "PostingType='" + this.getPostingType() + "'";
                if (this.getPostingType().equals("B") && this.getGL_Budget_ID() > 0) {
                    this.whereClause = this.whereClause + " AND GL_Budget_ID=" + this.getGL_Budget_ID();
                }
            }
            this.log.fine(this.whereClause);
        }
        return this.whereClause;
    }

    public boolean isPostingType() {
        return !Util.isEmpty(this.getPostingType());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MReportLine[").append(this.get_ID()).append(" - ").append(this.getName()).append(" - ").append(this.getDescription()).append(", SeqNo=").append(this.getSeqNo()).append(", AmountType=").append(this.getPAAmountType()).append(", PeriodType=").append(this.getPAPeriodType()).append(" - LineType=").append(this.getLineType());
        if (this.isLineTypeCalculation()) {
            sb.append(" - Calculation=").append(this.getCalculationType()).append(" - ").append(this.getOper_1_ID()).append(" - ").append(this.getOper_2_ID());
        } else {
            sb.append(" - SegmentValue - PostingType=").append(this.getPostingType()).append(", AmountType=").append(this.getPAAmountType()).append(", PeriodType=").append(this.getPAPeriodType());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isLineTypeCalculation() {
        return "C".equals(this.getLineType());
    }

    public boolean isLineTypeSegmentValue() {
        return "S".equals(this.getLineType());
    }

    public boolean isCalculationTypeRange() {
        return "R".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeAdd() {
        return "A".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeSubtract() {
        return "S".equals(this.getCalculationType());
    }

    public boolean isCalculationTypePercent() {
        return "P".equals(this.getCalculationType());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ("S".equals(this.getLineType())) {
            if (this.getCalculationType() != null) {
                this.setCalculationType(null);
            }
            if (this.getOper_1_ID() != 0) {
                this.setOper_1_ID(0);
            }
            if (this.getOper_2_ID() != 0) {
                this.setOper_2_ID(0);
            }
        }
        return true;
    }

    public static MReportLine copy(Properties ctx, int AD_Client_ID, int AD_Org_ID, int PA_ReportLineSet_ID, MReportLine source, String trxName) {
        MReportLine retValue = new MReportLine(ctx, 0, trxName);
        MReportLine.copyValues(source, retValue, AD_Client_ID, AD_Org_ID);
        retValue.setPA_ReportLineSet_ID(PA_ReportLineSet_ID);
        retValue.setOper_1_ID(0);
        retValue.setOper_2_ID(0);
        return retValue;
    }

    public String getSelectClauseCombination() {
        if (this.sources == null) {
            return "";
        }
        if (this.m_selectClauseCombination == null) {
            if (this.sources.length == 0) {
                this.m_selectClauseCombination = "";
            } else {
                MReportSource source = this.sources[0];
                StringBuffer select = new StringBuffer("");
                if (source.getOrg_ID() != 0 || source.isIncludeNullsOrg()) {
                    select.append(" AND fb.").append("AD_Org_ID").append("=x.").append("AD_Org_ID");
                    this.combinationGroupBy.add("AD_Org_ID");
                }
                if (source.getAD_OrgTrx_ID() != 0 || source.isIncludeNullsOrgTrx()) {
                    select.append(" AND fb.").append("AD_OrgTrx_ID").append("=x.").append("AD_OrgTrx_ID");
                    this.combinationGroupBy.add("AD_OrgTrx_ID");
                }
                if (source.getC_ElementValue_ID() != 0 || source.isIncludeNullsElementValue()) {
                    select.append(" AND fb.").append("Account_ID").append("=x.").append("Account_ID");
                    this.combinationGroupBy.add("Account_ID");
                }
                if (source.getC_BPartner_ID() != 0 || source.isIncludeNullsBPartner()) {
                    select.append(" AND fb.").append("C_BPartner_ID").append("=x.").append("C_BPartner_ID");
                    this.combinationGroupBy.add("C_BPartner_ID");
                }
                if (source.getM_Product_ID() != 0 || source.isIncludeNullsProduct()) {
                    select.append(" AND fb.").append("M_Product_ID").append("=x.").append("M_Product_ID");
                    this.combinationGroupBy.add("M_Product_ID");
                }
                if (source.getC_Location_ID() != 0 || source.isIncludeNullsLocation()) {
                    select.append(" AND fb.").append("C_LocFrom_ID").append("=x.").append("C_LocFrom_ID");
                    this.combinationGroupBy.add("C_LocFrom_ID");
                }
                if (source.getC_Project_ID() != 0 || source.isIncludeNullsProject()) {
                    select.append(" AND fb.").append("C_Project_ID").append("=x.").append("C_Project_ID");
                    this.combinationGroupBy.add("C_Project_ID");
                }
                if (source.getC_SalesRegion_ID() != 0 || source.isIncludeNullsSalesRegion()) {
                    select.append(" AND fb.").append("C_SalesRegion_ID").append("=x.").append("C_SalesRegion_ID");
                    this.combinationGroupBy.add("C_SalesRegion_ID");
                }
                if (source.getC_Activity_ID() != 0 || source.isIncludeNullsActivity()) {
                    select.append(" AND fb.").append("C_Activity_ID").append("=x.").append("C_Activity_ID");
                    this.combinationGroupBy.add("C_Activity_ID");
                }
                if (source.getC_Campaign_ID() != 0 || source.isIncludeNullsCampaign()) {
                    select.append(" AND fb.").append("C_Campaign_ID").append("=x.").append("C_Campaign_ID");
                    this.combinationGroupBy.add("C_Campaign_ID");
                }
                if (source.getUserElement1_ID() != 0 || source.isIncludeNullsUserElement1()) {
                    select.append(" AND fb.").append("UserElement1_ID").append("=x.").append("UserElement1_ID");
                    this.combinationGroupBy.add("UserElement1_ID");
                }
                if (source.get_ValueAsInt("User1_ID") != 0 || source.get_ValueAsBoolean("IsIncludeNullsUserList1")) {
                    select.append(" AND fb.").append("User1_ID").append("=x.").append("User1_ID");
                    this.combinationGroupBy.add("User1_ID");
                }
                if (source.get_ValueAsInt("User2_ID") != 0 || source.get_ValueAsBoolean("IsIncludeNullsUserList2")) {
                    select.append(" AND fb.").append("User2_ID").append("=x.").append("User2_ID");
                    this.combinationGroupBy.add("User2_ID");
                }
                if (source.get_ValueAsInt("User3_ID") != 0 || source.get_ValueAsBoolean("IsIncludeNullsUserList3")) {
                    select.append(" AND fb.").append("User3_ID").append("=x.").append("User3_ID");
                    this.combinationGroupBy.add("User3_ID");
                }
                if (source.get_ValueAsInt("User4_ID") != 0 || source.get_ValueAsBoolean("IsIncludeNullsUserList4")) {
                    select.append(" AND fb.").append("User4_ID").append("=x.").append("User4_ID");
                    this.combinationGroupBy.add("User4_ID");
                }
                this.m_selectClauseCombination = select.toString();
            }
            this.log.fine(this.m_selectClauseCombination);
        }
        return this.m_selectClauseCombination;
    }

    public List<String> getCombinationGroupByColumns() {
        return this.combinationGroupBy;
    }

    private float[] getPatternDotted(float width) {
        return new float[]{2.0f * width, 2.0f * width};
    }

    private float[] getPatternDashed(float width) {
        return new float[]{10.0f * width, 4.0f * width};
    }

    public int getUnderline() {
        if ("d".equals(this.getUnderlineStrokeType()) || "s".equals(this.getUnderlineStrokeType()) || "D".equals(this.getUnderlineStrokeType())) {
            return 1;
        }
        if ("d_d".equals(this.getUnderlineStrokeType()) || "d_s".equals(this.getUnderlineStrokeType()) || "d_D".equals(this.getUnderlineStrokeType())) {
            return 2;
        }
        return 0;
    }

    public int getOverline() {
        if ("d".equals(this.getOverlineStrokeType()) || "s".equals(this.getOverlineStrokeType()) || "D".equals(this.getOverlineStrokeType())) {
            return 1;
        }
        if ("d_d".equals(this.getOverlineStrokeType()) || "d_s".equals(this.getOverlineStrokeType()) || "d_D".equals(this.getOverlineStrokeType())) {
            return 2;
        }
        return 0;
    }

    public Stroke getUnderlineStroke(BigDecimal stroke) {
        if (this.underline_Stroke == null) {
            float width = stroke.floatValue() / 2.0f;
            if ("d".equals(this.getUnderlineStrokeType()) || "d_d".equals(this.getUnderlineStrokeType())) {
                this.underline_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            } else if ("s".equals(this.getUnderlineStrokeType()) || "d_s".equals(this.getUnderlineStrokeType())) {
                this.underline_Stroke = new BasicStroke(width);
            } else if ("D".equals(this.getUnderlineStrokeType()) || "d_D".equals(this.getUnderlineStrokeType())) {
                this.underline_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDashed(width), 0.0f);
            }
        }
        return this.underline_Stroke;
    }

    public Stroke getOverlineStroke(BigDecimal stroke) {
        if (this.overline_Stroke == null) {
            float width = stroke.floatValue() / 2.0f;
            if ("d".equals(this.getOverlineStrokeType()) || "d_d".equals(this.getOverlineStrokeType())) {
                this.overline_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            } else if ("s".equals(this.getOverlineStrokeType()) || "d_s".equals(this.getOverlineStrokeType())) {
                this.overline_Stroke = new BasicStroke(width);
            } else if ("D".equals(this.getOverlineStrokeType()) || "d_D".equals(this.getOverlineStrokeType())) {
                this.overline_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDashed(width), 0.0f);
            }
        }
        return this.overline_Stroke;
    }
}

