/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.HashSet;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class RollUpCosts
extends SvrProcess {
    int category = 0;
    int product_id = 0;
    int client_id = 0;
    int org_id = 0;
    int user_id = 0;
    int costelement_id = 0;
    private HashSet<Integer> processed;

    @Override
    protected void prepare() {
        int chosen_id = 0;
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Product_Category_ID")) {
                this.category = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                chosen_id = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_CostElement_ID")) {
                this.costelement_id = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.product_id = this.getRecord_ID();
        if (this.product_id == 0) {
            this.product_id = chosen_id;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.client_id = Env.getAD_Client_ID(this.getCtx());
        this.org_id = Env.getAD_Org_ID(this.getCtx());
        this.user_id = Env.getAD_User_ID(this.getCtx());
        this.createView();
        String result = this.rollUp();
        this.deleteView();
        return result;
    }

    protected String rollUp() throws Exception {
        if (this.product_id != 0) {
            this.rollUpCosts(this.product_id);
        } else if (this.category != 0) {
            String sql = "SELECT M_PRODUCT_ID FROM M_PRODUCT WHERE M_PRODUCT_CATEGORY_ID = " + this.category + " AND AD_CLIENT_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND M_PRODUCT_ID IN (SELECT b.M_PRODUCT_ID FROM PP_PRODUCT_BOM b JOIN PP_PRODUCT_BOMLINE bl ON b.PP_PRODUCT_BOM_ID = bl.PP_PRODUCT_BOM_ID)";
            RowSet results = DB.getRowSet(sql);
            while (results.next()) {
                this.rollUpCosts(results.getInt(1));
            }
        } else {
            String sql = "SELECT M_PRODUCT_ID FROM M_PRODUCT WHERE AD_CLIENT_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND M_PRODUCT_ID IN (SELECT b.M_PRODUCT_ID FROM PP_PRODUCT_BOM b JOIN PP_PRODUCT_BOMLINE bl ON b.PP_PRODUCT_BOM_ID = bl.PP_PRODUCT_BOM_ID)";
            RowSet results = DB.getRowSet(sql);
            while (results.next()) {
                this.rollUpCosts(results.getInt(1));
            }
        }
        return "Roll Up Complete";
    }

    protected void createView() throws Exception {
        this.processed = new HashSet();
    }

    protected void deleteView() {
    }

    protected void rollUpCosts(int p_id) throws Exception {
        String sql = "SELECT bl.M_Product_ID FROM PP_Product_BOMLine bl JOIN PP_PRODUCT_BOM b  ON ( b.PP_PRODUCT_BOM_ID = bl.PP_PRODUCT_BOM_ID ) WHERE b.M_Product_ID = " + p_id + " AND bl.AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx());
        RowSet results = DB.getRowSet(sql);
        while (results.next()) {
            if (this.processed.contains(p_id)) continue;
            this.rollUpCosts(results.getInt(1));
        }
        results.close();
        String update = "UPDATE M_Cost set CurrentCostPrice = COALESCE((select Sum (b.QtyBOM * c.currentcostprice) FROM PP_Product_BOMLine b INNER JOIN M_Cost c ON (b.M_PRODUCT_ID = c.M_Product_ID)  JOIN PP_Product_BOM bom ON (bom.PP_PRODUCT_BOM_ID = b.PP_PRODUCT_BOM_ID)  WHERE bom.M_Product_ID = " + p_id + " AND M_CostElement_ID = " + this.costelement_id + "),0), FutureCostPrice = COALESCE((select Sum (b.QtyBOM * c.futurecostprice) FROM PP_Product_BOMLine b  INNER JOIN M_Cost c ON (b.M_PRODUCT_ID = c.M_Product_ID)  JOIN PP_Product_BOM bom ON (bom.PP_PRODUCT_BOM_ID = b.PP_PRODUCT_BOM_ID)  WHERE bom.M_Product_ID = " + p_id + " AND M_CostElement_ID = " + this.costelement_id + "),0) WHERE M_Product_ID = " + p_id + " AND AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND M_CostElement_ID = " + this.costelement_id + " AND M_PRODUCT_ID IN (SELECT b.M_PRODUCT_ID FROM PP_PRODUCT_BOM b JOIN PP_PRODUCT_BOMLINE bl ON b.PP_PRODUCT_BOM_ID = bl.PP_PRODUCT_BOM_ID)";
        DB.executeUpdate(update, this.get_TrxName());
        this.processed.add(p_id);
    }
}

