/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class RfQCreateSO
extends SvrProcess {
    private int p_C_RfQ_ID = 0;
    private int p_C_DocType_ID = 0;
    private static BigDecimal ONEHUNDRED = new BigDecimal(100);

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        this.log.info("doIt - " + rfq);
        if (rfq.getC_BPartner_ID() == 0 || rfq.getC_BPartner_Location_ID() == 0) {
            throw new Exception("No Business Partner/Location");
        }
        MBPartner bp = new MBPartner(this.getCtx(), rfq.getC_BPartner_ID(), this.get_TrxName());
        MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setIsSOTrx(true);
        if (this.p_C_DocType_ID != 0) {
            order.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
        } else {
            order.setC_DocTypeTarget_ID();
        }
        order.setBPartner(bp);
        order.setC_BPartner_Location_ID(rfq.getC_BPartner_Location_ID());
        order.setSalesRep_ID(rfq.getSalesRep_ID());
        if (rfq.getDateWorkComplete() != null) {
            order.setDatePromised(rfq.getDateWorkComplete());
        }
        order.saveEx();
        MRfQLine[] lines = rfq.getLines();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MRfQLine line = lines[i2];
            MRfQLineQty[] qtys = line.getQtys();
            for (int j = 0; j < qtys.length; ++j) {
                MRfQLineQty qty = qtys[j];
                if (!qty.isActive() || !qty.isOfferQty()) continue;
                MOrderLine ol = new MOrderLine(order);
                ol.setM_Product_ID(line.getM_Product_ID(), qty.getC_UOM_ID());
                ol.setDescription(line.getDescription());
                ol.setQty(qty.getQty());
                BigDecimal price = qty.getOfferAmt();
                if (price == null || price.signum() == 0) {
                    price = qty.getBestResponseAmt();
                    if (price == null || price.signum() == 0) {
                        price = Env.ZERO;
                        this.log.warning(" - BestResponse=0 - " + qty);
                    } else {
                        BigDecimal margin = qty.getMargin();
                        if (margin == null || margin.signum() == 0) {
                            margin = rfq.getMargin();
                        }
                        if (margin != null && margin.signum() != 0) {
                            margin = margin.add(ONEHUNDRED);
                            price = price.multiply(margin).divide(ONEHUNDRED, 2, 4);
                        }
                    }
                }
                ol.setPrice(price);
                ol.saveEx();
            }
        }
        rfq.setC_Order_ID(order.getC_Order_ID());
        rfq.saveEx();
        return order.getDocumentNo();
    }
}

