/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_C_Order;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class RfQCreatePO
extends SvrProcess {
    private int p_C_RfQ_ID = 0;
    private int p_C_DocType_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        this.log.info(rfq.toString());
        MRfQResponse[] responses = rfq.getResponses(true, true);
        this.log.config("#Responses=" + responses.length);
        if (responses.length == 0) {
            throw new IllegalArgumentException("No completed RfQ Responses found");
        }
        for (int i = 0; i < responses.length; ++i) {
            MRfQResponse response = responses[i];
            if (!response.isSelectedWinner()) continue;
            MBPartner bp = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), this.get_TrxName());
            this.log.config("Winner=" + bp);
            MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
            order.setIsSOTrx(false);
            if (this.p_C_DocType_ID != 0) {
                order.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
            } else {
                order.setC_DocTypeTarget_ID();
            }
            order.setBPartner(bp);
            order.setC_BPartner_Location_ID(response.getC_BPartner_Location_ID());
            order.setSalesRep_ID(rfq.getSalesRep_ID());
            if (response.getDateWorkComplete() != null) {
                order.setDatePromised(response.getDateWorkComplete());
            } else if (rfq.getDateWorkComplete() != null) {
                order.setDatePromised(rfq.getDateWorkComplete());
            }
            order.saveEx();
            MRfQResponseLine[] lines = response.getLines(false);
            for (int j = 0; j < lines.length; ++j) {
                MRfQResponseLine line = lines[j];
                if (!line.isActive()) continue;
                MRfQResponseLineQty[] qtys = line.getQtys(false);
                for (int k = 0; k < qtys.length; ++k) {
                    MRfQResponseLineQty qty = qtys[k];
                    if (!qty.getRfQLineQty().isActive() || !qty.getRfQLineQty().isPurchaseQty()) continue;
                    MOrderLine ol = new MOrderLine(order);
                    ol.setM_Product_ID(line.getRfQLine().getM_Product_ID(), qty.getRfQLineQty().getC_UOM_ID());
                    ol.setDescription(line.getDescription());
                    ol.setQty(qty.getRfQLineQty().getQty());
                    BigDecimal price = qty.getNetAmt();
                    ol.setPrice();
                    ol.setPrice(price);
                    ol.saveEx();
                }
            }
            response.setC_Order_ID(order.getC_Order_ID());
            response.saveEx();
            return order.getDocumentNo();
        }
        int noOrders = 0;
        for (int i = 0; i < responses.length; ++i) {
            MRfQResponse response = responses[i];
            X_C_BPartner bp = null;
            X_C_Order order = null;
            MRfQResponseLine[] lines = response.getLines(false);
            for (int j = 0; j < lines.length; ++j) {
                MRfQResponseLine line = lines[j];
                if (!line.isActive() || !line.isSelectedWinner()) continue;
                if (bp == null || bp.getC_BPartner_ID() != response.getC_BPartner_ID()) {
                    bp = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), this.get_TrxName());
                    order = null;
                }
                this.log.config("Line=" + line + ", Winner=" + bp);
                if (order == null) {
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setIsSOTrx(false);
                    if (this.p_C_DocType_ID != 0) {
                        order.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
                    } else {
                        ((MOrder)order).setC_DocTypeTarget_ID();
                    }
                    ((MOrder)order).setBPartner((MBPartner)bp);
                    ((MOrder)order).setC_BPartner_Location_ID(response.getC_BPartner_Location_ID());
                    order.setSalesRep_ID(rfq.getSalesRep_ID());
                    order.saveEx();
                    ++noOrders;
                    this.addLog(0, null, null, order.getDocumentNo());
                }
                MRfQResponseLineQty[] qtys = line.getQtys(false);
                for (int k = 0; k < qtys.length; ++k) {
                    MRfQResponseLineQty qty = qtys[k];
                    if (!qty.getRfQLineQty().isActive() || !qty.getRfQLineQty().isPurchaseQty()) continue;
                    MOrderLine ol = new MOrderLine((MOrder)order);
                    ol.setM_Product_ID(line.getRfQLine().getM_Product_ID(), qty.getRfQLineQty().getC_UOM_ID());
                    ol.setDescription(line.getDescription());
                    ol.setQty(qty.getRfQLineQty().getQty());
                    BigDecimal price = qty.getNetAmt();
                    ol.setPrice();
                    ol.setPrice(price);
                    ol.saveEx();
                }
            }
            if (order == null) continue;
            response.setC_Order_ID(order.getC_Order_ID());
            response.saveEx();
        }
        return "#" + noOrders;
    }
}

