/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProjectGenOrderAbstract;
import org.compiere.util.Env;

public class ProjectGenOrder
extends ProjectGenOrderAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_Project_ID=" + this.getRecord_ID());
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@C_Project_ID@ @NotFound@");
        }
        MProject fromProject = ProjectGenOrder.getProject(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        Env.setSOTrx(this.getCtx(), true);
        MOrder order = new MOrder(fromProject, true, "WI");
        if (!order.save()) {
            throw new AdempiereException("@Error@ @To@ @Generated@ @C_Order_ID@");
        }
        AtomicInteger count = new AtomicInteger(0);
        if ("S".equals(fromProject.getProjectCategory())) {
            throw new AdempiereException("Service Charge Projects are on the TODO List");
        }
        List<MProjectLine> fromProjectLines = fromProject.getLines();
        fromProjectLines.stream().forEach(fromProjectLine -> {
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(fromProjectLine.getLine());
            orderLine.setDescription(fromProjectLine.getDescription());
            orderLine.setM_Product_ID(fromProjectLine.getM_Product_ID(), true);
            orderLine.setQty(fromProjectLine.getPlannedQty().subtract(fromProjectLine.getInvoicedQty()));
            orderLine.setPrice();
            if (fromProjectLine.getPlannedPrice() != null && fromProjectLine.getPlannedPrice().compareTo(Env.ZERO) != 0) {
                orderLine.setPrice(fromProjectLine.getPlannedPrice());
            }
            orderLine.setDiscount();
            orderLine.setTax();
            count.getAndUpdate(no -> no + 1);
        });
        if (fromProjectLines.size() != count.get()) {
            this.log.log(Level.SEVERE, "Lines difference - ProjectLines=" + fromProjectLines.size() + " <> Saved=" + count.get());
        }
        return "@C_Order_ID@ " + order.getDocumentNo() + " (" + count + ")";
    }

    protected static MProject getProject(Properties ctx, int projectId, String trxName) {
        MProject fromProject = new MProject(ctx, projectId, trxName);
        if (fromProject.getC_Project_ID() == 0) {
            throw new AdempiereException("@C_Project_ID@ @NotFound@" + projectId);
        }
        if (fromProject.getM_PriceList_Version_ID() == 0) {
            throw new AdempiereException("@M_PriceList_ID@ @NotFound @@To@ @C_Project_ID@");
        }
        if (fromProject.getM_Warehouse_ID() == 0) {
            throw new AdempiereException("@M_Warehouse_ID@ @NotFound@ @To@ @C_Project_ID@");
        }
        if (fromProject.getC_BPartner_ID() == 0) {
            throw new AdempiereException("@C_BPartner_ID@ @NotFound@");
        }
        if (fromProject.getC_BPartner_Location_ID() == 0) {
            throw new AdempiereException("@C_BPartner_Location_ID@ @NotFound@");
        }
        return fromProject;
    }
}

