/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class OrderRePrice
extends SvrProcess {
    private int p_C_Order_ID = 0;
    private int p_C_Invoice_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_Order_ID")) {
                this.p_C_Order_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Invoice_ID")) {
                this.p_C_Invoice_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        PO[] lines;
        BigDecimal oldPrice;
        this.log.info("C_Order_ID=" + this.p_C_Order_ID + ", C_Invoice_ID=" + this.p_C_Invoice_ID);
        if (this.p_C_Order_ID == 0 && this.p_C_Invoice_ID == 0) {
            throw new IllegalArgumentException("Nothing to do");
        }
        String retValue = "";
        if (this.p_C_Order_ID != 0) {
            MOrder order = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
            oldPrice = order.getGrandTotal();
            lines = order.getLines();
            for (int i2 = 0; i2 < lines.length; ++i2) {
                ((MOrderLine)lines[i2]).setPrice(order.getM_PriceList_ID());
                lines[i2].saveEx();
            }
            order = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
            BigDecimal newPrice = order.getGrandTotal();
            retValue = order.getDocumentNo() + ":  " + oldPrice + " -> " + newPrice;
        }
        if (this.p_C_Invoice_ID != 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, null);
            oldPrice = invoice.getGrandTotal();
            lines = invoice.getLines(false);
            for (int i3 = 0; i3 < lines.length; ++i3) {
                ((MInvoiceLine)lines[i3]).setPrice(invoice.getM_PriceList_ID(), invoice.getC_BPartner_ID());
                lines[i3].saveEx();
            }
            invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, null);
            BigDecimal newPrice = invoice.getGrandTotal();
            if (retValue.length() > 0) {
                retValue = retValue + Env.NL;
            }
            retValue = retValue + invoice.getDocumentNo() + ":  " + oldPrice + " -> " + newPrice;
        }
        return retValue;
    }
}

