/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class InOutCreateInvoice
extends SvrProcess {
    private int p_M_InOut_ID = 0;
    private int p_M_PriceList_ID = 0;
    private String p_InvoiceDocumentNo = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_PriceList_ID")) {
                this.p_M_PriceList_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("InvoiceDocumentNo")) {
                this.p_InvoiceDocumentNo = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_InOut_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_InOut_ID=" + this.p_M_InOut_ID + ", M_PriceList_ID=" + this.p_M_PriceList_ID + ", InvoiceDocumentNo=" + this.p_InvoiceDocumentNo);
        if (this.p_M_InOut_ID == 0) {
            throw new IllegalArgumentException("No Shipment");
        }
        MInOut ship = new MInOut(this.getCtx(), this.p_M_InOut_ID, this.get_TrxName());
        if (ship.get_ID() == 0) {
            throw new IllegalArgumentException("Shipment not found");
        }
        if (!"CO".equals(ship.getDocStatus())) {
            throw new IllegalArgumentException("Shipment not completed");
        }
        MInvoice invoice = new MInvoice(ship, null);
        if (this.p_M_PriceList_ID != 0 && ship.getM_RMA_ID() == 0) {
            invoice.setM_PriceList_ID(this.p_M_PriceList_ID);
        }
        if (this.p_InvoiceDocumentNo != null && this.p_InvoiceDocumentNo.length() > 0) {
            invoice.setDocumentNo(this.p_InvoiceDocumentNo);
        }
        if (!invoice.save()) {
            throw new IllegalArgumentException("Cannot save Invoice");
        }
        MInOutLine[] shipLines = ship.getLines(false);
        for (int i2 = 0; i2 < shipLines.length; ++i2) {
            MInOutLine sLine = shipLines[i2];
            MInvoiceLine line = new MInvoiceLine(invoice);
            line.setShipLine(sLine);
            if (sLine.sameOrderLineUOM()) {
                line.setQtyEntered(sLine.getQtyEntered());
            } else {
                line.setQtyEntered(sLine.getMovementQty());
            }
            line.setQtyInvoiced(sLine.getMovementQty());
            if (line.save()) continue;
            throw new IllegalArgumentException("Cannot save Invoice Line");
        }
        return invoice.getDocumentNo();
    }
}

