/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MActivity;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MCampaign;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_C_Activity;
import org.compiere.model.X_C_Campaign;
import org.compiere.model.X_C_Project;
import org.compiere.model.X_I_Requisition;
import org.compiere.model.X_M_Product_Class;
import org.compiere.model.X_M_Product_Classification;
import org.compiere.model.X_M_Product_Group;
import org.compiere.process.ImportRequisitionAbstract;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class ImportRequisition
extends ImportRequisitionAbstract
implements ImportProcess {
    private Timestamp dateValue = null;
    private StringBuffer stringError = new StringBuffer("");
    private int currentRequisitionId;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.dateValue == null) {
            this.dateValue = new Timestamp(System.currentTimeMillis());
        }
        if (this.getDocAction() == null) {
            this.setDocAction("PR");
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.getAD_Client_ID();
        if (this.getUserId() != 0) {
            clientCheck = clientCheck + " AND CreatedBy = " + this.getUserId();
        }
        if (this.isDeleteOldImported()) {
            sql = new StringBuffer("DELETE I_Requisition WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Requisition SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.getAD_Client_ID()).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.getOrgId()).append("), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_Requisition o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        AtomicInteger importedRecord = new AtomicInteger(0);
        AtomicInteger withErrors = new AtomicInteger(0);
        this.getImportIds(false, false, this.get_TrxName()).forEach(importRequisitionId -> {
            X_I_Requisition importRequisition = new X_I_Requisition(this.getCtx(), (int)importRequisitionId, this.get_TrxName());
            importRequisition.setI_ErrorMsg(null);
            this.fillIdValues(importRequisition, this.get_TrxName());
            if (this.importRequisition(importRequisition, this.get_TrxName())) {
                importedRecord.updateAndGet(record -> record + 1);
            } else {
                withErrors.updateAndGet(error -> error + 1);
            }
            if (!this.stringError.toString().isEmpty() && this.stringError.toString().length() > 0) {
                importRequisition.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), this.stringError.toString()));
            }
            importRequisition.saveEx();
        });
        return "@M_Requisition_ID@ @Import@ @Records@ " + importedRecord.get() + " @Errors@ " + withErrors.get();
    }

    private List<Integer> getImportIds(boolean isImported, boolean isProcessed, String transactionName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        return new Query(this.getCtx(), "I_Requisition", whereClause.toString(), transactionName).setOnlyActiveRecords(true).setParameters(isImported, isProcessed).setOrderBy("M_Warehouse_ID, DateDoc, DocumentNo, Line").getIDsAsList();
    }

    private boolean importRequisition(X_I_Requisition importRequisition, String transactionName) {
        int referenceId = importRequisition.getM_Requisition_ID();
        MRequisition requisition = null;
        if (referenceId <= 0) {
            if (this.isConsolidateRequisition()) {
                if (this.currentRequisitionId <= 0) {
                    this.currentRequisitionId = referenceId = this.getIdOnlyClient("M_Requisition", "C_DocType_ID = ? AND DateDoc = ? AND M_Warehouse_ID = ? AND DocStatus = 'DR'", transactionName, importRequisition.getC_DocType_ID(), importRequisition.getDateDoc(), importRequisition.getM_Warehouse_ID());
                } else {
                    referenceId = this.currentRequisitionId;
                }
            } else {
                referenceId = this.getIdOnlyClient("M_Requisition", "DocumentNo = ? AND C_DocType_ID = ? AND DateDoc = ? AND M_Warehouse_ID = ? AND DocStatus = 'DR'", transactionName, importRequisition.getDocumentNo(), importRequisition.getC_DocType_ID(), importRequisition.getDateDoc(), importRequisition.getM_Warehouse_ID());
            }
            if (referenceId > 0) {
                importRequisition.setM_Requisition_ID(referenceId);
            }
        }
        requisition = this.createRequisition(importRequisition, transactionName);
        ModelValidationEngine.get().fireImportValidate(this, importRequisition, requisition, 40);
        return requisition != null;
    }

    private MRequisition createRequisition(X_I_Requisition importRequisition, String transactionName) {
        MRequisition requisition = new MRequisition(this.getCtx(), importRequisition.getM_Requisition_ID(), transactionName);
        boolean isValid = true;
        if (requisition.getM_Requisition_ID() <= 0) {
            requisition.setAD_Org_ID(importRequisition.getAD_Org_ID());
            if (importRequisition.getDateRequired() != null) {
                requisition.setDateRequired(importRequisition.getDateRequired());
            } else {
                isValid = false;
                this.addError("DateRequired");
            }
            if (importRequisition.getC_DocType_ID() > 0) {
                requisition.setC_DocType_ID(importRequisition.getC_DocType_ID());
            } else {
                isValid = false;
                this.addError("C_DocType_ID");
            }
            if (importRequisition.getDateDoc() != null) {
                requisition.setDateDoc(importRequisition.getDateDoc());
            } else {
                isValid = false;
                this.addError("DateDoc");
            }
            if (!Util.isEmpty(importRequisition.getDocumentNo())) {
                requisition.setDocumentNo(importRequisition.getDocumentNo());
            }
            if (importRequisition.getAD_OrgTrx_ID() > 0) {
                requisition.setAD_OrgTrx_ID(importRequisition.getAD_OrgTrx_ID());
            }
            if (importRequisition.getM_Warehouse_ID() > 0) {
                requisition.setM_Warehouse_ID(importRequisition.getM_Warehouse_ID());
            } else {
                isValid = false;
                this.addError("M_Warehouse_ID");
            }
            if (importRequisition.getM_PriceList_ID() > 0) {
                requisition.setM_PriceList_ID(importRequisition.getM_PriceList_ID());
            } else {
                isValid = false;
                this.addError("M_PriceList_ID");
            }
            if (!Util.isEmpty(importRequisition.getPriorityRule())) {
                requisition.setPriorityRule(importRequisition.getPriorityRule());
            }
            if (importRequisition.getAD_User_ID() > 0) {
                requisition.setAD_User_ID(importRequisition.getAD_User_ID());
            }
            if (importRequisition.getC_Project_ID() > 0) {
                requisition.setC_Project_ID(importRequisition.getC_Project_ID());
            }
            if (importRequisition.getC_Campaign_ID() > 0) {
                requisition.setC_Campaign_ID(importRequisition.getC_Campaign_ID());
            }
            if (!Util.isEmpty(importRequisition.getDescription())) {
                requisition.setDescription(importRequisition.getDescription());
            }
            if (!Util.isEmpty(importRequisition.getHelp())) {
                requisition.setHelp(importRequisition.getHelp());
            }
            if (importRequisition.getUser1_ID() > 0) {
                requisition.setUser1_ID(importRequisition.getUser1_ID());
            }
            if (importRequisition.getUser2_ID() > 0) {
                requisition.setUser2_ID(importRequisition.getUser2_ID());
            }
            if (importRequisition.getUser3_ID() > 0) {
                requisition.setUser3_ID(importRequisition.getUser3_ID());
            }
            if (importRequisition.getUser4_ID() > 0) {
                requisition.setUser4_ID(importRequisition.getUser4_ID());
            }
            requisition.setDocStatus("DR");
            requisition.setDocAction(this.getDocAction());
            if (isValid) {
                requisition.saveEx();
                this.createRequisitionLine(requisition, importRequisition, transactionName);
                importRequisition.setM_Requisition_ID(requisition.getM_Requisition_ID());
                importRequisition.saveEx();
                return requisition;
            }
            return null;
        }
        this.createRequisitionLine(requisition, importRequisition, transactionName);
        return requisition;
    }

    private MRequisitionLine createRequisitionLine(MRequisition requisition, X_I_Requisition importRequisition, String transactionName) {
        MRequisitionLine requisitionLine = new MRequisitionLine(this.getCtx(), importRequisition.getM_RequisitionLine_ID(), transactionName);
        boolean isValid = true;
        if (requisitionLine.getM_RequisitionLine_ID() <= 0) {
            requisitionLine = new MRequisitionLine(requisition);
            requisitionLine.setAD_Org_ID(importRequisition.getAD_Org_ID());
            if (importRequisition.getAD_OrgTrx_ID() > 0) {
                requisitionLine.setAD_OrgTrx_ID(importRequisition.getAD_OrgTrx_ID());
            }
            if (importRequisition.getC_BPartner_ID() > 0) {
                requisitionLine.setC_BPartner_ID(importRequisition.getC_BPartner_ID());
            }
            if (importRequisition.getC_ProjectTask_ID() > 0) {
                requisitionLine.setC_ProjectTask_ID(importRequisition.getC_ProjectTask_ID());
            }
            if (importRequisition.getC_Project_ID() > 0) {
                requisitionLine.setC_Project_ID(importRequisition.getC_Project_ID());
            }
            if (importRequisition.getC_ProjectPhase_ID() > 0) {
                requisitionLine.setC_ProjectPhase_ID(importRequisition.getC_ProjectPhase_ID());
            }
            if (importRequisition.getM_Product_ID() > 0) {
                requisitionLine.setM_Product_ID(importRequisition.getM_Product_ID());
            } else {
                isValid = false;
                this.addError("M_Product_ID");
            }
            if (importRequisition.getC_UOM_ID() > 0) {
                requisitionLine.setC_UOM_ID(importRequisition.getC_UOM_ID());
            } else {
                isValid = false;
                this.addError("C_UOM_ID");
            }
            if (Optional.ofNullable(importRequisition.getQty()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0) {
                requisitionLine.setQty(importRequisition.getQty());
            } else {
                isValid = false;
                this.addError("Qty");
            }
            requisitionLine.setPriceActual(Optional.ofNullable(importRequisition.getPriceActual()).orElse(Env.ZERO));
            if (importRequisition.getC_Campaign_ID() > 0) {
                requisitionLine.setC_Campaign_ID(importRequisition.getC_Campaign_ID());
            }
            if (importRequisition.getLine() > 0) {
                requisitionLine.setLine(importRequisition.getLine());
            }
            if (!Util.isEmpty(importRequisition.getLineDescription())) {
                requisitionLine.setDescription(importRequisition.getLineDescription());
            }
            if (importRequisition.getUser1_ID() > 0) {
                requisitionLine.setUser1_ID(importRequisition.getUser1_ID());
            }
            if (importRequisition.getUser2_ID() > 0) {
                requisitionLine.setUser2_ID(importRequisition.getUser2_ID());
            }
            if (importRequisition.getUser3_ID() > 0) {
                requisitionLine.setUser3_ID(importRequisition.getUser3_ID());
            }
            if (importRequisition.getUser4_ID() > 0) {
                requisitionLine.setUser4_ID(importRequisition.getUser4_ID());
            }
            if (isValid) {
                requisitionLine.saveEx();
                importRequisition.setM_RequisitionLine_ID(requisitionLine.getM_RequisitionLine_ID());
                importRequisition.saveEx();
                return requisitionLine;
            }
            return null;
        }
        importRequisition.setM_RequisitionLine_ID(requisitionLine.getM_RequisitionLine_ID());
        importRequisition.saveEx();
        return requisitionLine;
    }

    private boolean importProduct(X_I_Requisition importRequisition, String transactionName) {
        boolean ok = false;
        try {
            MProduct product;
            String whereClause;
            String value;
            int referenceId = 0;
            if (importRequisition.getM_Product_Class_ID() == 0 && !Util.isEmpty(importRequisition.getProductClass_Value()) && !Util.isEmpty(importRequisition.getProductClass_Name())) {
                value = importRequisition.getProductClass_Value();
                whereClause = "VALUE= '" + value + "'";
                X_M_Product_Class productClass = (X_M_Product_Class)MTable.get(this.getCtx(), X_M_Product_Class.Table_ID).createQuery(whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().first();
                if (productClass == null) {
                    productClass = new X_M_Product_Class(this.getCtx(), 0, this.get_TrxName());
                    productClass.setValue(importRequisition.getProductClass_Value());
                    productClass.setName(importRequisition.getProductClass_Name());
                    productClass.setIsActive(true);
                    productClass.setIsDefault(false);
                    productClass.saveEx();
                }
                importRequisition.setM_Product_Class_ID(productClass.getM_Product_Class_ID());
                ModelValidationEngine.get().fireImportValidate(this, importRequisition, productClass, 40);
            }
            if (importRequisition.getM_Product_Classification_ID() == 0 && !Util.isEmpty(importRequisition.getProductClassification_Value()) && !Util.isEmpty(importRequisition.getProductClassification_Name())) {
                value = importRequisition.getProductClassification_Value();
                whereClause = "VALUE= '" + value + "'";
                X_M_Product_Classification productClassification = (X_M_Product_Classification)MTable.get(this.getCtx(), X_M_Product_Classification.Table_ID).createQuery(whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().first();
                if (productClassification == null) {
                    productClassification = new X_M_Product_Classification(this.getCtx(), 0, this.get_TrxName());
                    productClassification.setValue(importRequisition.getProductClassification_Value());
                    productClassification.setName(importRequisition.getProductClassification_Name());
                    productClassification.setIsActive(true);
                    productClassification.setIsDefault(false);
                    productClassification.saveEx();
                }
                importRequisition.setM_Product_Classification_ID(productClassification.getM_Product_Classification_ID());
                ModelValidationEngine.get().fireImportValidate(this, importRequisition, productClassification, 40);
            }
            if (importRequisition.getM_Product_Group_ID() == 0 && !Util.isEmpty(importRequisition.getProductGroup_Value()) && !Util.isEmpty(importRequisition.getProductGroup_Name())) {
                value = importRequisition.getProductGroup_Value();
                whereClause = "VALUE= '" + value + "'";
                X_M_Product_Group productGroup = (X_M_Product_Group)MTable.get(this.getCtx(), X_M_Product_Group.Table_ID).createQuery(whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().first();
                if (productGroup == null) {
                    productGroup = new X_M_Product_Group(this.getCtx(), 0, this.get_TrxName());
                    productGroup.setValue(importRequisition.getProductGroup_Value());
                    productGroup.setName(importRequisition.getProductGroup_Name());
                    productGroup.setIsActive(true);
                    productGroup.setIsDefault(false);
                    productGroup.saveEx();
                }
                importRequisition.setM_Product_Group_ID(productGroup.getM_Product_Group_ID());
                ModelValidationEngine.get().fireImportValidate(this, importRequisition, productGroup, 40);
            }
            if ((product = this.createProduct(importRequisition)) != null && (referenceId = importRequisition.getM_AttributeSetInstance_ID()) <= 0 && !Util.isEmpty(importRequisition.getAttributeSetInstanceValue())) {
                referenceId = this.getIdOnlyClient("M_AttributeInstance", "(TRIM(Description)=TRIM(?) OR TRIM(Lot) LIKE TRIM(?) OR TRIM(SerNo) LIKE TRIM(?))", transactionName, importRequisition.getAttributeSetInstanceValue(), importRequisition.getLot(), importRequisition.getSerNo());
                if (referenceId > 0) {
                    importRequisition.setM_AttributeSetInstance_ID(referenceId);
                } else if (importRequisition.getLot() != null || importRequisition.getSerNo() != null) {
                    if (product.isInstanceAttribute()) {
                        MAttributeSet attributeSet = product.getAttributeSet();
                        MAttributeSetInstance attributeSetInstance = new MAttributeSetInstance(this.getCtx(), 0, attributeSet.getM_AttributeSet_ID(), this.get_TrxName());
                        if (attributeSet.isLot() && importRequisition.getLot() != null) {
                            attributeSetInstance.setLot(importRequisition.getLot(), importRequisition.getM_Product_ID());
                        }
                        if (attributeSet.isSerNo() && importRequisition.getSerNo() != null) {
                            attributeSetInstance.setSerNo(importRequisition.getSerNo());
                        }
                        if (attributeSet.isGuaranteeDate()) {
                            attributeSetInstance.setGuaranteeDate(importRequisition.getGuaranteeDate());
                        }
                        attributeSetInstance.setDescription();
                        attributeSetInstance.saveEx();
                        attributeSetInstance.getM_AttributeSetInstance_ID();
                        if (referenceId > 0) {
                            importRequisition.setM_AttributeSetInstance_ID(referenceId);
                        }
                        ModelValidationEngine.get().fireImportValidate(this, importRequisition, attributeSetInstance, 40);
                    } else {
                        this.addError("M_AttributeSetInstance_ID");
                    }
                }
            }
            ok = true;
        }
        catch (Exception e) {
            this.addError(e.getLocalizedMessage());
        }
        return ok;
    }

    private MProduct createProduct(X_I_Requisition importRequisition) {
        MProduct product = new MProduct(importRequisition.getCtx(), importRequisition.getM_Product_ID(), importRequisition.get_TrxName());
        boolean isValid = true;
        if (product.getM_Product_ID() <= 0) {
            if (importRequisition.getM_Product_Category_ID() <= 0) {
                isValid = false;
                this.addError("M_Product_Category_ID");
            }
            if (importRequisition.getC_TaxCategory_ID() <= 0) {
                isValid = false;
                this.addError("C_TaxCategory_ID");
            }
            if (importRequisition.getC_UOM_ID() <= 0) {
                isValid = false;
                this.addError("C_UOM_ID");
            }
            if (Util.isEmpty(importRequisition.getProductValue())) {
                isValid = false;
                this.addError("Value");
            }
            if (Util.isEmpty(importRequisition.getProductName())) {
                isValid = false;
                this.addError("Name");
            }
            if (Util.isEmpty(importRequisition.getProductType())) {
                isValid = false;
                this.addError("ProductType");
            }
        }
        if (isValid) {
            if (importRequisition.getAD_Org_ID() > 0) {
                product.setAD_Org_ID(importRequisition.getAD_Org_ID());
            }
            if (!Util.isEmpty(importRequisition.getProductValue())) {
                product.setValue(importRequisition.getProductValue());
            }
            if (!Util.isEmpty(importRequisition.getProductName())) {
                product.setName(importRequisition.getProductName());
            }
            if (!Util.isEmpty(importRequisition.getDescription())) {
                product.setDescription(importRequisition.getDescription());
            }
            if (!Util.isEmpty(importRequisition.getDocumentNote())) {
                product.setDocumentNote(importRequisition.getDocumentNote());
            }
            if (!Util.isEmpty(importRequisition.getHelp())) {
                product.setHelp(importRequisition.getHelp());
            }
            if (!Util.isEmpty(importRequisition.getUPC())) {
                product.setUPC(importRequisition.getUPC());
            }
            if (!Util.isEmpty(importRequisition.getSKU())) {
                product.setSKU(importRequisition.getSKU());
            }
            if (importRequisition.getC_UOM_ID() > 0) {
                product.setC_UOM_ID(importRequisition.getC_UOM_ID());
            }
            if (importRequisition.getM_Product_Category_ID() > 0) {
                product.setM_Product_Category_ID(importRequisition.getM_Product_Category_ID());
            }
            if (!Util.isEmpty(importRequisition.getProductType())) {
                product.setProductType(importRequisition.getProductType());
            }
            if (!Util.isEmpty(importRequisition.getImageURL())) {
                product.setImageURL(importRequisition.getImageURL());
            }
            if (!Util.isEmpty(importRequisition.getDescriptionURL())) {
                product.setDescriptionURL(importRequisition.getDescriptionURL());
            }
            if (importRequisition.getM_Product_Class_ID() > 0) {
                product.setM_Product_Class_ID(importRequisition.getM_Product_Class_ID());
            }
            if (importRequisition.getM_Product_Classification_ID() > 0) {
                product.setM_Product_Classification_ID(importRequisition.getM_Product_Classification_ID());
            }
            if (importRequisition.getM_Product_Group_ID() > 0) {
                product.setM_Product_Group_ID(importRequisition.getM_Product_Group_ID());
            }
            if (importRequisition.getC_TaxCategory_ID() > 0) {
                product.setC_TaxCategory_ID(importRequisition.getC_TaxCategory_ID());
            }
            product.saveEx();
            importRequisition.setM_Product_ID(product.getM_Product_ID());
        } else {
            product = null;
        }
        ModelValidationEngine.get().fireImportValidate(this, importRequisition, product, 40);
        return product;
    }

    private void fillIdValues(X_I_Requisition importRequisition, String transactionName) {
        ModelValidationEngine.get().fireImportValidate(this, null, null, 10);
        int referenceId = 0;
        if (importRequisition.getAD_OrgTrx_ID() > 0) {
            referenceId = importRequisition.getAD_OrgTrx_ID();
        }
        if (referenceId <= 0) {
            referenceId = this.getIdOnlyClient("AD_Org", "Value=?", transactionName, importRequisition.getOrgTrxValue());
        }
        if (referenceId > 0) {
            importRequisition.setAD_OrgTrx_ID(referenceId);
        }
        if ((referenceId = importRequisition.getC_DocType_ID()) <= 0 && !Util.isEmpty(importRequisition.getDocTypeName())) {
            referenceId = this.getIdOnlyClient("C_DocType", "Name = ? AND DocBaseType = ?", transactionName, importRequisition.getDocTypeName(), "POR");
            if (referenceId > 0) {
                importRequisition.setC_DocType_ID(referenceId);
            } else {
                this.addError("C_DocType_ID");
            }
        }
        if ((referenceId = importRequisition.getM_PriceList_ID()) <= 0 && !Util.isEmpty(importRequisition.getPriceListName())) {
            referenceId = this.getIdOnlyClient("M_PriceList", "Name = ? AND IsSOPriceList = 'N'", transactionName, importRequisition.getPriceListName());
            if (referenceId > 0) {
                importRequisition.setM_PriceList_ID(referenceId);
            } else {
                this.addError("M_PriceList_ID");
            }
        }
        if ((referenceId = importRequisition.getM_Warehouse_ID()) <= 0 && !Util.isEmpty(importRequisition.getWarehouseValue())) {
            referenceId = this.getIdOnlyClient("M_Warehouse", "Value = ?", transactionName, importRequisition.getWarehouseValue());
            if (referenceId > 0) {
                importRequisition.setM_Warehouse_ID(referenceId);
            } else {
                this.addError("M_Warehouse_ID");
            }
        }
        if ((referenceId = importRequisition.getC_BPartner_ID()) <= 0 && !Util.isEmpty(importRequisition.getBPartnerValue())) {
            referenceId = this.getIdOnlyClient("C_BPartner", "(Value = ? OR TaxID = ?)", transactionName, importRequisition.getBPartnerValue(), importRequisition.getBPartnerValue());
            if (referenceId > 0) {
                importRequisition.setC_BPartner_ID(referenceId);
            } else {
                this.addError("C_BPartner_ID");
            }
        }
        if ((referenceId = importRequisition.getM_Product_ID()) <= 0 && !Util.isEmpty(importRequisition.getProductValue()) && (referenceId = this.getIdOnlyClient("M_Product", "(Value = ? OR UPC = ? OR SKU = ?)", transactionName, importRequisition.getProductValue(), importRequisition.getProductValue(), importRequisition.getProductValue())) > 0) {
            importRequisition.setM_Product_ID(referenceId);
        }
        if ((referenceId = importRequisition.getC_Charge_ID()) <= 0 && !Util.isEmpty(importRequisition.getChargeName())) {
            referenceId = this.getIdOnlyClient("C_Charge", "Name = ?", transactionName, importRequisition.getChargeName());
            if (referenceId > 0) {
                importRequisition.setC_Charge_ID(referenceId);
            } else {
                this.addError("C_Charge_ID");
            }
        }
        X_C_Activity activity = null;
        if (importRequisition.getC_Activity_ID() > 0) {
            activity = MActivity.getById(this.getCtx(), importRequisition.getC_Activity_ID(), transactionName);
        }
        if (activity == null && importRequisition.getActivityValue() != null) {
            activity = MActivity.getByValue(this.getCtx(), importRequisition.getActivityValue(), transactionName);
        }
        if (activity != null && activity.getC_Activity_ID() > 0) {
            importRequisition.setC_Activity_ID(activity.getC_Activity_ID());
        }
        X_C_Campaign campaign = null;
        if (importRequisition.getC_Campaign_ID() > 0) {
            campaign = MCampaign.getById(this.getCtx(), importRequisition.getC_Campaign_ID(), transactionName);
        }
        if (campaign == null && importRequisition.getCampaignValue() != null) {
            campaign = MCampaign.getByValue(this.getCtx(), importRequisition.getCampaignValue(), transactionName);
        }
        if (campaign != null && campaign.getC_Campaign_ID() > 0) {
            importRequisition.setC_Campaign_ID(campaign.getC_Campaign_ID());
        }
        X_C_Project project = null;
        if (importRequisition.getC_Project_ID() > 0) {
            project = MProject.getById(this.getCtx(), importRequisition.getC_Project_ID(), transactionName);
        }
        if (project == null && importRequisition.getProjectValue() != null) {
            project = MProject.getByValue(this.getCtx(), importRequisition.getProjectValue(), transactionName);
        }
        if (project != null && project.getC_Project_ID() > 0) {
            importRequisition.setC_Project_ID(project.getC_Project_ID());
        }
        if ((referenceId = importRequisition.getM_Product_Category_ID()) <= 0 && !Util.isEmpty(importRequisition.getProductCategory_Value())) {
            referenceId = this.getIdOnlyClient("M_Product_Category", "Value = ?", transactionName, importRequisition.getProductCategory_Value());
            if (referenceId > 0) {
                importRequisition.setM_Product_Category_ID(referenceId);
            } else {
                this.addError("M_Product_Category_ID");
            }
        }
        if ((referenceId = importRequisition.getC_TaxCategory_ID()) <= 0 && !Util.isEmpty(importRequisition.getTaxCategoryName())) {
            referenceId = this.getIdOnlyClient("C_TaxCategory", "Name = ?", transactionName, importRequisition.getTaxCategoryName());
            if (referenceId > 0) {
                importRequisition.setC_TaxCategory_ID(referenceId);
            } else {
                this.addError("C_TaxCategory_ID");
            }
        }
        if ((referenceId = importRequisition.getC_ProjectPhase_ID()) <= 0 && !Util.isEmpty(importRequisition.getProjectPhaseName())) {
            referenceId = this.getIdOnlyClient("C_ProjectPhase", "Name = ?", transactionName, importRequisition.getProjectPhaseName());
            if (referenceId > 0) {
                importRequisition.setC_ProjectPhase_ID(referenceId);
            } else {
                this.addError("C_ProjectPhase_ID");
            }
        }
        if ((referenceId = importRequisition.getAD_User_ID()) <= 0 && !Util.isEmpty(importRequisition.getUserAgent())) {
            referenceId = this.getIdOnlyClient("AD_User", "(Value = ? OR Name = ?)", transactionName, importRequisition.getUserAgent(), importRequisition.getUserAgent());
            if (referenceId > 0) {
                importRequisition.setAD_User_ID(referenceId);
            } else {
                this.addError("AD_User_ID");
            }
        }
        if ((referenceId = importRequisition.getC_UOM_ID()) <= 0 && !Util.isEmpty(importRequisition.getX12DE355())) {
            referenceId = this.getId("C_UOM", "X12DE355 = ?", transactionName, importRequisition.getX12DE355());
            if (referenceId > 0) {
                importRequisition.setC_UOM_ID(referenceId);
            } else {
                this.addError("C_UOM_ID");
            }
        }
        if ((referenceId = importRequisition.getUser1_ID()) <= 0 && !Util.isEmpty(importRequisition.getUserValue1())) {
            referenceId = this.getIdOnlyClient("C_ElementValue", "Value = ?", transactionName, importRequisition.getUserValue1());
            if (referenceId > 0) {
                importRequisition.setUser1_ID(referenceId);
            } else {
                this.addError("C_ElementValue_ID");
            }
        }
        if ((referenceId = importRequisition.getUser2_ID()) <= 0 && !Util.isEmpty(importRequisition.getUserValue2())) {
            referenceId = this.getIdOnlyClient("C_ElementValue", "Value = ?", transactionName, importRequisition.getUserValue2());
            if (referenceId > 0) {
                importRequisition.setUser2_ID(referenceId);
            } else {
                this.addError("C_ElementValue_ID");
            }
        }
        if ((referenceId = importRequisition.getUser3_ID()) <= 0 && !Util.isEmpty(importRequisition.getUserValue3())) {
            referenceId = this.getIdOnlyClient("C_ElementValue", "Value = ?", transactionName, importRequisition.getUserValue3());
            if (referenceId > 0) {
                importRequisition.setUser3_ID(referenceId);
            } else {
                this.addError("C_ElementValue_ID");
            }
        }
        if ((referenceId = importRequisition.getUser4_ID()) <= 0 && !Util.isEmpty(importRequisition.getUserValue4())) {
            referenceId = this.getIdOnlyClient("C_ElementValue", "Value = ?", transactionName, importRequisition.getUserValue4());
            if (referenceId > 0) {
                importRequisition.setUser4_ID(referenceId);
            } else {
                this.addError("C_ElementValue_ID");
            }
        }
        if (!this.stringError.toString().isEmpty() && this.stringError.toString().length() > 0) {
            importRequisition.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), this.stringError.toString()));
        } else {
            this.importProduct(importRequisition, transactionName);
        }
        if (importRequisition.getDateRequired() == null) {
            importRequisition.setDateRequired(TimeUtil.getDay(System.currentTimeMillis()));
        }
        if (importRequisition.getDateDoc() == null) {
            importRequisition.setDateDoc(TimeUtil.getDay(System.currentTimeMillis()));
        }
        importRequisition.saveEx();
        ModelValidationEngine.get().fireImportValidate(this, importRequisition, null, 20);
    }

    private void addError(String columnName) {
        if (this.stringError.length() > 0) {
            this.stringError.append(", ");
        }
        this.stringError.append("@").append(columnName).append("@ @NotFound@");
    }

    private int getIdOnlyClient(String tableName, String whereClause, String transactionName, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, transactionName).setClient_ID().setOnlyActiveRecords(true).setParameters(parameters).firstId();
    }

    private int getId(String tableName, String whereClause, String transactionName, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, transactionName).setOnlyActiveRecords(true).setParameters(parameters).firstId();
    }

    @Override
    public String getImportTableName() {
        return "I_Requisition";
    }

    @Override
    public String getWhereClause() {
        return " AND AD_Client_ID = " + this.getAD_Client_ID();
    }
}

