/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.SQLException;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.PO;
import org.compiere.process.CopyReportProcessAbstract;
import org.compiere.util.DB;

public class CopyReportProcess
extends CopyReportProcessAbstract {
    private StringBuffer sql = new StringBuffer();
    private int seqNo = 0;

    @Override
    protected String doIt() throws Exception {
        MProcess process = MProcess.get(this.getCtx(), this.getRecord_ID());
        this.seqNo = DB.getSQLValueEx(this.get_TrxName(), "SELECT MAX(SeqNo) FROM AD_Process_Para WHERE AD_Process_ID = ?", this.getRecord_ID());
        this.seqNo = this.seqNo == -1 ? 10 : (this.seqNo += 10);
        List<Integer> keys = this.getSelectionKeys();
        for (Integer key : keys) {
            this.copyFrom(process, key);
        }
        return "@OK@";
    }

    private void copyFrom(MProcess process, int key) throws SQLException {
        int columnId = this.getSelectionAsInt(key, "PARAMETER_AD_Column_ID");
        int reportViewId = this.getSelectionAsInt(key, "PARAMETER_AD_ReportView_ID");
        int processParaId = this.getSelectionAsInt(key, "PARAMETER_AD_Process_Para_ID");
        boolean isMandatory = this.getSelectionAsBoolean(key, "PARAMETER_IsMandatory");
        boolean isRange = this.getSelectionAsBoolean(key, "PARAMETER_IsRange");
        String defaultValue = this.getSelectionAsString(key, "PARAMETER_DefaultValue");
        String defaultValue2 = this.getSelectionAsString(key, "PARAMETER_DefaultValue2");
        MProcessPara newParameter = new MProcessPara(process);
        if (reportViewId != 0) {
            MColumn column = MColumn.get(this.getCtx(), columnId);
            if (column.getAD_Reference_ID() == 13) {
                return;
            }
            if (process.getAD_ReportView_ID() != reportViewId) {
                process.setAD_ReportView_ID(reportViewId);
                process.saveEx();
            }
            newParameter.setEntityType(process.getEntityType());
            newParameter.setAD_Element_ID(column.getAD_Element_ID());
            newParameter.setAD_Reference_ID(column.getAD_Reference_ID());
            newParameter.setAD_Reference_Value_ID(column.getAD_Reference_Value_ID());
            newParameter.setAD_Val_Rule_ID(column.getAD_Val_Rule_ID());
            newParameter.setName(column.getName());
            newParameter.setColumnName(column.getColumnName());
            newParameter.setDescription(column.getDescription());
            newParameter.setFieldLength(column.getFieldLength());
            newParameter.setHelp(column.getHelp());
            newParameter.setIsCentrallyMaintained(true);
        } else if (processParaId != 0) {
            MProcessPara fromParameter = new MProcessPara(this.getCtx(), processParaId, this.get_TrxName());
            PO.copyValues(fromParameter, newParameter);
            newParameter.setAD_Process_ID(process.getAD_Process_ID());
        } else {
            return;
        }
        newParameter.setIsMandatory(isMandatory);
        newParameter.setIsRange(isRange);
        newParameter.setDefaultValue(defaultValue);
        newParameter.setDefaultValue2(defaultValue2);
        newParameter.setSeqNo(this.seqNo);
        newParameter.saveEx();
        this.seqNo += 10;
        this.addLog("@AD_Process_Para_ID@ @" + newParameter.getColumnName() + "@ @Added@");
    }

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@AD_Process_ID@ @NotFound@");
        }
        this.log.fine(this.sql.toString());
    }
}

