/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBank;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.X_I_BankStatement;
import org.compiere.process.BankStatementPaymentAbstract;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class BankStatementPayment
extends BankStatementPaymentAbstract {
    @Override
    protected String doIt() throws Exception {
        int tableId = this.getTable_ID();
        int recordId = this.getRecord_ID();
        this.log.info("Table_ID=" + tableId + ", Record_ID=" + recordId);
        if (this.isSelection()) {
            String transactionType = this.getParameterAsString("TrxType");
            if (Util.isEmpty(transactionType)) {
                throw new AdempiereException("@TrxType@ @NotFound@");
            }
            int chargeId = this.getParameterAsInt("C_Charge_ID");
            int bPartnerId = this.getParameterAsInt("C_BPartner_ID");
            int created = 0;
            for (int key : this.getSelectionKeys()) {
                int bankStatementLineId = this.getSelectionAsInt(key, "BSL_C_BankStatementLine_ID");
                MBankStatementLine bankStatementLine = new MBankStatementLine(this.getCtx(), bankStatementLineId, this.get_TrxName());
                if (transactionType.equals("B")) {
                    MBank bank = MBank.get(this.getCtx(), bankStatementLine.getParent().getBankAccount().getC_Bank_ID());
                    if (bank.getC_BPartner_ID() == 0) {
                        throw new AdempiereException("@C_Bank_ID@ @C_BPartner_ID@ @NotFound@");
                    }
                    bPartnerId = bank.getC_BPartner_ID();
                } else if (transactionType.equals("U") && (bPartnerId = MOrgInfo.get(this.getCtx(), bankStatementLine.getAD_Org_ID(), this.get_TrxName()).getUnidentifiedBPartner_ID()) == 0) {
                    throw new AdempiereException("@AD_Org_ID@ @UnidentifiedBPartner_ID@ @NotFound@");
                }
                if (bPartnerId != 0) {
                    bankStatementLine.setC_BPartner_ID(bPartnerId);
                }
                if (chargeId != 0) {
                    bankStatementLine.setC_Charge_ID(chargeId);
                }
                this.createPayment(bankStatementLine);
                ++created;
            }
            return "@Created@: " + created;
        }
        if (tableId == X_I_BankStatement.Table_ID) {
            return this.createPayment(new X_I_BankStatement(this.getCtx(), recordId, this.get_TrxName()));
        }
        if (tableId == MBankStatementLine.Table_ID) {
            return this.createPayment(new MBankStatementLine(this.getCtx(), recordId, this.get_TrxName()));
        }
        return "Ok";
    }

    private String createPayment(X_I_BankStatement importBankStatement) throws Exception {
        if (importBankStatement == null || importBankStatement.getC_Payment_ID() != 0) {
            return "--";
        }
        this.log.fine(importBankStatement.toString());
        if (importBankStatement.getC_Invoice_ID() == 0 && importBankStatement.getC_BPartner_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_Invoice_ID@ / @C_BPartner_ID@");
        }
        if (importBankStatement.getC_BankAccount_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_BankAccount_ID@");
        }
        String documentNo = importBankStatement.getReferenceNo();
        if (Util.isEmpty(documentNo)) {
            documentNo = importBankStatement.getEftReference();
        }
        String checkNo = importBankStatement.getEftCheckNo();
        MPayment payment = this.createPayment(importBankStatement.getC_Invoice_ID(), importBankStatement.getC_BPartner_ID(), importBankStatement.getC_Currency_ID(), importBankStatement.getStmtAmt(), importBankStatement.getTrxAmt(), importBankStatement.getC_BankAccount_ID(), importBankStatement.getStatementLineDate() == null ? importBankStatement.getStatementDate() : importBankStatement.getStatementLineDate(), importBankStatement.getDateAcct(), importBankStatement.getDescription(), importBankStatement.getAD_Org_ID(), importBankStatement.getC_Charge_ID(), false, documentNo, checkNo);
        importBankStatement.setC_Payment_ID(payment.getC_Payment_ID());
        importBankStatement.setC_Currency_ID(payment.getC_Currency_ID());
        importBankStatement.setTrxAmt(payment.getPayAmt(true));
        importBankStatement.saveEx();
        String retString = "@C_Payment_ID@ = " + payment.getDocumentNo();
        if (payment.getOverUnderAmt().signum() != 0) {
            retString = retString + " - @OverUnderAmt@=" + payment.getOverUnderAmt();
        }
        return retString;
    }

    private String createPayment(MBankStatementLine bankStatementLine) throws Exception {
        if (bankStatementLine == null || bankStatementLine.getC_Payment_ID() != 0) {
            return "--";
        }
        this.log.fine(bankStatementLine.toString());
        if (bankStatementLine.getC_Invoice_ID() == 0 && bankStatementLine.getC_BPartner_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_Invoice_ID@ / @C_BPartner_ID@");
        }
        MBankStatement bankStatement = new MBankStatement(this.getCtx(), bankStatementLine.getC_BankStatement_ID(), this.get_TrxName());
        String documentNo = bankStatementLine.getReferenceNo();
        if (Util.isEmpty(documentNo)) {
            documentNo = bankStatementLine.getEftReference();
        }
        String checkNo = bankStatementLine.getEftCheckNo();
        boolean isUnidentified = false;
        if (!Util.isEmpty(this.getParameterAsString("TrxType")) && this.getParameterAsString("TrxType").equals("U")) {
            isUnidentified = true;
        }
        MPayment payment = this.createPayment(bankStatementLine.getC_Invoice_ID(), bankStatementLine.getC_BPartner_ID(), bankStatementLine.getC_Currency_ID(), bankStatementLine.getStmtAmt(), bankStatementLine.getTrxAmt(), bankStatement.getC_BankAccount_ID(), bankStatementLine.getStatementLineDate(), bankStatementLine.getDateAcct(), bankStatementLine.getDescription(), bankStatementLine.getAD_Org_ID(), bankStatementLine.getC_Charge_ID(), isUnidentified, documentNo, checkNo);
        bankStatementLine.setPayment(payment);
        if (isUnidentified) {
            bankStatementLine.setC_Charge_ID(-1);
        }
        bankStatementLine.saveEx();
        String retString = "@C_Payment_ID@ = " + payment.getDocumentNo();
        if (payment.getOverUnderAmt().signum() != 0) {
            retString = retString + " - @OverUnderAmt@=" + payment.getOverUnderAmt();
        }
        return retString;
    }

    private MPayment createPayment(int invoiceId, int bPartnerId, int currencyId, BigDecimal statementAmount, BigDecimal transactionAmount, int bankAccountId, Timestamp transactionDate, Timestamp accountingDate, String description, int organizationId, int chargeId, boolean isUnidentified, String documentNo, String checkNo) {
        BigDecimal paymentAmount = transactionAmount;
        if (paymentAmount == null || Env.ZERO.compareTo(paymentAmount) == 0) {
            paymentAmount = statementAmount;
        }
        if (invoiceId == 0 && (paymentAmount == null || Env.ZERO.compareTo(paymentAmount) == 0)) {
            throw new IllegalStateException("@PayAmt@ = 0");
        }
        if (paymentAmount == null) {
            paymentAmount = Env.ZERO;
        }
        MOrgInfo organizationInfo = MOrgInfo.get(this.getCtx(), organizationId, this.get_TrxName());
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        payment.setAD_Org_ID(organizationId);
        payment.setC_BankAccount_ID(bankAccountId);
        payment.setTenderType("K");
        if (transactionDate != null) {
            payment.setDateTrx(transactionDate);
        } else if (accountingDate != null) {
            payment.setDateTrx(accountingDate);
        }
        if (accountingDate != null) {
            payment.setDateAcct(accountingDate);
        } else {
            payment.setDateAcct(payment.getDateTrx());
        }
        payment.setDescription(description);
        if (invoiceId != 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), invoiceId, null);
            payment.setC_DocType_ID(invoice.isSOTrx());
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.setC_BPartner_ID(invoice.getC_BPartner_ID());
            if (paymentAmount.signum() != 0) {
                payment.setC_Currency_ID(currencyId);
                if (invoice.isSOTrx()) {
                    payment.setPayAmt(paymentAmount);
                } else {
                    payment.setPayAmt(paymentAmount.negate());
                }
                payment.setOverUnderAmt(invoice.getGrandTotal(true).subtract(payment.getPayAmt()));
            } else {
                payment.setC_Currency_ID(invoice.getC_Currency_ID());
                payment.setPayAmt(invoice.getGrandTotal(true));
            }
        } else if (bPartnerId != 0) {
            payment.setC_BPartner_ID(bPartnerId);
            payment.setC_Currency_ID(currencyId);
            if (chargeId != 0 && !isUnidentified) {
                payment.setC_Charge_ID(chargeId);
            }
            boolean isReceipt = paymentAmount.signum() > 0;
            payment.setPayAmt(paymentAmount.abs());
            if (organizationInfo.getUnidentifiedDocumentType(isReceipt) != 0) {
                payment.setC_DocType_ID(organizationInfo.getUnidentifiedDocumentType(isReceipt));
            } else {
                payment.setC_DocType_ID(isReceipt);
            }
        } else {
            throw new AdempiereException("@C_Invoice_ID@ / @C_BPartner_ID@ @NotFound@");
        }
        if (!Util.isEmpty(documentNo)) {
            payment.setDocumentNo(documentNo);
        }
        if (!Util.isEmpty(checkNo)) {
            payment.setCheckNo(checkNo);
        }
        payment.setIsUnidentifiedPayment(isUnidentified);
        if (isUnidentified) {
            payment.addDescription(Msg.parseTranslation(this.getCtx(), "@UnidentifiedPayment@"));
        }
        payment.saveEx();
        payment.processIt("CO");
        payment.saveEx();
        return payment;
    }
}

