/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.impexp.BankStatementMatchInfo;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MBankStatementMatcher;
import org.compiere.model.X_I_BankStatement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class BankStatementMatcher
extends SvrProcess {
    MBankStatementMatcher[] m_matchers = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_matchers = MBankStatementMatcher.getMatchers(this.getCtx(), this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        int tableId = this.getTable_ID();
        int recordId = this.getRecord_ID();
        if (this.m_matchers == null || this.m_matchers.length == 0) {
            throw new IllegalStateException("No Matchers found");
        }
        this.log.info("doIt - Table_ID=" + tableId + ", Record_ID=" + recordId + ", Matchers=" + this.m_matchers.length);
        if (tableId == X_I_BankStatement.Table_ID) {
            return this.matchImportBankStatement(new X_I_BankStatement(this.getCtx(), recordId, this.get_TrxName()));
        }
        if (tableId == MBankStatement.Table_ID) {
            return this.matchBankStatement(new MBankStatement(this.getCtx(), recordId, this.get_TrxName()));
        }
        if (tableId == MBankStatementLine.Table_ID) {
            return this.matchBankStatementLine(new MBankStatementLine(this.getCtx(), recordId, this.get_TrxName()));
        }
        return "??";
    }

    private String matchImportBankStatement(X_I_BankStatement ibs) {
        if (this.m_matchers == null || ibs == null || ibs.getC_Payment_ID() != 0) {
            return "--";
        }
        this.log.fine("" + ibs);
        BankStatementMatchInfo info = null;
        for (int i = 0; i < this.m_matchers.length; ++i) {
            if (!this.m_matchers[i].isMatcherValid() || (info = this.m_matchers[i].getMatcher().findMatch(ibs, null, null)) == null || !info.isMatched()) continue;
            if (info.getC_Payment_ID() > 0) {
                ibs.setC_Payment_ID(info.getC_Payment_ID());
            }
            if (info.getC_Invoice_ID() > 0) {
                ibs.setC_Invoice_ID(info.getC_Invoice_ID());
            }
            if (info.getC_BPartner_ID() > 0) {
                ibs.setC_BPartner_ID(info.getC_BPartner_ID());
            }
            ibs.saveEx();
            return "OK";
        }
        return "--";
    }

    private String matchBankStatementLine(MBankStatementLine bsl) {
        if (this.m_matchers == null || bsl == null || bsl.getC_Payment_ID() != 0) {
            return "--";
        }
        this.log.fine("match - " + bsl);
        BankStatementMatchInfo info = null;
        for (int i = 0; i < this.m_matchers.length; ++i) {
            if (!this.m_matchers[i].isMatcherValid() || (info = this.m_matchers[i].getMatcher().findMatch(bsl, null, null)) == null || !info.isMatched()) continue;
            if (info.getC_Payment_ID() > 0) {
                bsl.setC_Payment_ID(info.getC_Payment_ID());
            }
            if (info.getC_Invoice_ID() > 0) {
                bsl.setC_Invoice_ID(info.getC_Invoice_ID());
            }
            if (info.getC_BPartner_ID() > 0) {
                bsl.setC_BPartner_ID(info.getC_BPartner_ID());
            }
            bsl.saveEx();
            return "OK";
        }
        return "--";
    }

    private String matchBankStatement(MBankStatement bs) {
        if (this.m_matchers == null || bs == null) {
            return "--";
        }
        this.log.fine("match - " + bs);
        int count = 0;
        MBankStatementLine[] lines = bs.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].getC_Payment_ID() != 0) continue;
            this.matchBankStatementLine(lines[i]);
            ++count;
        }
        return String.valueOf(count);
    }
}

