/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOMLine;

public class BOMVerify
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private boolean p_IsReValidate = false;
    private MProduct m_product = null;
    private ArrayList<MProduct> foundproducts = new ArrayList();
    private ArrayList<MProduct> validproducts = new ArrayList();
    private ArrayList<MProduct> invalidproducts = new ArrayList();
    private ArrayList<MProduct> containinvalidproducts = new ArrayList();
    private ArrayList<MProduct> checkedproducts = new ArrayList();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("IsReValidate")) {
                this.p_IsReValidate = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_M_Product_ID == 0) {
            this.p_M_Product_ID = this.getRecord_ID();
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_M_Product_ID != 0) {
            this.log.info("M_Product_ID=" + this.p_M_Product_ID);
            this.checkProduct(new MProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName()));
            return "Product Checked";
        }
        this.log.info("M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", IsReValidate=" + this.p_IsReValidate);
        int counter = 0;
        CPreparedStatement pstmt = null;
        String sql = "SELECT M_Product_ID FROM M_Product WHERE IsBOM='Y' AND ";
        sql = this.p_M_Product_Category_ID == 0 ? sql + "AD_Client_ID=? " : sql + "M_Product_Category_ID=? ";
        if (!this.p_IsReValidate) {
            sql = sql + "AND IsVerified<>'Y' ";
        }
        sql = sql + "ORDER BY Name";
        int AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
        try {
            pstmt = DB.prepareStatement(sql, null);
            if (this.p_M_Product_Category_ID == 0) {
                pstmt.setInt(1, AD_Client_ID);
            } else {
                pstmt.setInt(1, this.p_M_Product_Category_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.p_M_Product_ID = rs.getInt(1);
                this.checkProduct(new MProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName()));
                ++counter;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "#" + counter;
    }

    private void checkProduct(MProduct product) {
        if (product.isBOM() && !this.checkedproducts.contains(product)) {
            this.validateProduct(product);
        }
    }

    private boolean validateProduct(MProduct product) {
        if (!product.isBOM()) {
            return false;
        }
        this.log.config(product.getName());
        this.foundproducts.add(product);
        MPPProductBOMLine[] productsBOMs = MPPProductBOMLine.getBOMLines(product);
        boolean containsinvalid = false;
        boolean invalid = false;
        for (int i2 = 0; i2 < productsBOMs.length; ++i2) {
            MPPProductBOMLine productsBOM = productsBOMs[i2];
            MProduct pp = new MProduct(this.getCtx(), productsBOM.getM_Product_ID(), this.get_TrxName());
            if (!pp.isBOM()) {
                this.log.finer(pp.getName());
                continue;
            }
            if (this.validproducts.contains(pp)) {
                // empty if block
            }
            if (this.invalidproducts.contains(pp)) {
                containsinvalid = true;
                continue;
            }
            if (this.foundproducts.contains(pp)) {
                invalid = true;
                this.addLog(0, null, null, product.getValue() + " recursively contains " + pp.getValue());
                continue;
            }
            if (this.validateProduct(pp)) continue;
            containsinvalid = true;
        }
        this.checkedproducts.add(product);
        this.foundproducts.remove(product);
        if (invalid) {
            this.invalidproducts.add(product);
            product.setIsVerified(false);
            product.save();
            return false;
        }
        if (containsinvalid) {
            this.containinvalidproducts.add(product);
            product.setIsVerified(false);
            product.save();
            return false;
        }
        this.validproducts.add(product);
        product.setIsVerified(true);
        product.save();
        return true;
    }
}

