/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MProductDownload;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.Query;
import org.compiere.process.AssetDeliveryAbstract;
import org.compiere.util.EMail;
import org.compiere.util.Util;

public class AssetDelivery
extends AssetDeliveryAbstract {
    private MClient client = null;
    private MMailText mailTemplate = null;
    private AtomicInteger count;
    private AtomicInteger errors;
    private AtomicInteger reminders;
    private AtomicInteger delivered;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getGuaranteeDate() == null) {
            this.setGuaranteeDate(new Timestamp(System.currentTimeMillis()));
        }
        this.client = MClient.get(this.getCtx());
        this.count = new AtomicInteger();
        this.errors = new AtomicInteger();
        this.reminders = new AtomicInteger();
        this.delivered = new AtomicInteger();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("");
        long l = System.currentTimeMillis();
        if (!this.isSelection()) {
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.getAssetId() != 0) {
                stringBuffer.append("A_Asset_ID = ?");
                arrayList.add(this.getAssetId());
            }
            if (this.getAssetGroupId() != 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append("A_Asset_Group_ID = ?");
                arrayList.add(this.getAssetGroupId());
            }
            if (this.getProductId() != 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append("M_Product_ID = ?");
                arrayList.add(this.getProductId());
            }
            if (arrayList.size() == 0) {
                throw new AdempiereException("@RestrictSelection@");
            }
            if (this.getMailTextId() == 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append("GuaranteeDate >= ?");
                arrayList.add(this.getGuaranteeDate());
            }
            new Query(this.getCtx(), "A_Asset", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("Value").list().forEach(mAsset -> this.deliverAsset((MAsset)mAsset));
        } else {
            this.getInstancesForSelection(this.get_TrxName()).forEach(mAsset -> this.deliverAsset((MAsset)mAsset));
        }
        this.log.info("Count=" + this.count + ", Errors=" + this.errors + ", Reminder=" + this.reminders + " - " + (System.currentTimeMillis() - l) + "ms");
        return "@IsDelivered@=" + this.delivered + " - @Sent@=" + this.count + " - @Errors@=" + this.errors;
    }

    private void deliverAsset(MAsset mAsset) {
        if (this.getBPartnerId() != 0) {
            int n = -1;
            int n2 = -1;
            boolean bl = this.getParameterAsBoolean("IsReturnedToOrganization");
            if (!bl) {
                n = this.getBPartnerId();
                n2 = this.getUserId();
            }
            mAsset.setIsInPosession(bl);
            mAsset.setC_BPartner_ID(n);
            mAsset.setAD_User_ID(n2);
            mAsset.saveEx();
            MAssetDelivery mAssetDelivery = new MAssetDelivery(mAsset, this.getBPartnerId(), 0, this.getParameterAsTimestamp("MovementDate"));
            String string = this.getParameterAsString("Description");
            if (!Util.isEmpty(string)) {
                mAssetDelivery.setDescription(string);
            }
            mAssetDelivery.saveEx();
            this.delivered.getAndIncrement();
        }
        if (this.isSendEMail()) {
            this.notifyAsset(mAsset);
        }
    }

    private void notifyAsset(MAsset mAsset) {
        if (mAsset.getGuaranteeDate() != null && mAsset.getGuaranteeDate().before(this.getGuaranteeDate())) {
            if (this.getMailTextId() != 0) {
                this.sendNoGuaranteeMail(mAsset);
                this.reminders.getAndIncrement();
            }
        } else {
            String string = this.sendDeliveryeMail(mAsset);
            this.addLog(mAsset.getA_Asset_ID(), null, null, string);
            if (string.startsWith("** ")) {
                this.errors.getAndIncrement();
            } else {
                this.count.getAndIncrement();
            }
        }
    }

    private String sendNoGuaranteeMail(MAsset mAsset) {
        if (mAsset.getAD_User_ID() == 0) {
            return "** No Asset User";
        }
        MUser mUser = new MUser(this.getCtx(), mAsset.getAD_User_ID(), this.get_TrxName());
        if (mUser.getEMail() == null || mUser.getEMail().length() == 0) {
            return "** No Asset User Email";
        }
        if (this.mailTemplate == null || this.mailTemplate.getR_MailText_ID() != this.getMailTextId()) {
            this.mailTemplate = new MMailText(this.getCtx(), this.getMailTextId(), this.get_TrxName());
        }
        if (Util.isEmpty(this.mailTemplate.getMailHeader())) {
            return "** No Subject";
        }
        EMail eMail = this.client.createEMail(mUser.getEMail(), null, null);
        this.mailTemplate.setPO(mUser);
        this.mailTemplate.setPO(mAsset);
        String string = this.mailTemplate.getMailText(true);
        if (this.mailTemplate.isHtml()) {
            eMail.setMessageHTML(this.mailTemplate.getMailHeader(), string);
        } else {
            eMail.setSubject(this.mailTemplate.getMailHeader());
            eMail.setMessageText(string);
        }
        String string2 = eMail.send();
        new MUserMail(this.mailTemplate, mAsset.getAD_User_ID(), eMail).saveEx();
        if (!"OK".equals(string2)) {
            return "** Not delivered: " + mUser.getEMail() + " - " + string2;
        }
        return mUser.getEMail();
    }

    private String sendDeliveryeMail(MAsset mAsset) {
        Object object;
        this.log.fine("A_Asset_ID=" + mAsset.getA_Asset_ID());
        long l = System.currentTimeMillis();
        if (mAsset.getAD_User_ID() == 0) {
            return "** No Asset User";
        }
        MUser mUser = new MUser(this.getCtx(), mAsset.getAD_User_ID(), this.get_TrxName());
        if (mUser.getEMail() == null || mUser.getEMail().length() == 0) {
            return "** No Asset User Email";
        }
        if (mAsset.getProductR_MailText_ID() == 0) {
            return "** Product Mail Text";
        }
        if (this.mailTemplate == null || this.mailTemplate.getR_MailText_ID() != mAsset.getProductR_MailText_ID()) {
            this.mailTemplate = new MMailText(this.getCtx(), mAsset.getProductR_MailText_ID(), this.get_TrxName());
        }
        if (this.mailTemplate.getMailHeader() == null || this.mailTemplate.getMailHeader().length() == 0) {
            return "** No Subject";
        }
        EMail eMail = this.client.createEMail(mUser.getEMail(), null, null);
        if (!eMail.isValid()) {
            mAsset.setHelp(mAsset.getHelp() + " - Invalid EMail");
            mAsset.setIsActive(false);
            return "** Invalid EMail: " + mUser.getEMail();
        }
        if (this.client.isSmtpAuthorization()) {
            eMail.createAuthenticator(this.client.getRequestUser(), this.client.getRequestUserPW());
        }
        this.mailTemplate.setUser(mUser);
        this.mailTemplate.setPO(mAsset);
        String string = this.mailTemplate.getMailText(true);
        if (this.mailTemplate.isHtml() || this.isAttachAsset()) {
            eMail.setMessageHTML(this.mailTemplate.getMailHeader(), string);
        } else {
            eMail.setSubject(this.mailTemplate.getMailHeader());
            eMail.setMessageText(string);
        }
        if (this.isAttachAsset()) {
            object = mAsset.getProductDownloads();
            if (object != null) {
                for (int i = 0; i < ((MProductDownload[])object).length; ++i) {
                    URI uRI = object[i].getDownloadURL(this.client.getDocumentDir());
                    if (uRI == null) continue;
                    eMail.addAttachment(uRI);
                }
            } else {
                this.log.warning("No DowloadURL for Asset=" + mAsset);
            }
        }
        object = eMail.send();
        new MUserMail(this.mailTemplate, mAsset.getAD_User_ID(), eMail).saveEx();
        if (!"OK".equals(object)) {
            return "** Not delivered: " + mUser.getEMail() + " - " + (String)object;
        }
        this.log.fine(System.currentTimeMillis() - l + " ms");
        return mUser.getEMail() + " - " + mAsset.getProductVersionNo();
    }
}

