/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.compiere.print.PrintDataElement;
import org.compiere.print.layout.ConversionUtil;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class ConversionElement
extends PrintDataElement {
    private static final long serialVersionUID = 1L;
    private BigDecimal convertedValue = null;

    public ConversionElement(Properties context, String columnName, BigDecimal amount, int conversionTypeId, int fromCurrencyId, int toCurrencyId, Timestamp conversionDate, int clientId, int organizationId, String pattern) {
        super(columnName, Env.ONEHUNDRED, 37, pattern);
        this.convertedValue = ConversionUtil.get().getConvertedAmount(context, conversionTypeId, fromCurrencyId, toCurrencyId, conversionDate, clientId, organizationId, amount);
    }

    @Override
    public Object getValue() {
        return this.convertedValue;
    }

    @Override
    public String getColumnName() {
        return super.getColumnName();
    }

    @Override
    public BigDecimal getFunctionValue() {
        if (this.convertedValue == null) {
            return Env.ZERO;
        }
        return this.convertedValue;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public String getValueAsString() {
        return Optional.ofNullable(this.convertedValue).orElse(Env.ZERO).toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getColumnName()).append("=").append(this.convertedValue);
        return sb.toString();
    }

    @Override
    public String getValueDisplay(Language language) {
        if (this.getValue() == null) {
            return "";
        }
        return DisplayType.getNumberFormat(this.getDisplayType(), language, this.getM_formatPattern()).format(this.getValue());
    }
}

