/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.adempiere.pdf.ITextDocument;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AMenu;
import org.compiere.apps.AWindow;
import org.compiere.apps.AWindowListener;
import org.compiere.apps.AppsAction;
import org.compiere.apps.EMailDialog;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessModalDialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.WindowMenu;
import org.compiere.apps.search.Find;
import org.compiere.model.GridField;
import org.compiere.model.MArchive;
import org.compiere.model.MClient;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_C_Invoice;
import org.compiere.print.AReport;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.View;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CFrame;
import org.compiere.swing.CLabel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ExtensionFileFilter;
import org.compiere.util.ImpExpUtil;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.spin.util.AbstractExportFormat;
import org.spin.util.ReportExportHandler;

public class Viewer
extends CFrame
implements ActionListener,
ChangeListener,
WindowStateListener {
    private static final long serialVersionUID = 7306392362119021781L;
    private static final String PDF = "P";
    private static final String XLS = "X";
    private static final String HTML = "H";
    private int m_WindowNo;
    private Properties m_ctx;
    private int m_pageNo = 1;
    private int m_pageMax = 1;
    private View m_viewPanel;
    private boolean m_setting = false;
    private ReportEngine m_reportEngine;
    private boolean m_drillDown = true;
    private int m_AD_Table_ID = 0;
    private boolean m_isCanExport;
    private boolean m_IsCanLoad = false;
    private boolean m_isAllowHTMLView = false;
    private boolean m_isAllowXLSView = false;
    private ReportExportHandler exportHandler = null;
    private MQuery m_ddQ = null;
    private MQuery m_daQ = null;
    private CMenuItem m_ddM = null;
    private CMenuItem m_daM = null;
    private static CLogger log = CLogger.getCLogger(Viewer.class);
    private CPanel northPanel = new CPanel();
    private JScrollPane centerScrollPane = new JScrollPane();
    private StatusBar statusBar = new StatusBar(false);
    private JMenuBar menuBar = new JMenuBar();
    private JToolBar toolBar = new JToolBar();
    private CButton bPrint = new CButton();
    private CButton bSendMail = new CButton();
    private CButton bPageSetup = new CButton();
    private CButton bArchive = new CButton();
    private BorderLayout northLayout = new BorderLayout();
    private CButton bCustomize = new CButton();
    private CButton bEnd = new CButton();
    private CButton bFind = new CButton();
    private CButton bExport = new CButton();
    private CComboBox comboReport = new CComboBox();
    private CButton bPrevious = new CButton();
    private CButton bNext = new CButton();
    private CButton bLoad = new CButton();
    private SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1, 1, 100, 1);
    private JSpinner spinner = new JSpinner(this.spinnerModel);
    private CLabel labelDrill = new CLabel();
    private CComboBox comboDrill = new CComboBox();
    private CCheckBox summary = new CCheckBox();
    private CComboBox comboZoom = new CComboBox(View.ZOOM_OPTIONS);
    private CComboBox comboReportView = new CComboBox();

    public Viewer(ReportEngine re) {
        this(null, re);
    }

    public Viewer(GraphicsConfiguration gc, ReportEngine re) {
        super(gc);
        log.info("");
        this.m_WindowNo = Env.createWindowNo(this);
        Env.setContext(re.getCtx(), this.m_WindowNo, "_WinInfo_IsReportViewer", "Y");
        this.m_reportEngine = re;
        this.m_AD_Table_ID = re.getPrintFormat().getAD_Table_ID();
        if (!MRole.getDefault().isCanReport(this.m_AD_Table_ID)) {
            ADialog.error(this.m_WindowNo, this, "AccessCannotReport", this.m_reportEngine.getName());
            this.dispose();
        }
        this.m_isCanExport = MRole.getDefault().isCanExport(this.m_AD_Table_ID);
        this.m_IsCanLoad = MRole.getDefault().isCanLoad(this.m_AD_Table_ID);
        this.m_isAllowHTMLView = MRole.getDefault().isAllow_HTML_View();
        this.m_isAllowXLSView = MRole.getDefault().isAllow_XLS_View();
        try {
            this.m_viewPanel = re.getView();
            this.m_ctx = this.m_reportEngine.getCtx();
            String type = this.m_reportEngine.getReportType();
            if (type == null) {
                String string = type = this.m_reportEngine.getPrintFormat().isForm() ? MSysConfig.getValue("ZK_REPORT_FORM_OUTPUT_TYPE") : MSysConfig.getValue("ZK_REPORT_TABLE_OUTPUT_TYPE");
                if (type != null && XLS.equals(type)) {
                    type = XLS;
                }
                if (type != null && PDF.equals(type)) {
                    type = PDF;
                }
            }
            if (HTML.equals(type) && !this.m_isAllowHTMLView) {
                type = PDF;
            }
            if (XLS.equals(type) && !this.m_isAllowXLSView || "XX".equals(type) && !this.m_isAllowXLSView) {
                type = PDF;
            }
            if (XLS.equals(type) || HTML.equals(type)) {
                try {
                    String extension = "pdf";
                    if (XLS.equals(type)) {
                        extension = "xls";
                    }
                    if (HTML.equals(type)) {
                        extension = "html";
                    }
                    File outFile = new File("./" + this.m_reportEngine.getPrintFormat().getName() + "_" + System.currentTimeMillis() + "." + extension);
                    outFile.createNewFile();
                    if (XLS.equals(type)) {
                        this.m_reportEngine.createXLS(outFile);
                    }
                    if (HTML.equals(type)) {
                        this.m_reportEngine.createHTML(outFile, false);
                    }
                    this.dispose();
                    return;
                }
                catch (Exception e) {
                    ADialog.error(this.m_WindowNo, this, "Error", e.getLocalizedMessage());
                    if (CLogMgt.isLevelFinest()) {
                        e.printStackTrace();
                    }
                    this.dispose();
                    return;
                }
            }
            this.exportHandler = new ReportExportHandler(this.m_ctx, this.m_reportEngine);
            this.jbInit();
            this.dynInit();
            if (!this.m_viewPanel.isArchivable()) {
                log.warning("Cannot archive Document");
            }
            AEnv.showCenterScreen(this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            ADialog.error(this.m_WindowNo, this, "LoadError", e.getLocalizedMessage());
            this.dispose();
        }
    }

    private void jbInit() throws Exception {
        this.setIconImage(Env.getImage("mReport.gif"));
        this.setDefaultCloseOperation(2);
        this.northPanel.setLayout(this.northLayout);
        this.getContentPane().add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.toolBar, "West");
        this.getContentPane().add((Component)this.centerScrollPane, "Center");
        this.centerScrollPane.getViewport().add((Component)this.m_viewPanel, null);
        this.centerScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.centerScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.getContentPane().add((Component)this.statusBar, "South");
        this.setJMenuBar(this.menuBar);
        this.toolBar.add(this.bPrevious);
        this.toolBar.add(this.spinner);
        this.spinner.setToolTipText(Msg.getMsg(this.m_ctx, "GoToPage"));
        this.toolBar.add(this.bNext);
        this.m_viewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(33, 0), "PAGE_UP");
        this.m_viewPanel.getActionMap().put("PAGE_UP", new AbstractAction(){
            private static final long serialVersionUID = -6439939910196779649L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.setPage(Viewer.this.m_pageNo - 1);
            }
        });
        this.m_viewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), "PAGE_DOWN");
        this.m_viewPanel.getActionMap().put("PAGE_DOWN", new AbstractAction(){
            private static final long serialVersionUID = -4468272400181368278L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.setPage(Viewer.this.m_pageNo + 1);
            }
        });
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.comboZoom, null);
        this.comboZoom.setToolTipText(Msg.getMsg(this.m_ctx, "Zoom"));
        this.toolBar.addSeparator();
        this.labelDrill.setText(Msg.getMsg(this.m_ctx, "Drill") + ": ");
        this.toolBar.add(this.labelDrill);
        this.toolBar.add(this.comboDrill);
        this.comboDrill.setToolTipText(Msg.getMsg(this.m_ctx, "Drill"));
        this.toolBar.addSeparator();
        this.toolBar.add(this.comboReport);
        this.comboReport.setToolTipText(Msg.translate(this.m_ctx, "AD_PrintFormat_ID"));
        this.toolBar.add(this.comboReportView);
        this.comboReportView.setToolTipText(Msg.translate(this.m_ctx, "AD_ReportView_ID"));
        this.toolBar.add(this.summary);
        this.summary.setText(Msg.getMsg(this.m_ctx, "Summary"));
        this.toolBar.add(this.bCustomize);
        this.bCustomize.setToolTipText(Msg.getMsg(this.m_ctx, "PrintCustomize"));
        this.toolBar.add(this.bFind);
        this.bFind.setToolTipText(Msg.getMsg(this.m_ctx, "Find"));
        this.toolBar.addSeparator();
        this.toolBar.add(this.bPrint);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bPageSetup);
        this.bPageSetup.setToolTipText(Msg.getMsg(this.m_ctx, "PageSetup"));
        this.toolBar.add(this.bSendMail);
        this.toolBar.add(this.bArchive);
        if (this.m_isCanExport) {
            this.bExport.setToolTipText(Msg.getMsg(this.m_ctx, "Export"));
            this.toolBar.add(this.bExport);
        }
        if (this.m_IsCanLoad) {
            this.bLoad.setToolTipText("Load New Report Definition");
            this.toolBar.add(this.bLoad);
        }
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.bEnd, null);
        this.bEnd.setToolTipText(Msg.getMsg(this.m_ctx, "End"));
    }

    private void dynInit() {
        boolean trl;
        this.createMenu();
        this.comboZoom.setSelectedIndex(this.m_viewPanel.getZoomLevel());
        this.comboZoom.addActionListener(this);
        this.summary.setSelected(this.m_reportEngine.getPrintFormat().isSummary());
        this.summary.addActionListener(this);
        this.m_pageMax = this.m_viewPanel.getPageCount();
        this.spinnerModel.setMaximum(new Integer(this.m_pageMax));
        this.spinner.addChangeListener(this);
        this.fillComboReport(this.m_reportEngine.getPrintFormat().get_ID());
        this.m_viewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Viewer.this.mouse_clicked(e, true);
                } else if (e.getClickCount() > 1) {
                    Viewer.this.mouse_clicked(e, false);
                }
            }
        });
        this.comboDrill.addItem(new ValueNamePair(null, ""));
        String sql = "SELECT t.AD_Table_ID, t.TableName, e.PrintName, NULLIF(e.PO_PrintName,e.PrintName) FROM AD_Column c  INNER JOIN AD_Column used ON (c.ColumnName=used.ColumnName) INNER JOIN AD_Table t ON (used.AD_Table_ID=t.AD_Table_ID AND t.IsView='N' AND t.AD_Table_ID <> c.AD_Table_ID) INNER JOIN AD_Column cKey ON (t.AD_Table_ID=cKey.AD_Table_ID AND cKey.IsKey='Y') INNER JOIN AD_Element e ON (cKey.ColumnName=e.ColumnName) WHERE c.AD_Table_ID=? AND c.IsKey='Y' ORDER BY 3";
        boolean bl = trl = !Env.isBaseLanguage(Env.getCtx(), "AD_Element");
        if (trl) {
            sql = "SELECT t.AD_Table_ID, t.TableName, et.PrintName, NULLIF(et.PO_PrintName,et.PrintName) FROM AD_Column c INNER JOIN AD_Column used ON (c.ColumnName=used.ColumnName) INNER JOIN AD_Table t ON (used.AD_Table_ID=t.AD_Table_ID AND t.IsView='N' AND t.AD_Table_ID <> c.AD_Table_ID) INNER JOIN AD_Column cKey ON (t.AD_Table_ID=cKey.AD_Table_ID AND cKey.IsKey='Y') INNER JOIN AD_Element e ON (cKey.ColumnName=e.ColumnName) INNER JOIN AD_Element_Trl et ON (e.AD_Element_ID=et.AD_Element_ID) WHERE c.AD_Table_ID=? AND c.IsKey='Y' AND et.AD_Language=? ORDER BY 3";
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_reportEngine.getPrintFormat().getAD_Table_ID());
            if (trl) {
                pstmt.setString(2, Env.getAD_Language(Env.getCtx()));
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(2);
                String name = rs.getString(3);
                String poName = rs.getString(4);
                if (poName != null) {
                    name = name + "/" + poName;
                }
                this.comboDrill.addItem(new ValueNamePair(tableName, name));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.comboDrill.getItemCount() == 1) {
            this.labelDrill.setVisible(false);
            this.comboDrill.setVisible(false);
        } else {
            this.comboDrill.addActionListener(this);
        }
        this.revalidate();
    }

    private void fillComboReport(int AD_PrintFormat_ID) {
        this.comboReport.removeActionListener(this);
        this.comboReport.removeAllItems();
        KeyNamePair selectValue = null;
        String sql = MRole.getDefault().addAccessSQL("SELECT AD_PrintFormat_ID, Name, Description FROM AD_PrintFormat WHERE AD_Table_ID=? AND IsActive='Y' AND AD_Client_ID=? ORDER BY Name", "AD_PrintFormat", false, false);
        int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            pstmt.setInt(2, Env.getAD_Client_ID(this.m_ctx));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                this.comboReport.addItem(pp);
                if (rs.getInt(1) != AD_PrintFormat_ID) continue;
                selectValue = pp;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        StringBuffer sb = new StringBuffer("** ").append(Msg.getMsg(this.m_ctx, "NewReport")).append(" **");
        KeyNamePair pp = new KeyNamePair(-1, sb.toString());
        this.comboReport.addItem(pp);
        sb = new StringBuffer("** ").append(Msg.getMsg(this.m_ctx, "CopyReport")).append(" **");
        pp = new KeyNamePair(-2, sb.toString());
        this.comboReport.addItem(pp);
        if (selectValue != null) {
            this.comboReport.setSelectedItem(selectValue);
        }
        this.comboReport.addActionListener(this);
        this.fillComboReportView();
    }

    private void fillComboReportView() {
        KeyNamePair[] pairs;
        this.comboReportView.removeActionListener(this);
        this.comboReportView.removeAllItems();
        KeyNamePair selectValue = null;
        String sql = "";
        sql = Env.isBaseLanguage(Env.getCtx(), "AD_ReportView") ? MRole.getDefault().addAccessSQL("SELECT AD_ReportView_ID, COALESCE(PrintName, Name) AS Name FROM AD_ReportView WHERE AD_Table_ID = ? AND IsActive='Y' ORDER BY Name", "AD_ReportView", false, false) : MRole.getDefault().addAccessSQL("SELECT rv.AD_ReportView_ID, COALESCE(rvt.PrintName, rv.PrintName, rvt.Name, rv.Name) AS Name FROM AD_ReportView rv LEFT JOIN AD_ReportView_Trl rvt ON(rvt.AD_ReportView_ID = rv.AD_ReportView_ID \t\t\t\t\t\t\t\t\t\tAND rvt.AD_Language = '" + Env.getAD_Language(Env.getCtx()) + "') WHERE rv.AD_Table_ID = ? AND rv.IsActive='Y' ORDER BY rvt.Name", "rv", true, false);
        int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
        int AD_ReportView_ID = this.m_reportEngine.getPrintFormat().getAD_ReportView_ID();
        for (KeyNamePair view : pairs = DB.getKeyNamePairs(sql, true, AD_Table_ID)) {
            this.comboReportView.addItem(view);
            if (view.getKey() != AD_ReportView_ID) continue;
            selectValue = view;
        }
        if (selectValue != null) {
            this.comboReportView.setSelectedItem(selectValue);
        }
        this.comboReportView.addActionListener(this);
    }

    private void selectReportView(int p_AD_ReportView_ID) {
        this.comboReportView.removeActionListener(this);
        KeyNamePair selectValue = null;
        for (int i2 = 0; i2 < this.comboReportView.getItemCount(); ++i2) {
            KeyNamePair pp = (KeyNamePair)this.comboReportView.getItemAt(i2);
            if (pp.getKey() != p_AD_ReportView_ID) continue;
            selectValue = pp;
            break;
        }
        if (selectValue != null) {
            this.comboReportView.setSelectedItem(selectValue);
        } else {
            this.comboReportView.setSelectedIndex(0);
        }
        this.comboReportView.addActionListener(this);
    }

    @Override
    public void revalidate() {
        this.m_pageMax = this.m_viewPanel.getPageCount();
        this.spinnerModel.setMaximum(new Integer(this.m_pageMax));
        this.centerScrollPane.setPreferredSize(new Dimension(this.m_viewPanel.getPaperWidth() + 30, this.m_viewPanel.getPaperHeight() + 15));
        this.centerScrollPane.getViewport().setViewSize(new Dimension(this.m_viewPanel.getPaperWidth() + 2 * this.m_viewPanel.getMarginSize(true), this.m_viewPanel.getPaperHeight() + 2 * this.m_viewPanel.getMarginSize(true)));
        this.setTitle(Msg.getMsg(this.m_ctx, "Report") + ": " + this.m_reportEngine.getName() + "  " + Env.getHeader(this.m_ctx, 0));
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_viewPanel.getPaper().toString(this.m_ctx)).append(" - ").append(Msg.getMsg(this.m_ctx, "DataCols")).append("=").append(this.m_reportEngine.getColumnCount()).append(", ").append(Msg.getMsg(this.m_ctx, "DataRows")).append("=").append(this.m_reportEngine.getRowCount());
        this.statusBar.setStatusLine(sb.toString());
        this.setPage(this.m_pageNo);
    }

    private void createMenu() {
        JMenu mFile = AEnv.getMenu("File");
        this.menuBar.add(mFile);
        AEnv.addMenuItem("PrintScreen", null, KeyStroke.getKeyStroke(154, 0), mFile, this);
        AEnv.addMenuItem("ScreenShot", null, KeyStroke.getKeyStroke(154, 1), mFile, this);
        AEnv.addMenuItem("Report", null, KeyStroke.getKeyStroke(80, 8), mFile, this);
        mFile.addSeparator();
        AEnv.addMenuItem("PrintCustomize", "Preference", null, mFile, this);
        AEnv.addMenuItem("Translate", null, null, mFile, this);
        AEnv.addMenuItem("Find", null, KeyStroke.getKeyStroke(70, 2), mFile, this);
        mFile.addSeparator();
        AEnv.addMenuItem("PageSetup", null, null, mFile, this);
        AEnv.addMenuItem("Print", null, KeyStroke.getKeyStroke(80, 2), mFile, this);
        if (this.m_isCanExport) {
            AEnv.addMenuItem("Export", null, null, mFile, this);
        }
        if (this.m_IsCanLoad) {
            AEnv.addMenuItem("Load", "Import", null, mFile, this);
        }
        mFile.addSeparator();
        AEnv.addMenuItem("End", null, KeyStroke.getKeyStroke(88, 8), mFile, this);
        AEnv.addMenuItem("Logout", null, KeyStroke.getKeyStroke(76, 9), mFile, this);
        AEnv.addMenuItem("Exit", null, KeyStroke.getKeyStroke(88, 9), mFile, this);
        JMenu mView = AEnv.getMenu("View");
        this.menuBar.add(mView);
        if (MRole.getDefault().isAllow_Info_Product()) {
            AEnv.addMenuItem("InfoProduct", null, KeyStroke.getKeyStroke(73, 8), mView, this);
        }
        if (MRole.getDefault().isAllow_Info_BPartner()) {
            AEnv.addMenuItem("InfoBPartner", null, KeyStroke.getKeyStroke(73, 10), mView, this);
        }
        if (MRole.getDefault().isShowAcct() && MRole.getDefault().isAllow_Info_Account()) {
            AEnv.addMenuItem("InfoAccount", null, KeyStroke.getKeyStroke(73, 10), mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Schedule()) {
            AEnv.addMenuItem("InfoSchedule", null, null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_MRP()) {
            AEnv.addMenuItem("InfoMRP", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_CRP()) {
            AEnv.addMenuItem("InfoCRP", "Info", null, mView, this);
        }
        mView.addSeparator();
        if (MRole.getDefault().isAllow_Info_Order()) {
            AEnv.addMenuItem("InfoOrder", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Invoice()) {
            AEnv.addMenuItem("InfoInvoice", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_InOut()) {
            AEnv.addMenuItem("InfoInOut", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Payment()) {
            AEnv.addMenuItem("InfoPayment", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_CashJournal()) {
            AEnv.addMenuItem("InfoCashLine", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Resource()) {
            AEnv.addMenuItem("InfoAssignment", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Asset()) {
            AEnv.addMenuItem("InfoAsset", "Info", null, mView, this);
        }
        JMenu mGo = AEnv.getMenu("Go");
        this.menuBar.add(mGo);
        AEnv.addMenuItem("First", "First", KeyStroke.getKeyStroke(33, 8), mGo, this);
        AEnv.addMenuItem("PreviousPage", "Previous", KeyStroke.getKeyStroke(38, 8), mGo, this);
        AEnv.addMenuItem("NextPage", "Next", KeyStroke.getKeyStroke(40, 8), mGo, this);
        AEnv.addMenuItem("Last", "Last", KeyStroke.getKeyStroke(34, 8), mGo, this);
        JMenu mTools = AEnv.getMenu("Tools");
        this.menuBar.add(mTools);
        AEnv.addMenuItem("Calculator", null, null, mTools, this);
        AEnv.addMenuItem("Calendar", null, null, mTools, this);
        MUser user = MUser.get(Env.getCtx());
        if (user.isAdministrator()) {
            AEnv.addMenuItem("Editor", null, null, mTools, this);
        }
        AEnv.addMenuItem("Script", null, null, mTools, this);
        mTools.addSeparator();
        AEnv.addMenuItem("Preference", null, null, mTools, this);
        AMenu aMenu = (AMenu)Env.getWindow(0);
        WindowMenu mWindow = new WindowMenu(aMenu.getWindowManager(), this);
        this.menuBar.add(mWindow);
        JMenu mHelp = AEnv.getMenu("Help");
        this.menuBar.add(mHelp);
        AEnv.addMenuItem("Online", null, null, mHelp, this);
        AEnv.addMenuItem("SendMail", null, null, mHelp, this);
        AEnv.addMenuItem("About", null, null, mHelp, this);
        this.setButton(this.bPrint, "Print", "Print");
        this.setButton(this.bSendMail, "SendMail", "SendMail");
        this.setButton(this.bPageSetup, "PageSetup", "PageSetup");
        this.setButton(this.bArchive, "Archive", "Archive");
        if (this.m_isCanExport) {
            this.setButton(this.bExport, "Export", "Export");
        }
        this.setButton(this.bNext, "NextPage", "Next");
        this.setButton(this.bPrevious, "PreviousPage", "Previous");
        this.setButton(this.bFind, "Find", "Find");
        this.setButton(this.bCustomize, "PrintCustomize", "Preference");
        this.setButton(this.bEnd, "End", "End");
        if (this.m_IsCanLoad) {
            this.setButton(this.bLoad, "Load", "Import");
        }
    }

    private void setButton(AbstractButton button, String cmd, String file) {
        String text = Msg.getMsg(this.m_ctx, cmd);
        button.setToolTipText(text);
        button.setActionCommand(cmd);
        ImageIcon ii24 = Env.getImageIcon(file + "24.gif");
        if (ii24 != null) {
            button.setIcon(ii24);
        }
        button.setMargin(AppsAction.BUTTON_INSETS);
        button.setPreferredSize(AppsAction.BUTTON_SIZE);
        button.addActionListener(this);
    }

    @Override
    public void dispose() {
        Env.clearWinContext(this.m_WindowNo);
        this.m_reportEngine = null;
        this.m_viewPanel = null;
        this.m_ctx = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_setting) {
            return;
        }
        String cmd = e.getActionCommand();
        log.config(cmd);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e.getSource() == this.comboZoom) {
            this.cmd_zoom();
        } else if (e.getSource() == this.comboReport) {
            this.cmd_report();
        } else if (e.getSource() == this.comboReportView) {
            this.cmd_reportView();
        } else if (e.getSource() == this.comboDrill) {
            this.cmd_drill();
        } else if (e.getSource() == this.summary) {
            this.m_reportEngine.setSummary(this.summary.isSelected());
            this.cmd_isSummary();
        } else if (cmd.equals("First")) {
            this.setPage(1);
        } else if (cmd.equals("PreviousPage") || cmd.equals("Previous")) {
            this.setPage(this.m_pageNo - 1);
        } else if (cmd.equals("NextPage") || cmd.equals("Next")) {
            this.setPage(this.m_pageNo + 1);
        } else if (cmd.equals("Last")) {
            this.setPage(this.m_pageMax);
        } else if (cmd.equals("Find")) {
            this.cmd_find();
        } else if (cmd.equals("Export")) {
            this.cmd_export();
        } else if (cmd.equals("Print")) {
            this.cmd_print();
        } else if (cmd.equals("SendMail")) {
            this.cmd_sendMail();
        } else if (cmd.equals("Archive")) {
            this.cmd_archive();
        } else if (cmd.equals("PrintCustomize")) {
            this.cmd_customize();
        } else if (cmd.equals("PageSetup")) {
            this.cmd_pageSetup();
        } else if (cmd.equals("Translate")) {
            this.cmd_translate();
        } else if (cmd.equals("End")) {
            this.dispose();
        } else if (cmd.equals("Load")) {
            this.cmd_LoadFormat();
        } else if (e.getSource() == this.m_ddM) {
            this.cmd_window(this.m_ddQ);
        } else if (e.getSource() == this.m_daM) {
            this.cmd_window(this.m_daQ);
        } else if (!AEnv.actionPerformed(e.getActionCommand(), this.m_WindowNo, this)) {
            log.log(Level.SEVERE, "unknown action=" + e.getActionCommand());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.m_setting) {
            return;
        }
        this.m_setting = true;
        int newPage = 0;
        if (e.getSource() == this.spinner) {
            newPage = (Integer)this.spinnerModel.getValue();
        } else {
            Point p2 = this.centerScrollPane.getViewport().getViewPosition();
            newPage = Math.round(this.m_viewPanel.getPageNoAt(p2));
        }
        this.setPage(newPage);
        this.m_setting = false;
    }

    private void setPage(int page) {
        this.m_setting = true;
        this.m_pageNo = page;
        if (this.m_pageNo < 1) {
            this.m_pageNo = 1;
        }
        if (page > this.m_pageMax) {
            this.m_pageNo = this.m_pageMax;
        }
        this.bPrevious.setEnabled(this.m_pageNo != 1);
        this.bNext.setEnabled(this.m_pageNo != this.m_pageMax);
        Rectangle pageRectangle = this.m_viewPanel.getRectangleOfPage(this.m_pageNo);
        pageRectangle.x -= this.m_viewPanel.getMarginSize(true);
        pageRectangle.y -= this.m_viewPanel.getMarginSize(true);
        this.centerScrollPane.getViewport().setViewPosition(pageRectangle.getLocation());
        this.spinnerModel.setValue(new Integer(this.m_pageNo));
        StringBuffer sb = new StringBuffer(Msg.getMsg(this.m_ctx, "Page")).append(" ").append(this.m_pageNo).append(this.m_viewPanel.getPageInfo(this.m_pageNo)).append(" ").append(Msg.getMsg(this.m_ctx, "of")).append(" ").append(this.m_pageMax).append(this.m_viewPanel.getPageInfoMax());
        this.statusBar.setStatusDB(sb.toString());
        this.m_setting = false;
    }

    private void cmd_drill() {
        boolean bl = this.m_drillDown = this.comboDrill.getSelectedIndex() < 1;
        if (this.m_drillDown) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    private void mouse_clicked(MouseEvent e, boolean rightClick) {
        MQuery query;
        Point point = e.getPoint();
        log.info("Right=" + rightClick + " - " + point.toString());
        if (rightClick) {
            this.m_ddQ = this.m_viewPanel.getDrillDown(point);
            this.m_daQ = this.m_viewPanel.getDrillAcross(point);
            this.m_ddM = null;
            this.m_daM = null;
            if (this.m_ddQ == null && this.m_daQ == null) {
                return;
            }
            JPopupMenu pop = new JPopupMenu();
            ImageIcon wi = Env.getImageIcon("mWindow.gif");
            if (this.m_ddQ != null) {
                this.m_ddM = new CMenuItem(this.m_ddQ.getDisplayName(Env.getCtx()), wi);
                this.m_ddM.setToolTipText(this.m_ddQ.toString());
                this.m_ddM.addActionListener(this);
                pop.add(this.m_ddM);
            }
            if (this.m_daQ != null) {
                this.m_daM = new CMenuItem(this.m_daQ.getDisplayName(Env.getCtx()), wi);
                this.m_daM.setToolTipText(this.m_daQ.toString());
                this.m_daM.addActionListener(this);
                pop.add(this.m_daM);
            }
            Point pp = e.getPoint();
            pop.show((Component)e.getSource(), pp.x, pp.y);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_drillDown) {
            MQuery query2 = this.m_viewPanel.getDrillDown(point);
            if (query2 != null) {
                log.info("Drill Down: " + query2.getWhereClause(true));
                this.executeDrill(query2);
            }
        } else if (this.comboDrill.getSelectedItem() != null && this.comboDrill.getSelectedIndex() > 0 && (query = this.m_viewPanel.getDrillAcross(point)) != null) {
            NamePair pp = (NamePair)this.comboDrill.getSelectedItem();
            query.setTableName(pp.getID());
            log.info("Drill Accross: " + query.getWhereClause(true));
            this.executeDrill(query);
        }
        this.cmd_drill();
    }

    private void executeDrill(MQuery query) {
        int AD_Table_ID = AReport.getAD_Table_ID(query.getTableName());
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            ADialog.error(this.m_WindowNo, this, "AccessCannotReport", query.getTableName());
            return;
        }
        if (AD_Table_ID != 0) {
            new AReport(AD_Table_ID, null, query);
        } else {
            log.warning("No Table found for " + query.getWhereClause(true));
        }
    }

    private void cmd_window(MQuery query) {
        if (query == null) {
            return;
        }
        AEnv.zoom(query);
    }

    private void cmd_print() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_reportEngine.getPrintInfo().setWithDialog(true);
        this.m_reportEngine.print();
        this.cmd_drill();
    }

    private void cmd_sendMail() {
        String to = "";
        MUser from = MUser.get(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()));
        String subject = this.m_reportEngine.getName();
        String message = "";
        File attachment = null;
        try {
            attachment = this.m_reportEngine.getPDF(null);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        new EMailDialog(this, Msg.getMsg(Env.getCtx(), "SendMail"), from, to, subject, message, attachment);
    }

    private void cmd_archive() {
        boolean success = false;
        byte[] data = new ITextDocument().getPDFAsArray(this.m_reportEngine.getLayout().getPageable(false));
        if (data != null) {
            MArchive archive = new MArchive(Env.getCtx(), this.m_reportEngine.getPrintInfo(), null);
            archive.setBinaryData(data);
            success = archive.save();
        }
        if (success) {
            ADialog.info(this.m_WindowNo, this, "Archived");
        } else {
            ADialog.error(this.m_WindowNo, this, "ArchiveError");
        }
    }

    private void cmd_pageSetup() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_reportEngine.pageSetupDialog();
        this.revalidate();
        this.cmd_drill();
    }

    private void cmd_export() {
        log.config("");
        if (!this.m_isCanExport) {
            ADialog.error(this.m_WindowNo, this, "AccessCannotExport", this.getTitle());
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(Msg.getMsg(this.m_ctx, "Export") + ": " + this.getTitle());
        this.exportHandler = new ReportExportHandler(this.m_ctx, this.m_reportEngine);
        if (this.exportHandler.getExportFormatList() != null) {
            for (AbstractExportFormat exportFormat : this.exportHandler.getExportFormatList()) {
                if (exportFormat.getExtension().equals("arxml") && !this.m_IsCanLoad) continue;
                chooser.addChoosableFileFilter(new ExtensionFileFilter(exportFormat.getExtension(), exportFormat.getName()));
            }
        }
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        String exportName = chooser.getFileFilter().getDescription();
        File outFile = ExtensionFileFilter.getFile(chooser.getSelectedFile(), chooser.getFileFilter());
        try {
            outFile.createNewFile();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
            ADialog.error(this.m_WindowNo, this, "FileCannotCreate", e.getLocalizedMessage());
            return;
        }
        String ext = outFile.getPath();
        if (ext.lastIndexOf(46) == -1) {
            ADialog.error(this.m_WindowNo, this, "FileInvalidExtension");
            return;
        }
        ext = ext.substring(ext.lastIndexOf(46) + 1).toLowerCase();
        log.config("File=" + outFile.getPath() + "; Type=" + ext);
        this.setCursor(Cursor.getPredefinedCursor(3));
        AbstractExportFormat exporter = this.exportHandler.getExporter(exportName);
        exporter.exportTo(outFile);
        this.cmd_drill();
    }

    private void cmd_report() {
        KeyNamePair pp = (KeyNamePair)this.comboReport.getSelectedItem();
        if (pp != null && pp.getKey() >= 0) {
            MPrintFormat pf = MPrintFormat.get(Env.getCtx(), pp.getKey(), true);
            this.selectReportView(pf.getAD_ReportView_ID());
        }
        this.cmd_report(false);
    }

    private void cmd_isSummary() {
        this.cmd_report(true);
    }

    private void cmd_reportView() {
        this.cmd_report(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cmd_report(boolean isSummaryChanged) {
        KeyNamePair reportView;
        KeyNamePair pp = (KeyNamePair)this.comboReport.getSelectedItem();
        if (pp == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        MPrintFormat pf = null;
        int AD_PrintFormat_ID = pp.getKey();
        if (AD_PrintFormat_ID == -1) {
            int AD_ReportView_ID = this.m_reportEngine.getPrintFormat().getAD_ReportView_ID();
            if (AD_ReportView_ID != 0) {
                String name = this.m_reportEngine.getName();
                int index = name.lastIndexOf(95);
                if (index != -1) {
                    name = name.substring(0, index);
                }
                pf = MPrintFormat.createFromReportView(this.m_ctx, AD_ReportView_ID, name);
            } else {
                int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
                pf = MPrintFormat.createFromTable(this.m_ctx, AD_Table_ID);
            }
            if (pf == null) return;
            this.fillComboReport(pf.get_ID());
        } else if (AD_PrintFormat_ID == -2) {
            MPrintFormat current = this.m_reportEngine.getPrintFormat();
            if (current == null) return;
            pf = MPrintFormat.copyToClient(this.m_ctx, current.getAD_PrintFormat_ID(), Env.getAD_Client_ID(this.m_ctx));
            if (pf == null) return;
            this.fillComboReport(pf.get_ID());
        } else {
            pf = MPrintFormat.get(Env.getCtx(), AD_PrintFormat_ID, true);
        }
        if (pf == null) {
            return;
        }
        if (!isSummaryChanged) {
            this.summary.setSelected(pf.isSummary());
        }
        this.m_reportEngine.setSummary(this.summary.isSelected());
        if (this.m_reportEngine.getPrintFormat() != null) {
            pf.setLanguage(this.m_reportEngine.getPrintFormat().getLanguage());
            pf.setTranslationLanguage(this.m_reportEngine.getPrintFormat().getLanguage());
        }
        if ((reportView = (KeyNamePair)this.comboReportView.getSelectedItem()) != null) {
            this.m_reportEngine.setAD_ReportView_ID(reportView.getKey());
        }
        this.m_reportEngine.setPrintFormat(pf);
        this.revalidate();
        this.cmd_drill();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cmd_find() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
        String title = null;
        String tableName = null;
        String sql = "SELECT t.AD_Tab_ID FROM AD_Tab t INNER JOIN AD_Window w ON (t.AD_Window_ID=w.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) WHERE tt.AD_Table_ID=? ORDER BY w.IsDefault DESC, t.SeqNo, ABS (tt.AD_Window_ID-t.AD_Window_ID)";
        int AD_Tab_ID = DB.getSQLValue(null, sql, AD_Table_ID);
        MClient client = MClient.get(Env.getCtx());
        String aSPFilter = "";
        if (client.isUseASP()) {
            aSPFilter = "     AND (   AD_Tab_ID IN (               SELECT t.AD_Tab_ID                 FROM ASP_Tab t, ASP_Window w, ASP_Level l, ASP_ClientLevel cl                WHERE w.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND t.ASP_Window_ID = w.ASP_Window_ID                  AND t.IsActive = 'Y'                  AND w.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y'                  AND t.ASP_Status = 'S') OR \tEXISTS(SELECT 1 FROM ASP_ClientException ce \t\t\t\tWHERE ce.AD_Tab_ID = t.AD_Tab_ID \t\t\t\tAND ce.AD_Client_ID = " + client.getAD_Client_ID() + "\t\t\t\tAND ce.IsActive = 'Y' \t\t\t\tAND ce.AD_Tab_ID IS NOT NULL \t\t\t\tAND ce.AD_Field_ID IS NULL \t\t\t\tAND ce.ASP_Status = 'S')AND EXISTS(SELECT 1 FROM ASP_ClientException ce \t\t\t\tWHERE ce.AD_Tab_ID = t.AD_Tab_ID \t\t\t\tAND ce.AD_Client_ID = " + client.getAD_Client_ID() + "\t\t\t\tAND ce.IsActive = 'Y' \t\t\t\tAND ce.AD_Tab_ID IS NOT NULL \t\t\t\tAND ce.AD_Field_ID IS NULL \t\t\t\tAND ce.ASP_Status = 'H') OR EXISTS(SELECT 1 FROM ASP_Level l \t\t\t\t\tINNER JOIN ASP_ClientLevel cl ON(cl.ASP_Level_ID = l.ASP_Level_ID) \t\t\t\tWHERE cl.AD_Client_ID = " + client.getAD_Client_ID() + "\t\t\t\tAND l.IsActive = 'Y' \t\t\t\tAND cl.IsActive = 'Y' \t\t\t\tAND l.Type = 'C') ) ";
        }
        sql = "SELECT t.Name, t.TableName FROM AD_Tab_v t WHERE t.AD_Tab_ID=? " + aSPFilter;
        if (!Env.isBaseLanguage(Env.getCtx(), "AD_Tab")) {
            sql = "SELECT t.Name, t.TableName FROM AD_Tab_vt t WHERE t.AD_Tab_ID=? AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "' " + aSPFilter;
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Tab_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                title = rs.getString(1);
                tableName = rs.getString(2);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        GridField[] findFields = null;
        if (tableName != null) {
            findFields = GridField.createFields(this.m_ctx, this.m_WindowNo, 0, AD_Tab_ID);
        }
        if (findFields == null) {
            this.bFind.setEnabled(false);
            if (!this.launchProcessPara()) return;
            this.revalidate();
        } else {
            String whereExtended = "";
            whereExtended = this.m_reportEngine.getWhereExtended();
            Find find = new Find(this, this.m_reportEngine.getWindowNo(), title, AD_Tab_ID, AD_Table_ID, tableName, whereExtended, findFields, 1);
            this.m_reportEngine.setQuery(find.getQuery());
            find.dispose();
            find = null;
            this.revalidate();
        }
        this.cmd_drill();
    }

    private boolean launchProcessPara() {
        if (this.m_reportEngine.getProcessInfo() == null) {
            return false;
        }
        ProcessInfo pi = new ProcessInfo(this.m_reportEngine.getProcessInfo().getTitle(), this.m_reportEngine.getProcessInfo().getAD_Process_ID(), this.m_reportEngine.getProcessInfo().getTable_ID(), this.m_reportEngine.getProcessInfo().getRecord_ID());
        ProcessModalDialog para = new ProcessModalDialog((Frame)Env.getFrame(this), this.m_WindowNo, pi);
        if (para.isValidDialog()) {
            para.validate();
            para.pack();
            AEnv.showCenterWindow(Env.getWindow(this.m_WindowNo), para);
            if (para.isOK()) {
                ProcessCtl worker = new ProcessCtl(null, this.m_WindowNo, pi, true, null);
                worker.run();
                ReportEngine re = ReportEngine.get(Env.getCtx(), pi);
                this.m_reportEngine.setQuery(re.getQuery());
                return true;
            }
        }
        return false;
    }

    private void cmd_customize() {
        AWindow win = new AWindow(this.getGraphicsConfiguration());
        new AWindowListener(win, this);
        int AD_Window_ID = 240;
        int AD_PrintFormat_ID = this.m_reportEngine.getPrintFormat().get_ID();
        boolean loadedOK = win.initWindow(AD_Window_ID, MQuery.getEqualQuery("AD_PrintFormat_ID", AD_PrintFormat_ID));
        if (loadedOK) {
            AEnv.addToWindowManager(win);
            AEnv.showCenterScreen(win);
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        if (e.getID() == 202 && this.m_reportEngine != null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            log.info("Re-read PrintFormat");
            int AD_PrintFormat_ID = this.m_reportEngine.getPrintFormat().get_ID();
            Language language = this.m_reportEngine.getPrintFormat().getLanguage();
            MPrintFormat pf = MPrintFormat.get(Env.getCtx(), AD_PrintFormat_ID, true);
            if (pf == null) {
                this.dispose();
            } else {
                pf.setLanguage(language);
                pf.setTranslationLanguage(language);
                this.m_reportEngine.setPrintFormat(pf);
                this.revalidate();
                this.cmd_drill();
            }
        }
    }

    private void cmd_zoom() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_viewPanel.setZoomLevel(this.comboZoom.getSelectedIndex());
        this.revalidate();
        this.cmd_drill();
    }

    private void cmd_translate() {
        ArrayList<ValueNamePair> list = new ArrayList<ValueNamePair>();
        ValueNamePair pp = null;
        String sql = "SELECT Name, AD_Language FROM AD_Language WHERE IsSystemLanguage='Y' ORDER BY 1";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new ValueNamePair(rs.getString(2), rs.getString(1)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (list.size() == 0) {
            ADialog.warn(this.m_WindowNo, this, "NoTranslation");
            return;
        }
        String title = Msg.getMsg(Env.getCtx(), "PrintFormatTrl", true);
        String message = Msg.getMsg(Env.getCtx(), "PrintFormatTrl", false);
        int choice = JOptionPane.showOptionDialog(this, message, title, 0, 3, null, list.toArray(), null);
        if (choice == -1) {
            return;
        }
        pp = (ValueNamePair)list.get(choice);
        String AD_Language = pp.getValue();
        int AD_PrintFormat_ID = this.m_reportEngine.getPrintFormat().get_ID();
        log.config(AD_Language + " - AD_PrintFormat_ID=" + AD_PrintFormat_ID);
        StringBuffer sb = new StringBuffer();
        if (Language.isBaseLanguage(AD_Language)) {
            sb.append("UPDATE AD_PrintFormatItem pfi SET Name = (SELECT e.Name FROM AD_Element e, AD_Column c WHERE e.AD_Element_ID=c.AD_Element_ID AND c.AD_Column_ID=pfi.AD_Column_ID),PrintName = (SELECT e.PrintName FROM AD_Element e, AD_Column c WHERE e.AD_Element_ID=c.AD_Element_ID AND c.AD_Column_ID=pfi.AD_Column_ID) WHERE AD_PrintFormat_ID=").append(AD_PrintFormat_ID).append(" AND EXISTS (SELECT * FROM AD_Element e, AD_Column c WHERE e.AD_Element_ID=c.AD_Element_ID AND c.AD_Column_ID=pfi.AD_Column_ID)");
        } else {
            AD_Language = "'" + AD_Language + "'";
            sb.append("UPDATE AD_PrintFormatItem pfi SET Name = (SELECT e.Name FROM AD_Element_Trl e, AD_Column c WHERE e.AD_Language=").append(AD_Language).append(" AND e.AD_Element_ID=c.AD_Element_ID AND c.AD_Column_ID=pfi.AD_Column_ID), PrintName = (SELECT e.PrintName FROM AD_Element_Trl e, AD_Column c\tWHERE e.AD_Language=").append(AD_Language).append(" AND e.AD_Element_ID=c.AD_Element_ID AND c.AD_Column_ID=pfi.AD_Column_ID) WHERE AD_PrintFormat_ID=").append(AD_PrintFormat_ID).append(" AND EXISTS (SELECT * FROM AD_Element_Trl e, AD_Column c WHERE e.AD_Language=").append(AD_Language).append(" AND e.AD_Element_ID=c.AD_Element_ID AND c.AD_Column_ID=pfi.AD_Column_ID)");
        }
        int count = DB.executeUpdate(sb.toString(), null);
        log.config("Count=" + count);
        this.m_reportEngine.setPrintFormat(MPrintFormat.get(Env.getCtx(), AD_PrintFormat_ID, true));
        this.revalidate();
    }

    private void cmd_LoadFormat() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new ExtensionFileFilter("arxml", "Adempiere Report Definition"));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File reportFile = ExtensionFileFilter.getFile(chooser.getSelectedFile(), chooser.getFileFilter());
        if (ImpExpUtil.importPrintFormat(reportFile)) {
            ADialog.info(this.m_WindowNo, this, "Report Definition Loaded");
            this.fillComboReport(this.m_reportEngine.getPrintFormat().get_ID());
        }
    }

    public static void main(String[] args) {
        Login.initTest(true);
        MQuery q = new MQuery("C_Invoice");
        q.addRestriction("C_Invoice_ID", "=", new Integer(103));
        PrintInfo i2 = new PrintInfo("test", X_C_Invoice.Table_ID, 102, 0);
        MPrintFormat f = MPrintFormat.get(Env.getCtx(), 102, false);
        ReportEngine re = new ReportEngine(Env.getCtx(), f, q, i2);
        new Viewer(re);
    }
}

