/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.lang.reflect.Method;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.ADialog;
import org.compiere.model.MPInstance;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.ReportViewerProvider;
import org.compiere.print.ServerReportCtl;
import org.compiere.print.SwingViewerProvider;
import org.compiere.process.ProcessInfo;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public class ReportCtl {
    public static final String PARAM_PRINTER_NAME = "PRINTER_NAME";
    public static final String PARAM_PRINT_FORMAT = "PRINT_FORMAT";
    public static final String PARAM_PRINT_INFO = "PRINT_INFO";
    private static CLogger s_log = CLogger.getCLogger(ReportCtl.class);
    private static ReportViewerProvider viewerProvider = new SwingViewerProvider();

    private ReportCtl() {
    }

    public static boolean start(ProcessInfo processInfo, boolean isDirectPrint) {
        return ReportCtl.start(null, -1, processInfo, isDirectPrint);
    }

    public static boolean start(ASyncProcess parent, int windowNo, ProcessInfo processInfo, boolean isDirectPrint) {
        processInfo.setPrintPreview(!isDirectPrint);
        return ReportCtl.start(parent, windowNo, processInfo);
    }

    public static boolean start(ASyncProcess parent, int windowNo, ProcessInfo processInfo) {
        s_log.info("start - " + processInfo);
        MPInstance instance = new MPInstance(Env.getCtx(), processInfo.getAD_PInstance_ID(), null);
        if (processInfo.getReportType() != null) {
            instance.setReportType(processInfo.getReportType());
        }
        if (processInfo.getTransientObject() != null) {
            instance.setAD_PrintFormat_ID(((MPrintFormat)processInfo.getTransientObject()).getAD_PrintFormat_ID());
        } else if (processInfo.getSerializableObject() != null) {
            instance.setAD_PrintFormat_ID(((MPrintFormat)processInfo.getSerializableObject()).getAD_PrintFormat_ID());
        }
        instance.saveEx();
        if (processInfo.getAD_Process_ID() == 110) {
            return ReportCtl.startDocumentPrint(0, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == MProcess.getProcess_ID("Rpt PP_Order", null)) {
            return ReportCtl.startDocumentPrint(8, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == MProcess.getProcess_ID("Rpt DD_Order", null)) {
            return ReportCtl.startDocumentPrint(9, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 116) {
            return ReportCtl.startDocumentPrint(2, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 117) {
            return ReportCtl.startDocumentPrint(1, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 217) {
            return ReportCtl.startDocumentPrint(3, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 276) {
            return ReportCtl.startDocumentPrint(4, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 313) {
            return ReportCtl.startCheckPrint(processInfo.getRecord_ID(), !processInfo.isPrintPreview());
        }
        if (processInfo.getAD_Process_ID() == 290) {
            return ReportCtl.startDocumentPrint(12, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 159) {
            return ReportCtl.startDocumentPrint(7, null, processInfo.getRecord_ID(), parent, windowNo, !processInfo.isPrintPreview(), null, processInfo);
        }
        return ReportCtl.startStandardReport(processInfo);
    }

    public static boolean startStandardReport(ProcessInfo processInfo, boolean isDirectPrint) {
        processInfo.setPrintPreview(!isDirectPrint);
        return ReportCtl.startStandardReport(processInfo);
    }

    public static boolean startStandardReport(ProcessInfo processInfo) {
        ReportEngine reportEngine = null;
        Object transientObject = processInfo.getTransientObject();
        if (transientObject == null) {
            transientObject = processInfo.getSerializableObject();
        }
        if (transientObject != null && transientObject instanceof MPrintFormat) {
            Properties ctx = Env.getCtx();
            MPrintFormat format = (MPrintFormat)transientObject;
            String tableName = MTable.getTableName(ctx, format.getAD_Table_ID());
            if (processInfo.getAD_Process_ID() == 202) {
                tableName = "T_Report";
            }
            MQuery query = MQuery.get(ctx, processInfo.getAD_PInstance_ID(), tableName);
            PrintInfo info = new PrintInfo(processInfo);
            reportEngine = new ReportEngine(ctx, format, query, info);
            reportEngine.setReportType(processInfo.getReportType());
            ReportCtl.createOutput(reportEngine, processInfo.isPrintPreview(), null);
            return true;
        }
        reportEngine = ReportEngine.get(Env.getCtx(), processInfo);
        if (reportEngine == null) {
            processInfo.setSummary("No ReportEngine");
            return false;
        }
        if (processInfo.getReportType() != null) {
            reportEngine.setReportType(processInfo.getReportType());
        }
        ReportCtl.createOutput(reportEngine, processInfo.isPrintPreview(), null);
        return true;
    }

    public static boolean startDocumentPrint(int type, int recordId, boolean isDirectPrint) {
        return ReportCtl.startDocumentPrint(type, recordId, null, -1, isDirectPrint);
    }

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int recordId, ASyncProcess parent, int windowNo, String printerName) {
        return ReportCtl.startDocumentPrint(type, customPrintFormat, recordId, parent, windowNo, true, printerName, null);
    }

    public static boolean startDocumentPrint(int type, int recordId, ASyncProcess parent, int windowNo, boolean isDirectPrint) {
        return ReportCtl.startDocumentPrint(type, null, recordId, parent, windowNo, isDirectPrint, null, null);
    }

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int recordId, ASyncProcess parent, int windowNo, boolean isDirectPrint, String printerName, ProcessInfo processInfo) {
        String trxName = processInfo != null ? processInfo.getTransactionName() : null;
        ReportEngine reportEngine = ReportEngine.get(Env.getCtx(), type, recordId, trxName);
        if (reportEngine == null) {
            if (Ini.isClient()) {
                ADialog.error(0, null, "NoDocPrintFormat");
            } else {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (loader == null) {
                        loader = ReportCtl.class.getClassLoader();
                    }
                    Class<?> clazz = loader.loadClass("org.adempiere.webui.window.FDialog");
                    Method m = clazz.getMethod("error", Integer.TYPE, String.class);
                    m.invoke(null, 0, "NoDocPrintFormat");
                }
                catch (Exception e) {
                    throw new AdempiereException(e);
                }
            }
            return false;
        }
        if (customPrintFormat != null) {
            reportEngine.setPrintFormat(customPrintFormat);
        }
        if (reportEngine.getPrintFormat() != null) {
            MPrintFormat format = reportEngine.getPrintFormat();
            if (format.getJasperProcess_ID() > 0) {
                ServerReportCtl.runJasperProcess(recordId, reportEngine, isDirectPrint, printerName, processInfo);
            } else {
                if (processInfo != null) {
                    processInfo.setPDFReport(reportEngine.getPDF());
                    if (processInfo.isBatch()) {
                        return true;
                    }
                }
                ReportCtl.createOutput(reportEngine, !isDirectPrint, printerName);
                if (isDirectPrint) {
                    ReportEngine.printConfirm(type, recordId, trxName);
                }
            }
        }
        return true;
    }

    public static boolean startCheckPrint(int C_Payment_ID, boolean IsDirectPrint) {
        int paySelectionCheckById = ReportCtl.getHRPaySelectionCheckById(Env.getCtx(), C_Payment_ID, null);
        if (paySelectionCheckById > 0) {
            return ReportCtl.startDocumentPrint(10, paySelectionCheckById, null, -1, IsDirectPrint);
        }
        boolean ok = MPaySelectionCheck.deleteGeneratedDraft(Env.getCtx(), C_Payment_ID, null);
        int PaySelectionCheckId = 0;
        MPaySelectionCheck paySelectionCheck = MPaySelectionCheck.getOfPayment(Env.getCtx(), C_Payment_ID, null);
        if (paySelectionCheck != null) {
            PaySelectionCheckId = paySelectionCheck.getC_PaySelectionCheck_ID();
        } else {
            paySelectionCheck = MPaySelectionCheck.createForPayment(Env.getCtx(), C_Payment_ID, null);
            if (paySelectionCheck != null) {
                PaySelectionCheckId = paySelectionCheck.getC_PaySelectionCheck_ID();
            }
        }
        return ReportCtl.startDocumentPrint(6, PaySelectionCheckId, null, -1, IsDirectPrint);
    }

    private static int getHRPaySelectionCheckById(Properties ctx, int paymentId, String trxName) {
        String sql = "SELECT MAX(HR_PaySelectionCheck_ID) FROM HR_PaySelectionCheck psc WHERE psc.C_Payment_ID = ? AND Processed=?";
        return DB.getSQLValue(trxName, "SELECT MAX(HR_PaySelectionCheck_ID) FROM HR_PaySelectionCheck psc WHERE psc.C_Payment_ID = ? AND Processed=?", paymentId, true);
    }

    private static void createOutput(ReportEngine reportEngine, boolean printPreview, String printerName) {
        if (printPreview) {
            ReportCtl.preview(reportEngine);
        } else {
            if (printerName != null) {
                reportEngine.getPrintInfo().setPrinterName(printerName);
            }
            reportEngine.print();
        }
    }

    public static void preview(ReportEngine reportEngine) {
        ReportViewerProvider provider = ReportCtl.getReportViewerProvider();
        provider.openViewer(reportEngine);
    }

    public static void setReportViewerProvider(ReportViewerProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set report viewer provider to null");
        }
        viewerProvider = provider;
    }

    public static ReportViewerProvider getReportViewerProvider() {
        return viewerProvider;
    }
}

