/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.Adempiere;
import org.compiere.print.PrintDataColumn;
import org.compiere.print.PrintDataElement;
import org.compiere.print.PrintDataHandler;
import org.compiere.print.util.SerializableMatrix;
import org.compiere.print.util.SerializableMatrixImpl;
import org.compiere.report.MReportLine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class PrintData
implements Serializable {
    private static final long serialVersionUID = -5013410697934610197L;
    private SerializableMatrix<Serializable> m_matrix;
    private Properties m_ctx;
    private String m_name;
    private ArrayList<Integer> m_functionRows = new ArrayList();
    private boolean m_hasLevelNo = false;
    private static final String LEVEL_NO = "LEVELNO";
    private PrintDataColumn[] m_columnInfo = null;
    private String m_sql = null;
    private String m_TableName = null;
    public static final String XML_TAG = "adempiereData";
    public static final String XML_ROW_TAG = "row";
    public static final String XML_ATTRIBUTE_NAME = "name";
    public static final String XML_ATTRIBUTE_COUNT = "count";
    public static final String XML_ATTRIBUTE_NO = "no";
    public static final String XML_ATTRIBUTE_FUNCTION_ROW = "function_row";
    private static CLogger log = CLogger.getCLogger(PrintData.class);
    private boolean hasDummyTableID = false;

    public PrintData(Properties ctx, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.m_ctx = ctx;
        this.m_name = name;
        this.m_matrix = new SerializableMatrixImpl<Serializable>(name);
    }

    public PrintData(Properties ctx, String name, ArrayList<Serializable> nodes) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.m_ctx = ctx;
        this.m_name = name;
        this.m_matrix = new SerializableMatrixImpl<Serializable>(name);
        if (nodes != null) {
            this.addRow(false, 0, nodes);
        }
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public String getName() {
        return this.m_name;
    }

    public void setColumnInfo(PrintDataColumn[] newInfo) {
        this.m_columnInfo = newInfo;
    }

    public PrintDataColumn[] getColumnInfo() {
        return this.m_columnInfo;
    }

    public void setSQL(String sql) {
        this.m_sql = sql;
    }

    public String getSQL() {
        return this.m_sql;
    }

    public boolean isHasDummyTableID() {
        return this.hasDummyTableID;
    }

    public void setHasDummyTableID(boolean hasDummyTableID) {
        this.hasDummyTableID = hasDummyTableID;
    }

    public void setTableName(String TableName) {
        this.m_TableName = TableName;
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PrintData[");
        sb.append(this.m_name).append(",Rows=").append(this.m_matrix.getRowCount());
        if (this.m_TableName != null) {
            sb.append(",TableName=").append(this.m_TableName);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.m_matrix.getRowCount() == 0 || this.m_matrix.getRowData().isEmpty();
    }

    public int getNodeCount() {
        if (this.m_matrix.getRowCount() == 0) {
            return 0;
        }
        return this.m_matrix.getRowData().size();
    }

    public void addRow(boolean functionRow, int levelNo) {
        this.addRow(functionRow, levelNo, new ArrayList<Serializable>());
    }

    public void addRow(boolean functionRow, int levelNo, List<Serializable> nodes) {
        this.m_matrix.addRow(nodes);
        if (functionRow) {
            this.m_functionRows.add(new Integer(this.m_matrix.getRowIndex()));
        }
        if (this.m_hasLevelNo && levelNo != 0) {
            this.addNode(new PrintDataElement(LEVEL_NO, new Integer(levelNo), 11, null));
        }
    }

    public boolean setRowIndex(int row) {
        return this.m_matrix.setRowIndex(row);
    }

    public boolean setRowNext() {
        return this.m_matrix.setRowNext();
    }

    public int getRowCount() {
        return this.m_matrix.getRowCount();
    }

    public int getRowIndex() {
        return this.m_matrix.getRowIndex();
    }

    public boolean isFunctionRow(int row) {
        return this.m_functionRows.contains(new Integer(row));
    }

    public boolean isFunctionRow() {
        return this.m_functionRows.contains(new Integer(this.m_matrix.getRowIndex()));
    }

    public boolean isPageBreak() {
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (this.isFunctionRow() && nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                PrintDataElement pde;
                Serializable o = nodes.get(i);
                if (!(o instanceof PrintDataElement) || !(pde = (PrintDataElement)o).isPageBreak()) continue;
                return true;
            }
        }
        return false;
    }

    public void setHasLevelNo(boolean hasLevelNo) {
        this.m_hasLevelNo = hasLevelNo;
    }

    public boolean hasLevelNo() {
        return this.m_hasLevelNo;
    }

    public int getLineLevelNo() {
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (nodes == null || !this.m_hasLevelNo) {
            return 0;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            PrintDataElement pde;
            Serializable o = nodes.get(i);
            if (!(o instanceof PrintDataElement) || !LEVEL_NO.equals((pde = (PrintDataElement)o).getColumnName())) continue;
            Integer ii = (Integer)pde.getValue();
            return ii;
        }
        return 0;
    }

    public void addNode(PrintData parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (nodes == null) {
            nodes = new ArrayList<Serializable>();
            this.addRow(false, 0, nodes);
        }
        nodes.add(parent);
    }

    public void addNode(PrintDataElement node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (nodes == null) {
            nodes = new ArrayList<Serializable>();
            this.addRow(false, 0, nodes);
        }
        nodes.add(node);
    }

    public void addNode(String s) {
        if (s == null) {
            return;
        }
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (nodes == null) {
            nodes = new ArrayList<Serializable>();
            this.addRow(false, 0, nodes);
        }
        nodes.add((Serializable)((Object)s));
    }

    private Object getNode(int index) {
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (nodes == null || index < 0 || index >= nodes.size()) {
            return null;
        }
        return nodes.get(index);
    }

    public Object getNode(String name) {
        int index = this.getIndex(name);
        if (index < 0) {
            return null;
        }
        List<Serializable> nodes = this.m_matrix.getRowData();
        return nodes.get(index);
    }

    public Object getNode(Integer AD_Column_ID) {
        int index = this.getIndex(AD_Column_ID);
        if (index < 0) {
            return null;
        }
        List<Serializable> nodes = this.m_matrix.getRowData();
        return nodes.get(index);
    }

    public Object getNodeFromPrintFormatItem(int printFormatItemId) {
        int index = this.getIndexFromPrintFormatItem(printFormatItemId);
        if (index < 0) {
            return null;
        }
        List<Serializable> nodes = this.m_matrix.getRowData();
        return nodes.get(index);
    }

    public PrintDataElement getPKey() {
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (nodes == null) {
            return null;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            PrintDataElement pde;
            Serializable o = nodes.get(i);
            if (!(o instanceof PrintDataElement) || !(pde = (PrintDataElement)o).isPKey()) continue;
            return pde;
        }
        return null;
    }

    public int getIndex(String columnName) {
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (nodes == null) {
            return -1;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Serializable o = nodes.get(i);
            if (o instanceof PrintDataElement) {
                if (!columnName.equals(((PrintDataElement)o).getColumnName())) continue;
                return i;
            }
            if (o instanceof PrintData) {
                if (!columnName.equals(((PrintData)o).getName())) continue;
                return i;
            }
            if (o instanceof String) {
                return i;
            }
            log.log(Level.SEVERE, "Element not PrintData(Element) " + o.getClass().getName());
        }
        return -1;
    }

    public int getIndex(int AD_Column_ID) {
        if (this.m_columnInfo == null) {
            return -1;
        }
        for (int i = 0; i < this.m_columnInfo.length; ++i) {
            if (this.m_columnInfo[i].getAD_Column_ID() != AD_Column_ID) continue;
            return this.getIndex(this.m_columnInfo[i].getColumnName());
        }
        log.log(Level.SEVERE, "Column not found - AD_Column_ID=" + AD_Column_ID);
        if (AD_Column_ID == 0) {
            Trace.printStack();
        }
        return -1;
    }

    public int getIndexFromPrintFormatItem(int printFormatItemId) {
        if (this.m_columnInfo == null) {
            return -1;
        }
        for (int i = 0; i < this.m_columnInfo.length; ++i) {
            if (this.m_columnInfo[i].getPrinformatItemId() != printFormatItemId) continue;
            return this.getIndex(this.m_columnInfo[i].getColumnName());
        }
        log.log(Level.SEVERE, "Column not found - AD_Column_ID=" + printFormatItemId);
        if (printFormatItemId == 0) {
            Trace.printStack();
        }
        return -1;
    }

    public void dump() {
        PrintData.dump(this);
    }

    public void dumpHeader() {
        PrintData.dumpHeader(this);
    }

    public void dumpCurrentRow() {
        PrintData.dumpRow(this, this.m_matrix.getRowIndex());
    }

    private static void dump(PrintData pd) {
        PrintData.dumpHeader(pd);
        for (int i = 0; i < pd.getRowCount(); ++i) {
            PrintData.dumpRow(pd, i);
        }
    }

    private static void dumpHeader(PrintData pd) {
        if (log.isLoggable(Level.INFO)) {
            log.info(pd.toString());
        }
        if (pd.getColumnInfo() != null) {
            for (int i = 0; i < pd.getColumnInfo().length; ++i) {
                if (!log.isLoggable(Level.CONFIG)) continue;
                log.config(i + ": " + pd.getColumnInfo()[i]);
            }
        }
    }

    private static void dumpRow(PrintData pd, int row) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Row #" + row);
        }
        if (row < 0 || row >= pd.getRowCount()) {
            log.warning("- invalid -");
            return;
        }
        pd.setRowIndex(row);
        if (pd.getNodeCount() == 0) {
            log.config("- n/a -");
            return;
        }
        for (int i = 0; i < pd.getNodeCount(); ++i) {
            Object obj = pd.getNode(i);
            if (obj == null) {
                log.config("- NULL -");
                continue;
            }
            if (obj instanceof PrintData) {
                log.config("- included -");
                PrintData.dump((PrintData)obj);
                continue;
            }
            if (obj instanceof PrintDataElement) {
                if (!log.isLoggable(Level.CONFIG)) continue;
                log.config(((PrintDataElement)obj).toStringX());
                continue;
            }
            if (!log.isLoggable(Level.CONFIG)) continue;
            log.config("- INVALID: " + obj);
        }
    }

    public Document getDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            document.appendChild(document.createComment(Adempiere.getSummaryAscii()));
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        if (document != null) {
            Element root = document.createElement(XML_TAG);
            root.setAttribute(XML_ATTRIBUTE_NAME, this.getName());
            root.setAttribute(XML_ATTRIBUTE_COUNT, String.valueOf(this.getRowCount()));
            document.appendChild(root);
            PrintData.processXML(this, document, root);
        }
        return document;
    }

    private static void processXML(PrintData pd, Document document, Element root) {
        for (int r = 0; r < pd.getRowCount(); ++r) {
            pd.setRowIndex(r);
            Element row = document.createElement(XML_ROW_TAG);
            row.setAttribute(XML_ATTRIBUTE_NO, String.valueOf(r));
            if (pd.isFunctionRow()) {
                row.setAttribute(XML_ATTRIBUTE_FUNCTION_ROW, "yes");
            }
            root.appendChild(row);
            for (int i = 0; i < pd.getNodeCount(); ++i) {
                Element element;
                Object o = pd.getNode(i);
                if (o instanceof PrintData) {
                    PrintData pd_x = (PrintData)o;
                    element = document.createElement(XML_TAG);
                    element.setAttribute(XML_ATTRIBUTE_NAME, pd_x.getName());
                    element.setAttribute(XML_ATTRIBUTE_COUNT, String.valueOf(pd_x.getRowCount()));
                    row.appendChild(element);
                    PrintData.processXML(pd_x, document, element);
                    continue;
                }
                if (o instanceof PrintDataElement) {
                    PrintDataElement pde = (PrintDataElement)o;
                    if (pde.isNull()) continue;
                    element = document.createElement("element");
                    element.setAttribute(XML_ATTRIBUTE_NAME, pde.getColumnName());
                    if (pde.hasKey()) {
                        element.setAttribute("key", pde.getValueKey());
                    }
                    element.appendChild(document.createTextNode(pde.getValueDisplay(Env.getLanguage(Env.getCtx()))));
                    row.appendChild(element);
                    continue;
                }
                log.log(Level.SEVERE, "Element not PrintData(Element) " + o.getClass().getName());
            }
        }
    }

    public boolean createXML(StreamResult result) {
        try {
            DOMSource source = new DOMSource(this.getDocument());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(StreamResult)", e);
            return false;
        }
        return true;
    }

    public boolean createXML(String fileName) {
        try {
            File file = new File(fileName);
            file.createNewFile();
            StreamResult result = new StreamResult(file);
            this.createXML(result);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(file)", e);
            return false;
        }
        return true;
    }

    public static PrintData parseXML(Properties ctx, File input) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(input.toString());
        }
        PrintData pd = null;
        try {
            PrintDataHandler handler = new PrintDataHandler(ctx);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(input, (DefaultHandler)handler);
            pd = handler.getPrintData();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        return pd;
    }

    public static void main(String[] args) {
        PrintData pd = new PrintData(new Properties(), "test1");
        pd.addNode(new PrintDataElement("test1element1", (Serializable)((Object)"testvalue<1>"), 0, null));
        pd.addNode(new PrintDataElement("test1element2", (Serializable)((Object)"testvalue&2&"), 0, null));
        PrintData pdx = new PrintData(new Properties(), "test2");
        pdx.addNode(new PrintDataElement("test2element1-1", (Serializable)((Object)"testvalue11"), 0, null));
        pdx.addNode(new PrintDataElement("test2element1-2", (Serializable)((Object)"testvalue12"), 0, null));
        pdx.addRow(false, 0, new ArrayList<Serializable>());
        pdx.addNode(new PrintDataElement("test2element2-1", (Serializable)((Object)"testvalue21"), 0, null));
        pdx.addNode(new PrintDataElement("test2element2-2", (Serializable)((Object)"testvalue22"), 0, null));
        pd.addNode(pdx);
        pd.addNode(new PrintDataElement("test1element3", (Serializable)((Object)"testvalue/3/"), 0, null));
        pd.createXML("C:\\Temp\\printData.xml");
        pd.createXML(new StreamResult(System.out));
        System.out.println("");
        pd.dump();
        System.out.println("");
        PrintData pd1 = PrintData.parseXML(new Properties(), new File("C:\\Temp\\printData.xml"));
        pd1.createXML(new StreamResult(System.out));
        System.out.println("");
        pd1.dump();
    }

    public MReportLine getMReportLine() {
        List<Serializable> nodes = this.m_matrix.getRowData();
        if (nodes == null || !this.m_hasLevelNo) {
            return null;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Integer ii;
            PrintDataElement pde;
            Serializable o = nodes.get(i);
            if (!(o instanceof PrintDataElement) || !"PA_ReportLine_ID".equals((pde = (PrintDataElement)o).getColumnName()) || (ii = (Integer)pde.getValue()) <= 0) continue;
            return new MReportLine(this.m_ctx, ii, null);
        }
        return null;
    }

    public void addRow(boolean functionRow, int levelNo, int reportLineId) {
        this.addRow(functionRow, levelNo);
        if (this.m_hasLevelNo && reportLineId != 0) {
            this.addNode(new PrintDataElement("PA_ReportLine_ID", new Integer(reportLineId), 11, null));
        }
    }
}

