/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.util.Comparator;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataColumn;

class GroupOrderComparator
implements Comparator<Integer> {
    PrintData printData = null;

    GroupOrderComparator(PrintData data) {
        this.printData = data;
    }

    @Override
    public int compare(Integer aIndex, Integer bIndex) {
        if (this.printData == null) {
            throw new IllegalArgumentException("PrintData not initialized");
        }
        if (aIndex.compareTo(bIndex) == 0) {
            return 0;
        }
        if (aIndex.compareTo(0) < 0 || aIndex.compareTo(this.printData.getColumnInfo().length) > 0) {
            throw new IllegalArgumentException("aIndex out of bounds");
        }
        if (bIndex.compareTo(0) < 0 || bIndex.compareTo(this.printData.getColumnInfo().length) > 0) {
            throw new IllegalArgumentException("bIndex out of bounds");
        }
        PrintDataColumn a = this.printData.getColumnInfo()[aIndex];
        PrintDataColumn b = this.printData.getColumnInfo()[bIndex];
        if (a == null || b == null) {
            throw new IllegalArgumentException("Cannot compare null values.");
        }
        int result = this.compare(a.getSortOrderIndex(), b.getSortOrderIndex());
        if (result == 0) {
            result = this.compare(a.getDisplayOrderIndex(), b.getDisplayOrderIndex());
        }
        return result;
    }

    @Override
    private int compare(int a, int b) {
        if (a > 0 && b > 0) {
            return a - b;
        }
        if (a > 0 && b <= 0) {
            return -1 * a;
        }
        if (a <= 0 && b > 0) {
            return b;
        }
        return 0;
    }
}

