/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.print.GroupOrderComparator;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataColumn;
import org.compiere.print.PrintDataElement;
import org.compiere.print.PrintDataFunction;
import org.compiere.print.PrintDataGroup;
import org.compiere.print.TableReference;
import org.compiere.print.layout.ConversionElement;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class DataEngine {
    private static CLogger log = CLogger.getCLogger(DataEngine.class);
    private String m_synonym = "A";
    private Language m_language = Language.getLoginLanguage();
    private PrintDataGroup group = new PrintDataGroup();
    private PrintData printData = null;
    private long m_startTime = System.currentTimeMillis();
    private int runningTotalLines = -1;
    private String m_trxName = null;
    private boolean m_summary = false;
    TreeMap<Integer, PrintDataColumn> columnsSortedByGroupOrder = null;
    public static final String KEY = "*";
    private static final String REPORT_DISPLAY_YES_NO = "REPORT_DISPLAY_YES_NO";

    public DataEngine(Language language) {
        this(language, null);
    }

    public DataEngine(Language language, String trxName) {
        if (language != null) {
            this.m_language = language;
        }
        this.m_trxName = trxName;
    }

    public PrintData getPrintData(Properties ctx, MPrintFormat format, MQuery query) {
        return this.getPrintData(ctx, format, query, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintData getPrintData(Properties ctx, MPrintFormat format, MQuery query, boolean summary, int p_AD_ReportView_ID) {
        PrintData pd;
        boolean hasVT;
        String reportName;
        String tableName;
        block11: {
            block10: {
                ResultSet rs;
                CPreparedStatement pstmt;
                block9: {
                    if (format == null) {
                        throw new IllegalStateException("No print format");
                    }
                    this.m_summary = !format.isForm() && summary;
                    tableName = null;
                    reportName = format.getName();
                    query.clear();
                    if (p_AD_ReportView_ID == 0) {
                        p_AD_ReportView_ID = format.getAD_ReportView_ID();
                    }
                    if (p_AD_ReportView_ID <= 0) break block10;
                    String sql = "SELECT t.AD_Table_ID, t.TableName, rv.Name, rv.WhereClause FROM AD_Table t INNER JOIN AD_ReportView rv ON (t.AD_Table_ID=rv.AD_Table_ID) WHERE rv.AD_ReportView_ID=?";
                    pstmt = null;
                    rs = null;
                    try {
                        pstmt = DB.prepareStatement(sql, this.m_trxName);
                        pstmt.setInt(1, p_AD_ReportView_ID);
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block9;
                        tableName = rs.getString(2);
                        reportName = rs.getString(3);
                        String whereClause = rs.getString(4);
                        if (Util.isEmpty(whereClause)) break block9;
                        query.addRestriction(whereClause);
                    }
                    catch (SQLException e) {
                        PrintData printData;
                        try {
                            log.log(Level.SEVERE, sql, e);
                            printData = null;
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        return printData;
                    }
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                break block11;
            }
            tableName = MTable.getTableName(ctx, format.getAD_Table_ID());
        }
        if (tableName == null) {
            log.log(Level.SEVERE, "Not found Format=" + format);
            return null;
        }
        if (format.isTranslationView() && tableName.toLowerCase().endsWith("_v") && (hasVT = DB.isTableOrViewExists(tableName + "t"))) {
            tableName = tableName + "t";
            format.setTranslationViewQuery(query);
        }
        if ((pd = this.getPrintDataInfo(ctx, format, query, reportName, tableName)) == null) {
            return null;
        }
        this.loadPrintData(pd, format);
        return pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintData getPrintDataInfo(Properties ctx, MPrintFormat format, MQuery query, String reportName, String tableName) {
        String q;
        this.m_startTime = System.currentTimeMillis();
        log.info(reportName + " - " + this.m_language.getAD_Language());
        log.fine("TableName=" + tableName + ", Query=" + query);
        log.fine("Format=" + format);
        ArrayList<PrintDataColumn> columns = new ArrayList<PrintDataColumn>();
        this.group = new PrintDataGroup();
        int[] orderAD_Column_IDs = format.getOrderAD_Column_IDs();
        ArrayList<String> orderColumns = new ArrayList<String>(orderAD_Column_IDs.length);
        for (int i = 0; i < orderAD_Column_IDs.length; ++i) {
            log.finest("Order AD_Column_ID=" + orderAD_Column_IDs[i]);
            orderColumns.add("");
        }
        StringBuffer sqlSELECT = new StringBuffer("SELECT ");
        StringBuffer sqlFROM = new StringBuffer(" FROM ").append(tableName);
        StringBuffer sqlConvert = new StringBuffer("");
        ArrayList<String> groupByColumns = new ArrayList<String>();
        MTable tableOfQuery = MTable.get(ctx, "AD_PrintFormatItem");
        MColumn column = tableOfQuery.getColumn("OverwriteReference");
        MColumn convertedColumn = tableOfQuery.getColumn("IsConvertedColumn");
        String referenceColumn = "c.AD_Reference_ID";
        String referenceValueColumn = "c.AD_Reference_Value_ID";
        String columnSQLValueColumn = "c.ColumnSQL";
        if (column != null && column.getAD_Column_ID() > 0) {
            referenceColumn = "CASE WHEN pfi.OverwriteReference = 'Y' THEN COALESCE(pfi.AD_Reference_ID, c.AD_Reference_ID) ELSE c.AD_Reference_ID END AS AD_Reference_ID";
            referenceValueColumn = "CASE WHEN pfi.OverwriteReference = 'Y' THEN COALESCE(pfi.AD_Reference_Value_ID, c.AD_Reference_Value_ID) ELSE c.AD_Reference_Value_ID END AS AD_Reference_Value_ID";
            columnSQLValueColumn = "CASE WHEN pfi.OverwriteReference = 'Y' THEN COALESCE(pfi.ColumnSQL, c.ColumnSQL) ELSE c.ColumnSQL END AS ColumnSQL";
        }
        String queryConvertedColumn = "";
        String queryConvertedJoin = "";
        boolean isConvertedSupported = false;
        if (convertedColumn != null && convertedColumn.getAD_Column_ID() > 0) {
            isConvertedSupported = true;
            queryConvertedColumn = ", COALESCE(pfi.IsConvertedColumn, 'N') AS IsConvertedColumn, sc.ColumnName AS SourceColumnDocument, scd.ColumnName AS SourceColumnDate, pfi.C_ConversionType_ID, pfi.C_Currency_ID ";
            queryConvertedJoin = " LEFT JOIN AD_Column sc ON(sc.AD_Column_ID = pfi.SourceColumnDocument_ID)  LEFT JOIN AD_Column scd ON(scd.AD_Column_ID = pfi.SourceColumnDate_ID) ";
        }
        boolean isTableIDRequired = false;
        boolean isTableIDPresent = false;
        boolean IsGroupedBy = false;
        String sql = "SELECT c.AD_Column_ID,c.ColumnName," + referenceColumn + "," + referenceValueColumn + ",c.FieldLength,c.IsMandatory,c.IsKey,c.IsParent,COALESCE(rvc.IsGroupFunction,'N') AS IsGroupFunction, rvc.FunctionColumn,pfi.IsGroupBy,pfi.IsSummarized,pfi.IsAveraged,pfi.IsCounted, pfi.IsPrinted,pfi.SortNo,pfi.IsPageBreak, pfi.IsMinCalc,pfi.IsMaxCalc, pfi.isRunningTotal,pfi.RunningTotalLines, pfi.IsVarianceCalc, pfi.IsDeviationCalc, " + columnSQLValueColumn + ", COALESCE(pfi.FormatPattern, c.FormatPattern) AS FormatPattern  , pfi.isDesc  , pfi.SeqNo , pfi.AD_PrintFormatItem_ID, pfi.IsHideGrandTotal " + queryConvertedColumn + "FROM AD_PrintFormat pf INNER JOIN AD_PrintFormatItem pfi ON (pf.AD_PrintFormat_ID=pfi.AD_PrintFormat_ID) INNER JOIN AD_Column c ON (pfi.AD_Column_ID=c.AD_Column_ID) LEFT OUTER JOIN AD_ReportView_Col rvc ON (pf.AD_ReportView_ID=rvc.AD_ReportView_ID AND c.AD_Column_ID=rvc.AD_Column_ID) " + queryConvertedJoin + "WHERE pf.AD_PrintFormat_ID=? AND pfi.IsActive='Y' AND (pfi.IsPrinted='Y' OR c.IsKey='Y' OR pfi.SortNo > 0)  AND pfi.PrintFormatType IN ('" + "F" + "','" + "I" + "','" + "P" + "') ORDER BY pfi.IsPrinted DESC, pfi.SeqNo";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.m_trxName);
            pstmt.setInt(1, format.get_ID());
            rs = pstmt.executeQuery();
            this.m_synonym = "A";
            while (rs.next()) {
                String orderName;
                String functionColumn;
                int printFormatItemId = rs.getInt("AD_PrintFormatItem_ID");
                int columnId = rs.getInt("AD_Column_ID");
                String columnName = rs.getString("ColumnName");
                String columnSQL = rs.getString("ColumnSQL");
                if (columnSQL == null) {
                    columnSQL = "";
                }
                int referenceId = rs.getInt("AD_Reference_ID");
                int referenceValueId = rs.getInt("AD_Reference_Value_ID");
                int fieldLength = rs.getInt("FieldLength");
                boolean isMandatory = "Y".equals(rs.getString("IsMandatory"));
                boolean isKey = "Y".equals(rs.getString("IsKey"));
                boolean isGroupFunction = "Y".equals(rs.getString("IsGroupFunction"));
                if (isGroupFunction) {
                    IsGroupedBy = true;
                }
                if ((functionColumn = rs.getString("FunctionColumn")) == null) {
                    functionColumn = "";
                }
                if ("Y".equals(rs.getString("IsGroupBy"))) {
                    this.group.addGroupColumn(String.valueOf(printFormatItemId));
                }
                if ("Y".equals(rs.getString("IsSummarized"))) {
                    this.group.addFunction(String.valueOf(printFormatItemId), 'S');
                }
                if ("Y".equals(rs.getString("IsAveraged"))) {
                    this.group.addFunction(String.valueOf(printFormatItemId), 'A');
                }
                if ("Y".equals(rs.getString("IsCounted"))) {
                    this.group.addFunction(String.valueOf(printFormatItemId), 'C');
                }
                if ("Y".equals(rs.getString("IsMinCalc"))) {
                    this.group.addFunction(String.valueOf(printFormatItemId), 'm');
                }
                if ("Y".equals(rs.getString("IsMaxCalc"))) {
                    this.group.addFunction(String.valueOf(printFormatItemId), 'M');
                }
                if ("Y".equals(rs.getString("IsVarianceCalc"))) {
                    this.group.addFunction(String.valueOf(printFormatItemId), 'V');
                }
                if ("Y".equals(rs.getString("IsDeviationCalc"))) {
                    this.group.addFunction(String.valueOf(printFormatItemId), 'D');
                }
                if ("Y".equals(rs.getString("isRunningTotal"))) {
                    this.runningTotalLines = Math.max(this.runningTotalLines, rs.getInt("RunningTotalLines"));
                }
                if (columnName.equalsIgnoreCase("Line_ID") || columnName.equalsIgnoreCase("Record_ID")) {
                    isTableIDRequired = true;
                }
                if (columnName.equalsIgnoreCase("AD_Table_ID")) {
                    isTableIDPresent = true;
                }
                boolean IsPrinted = "Y".equals(rs.getString("IsPrinted"));
                int SortNo = rs.getInt(16);
                boolean isPageBreak = "Y".equals(rs.getString("IsPageBreak"));
                String formatPattern = rs.getString("FormatPattern");
                boolean isDesc = "Y".equals(rs.getString("isDesc"));
                boolean isHideGrandTotal = "Y".equals(rs.getString("IsHideGrandTotal"));
                boolean isConverted = false;
                if (isConvertedSupported) {
                    isConverted = "Y".equals(rs.getString("IsConvertedColumn"));
                }
                String lookupSQL = orderName = tableName + "." + columnName;
                PrintDataColumn pdc = null;
                int seqNo = rs.getInt("SeqNo");
                if (isConverted) {
                    columnSQL = "(" + tableName + "." + columnName + ")";
                }
                if (isConverted) {
                    String sourceColumnDocument = rs.getString("SourceColumnDocument");
                    String sourceColumnDate = rs.getString("SourceColumnDate");
                    String table = sourceColumnDocument;
                    if (table.endsWith("_ID")) {
                        table = table.substring(0, table.length() - 3);
                    }
                    String linkColumn = tableName + "." + sourceColumnDocument;
                    if (!sqlSELECT.equals(new StringBuffer("SELECT ")) || sqlConvert.length() > 0) {
                        sqlConvert.append(",");
                    }
                    sqlConvert.append(this.m_synonym).append(".").append("C_ConversionType_ID").append(" AS ").append("_").append(printFormatItemId).append("_C_ConversionType_ID").append(",").append(this.m_synonym).append(".").append(sourceColumnDate).append(" AS ").append("_").append(printFormatItemId).append("_ConversionDate").append(",").append(this.m_synonym).append(".").append("C_Currency_ID").append(" AS ").append("_").append(printFormatItemId).append("_C_Currency_ID").append(",").append(this.m_synonym).append(".").append("AD_Client_ID").append(" AS ").append("_").append(printFormatItemId).append("_AD_Client_ID").append(",").append(this.m_synonym).append(".").append("AD_Org_ID").append(" AS ").append("_").append(printFormatItemId).append("_AD_Org_ID");
                    groupByColumns.add(this.m_synonym + "C_ConversionType_ID");
                    groupByColumns.add(linkColumn);
                    orderName = this.m_synonym + "C_ConversionType_ID";
                    sqlFROM.append(" LEFT OUTER JOIN ");
                    sqlFROM.append(table).append(" ").append(this.m_synonym).append(" ON (").append(linkColumn).append("=").append(this.m_synonym).append(".").append(sourceColumnDocument).append(")");
                    this.synonymNext();
                }
                if (isKey && columnSQL.isEmpty()) {
                    sqlSELECT.append(tableName).append(".").append(columnName).append(",");
                    groupByColumns.add(tableName + "." + columnName);
                    pdc = new PrintDataColumn(columnId, columnName, referenceId, fieldLength, KEY, isPageBreak, printFormatItemId, isHideGrandTotal);
                } else if (IsPrinted) {
                    String display;
                    if (referenceId == 19 || referenceId == 30 && referenceValueId == 0) {
                        String eSql;
                        if (columnSQL.length() > 0) {
                            eSql = MLookupFactory.getLookup_TableDirEmbed(this.m_language, columnName, tableName, "(" + columnSQL + ")");
                            lookupSQL = columnSQL;
                        } else {
                            eSql = MLookupFactory.getLookup_TableDirEmbed(this.m_language, columnName, tableName);
                        }
                        String table = columnName;
                        if (table.endsWith("_ID")) {
                            table = table.substring(0, table.length() - 3);
                        }
                        display = columnName;
                        sqlSELECT.append("(").append(eSql).append(") AS ").append(this.m_synonym).append(display).append(",").append(lookupSQL).append(" AS ").append(columnName).append(",");
                        groupByColumns.add(lookupSQL);
                        orderName = this.m_synonym + display;
                        pdc = new PrintDataColumn(columnId, columnName, referenceId, fieldLength, orderName, isPageBreak, printFormatItemId, isHideGrandTotal);
                        this.synonymNext();
                    } else if (referenceId == 18 || referenceId == 30 && referenceValueId != 0) {
                        if (columnSQL.length() > 0) {
                            lookupSQL = columnSQL;
                        }
                        if (referenceValueId <= 0) {
                            log.warning(columnName + " - AD_Reference_Value_ID not set");
                            continue;
                        }
                        TableReference tr = DataEngine.getTableReference(referenceValueId);
                        String display2 = tr.DisplayColumn;
                        if (tr.IsValueDisplayed) {
                            sqlSELECT.append(this.m_synonym).append(".Value||'-'||");
                        }
                        sqlSELECT.append(this.m_synonym).append(".").append(display2);
                        sqlSELECT.append(" AS ").append(this.m_synonym).append(display2).append(",").append(lookupSQL).append(" AS ").append(columnName).append(",");
                        groupByColumns.add(this.m_synonym + display2);
                        groupByColumns.add(lookupSQL);
                        orderName = this.m_synonym + display2;
                        if (isMandatory) {
                            sqlFROM.append(" INNER JOIN ");
                        } else {
                            sqlFROM.append(" LEFT OUTER JOIN ");
                        }
                        sqlFROM.append(tr.TableName).append(" ").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=").append(this.m_synonym).append(".").append(tr.KeyColumn).append(")");
                        pdc = new PrintDataColumn(columnId, columnName, referenceId, fieldLength, orderName, isPageBreak, printFormatItemId, isHideGrandTotal);
                        this.synonymNext();
                    } else if (referenceId == 17 || referenceId == 28 && referenceValueId != 0) {
                        if (columnSQL.length() > 0) {
                            lookupSQL = columnSQL;
                        }
                        if (Env.isBaseLanguage(this.m_language, "AD_Ref_List")) {
                            sqlSELECT.append(this.m_synonym).append(".Name AS ").append(this.m_synonym).append("Name,");
                            groupByColumns.add(this.m_synonym + ".Name");
                            orderName = this.m_synonym + "Name";
                            if (isMandatory) {
                                sqlFROM.append(" INNER JOIN ");
                            } else {
                                sqlFROM.append(" LEFT OUTER JOIN ");
                            }
                            sqlFROM.append("AD_Ref_List ").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=").append(this.m_synonym).append(".Value").append(" AND ").append(this.m_synonym).append(".AD_Reference_ID=").append(referenceValueId).append(")");
                        } else {
                            sqlSELECT.append(this.m_synonym).append(".Name AS ").append(this.m_synonym).append("Name,");
                            groupByColumns.add(this.m_synonym + ".Name");
                            orderName = this.m_synonym + "Name";
                            if (isMandatory) {
                                sqlFROM.append(" INNER JOIN ");
                            } else {
                                sqlFROM.append(" LEFT OUTER JOIN ");
                            }
                            sqlFROM.append(" AD_Ref_List X").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=X").append(this.m_synonym).append(".Value AND X").append(this.m_synonym).append(".AD_Reference_ID=").append(referenceValueId).append(")");
                            if (isMandatory) {
                                sqlFROM.append(" INNER JOIN ");
                            } else {
                                sqlFROM.append(" LEFT OUTER JOIN ");
                            }
                            sqlFROM.append(" AD_Ref_List_Trl ").append(this.m_synonym).append(" ON (X").append(this.m_synonym).append(".AD_Ref_List_ID=").append(this.m_synonym).append(".AD_Ref_List_ID").append(" AND ").append(this.m_synonym).append(".AD_Language='").append(this.m_language.getAD_Language()).append("')");
                        }
                        sqlSELECT.append(lookupSQL).append(" AS ").append(columnName).append(",");
                        pdc = new PrintDataColumn(columnId, columnName, referenceId, fieldLength, orderName, isPageBreak, printFormatItemId, isHideGrandTotal);
                        this.synonymNext();
                    } else if (referenceId == 21 || referenceId == 25 || referenceId == 31 || referenceId == 35) {
                        if (columnSQL.length() > 0) {
                            lookupSQL = columnSQL;
                        }
                        String table = "";
                        String key = "";
                        display = "";
                        String synonym = null;
                        if (referenceId == 21) {
                            table = "C_Location";
                            key = "C_Location_ID";
                            display = "City||'.'";
                            synonym = "Address";
                        } else if (referenceId == 25) {
                            table = "C_ValidCombination";
                            key = "C_ValidCombination_ID";
                            display = "Combination";
                        } else if (referenceId == 31) {
                            table = "M_Locator";
                            key = "M_Locator_ID";
                            display = "Value";
                        } else if (referenceId == 35) {
                            table = "M_AttributeSetInstance";
                            key = "M_AttributeSetInstance_ID";
                            display = "Description";
                            if (CLogMgt.isLevelFine()) {
                                display = display + "||'{'||" + this.m_synonym + ".M_AttributeSetInstance_ID||'}'";
                            }
                            synonym = "Description";
                        }
                        if (synonym == null) {
                            synonym = display;
                        }
                        sqlSELECT.append(this.m_synonym).append(".").append(display).append(" AS ").append(this.m_synonym).append(synonym).append(",").append(lookupSQL).append(" AS ").append(columnName).append(",");
                        groupByColumns.add(this.m_synonym + "." + synonym);
                        groupByColumns.add(lookupSQL);
                        orderName = this.m_synonym + synonym;
                        if (isMandatory) {
                            sqlFROM.append(" INNER JOIN ");
                        } else {
                            sqlFROM.append(" LEFT OUTER JOIN ");
                        }
                        sqlFROM.append(table).append(" ").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=").append(this.m_synonym).append(".").append(key).append(")");
                        pdc = new PrintDataColumn(columnId, columnName, referenceId, fieldLength, orderName, isPageBreak, printFormatItemId, isHideGrandTotal);
                        this.synonymNext();
                    } else {
                        StringBuffer sb;
                        int index = functionColumn.indexOf(64);
                        if (columnSQL != null && columnSQL.length() > 0) {
                            columnName = this.m_synonym + columnName;
                            sqlSELECT.append("(").append(columnSQL).append(") AS ").append(columnName).append(",");
                            groupByColumns.add(lookupSQL);
                            this.synonymNext();
                        } else if (index == -1) {
                            sb = new StringBuffer();
                            sb.append(tableName).append(".").append(columnName);
                            sqlSELECT.append(sb).append(",");
                            if (!isGroupFunction) {
                                groupByColumns.add(sb.toString());
                            }
                        } else {
                            sb = new StringBuffer();
                            sb.append(functionColumn.substring(0, index)).append(tableName).append(".").append(columnName).append(functionColumn.substring(index + 1));
                            sqlSELECT.append(sb).append(" AS ").append(columnName).append(",");
                            if (!isGroupFunction) {
                                groupByColumns.add(sb.toString());
                            }
                            orderName = columnName;
                        }
                        pdc = new PrintDataColumn(columnId, columnName, referenceId, fieldLength, columnName, isPageBreak, printFormatItemId, isHideGrandTotal);
                    }
                }
                for (int i = 0; i < orderAD_Column_IDs.length; ++i) {
                    if (columnId != orderAD_Column_IDs[i]) continue;
                    if (isDesc) {
                        orderName = orderName + " DESC";
                    }
                    orderColumns.set(i, orderName);
                    if (IsPrinted || isGroupFunction) break;
                    groupByColumns.add(tableName + "." + columnName);
                    break;
                }
                if (pdc == null || !IsPrinted && !isKey) continue;
                pdc.setFormatPattern(formatPattern);
                pdc.setSortOrderIndex(SortNo);
                pdc.setDisplayOrderIndex(seqNo);
                columns.add(pdc);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, "SQL=" + sql + " - ID=" + format.get_ID(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (columns.size() == 0 && format.getJasperProcess_ID() == 0) {
            log.log(Level.SEVERE, "No Colums - Delete Report Format " + reportName + " and start again");
            log.finest("No Colums - SQL=" + sql + " - ID=" + format.get_ID());
            return null;
        }
        boolean hasLevelNo = false;
        if (tableName.startsWith("T_Report")) {
            hasLevelNo = true;
            if (sqlSELECT.indexOf("LevelNo") == -1) {
                sqlSELECT.append("LevelNo,");
            }
            if (tableName.equals("T_Report") && sqlSELECT.indexOf("PA_ReportLine_ID") == -1) {
                sqlSELECT.append("PA_ReportLine_ID,");
            }
        }
        if (isTableIDRequired && !isTableIDPresent) {
            sqlSELECT.append(tableName).append(".").append("AD_Table_ID").append(",");
        }
        StringBuffer finalSQL = new StringBuffer();
        finalSQL.append(sqlSELECT.substring(0, sqlSELECT.length() - 1)).append(sqlConvert).append(sqlFROM);
        if (tableName.startsWith("T_Report")) {
            finalSQL.append(" WHERE ");
            for (int i = 0; i < query.getRestrictionCount(); ++i) {
                q = query.getWhereClause(i);
                if (q.indexOf("AD_PInstance_ID") == -1) continue;
                finalSQL.append(q);
            }
        } else if (tableName.startsWith("AD_PInstance")) {
            finalSQL.append(" WHERE ");
            for (int i = 0; i < query.getRestrictionCount(); ++i) {
                q = query.getWhereClause(i);
                if (q.indexOf("AD_PInstance_ID") == -1) continue;
                q = q.substring(9);
                finalSQL.append(q);
            }
        } else {
            MRole role;
            if (query != null && query.isActive()) {
                finalSQL.append(" WHERE ");
                if (!query.getTableName().equals(tableName)) {
                    query.setTableName(tableName);
                }
                finalSQL.append(query.getWhereClause(true));
            }
            if ((role = MRole.getDefault(ctx, false)).getAD_Role_ID() != 0 || Ini.isClient()) {
                finalSQL = new StringBuffer(role.addAccessSQL(finalSQL.toString(), tableName, true, false));
            }
        }
        if (IsGroupedBy) {
            for (int i = 0; i < groupByColumns.size(); ++i) {
                if (i == 0) {
                    finalSQL.append(" GROUP BY ");
                } else {
                    finalSQL.append(",");
                }
                finalSQL.append((String)groupByColumns.get(i));
            }
        }
        if (orderColumns != null) {
            for (int i = 0; i < orderColumns.size(); ++i) {
                if (i == 0) {
                    finalSQL.append(" ORDER BY ");
                } else {
                    finalSQL.append(",");
                }
                String by = (String)orderColumns.get(i);
                if (by == null || by.length() == 0) {
                    by = String.valueOf(i + 1);
                }
                finalSQL.append(by);
            }
        }
        PrintData pd = new PrintData(ctx, reportName);
        PrintDataColumn[] info = new PrintDataColumn[columns.size()];
        columns.toArray(info);
        pd.setColumnInfo(info);
        pd.setTableName(tableName);
        pd.setSQL(finalSQL.toString());
        pd.setHasLevelNo(hasLevelNo);
        if (isTableIDRequired && !isTableIDPresent) {
            pd.setHasDummyTableID(true);
        }
        log.finest(finalSQL.toString());
        log.finest("Group=" + this.group);
        return pd;
    }

    private void synonymNext() {
        int length = this.m_synonym.length();
        char cc = this.m_synonym.charAt(0);
        if (cc == 'Z') {
            cc = 'A';
            ++length;
        } else {
            cc = (char)(cc + 1);
        }
        this.m_synonym = String.valueOf(cc);
        if (length == 1) {
            return;
        }
        this.m_synonym = this.m_synonym + String.valueOf(cc);
        if (length == 2) {
            return;
        }
        this.m_synonym = this.m_synonym + String.valueOf(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableReference getTableReference(int AD_Reference_Value_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        TableReference tr;
        block5: {
            if (AD_Reference_Value_ID <= 0) {
                throw new IllegalArgumentException("AD_Reference_Value_ID <= 0");
            }
            tr = new TableReference();
            String SQL = "SELECT t.TableName, ck.ColumnName AS KeyColumn, cd.ColumnName AS DisplayColumn, rt.IsValueDisplayed, cd.IsTranslated FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (rt.AD_Table_ID = t.AD_Table_ID) INNER JOIN AD_Column ck ON (rt.AD_Key = ck.AD_Column_ID) INNER JOIN AD_Column cd ON (rt.AD_Display = cd.AD_Column_ID) WHERE rt.AD_Reference_ID=? AND rt.IsActive = 'Y' AND t.IsActive = 'Y'";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(SQL, null);
                pstmt.setInt(1, AD_Reference_Value_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                tr.TableName = rs.getString(1);
                tr.KeyColumn = rs.getString(2);
                tr.DisplayColumn = rs.getString(3);
                tr.IsValueDisplayed = "Y".equals(rs.getString(4));
                tr.IsTranslated = "Y".equals(rs.getString(5));
            }
            catch (SQLException ex) {
                try {
                    log.log(Level.SEVERE, SQL, ex);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrintData(PrintData pd, MPrintFormat format) {
        ResultSet rs;
        CPreparedStatement pstmt;
        int levelNo;
        PrintDataColumn pdc;
        int rowNo;
        block48: {
            boolean translateSpool = pd.getTableName().equals("T_Spool");
            rowNo = 0;
            pdc = null;
            boolean hasLevelNo = pd.hasLevelNo();
            levelNo = 0;
            int reportLineId = 0;
            log.log(Level.FINE, "SQL: " + pd.getSQL());
            this.printData = pd;
            pstmt = null;
            rs = null;
            try {
                int firstColumn;
                pstmt = DB.prepareStatement(pd.getSQL(), this.m_trxName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (hasLevelNo) {
                        levelNo = rs.getInt("LevelNo");
                        if (pd.getTableName().equals("T_Report")) {
                            reportLineId = rs.getInt("PA_ReportLine_ID");
                        }
                    } else {
                        levelNo = 0;
                    }
                    if (this.group.getGroupColumnCount() > 1) {
                        firstColumn = this.getFirstColumnIndexInGroupOrder();
                        rowNo = this.checkGroupChange(firstColumn, pd, rs, false, levelNo, rowNo);
                    }
                    this.printRunningTotal(pd, levelNo, rowNo++);
                    if (!this.m_summary) {
                        pd.addRow(false, levelNo, reportLineId);
                    }
                    int counter = 1;
                    for (int i = 0; i < pd.getColumnInfo().length; ++i) {
                        pdc = pd.getColumnInfo()[i];
                        PrintDataElement pde = null;
                        if (pdc.getAlias().equals(KEY)) {
                            if (pdc.getColumnName().endsWith("_ID")) {
                                int id = rs.getInt(counter++);
                                if (!rs.wasNull()) {
                                    KeyNamePair pp = new KeyNamePair(id, KEY);
                                    pde = new PrintDataElement(pdc.getColumnName(), pp, pdc.getDisplayType(), true, pdc.isPageBreak(), pdc.getFormatPattern());
                                }
                            } else {
                                String id = rs.getString(counter++);
                                if (!rs.wasNull()) {
                                    ValueNamePair pp = new ValueNamePair(id, KEY);
                                    pde = new PrintDataElement(pdc.getColumnName(), pp, pdc.getDisplayType(), true, pdc.isPageBreak(), pdc.getFormatPattern());
                                }
                            }
                        } else if (pdc.hasAlias()) {
                            NamePair pp;
                            String display = rs.getString(counter++);
                            if (pdc.getColumnName().endsWith("_ID")) {
                                int id = rs.getInt(counter++);
                                if (display != null && !rs.wasNull()) {
                                    pp = new KeyNamePair(id, display);
                                    pde = new PrintDataElement(pdc.getColumnName(), pp, pdc.getDisplayType(), pdc.getFormatPattern());
                                }
                            } else {
                                String id = rs.getString(counter++);
                                if (display != null && !rs.wasNull()) {
                                    pp = new ValueNamePair(id, display);
                                    pde = new PrintDataElement(pdc.getColumnName(), pp, pdc.getDisplayType(), pdc.getFormatPattern());
                                }
                            }
                        } else {
                            String s;
                            MPrintFormatItem item = MPrintFormatItem.getById(Env.getCtx(), pdc.getPrinformatItemId(), null);
                            if (item.get_ValueAsBoolean("IsConvertedColumn") && (pdc.getDisplayType() == 22 || pdc.getDisplayType() == 37 || pdc.getDisplayType() == 29 || pdc.getDisplayType() == 12 || pdc.getDisplayType() == 22)) {
                                BigDecimal numberValue = rs.getBigDecimal(counter++);
                                pde = new ConversionElement(Env.getCtx(), pdc.getColumnName(), numberValue, item.get_ValueAsInt("C_ConversionType_ID") > 0 ? item.get_ValueAsInt("C_ConversionType_ID") : rs.getInt("_" + item.getAD_PrintFormatItem_ID() + "_C_ConversionType_ID"), rs.getInt("_" + item.getAD_PrintFormatItem_ID() + "_C_Currency_ID"), item.get_ValueAsInt("C_Currency_ID"), rs.getTimestamp("_" + item.getAD_PrintFormatItem_ID() + "_ConversionDate"), rs.getInt("_" + item.getAD_PrintFormatItem_ID() + "_AD_Client_ID"), rs.getInt("_" + item.getAD_PrintFormatItem_ID() + "_AD_Org_ID"), pdc.getFormatPattern());
                            } else if (pdc.getDisplayType() == 20) {
                                String displayAs = MSysConfig.getValue(REPORT_DISPLAY_YES_NO, "text", Env.getAD_Client_ID(pd.getCtx()));
                                s = rs.getString(counter++);
                                if (!rs.wasNull()) {
                                    Object value = null;
                                    boolean b = s.equals("Y");
                                    value = "symbol".equalsIgnoreCase(displayAs) ? (b ? "\u2714" : "\u2718") : ("image".equalsIgnoreCase(displayAs) ? Boolean.valueOf(b) : (b ? "Y" : "N"));
                                    pde = new PrintDataElement(pdc.getColumnName(), (Serializable)value, pdc.getDisplayType(), pdc.getFormatPattern());
                                }
                            } else if (pdc.getDisplayType() == 36) {
                                Clob clob;
                                String value = "";
                                if ("java.lang.String".equals(rs.getMetaData().getColumnClassName(counter))) {
                                    value = rs.getString(counter++);
                                } else if ((clob = rs.getClob(counter++)) != null) {
                                    long length = clob.length();
                                    value = clob.getSubString(1L, (int)length);
                                }
                                pde = new PrintDataElement(pdc.getColumnName(), (Serializable)((Object)value), pdc.getDisplayType(), pdc.getFormatPattern());
                            } else if (pdc.getDisplayType() == 16) {
                                Timestamp datetime = rs.getTimestamp(counter++);
                                pde = new PrintDataElement(pdc.getColumnName(), datetime, pdc.getDisplayType(), pdc.getFormatPattern());
                            } else {
                                Object obj;
                                if ((obj = rs.getObject(counter++)) != null && obj instanceof String && ((String)(obj = (String)obj)).length() == 0) {
                                    obj = null;
                                }
                                if (obj != null) {
                                    if (translateSpool && obj instanceof String) {
                                        s = (String)obj;
                                        s = Msg.parseTranslation(pd.getCtx(), s);
                                        pde = new PrintDataElement(pdc.getColumnName(), (Serializable)((Object)s), pdc.getDisplayType(), pdc.getFormatPattern());
                                    } else {
                                        pde = new PrintDataElement(pdc.getColumnName(), (Serializable)obj, pdc.getDisplayType(), pdc.getFormatPattern());
                                    }
                                }
                            }
                        }
                        if (pde == null) continue;
                        if (!this.m_summary) {
                            pd.addNode(pde);
                        }
                        this.group.addValue(String.valueOf(pdc.getPrinformatItemId()), pde.getFunctionValue());
                    }
                    if (!pd.isHasDummyTableID()) continue;
                    String tableID = rs.getString("AD_Table_ID");
                    pd.addNode(tableID);
                }
                if (this.group.getGroupColumnCount() <= 1) break block48;
                firstColumn = this.getFirstColumnIndexInGroupOrder();
                rowNo = this.checkGroupChange(firstColumn, pd, rs, true, levelNo, rowNo);
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, pdc + " - " + e.getMessage() + "\nSQL=" + pd.getSQL());
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.group.isGroupColumn("=TOTAL=")) {
            char[] functions = this.group.getFunctions("=TOTAL=");
            for (int f = 0; f < functions.length; ++f) {
                this.printRunningTotal(pd, levelNo, rowNo++);
                pd.addRow(true, levelNo);
                for (int c = 0; c < pd.getColumnInfo().length; ++c) {
                    pdc = pd.getColumnInfo()[c];
                    if (c == 0) {
                        String name = "";
                        name = !format.getTableFormat().isPrintFunctionSymbols() ? Msg.getMsg(format.getLanguage(), PrintDataFunction.getFunctionName(functions[f])) : PrintDataFunction.getFunctionSymbol(functions[f]);
                        pd.addNode(new PrintDataElement(pdc.getColumnName(), (Serializable)((Object)name.trim()), 10, pdc.getFormatPattern()));
                        continue;
                    }
                    if (!this.group.isFunctionColumn(String.valueOf(pdc.getPrinformatItemId()), functions[f]) || pdc.isHideGrandTotal()) continue;
                    pd.addNode(new PrintDataElement(pdc.getColumnName(), this.group.getValue("=TOTAL=", String.valueOf(pdc.getPrinformatItemId()), functions[f]), PrintDataFunction.getFunctionDisplayType(functions[f], pdc.getDisplayType()), pdc.getFormatPattern()));
                }
            }
        }
        if (pd.getRowCount() == 0) {
            if (CLogMgt.isLevelFiner()) {
                log.warning("NO Rows - ms=" + (System.currentTimeMillis() - this.m_startTime) + " - " + pd.getSQL());
            } else {
                log.warning("NO Rows - ms=" + (System.currentTimeMillis() - this.m_startTime));
            }
        } else {
            log.info("Rows=" + pd.getRowCount() + " - ms=" + (System.currentTimeMillis() - this.m_startTime));
        }
    }

    private void printRunningTotal(PrintData pd, int levelNo, int rowNo) {
        if (this.runningTotalLines < 1) {
            return;
        }
        log.fine("(" + this.runningTotalLines + ") - Row=" + rowNo + ", mod=" + rowNo % this.runningTotalLines);
        if (rowNo % this.runningTotalLines != 0) {
            return;
        }
        log.fine("Row=" + rowNo);
        PrintDataColumn pdc = null;
        int start = 0;
        if (rowNo == 0) {
            start = 1;
        }
        for (int rt = start; rt < 2; ++rt) {
            pd.addRow(true, levelNo);
            for (int c = 0; c < pd.getColumnInfo().length; ++c) {
                pdc = pd.getColumnInfo()[c];
                if (c == 0) {
                    String title = "RunningTotal";
                    pd.addNode(new PrintDataElement(pdc.getColumnName(), (Serializable)((Object)title), 10, false, rt == 0, pdc.getFormatPattern()));
                    continue;
                }
                if (!this.group.isFunctionColumn(String.valueOf(pdc.getPrinformatItemId()), 'S')) continue;
                pd.addNode(new PrintDataElement(pdc.getColumnName(), this.group.getValue("=TOTAL=", String.valueOf(pdc.getPrinformatItemId()), 'S'), PrintDataFunction.getFunctionDisplayType('S', pdc.getDisplayType()), false, false, pdc.getFormatPattern()));
            }
        }
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        DataEngine de = new DataEngine(Language.getLanguage("de_DE"));
        MQuery query = new MQuery();
        query.addRestriction("AD_Table_ID", "<", 105);
    }

    private int checkGroupChange(int columnIndex, PrintData pd, ResultSet rs, boolean forceChange, int levelNo, int rowNo) throws SQLException {
        if (columnIndex >= pd.getColumnInfo().length) {
            return rowNo;
        }
        PrintDataColumn group_pdc = pd.getColumnInfo()[columnIndex];
        PrintDataColumn pdc = null;
        if (!this.group.isGroupColumn(String.valueOf(group_pdc.getPrinformatItemId()))) {
            columnIndex = this.getNextColumnIndexInGroupOrder(columnIndex);
            return this.checkGroupChange(columnIndex, pd, rs, forceChange, levelNo, rowNo);
        }
        Object currentValue = new Object();
        if (!rs.isAfterLast()) {
            currentValue = rs.getObject(group_pdc.getAlias());
        }
        Object value = this.group.groupChange(String.valueOf(group_pdc.getPrinformatItemId()), currentValue);
        forceChange = forceChange || value != null;
        columnIndex = this.getNextColumnIndexInGroupOrder(columnIndex);
        rowNo = this.checkGroupChange(columnIndex, pd, rs, forceChange, levelNo, rowNo);
        if (forceChange) {
            char[] functions = this.group.getFunctions(String.valueOf(group_pdc.getPrinformatItemId()));
            for (int f = 0; f < functions.length; ++f) {
                this.printRunningTotal(pd, levelNo, rowNo++);
                pd.addRow(true, levelNo);
                int c = this.getFirstColumnIndexInGroupOrder();
                while (c < pd.getColumnInfo().length) {
                    pdc = pd.getColumnInfo()[c];
                    if (group_pdc.getPrinformatItemId() == pdc.getPrinformatItemId()) {
                        if (value == null) {
                            if (!rs.isAfterLast()) {
                                value = rs.getObject(group_pdc.getAlias());
                            }
                            if (value == null) {
                                value = "";
                            }
                        }
                        String valueString = value.toString();
                        if (value instanceof Timestamp) {
                            valueString = DisplayType.getDateFormat(pdc.getDisplayType(), this.m_language).format(value);
                        }
                        valueString = valueString + PrintDataFunction.getFunctionSymbol(functions[f]);
                        pd.addNode(new PrintDataElement(pdc.getColumnName(), (Serializable)((Object)valueString), 10, false, pdc.isPageBreak(), pdc.getFormatPattern()));
                    } else if (this.group.isFunctionColumn(String.valueOf(pdc.getPrinformatItemId()), functions[f])) {
                        pd.addNode(new PrintDataElement(pdc.getColumnName(), this.group.getValue(String.valueOf(group_pdc.getPrinformatItemId()), String.valueOf(pdc.getPrinformatItemId()), functions[f]), PrintDataFunction.getFunctionDisplayType(functions[f], pdc.getDisplayType()), false, pdc.isPageBreak(), pdc.getFormatPattern()));
                    }
                    c = this.getNextColumnIndexInGroupOrder(c);
                }
            }
            for (int c = 0; c < pd.getColumnInfo().length; ++c) {
                pdc = pd.getColumnInfo()[c];
                this.group.reset(String.valueOf(group_pdc.getPrinformatItemId()), String.valueOf(pdc.getPrinformatItemId()));
            }
        }
        return rowNo;
    }

    private int getNextColumnIndexInGroupOrder(int columnIndex) {
        if (this.printData == null) {
            return -1;
        }
        this.sortColumnsByGroupOrder();
        Integer nextColIndex = this.columnsSortedByGroupOrder.higherKey(new Integer(columnIndex));
        if (nextColIndex == null) {
            return this.printData.getColumnInfo().length;
        }
        return nextColIndex;
    }

    private int getPreviousColumnIndexInGroupOrder(int columnIndex) {
        if (this.printData == null) {
            return -1;
        }
        this.sortColumnsByGroupOrder();
        Integer prevColIndex = this.columnsSortedByGroupOrder.lowerKey(new Integer(columnIndex));
        if (prevColIndex == null) {
            return -1;
        }
        return prevColIndex;
    }

    private int getFirstColumnIndexInGroupOrder() {
        if (this.printData == null) {
            return -1;
        }
        this.sortColumnsByGroupOrder();
        Integer firstColIndex = this.columnsSortedByGroupOrder.firstKey();
        if (firstColIndex == null) {
            return 0;
        }
        return firstColIndex;
    }

    private int getLastColumnIndexInGroupOrder() {
        if (this.printData == null) {
            return -1;
        }
        this.sortColumnsByGroupOrder();
        return this.columnsSortedByGroupOrder.lastKey();
    }

    private void sortColumnsByGroupOrder() {
        if (this.printData == null || this.columnsSortedByGroupOrder != null) {
            return;
        }
        this.columnsSortedByGroupOrder = new TreeMap(new GroupOrderComparator(this.printData));
        for (int i = 0; i < this.printData.getColumnInfo().length; ++i) {
            this.columnsSortedByGroupOrder.put(new Integer(i), this.printData.getColumnInfo()[i]);
        }
    }
}

