/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.model.MStandardRequestType;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_R_StandardRequestType;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class RequestModelValidator
implements ModelValidator {
    private int clientId = -1;
    private static CLogger log = CLogger.getCLogger(RequestModelValidator.class);
    ModelValidationEngine modelValidationEngine = null;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        this.modelValidationEngine = engine;
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
    }

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        List<Object> standardRequestTypes = new ArrayList();
        standardRequestTypes = new Query(Env.getCtx(), "R_StandardRequestType", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("AD_Table_ID,C_DocType_ID").list();
        standardRequestTypes.stream().filter(standardRequestType -> standardRequestType.isValidFromTo() != false && standardRequestType.getEventModelValidator().startsWith("T")).collect(Collectors.groupingBy(X_R_StandardRequestType::getAD_Table_ID)).entrySet().stream().forEach(tableSet -> this.modelValidationEngine.addModelChange(MTable.getTableName(Env.getCtx(), (Integer)tableSet.getKey()), this));
        standardRequestTypes.stream().filter(standardRequestType -> standardRequestType.isValidFromTo() != false && standardRequestType.getEventModelValidator().startsWith("D")).collect(Collectors.groupingBy(X_R_StandardRequestType::getAD_Table_ID)).entrySet().stream().forEach(tableSet -> this.modelValidationEngine.addDocValidate(MTable.getTableName(Env.getCtx(), (Integer)tableSet.getKey()), this));
        return null;
    }

    @Override
    public String modelChange(PO entity, int type) throws Exception {
        MProjectTask projectTask;
        MProjectPhase projectPhase;
        if (MInvoice.Table_ID == entity.get_Table_ID() && 3 == type) {
            StringBuilder statement = new StringBuilder();
            statement.append("UPDATE R_RequestUpdate r SET C_InvoiceLine_ID = NULL WHERE ");
            statement.append("EXISTS (SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON (i.C_Invoice_ID=il.C_Invoice_ID) ");
            statement.append("WHERE i.DocStatus IN('DR','IP') AND i.C_Invoice_ID=? AND il.C_InvoiceLine_ID = r.C_InvoiceLine_ID)");
            DB.executeUpdate(statement.toString(), entity.get_ID(), entity.get_TrxName());
        }
        if (MProjectPhase.Table_ID == entity.get_Table_ID() && (projectPhase = (MProjectPhase)entity) != null && projectPhase.getC_Phase_ID() > 0) {
            MProjectTypePhase projectTypePhase = new MProjectTypePhase(projectPhase.getCtx(), projectPhase.getC_Phase_ID(), projectPhase.get_TrxName());
            MStandardRequestType.getByTable(entity).stream().filter(standardRequestType -> standardRequestType.get_ID() == projectTypePhase.getR_StandardRequestType_ID() && standardRequestType.getEventModelValidator().equals(tableEventValidators[type]) && standardRequestType.isValid(entity)).forEach(standardRequestType -> standardRequestType.createStandardRequest(entity));
            return "";
        }
        if (MProjectTask.Table_ID == entity.get_Table_ID() && (projectTask = (MProjectTask)entity) != null && projectTask.getC_Task_ID() > 0) {
            MProjectTypeTask projectTypeTask = new MProjectTypeTask(projectTask.getCtx(), projectTask.getC_Task_ID(), projectTask.get_TrxName());
            MStandardRequestType.getByTable(entity).stream().filter(standardRequestType -> standardRequestType.get_ID() == projectTypeTask.getR_StandardRequestType_ID() && standardRequestType.getEventModelValidator().equals(tableEventValidators[type]) && standardRequestType.isValid(entity)).forEach(standardRequestType -> standardRequestType.createStandardRequest(entity));
            return "";
        }
        MStandardRequestType.getByTable(entity).stream().filter(standardRequestType -> standardRequestType.getEventModelValidator().equals(tableEventValidators[type]) && standardRequestType.isValid(entity)).forEach(standardRequestType -> standardRequestType.createStandardRequest(entity));
        return null;
    }

    @Override
    public String docValidate(PO entity, int timing) {
        String documentStatus = entity.get_ValueAsString("DocStatus");
        int documentTypeId = entity.get_ValueAsInt("C_DocType_ID");
        MStandardRequestType.getByTable(entity).stream().filter(standardRequestType -> standardRequestType.getEventModelValidator().equals(documentEventValidators[timing]) && standardRequestType.isValidDocument(entity, documentTypeId, documentStatus)).forEach(standardRequestType -> standardRequestType.createStandardRequest(entity));
        return null;
    }
}

