/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.POInfoColumn;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class POInfo
implements Serializable {
    static final long serialVersionUID = -5976719579744948419L;
    private static CCache<Integer, POInfo> s_cache = new CCache("POInfo", 200);
    private static StringBuffer columnListCache = null;
    private Properties m_ctx = null;
    private int tableId = 0;
    private String tableName = null;
    private String accessLevel = "1";
    private POInfoColumn[] columns = null;
    private boolean hasKeyColumn = false;
    private boolean isChangeLog = false;
    private boolean isIgnoreMigration = false;
    private boolean isAllowCopy = false;
    private String keyColumnName = null;
    private static final CCache<String, POInfo> s_cacheByTableName = new CCache("POInfo_ByTableName", 200);

    public static POInfo getPOInfo(Properties ctx, int AD_Table_ID) {
        return POInfo.getPOInfo(ctx, AD_Table_ID, null);
    }

    public static POInfo getPOInfo(Properties ctx, int AD_Table_ID, String trxName) {
        Integer key = AD_Table_ID;
        POInfo retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new POInfo(ctx, AD_Table_ID, false, trxName);
            if (retValue.getColumnCount() == 0) {
                retValue = new POInfo(ctx, AD_Table_ID, true, trxName);
            } else {
                s_cache.put(key, retValue);
                s_cacheByTableName.put(retValue.getTableName(), retValue);
            }
        }
        return retValue;
    }

    private POInfo(Properties ctx, int AD_Table_ID, boolean baseLanguageOnly) {
        this(ctx, AD_Table_ID, baseLanguageOnly, null);
    }

    private POInfo(Properties ctx, int AD_Table_ID, boolean baseLanguageOnly, String trxName) {
        this.m_ctx = ctx;
        this.tableId = AD_Table_ID;
        boolean baseLanguage = baseLanguageOnly ? true : Env.isBaseLanguage(this.m_ctx, "AD_Table");
        this.loadInfo(baseLanguage, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInfo(boolean baseLanguage, String trxName) {
        ArrayList<POInfoColumn> list = new ArrayList<POInfoColumn>(15);
        StringBuffer sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            sql.append("SELECT ").append(this.getPOInfoColumnList());
            sql.append(" FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) INNER JOIN AD_Element");
            if (!baseLanguage) {
                sql.append("_Trl");
            }
            sql.append(" e  ON (c.AD_Element_ID=e.AD_Element_ID) WHERE t." + (this.tableId <= 0 ? "TableName=?" : "AD_Table_ID=?") + " AND c.IsActive='Y'");
            if (!baseLanguage) {
                sql.append(" AND e.AD_Language='").append(Env.getAD_Language(this.m_ctx)).append("'");
            }
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            if (this.tableId <= 0) {
                pstmt.setString(1, this.tableName);
            } else {
                pstmt.setInt(1, this.tableId);
            }
            rs = pstmt.executeQuery();
            if (rs.next()) {
                if (this.tableName == null) {
                    this.tableName = rs.getString(1);
                }
                if (this.tableId <= 0) {
                    this.tableId = rs.getInt("AD_Table_ID");
                }
                do {
                    String ColumnName = rs.getString(2);
                    int AD_Reference_ID = rs.getInt(3);
                    boolean IsMandatory = "Y".equals(rs.getString(4));
                    boolean IsUpdateable = "Y".equals(rs.getString(5));
                    String DefaultLogic = rs.getString(6);
                    String Name2 = rs.getString(7);
                    String Description = rs.getString(8);
                    int AD_Column_ID = rs.getInt(9);
                    boolean IsKey = "Y".equals(rs.getString(10));
                    if (IsKey) {
                        this.keyColumnName = this.hasKeyColumn ? null : ColumnName;
                    }
                    if (IsKey) {
                        this.hasKeyColumn = true;
                    }
                    boolean IsParent = "Y".equals(rs.getString(11));
                    int AD_Reference_Value_ID = rs.getInt(12);
                    String ValidationCode = rs.getString(13);
                    int FieldLength = rs.getInt(14);
                    String ValueMin = rs.getString(15);
                    String ValueMax = rs.getString(16);
                    boolean IsTranslated = "Y".equals(rs.getString(17));
                    this.accessLevel = rs.getString(18);
                    String ColumnSQL = rs.getString(19);
                    boolean IsEncrypted = "Y".equals(rs.getString(20));
                    boolean IsAllowLogging = "Y".equals(rs.getString(21));
                    this.isChangeLog = "Y".equals(rs.getString(22));
                    this.loadAdditionalAttributes(rs);
                    POInfoColumn col = new POInfoColumn(AD_Column_ID, ColumnName, ColumnSQL, AD_Reference_ID, IsMandatory, IsUpdateable, DefaultLogic, Name2, Description, IsKey, IsParent, AD_Reference_Value_ID, ValidationCode, FieldLength, ValueMin, ValueMax, IsTranslated, IsEncrypted, IsAllowLogging, this.isAllowCopy, trxName);
                    list.add(col);
                } while (rs.next());
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.columns = new POInfoColumn[list.size()];
        list.toArray(this.columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuffer getPOInfoColumnList() {
        StringBuffer extraColumns;
        String columnList;
        block20: {
            if (columnListCache != null && columnListCache.length() > 0) {
                return columnListCache;
            }
            columnList = "t.TableName, c.ColumnName, c.AD_Reference_ID,c.IsMandatory, c.IsUpdateable, c.DefaultValue,e.Name, e.Description, c.AD_Column_ID, c.IsKey, c.IsParent, c.AD_Reference_Value_ID, vr.Code, c.FieldLength, c.ValueMin, c.ValueMax, c.IsTranslated, t.AccessLevel, c.ColumnSQL, c.IsEncrypted, c.IsAllowLogging, t.IsChangeLog, t.AD_Table_ID";
            String columnListLC = columnList.toLowerCase();
            extraColumns = new StringBuffer();
            Object pstmt = null;
            ResultSet rs = null;
            Connection conn = null;
            try {
                String columnName;
                conn = DB.getConnectionRO();
                DatabaseMetaData md = conn.getMetaData();
                String catalog = DB.getDatabase().getCatalog();
                String schema = DB.getDatabase().getSchema();
                String tableName = "AD_Table";
                if (md.storesUpperCaseIdentifiers()) {
                    tableName = tableName.toUpperCase();
                } else if (md.storesLowerCaseIdentifiers()) {
                    tableName = tableName.toLowerCase();
                }
                rs = md.getColumns(catalog, schema, tableName, null);
                while (rs.next()) {
                    columnName = rs.getString("COLUMN_NAME");
                    if (columnListLC.contains("t." + columnName.toLowerCase())) continue;
                    extraColumns.append(", t." + columnName);
                }
                rs.close();
                rs = null;
                tableName = "AD_Column";
                if (md.storesUpperCaseIdentifiers()) {
                    tableName = tableName.toUpperCase();
                } else if (md.storesLowerCaseIdentifiers()) {
                    tableName = tableName.toLowerCase();
                }
                rs = md.getColumns(catalog, schema, tableName, null);
                while (rs.next()) {
                    columnName = rs.getString("COLUMN_NAME").toLowerCase();
                    if (columnListLC.contains("c." + columnName.toLowerCase())) continue;
                    extraColumns.append(", c." + columnName);
                }
                DB.close(rs, pstmt);
            }
            catch (SQLException e) {
                CLogger.get().log(Level.SEVERE, "Exception when trying to access metadata", e);
                break block20;
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                CLogger.get().log(Level.SEVERE, "Unable to close connection.", e);
            }
            rs = null;
            pstmt = null;
            conn = null;
            break block20;
            finally {
                DB.close(rs, pstmt);
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    CLogger.get().log(Level.SEVERE, "Unable to close connection.", e);
                }
                rs = null;
                pstmt = null;
                conn = null;
            }
        }
        columnListCache = new StringBuffer().append(columnList).append(extraColumns);
        return columnListCache;
    }

    public static void resetPOInfoColumnList() {
        columnListCache = null;
    }

    private void loadAdditionalAttributes(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i2 = 1; i2 <= rsmd.getColumnCount(); ++i2) {
            String value;
            String columnName = rsmd.getColumnName(i2);
            if (columnName.equalsIgnoreCase("IsIgnoreMigration")) {
                value = rs.getString(i2);
                this.isIgnoreMigration = value != null && value.equals("Y");
                continue;
            }
            if (!columnName.equalsIgnoreCase("IsAllowCopy")) continue;
            value = rs.getString(i2);
            this.isAllowCopy = value != null && value.equals("Y");
        }
    }

    public String toString() {
        return "POInfo[" + this.getTableName() + ",AD_Table_ID=" + this.getAD_Table_ID() + "]";
    }

    public String toString(int index) {
        if (index < 0 || index >= this.columns.length) {
            return "POInfo[" + this.getTableName() + "-(InvalidColumnIndex=" + index + ")]";
        }
        return "POInfo[" + this.getTableName() + "-" + this.columns[index].toString() + "]";
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getAD_Table_ID() {
        return this.tableId;
    }

    public boolean isIgnoreMigration() {
        return this.isIgnoreMigration;
    }

    public boolean hasKeyColumn() {
        return this.hasKeyColumn;
    }

    public String getAccessLevel() {
        return this.accessLevel;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public int getColumnIndex(String ColumnName) {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            if (!ColumnName.equalsIgnoreCase(this.columns[i2].ColumnName)) continue;
            return i2;
        }
        return -1;
    }

    public int getColumnIndex(int AD_Column_ID) {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            if (AD_Column_ID != this.columns[i2].AD_Column_ID) continue;
            return i2;
        }
        return -1;
    }

    public int getAD_Column_ID(String columnName) {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            if (!columnName.equalsIgnoreCase(this.columns[i2].ColumnName)) continue;
            return this.columns[i2].AD_Column_ID;
        }
        return -1;
    }

    public POInfoColumn getColumn(int index) {
        if (index < 0 || index >= this.columns.length) {
            return null;
        }
        return this.columns[index];
    }

    public String getColumnName(int index) {
        if (index < 0 || index >= this.columns.length) {
            return null;
        }
        return this.columns[index].ColumnName;
    }

    public String getColumnSQL(int index) {
        if (index < 0 || index >= this.columns.length) {
            return null;
        }
        if (this.columns[index].ColumnSQL != null && this.columns[index].ColumnSQL.length() > 0) {
            return this.columns[index].ColumnSQL + " AS " + this.columns[index].ColumnName;
        }
        return this.columns[index].ColumnName;
    }

    public boolean isVirtualColumn(int index) {
        if (index < 0 || index >= this.columns.length) {
            return true;
        }
        return this.columns[index].ColumnSQL != null && this.columns[index].ColumnSQL.length() > 0;
    }

    public String getColumnLabel(int index) {
        if (index < 0 || index >= this.columns.length) {
            return null;
        }
        return this.columns[index].ColumnLabel;
    }

    public String getColumnDescription(int index) {
        if (index < 0 || index >= this.columns.length) {
            return null;
        }
        return this.columns[index].ColumnDescription;
    }

    public Class<?> getColumnClass(int index) {
        if (index < 0 || index >= this.columns.length) {
            return null;
        }
        return this.columns[index].ColumnClass;
    }

    public int getColumnDisplayType(int index) {
        if (index < 0 || index >= this.columns.length) {
            return 10;
        }
        return this.columns[index].DisplayType;
    }

    public String getDefaultLogic(int index) {
        if (index < 0 || index >= this.columns.length) {
            return null;
        }
        return this.columns[index].DefaultLogic;
    }

    public boolean isColumnMandatory(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsMandatory;
    }

    public int getColumnReferenceValueId(int index) {
        if (index < 0 || index >= this.columns.length) {
            return -1;
        }
        return this.columns[index].AD_Reference_Value_ID;
    }

    public boolean isColumnUpdateable(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsUpdateable;
    }

    public void setColumnUpdateable(int index, boolean updateable) {
        if (index < 0 || index >= this.columns.length) {
            return;
        }
        this.columns[index].IsUpdateable = updateable;
    }

    public void setUpdateable(boolean updateable) {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            this.columns[i2].IsUpdateable = updateable;
        }
    }

    public boolean isColumnLookup(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return DisplayType.isLookup(this.columns[index].DisplayType);
    }

    public Lookup getColumnLookup(int index) {
        if (!this.isColumnLookup(index)) {
            return null;
        }
        int WindowNo = 0;
        MLookup lookup = null;
        try {
            lookup = MLookupFactory.get(this.m_ctx, WindowNo, this.columns[index].AD_Column_ID, this.columns[index].DisplayType, Env.getLanguage(this.m_ctx), this.columns[index].ColumnName, this.columns[index].AD_Reference_Value_ID, this.columns[index].IsParent, this.columns[index].ValidationCode);
        }
        catch (Exception e) {
            lookup = null;
        }
        return lookup;
    }

    public boolean isKey(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsKey;
    }

    public boolean isColumnParent(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsParent;
    }

    public boolean isColumnTranslated(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsTranslated;
    }

    public boolean isTranslated() {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            if (!this.columns[i2].IsTranslated) continue;
            return true;
        }
        return false;
    }

    public boolean isEncrypted(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsEncrypted;
    }

    public boolean isAllowLogging(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsAllowLogging;
    }

    public boolean isAllowCopy(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsAllowCopy;
    }

    public int getFieldLength(int index) {
        if (index < 0 || index >= this.columns.length) {
            return 0;
        }
        return this.columns[index].FieldLength;
    }

    public int getFieldLength(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index >= 0) {
            return this.getFieldLength(index);
        }
        return 0;
    }

    public String validate(int index, Object value) {
        BigDecimal value_BD;
        if (index < 0 || index >= this.columns.length) {
            return "RangeError";
        }
        if (this.columns[index].IsMandatory && value == null) {
            return "IsMandatory";
        }
        if (value == null) {
            return null;
        }
        if (this.columns[index].ValueMin != null) {
            int comp;
            value_BD = null;
            try {
                if (this.columns[index].ValueMin_BD != null) {
                    value_BD = new BigDecimal(value.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.columns[index].ValueMin_BD != null && value_BD != null) {
                comp = this.columns[index].ValueMin_BD.compareTo(value_BD);
                if (comp > 0) {
                    return "MinValue=" + this.columns[index].ValueMin_BD + "(" + this.columns[index].ValueMin + ") - compared with Numeric Value=" + value_BD + "(" + value + ") - results in " + comp;
                }
            } else {
                comp = this.columns[index].ValueMin.compareTo(value.toString());
                if (comp > 0) {
                    return "MinValue=" + this.columns[index].ValueMin + " - compared with String Value=" + value + " - results in " + comp;
                }
            }
        }
        if (this.columns[index].ValueMax != null) {
            value_BD = null;
            try {
                if (this.columns[index].ValueMax_BD != null) {
                    value_BD = new BigDecimal(value.toString());
                }
            }
            catch (Exception comp) {
                // empty catch block
            }
            if (this.columns[index].ValueMax_BD != null && value_BD != null) {
                int comp = this.columns[index].ValueMax_BD.compareTo(value_BD);
                if (comp < 0) {
                    return "MaxValue=" + this.columns[index].ValueMax_BD + "(" + this.columns[index].ValueMax + ") - compared with Numeric Value=" + value_BD + "(" + value + ") - results in " + comp;
                }
            } else {
                int comp = this.columns[index].ValueMax.compareTo(value.toString());
                if (comp < 0) {
                    return "MaxValue=" + this.columns[index].ValueMax + " - compared with String Value=" + value + " - results in " + comp;
                }
            }
        }
        return null;
    }

    public boolean isLazyLoading(int index) {
        if (index < 0 || index >= this.columns.length) {
            return true;
        }
        return this.isVirtualColumn(index) && this.columns[index].IsLazyLoading;
    }

    public StringBuffer buildSelect() {
        StringBuffer sql = new StringBuffer();
        int size = this.getColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.isLazyLoading(i2)) continue;
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append(this.getColumnSQL(i2));
        }
        sql.insert(0, "SELECT ");
        sql.append(" FROM ").append(this.getTableName());
        return sql;
    }

    public boolean isChangeLog() {
        return this.isChangeLog;
    }

    public boolean isCalculated(int index) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        return this.columns[index].IsCalculated;
    }

    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    public static void removeFromCache(String tableName) {
        POInfo cachedValue = s_cacheByTableName.get(tableName);
        if (cachedValue == null) {
            return;
        }
        s_cacheByTableName.remove(tableName);
        s_cache.remove(cachedValue.getAD_Table_ID());
    }

    public static void removeFromCache(int AD_Table_ID) {
        POInfo cachedValue = s_cache.get(AD_Table_ID);
        if (cachedValue == null) {
            return;
        }
        s_cache.remove(AD_Table_ID);
        s_cacheByTableName.remove(cachedValue.getTableName());
    }

    public static POInfo getPOInfo(Properties ctx, String tableName) {
        return POInfo.getPOInfo(ctx, tableName, null);
    }

    public static POInfo getPOInfo(Properties ctx, String tableName, String trxName) {
        POInfo retValue = s_cacheByTableName.get(tableName);
        if (retValue == null) {
            retValue = new POInfo(ctx, tableName, false, trxName);
            if (retValue.getColumnCount() == 0) {
                retValue = new POInfo(ctx, tableName, true, trxName);
            } else {
                s_cache.put(retValue.getAD_Table_ID(), retValue);
                s_cacheByTableName.put(retValue.getTableName(), retValue);
            }
        }
        return retValue;
    }

    public int getAccessLevelInt() {
        return Integer.parseInt(this.accessLevel);
    }

    private POInfo(Properties ctx, String tableName, boolean baseLanguageOnly, String trxName) {
        this.m_ctx = ctx;
        this.tableName = tableName;
        boolean baseLanguage = baseLanguageOnly ? true : Env.isBaseLanguage(this.m_ctx, "AD_Table");
        this.loadInfo(baseLanguage, trxName);
    }
}

