/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MField;
import org.compiere.model.MFieldCustom;
import org.compiere.model.MTab;
import org.compiere.model.MWindowCustom;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_TabCustom;
import org.compiere.util.Util;

public class MTabCustom
extends X_AD_TabCustom {
    private static final long serialVersionUID = -7788247772367181508L;

    public MTabCustom(Properties ctx, int AD_TabCustom_ID, String trxName) {
        super(ctx, AD_TabCustom_ID, trxName);
    }

    public MTabCustom(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTabCustom(MWindowCustom customWindow) {
        this(customWindow.getCtx(), 0, customWindow.get_TrxName());
        this.setAD_WindowCustom_ID(customWindow.getAD_WindowCustom_ID());
    }

    @Override
    public void setAD_Tab_ID(int tabId) {
        super.setAD_Tab_ID(tabId);
        if (tabId > 0) {
            MTab tab = new MTab(this.getCtx(), tabId, this.get_TrxName());
            this.setIsActive(tab.isActive());
            this.setSeqNo(tab.getSeqNo());
            this.setTabLevel(tab.getTabLevel());
        }
    }

    public void overwriteValuesFromCustomTab(MTabCustom customTab) {
        if (this.getAD_TabCustom_ID() == 0) {
            throw new AdempiereException("Use default constructor based on other custom field");
        }
        int tabId = this.getAD_Tab_ID();
        int customWindowId = this.getAD_WindowCustom_ID();
        PO.copyValues(customTab, this);
        this.setIsActive(customTab.isActive());
        this.set_ValueNoCheck("AD_WindowCustom_ID", customWindowId);
        this.set_ValueNoCheck("AD_Tab_ID", tabId);
    }

    public List<MFieldCustom> getFields() {
        return new Query(this.getCtx(), "AD_FieldCustom", "AD_TabCustom_ID = ?", this.get_TrxName()).setParameters(this.getAD_TabCustom_ID()).setOnlyActiveRecords(true).list();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && this.getAD_WindowCustom_ID() > 0 && this.getAD_Tab_ID() > 0) {
            Optional.ofNullable(this.getAD_WindowCustom()).ifPresent(customWindow -> {
                if (!Util.isEmpty(customWindow.getHierarchyType()) && customWindow.getHierarchyType().equals("O")) {
                    Arrays.asList(MTab.get(this.getCtx(), this.getAD_Tab_ID()).getFields(true, this.get_TrxName())).forEach(field -> {
                        MFieldCustom customField = new MFieldCustom(this);
                        customField.setField((MField)field);
                        customField.saveEx();
                    });
                }
            });
        }
        return super.afterSave(newRecord, success);
    }

    @Override
    public String toString() {
        return "MTabCustom [getAD_TabCustom_ID()=" + this.getAD_TabCustom_ID() + ", getAD_Tab_ID()=" + this.getAD_Tab_ID() + "]";
    }
}

