/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MAccount;
import org.compiere.model.MTree;
import org.compiere.model.Query;
import org.compiere.model.X_C_SalesRegion;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MSalesRegion
extends X_C_SalesRegion {
    private static final long serialVersionUID = 8582026748675153489L;
    private static CCache<Integer, MSalesRegion> salesRegionCacheIds = new CCache("C_SalesRegion", 30);
    private static CCache<String, MSalesRegion> salesRegionCacheValues = new CCache("C_SalesRegion", 30);

    @Deprecated
    public static MSalesRegion get(Properties ctx, int salesRegionId) {
        return MSalesRegion.getById(ctx, salesRegionId, null);
    }

    public static MSalesRegion getById(Properties ctx, int salesRegionId, String trxName) {
        if (salesRegionId <= 0) {
            return null;
        }
        MSalesRegion salesRegion = salesRegionCacheIds.get(salesRegionId);
        if (salesRegion != null && salesRegion.get_ID() > 0) {
            return salesRegion;
        }
        salesRegion = (MSalesRegion)new Query(ctx, "C_SalesRegion", "C_SalesRegion_ID=?", trxName).setClient_ID().setParameters(salesRegionId).first();
        if (salesRegion != null && salesRegion.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID(ctx);
            String key = clientId + "#" + salesRegion.getValue();
            salesRegionCacheValues.put(key, salesRegion);
            salesRegionCacheIds.put(salesRegion.get_ID(), salesRegion);
        }
        return salesRegion;
    }

    public static MSalesRegion getByValue(Properties ctx, String salesRegionValue, String trxName) {
        int clientId;
        String key;
        MSalesRegion salesRegion;
        if (salesRegionValue == null) {
            return null;
        }
        if (salesRegionCacheValues.size() == 0) {
            MSalesRegion.getAll(ctx, true, trxName);
        }
        if ((salesRegion = salesRegionCacheValues.get(key = (clientId = Env.getAD_Client_ID(ctx)) + "#" + salesRegionValue)) != null && salesRegion.get_ID() > 0) {
            return salesRegion;
        }
        salesRegion = (MSalesRegion)new Query(ctx, "C_SalesRegion", "Value=?", trxName).setClient_ID().setParameters(salesRegionValue).first();
        if (salesRegion != null && salesRegion.get_ID() > 0) {
            salesRegionCacheValues.put(key, salesRegion);
            salesRegionCacheIds.put(salesRegion.get_ID(), salesRegion);
        }
        return salesRegion;
    }

    public static List<MSalesRegion> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || salesRegionCacheIds.size() > 0) {
            List<MSalesRegion> salesRegionList = new Query(Env.getCtx(), "C_SalesRegion", null, trxName).setClient_ID().setOrderBy("Name").list();
            salesRegionList.stream().forEach(salesRegion -> {
                int clientId = Env.getAD_Client_ID(ctx);
                String key = clientId + "#" + salesRegion.getValue();
                salesRegionCacheIds.put(salesRegion.getC_SalesRegion_ID(), (MSalesRegion)salesRegion);
                salesRegionCacheValues.put(key, (MSalesRegion)salesRegion);
            });
            return salesRegionList;
        }
        List<MSalesRegion> salesRegionList = salesRegionCacheIds.entrySet().stream().map(salesRegion -> (MSalesRegion)salesRegion.getValue()).collect(Collectors.toList());
        return salesRegionList;
    }

    public MSalesRegion(Properties ctx, int C_SalesRegion_ID, String trxName) {
        super(ctx, C_SalesRegion_ID, trxName);
    }

    public MSalesRegion(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "C_SalesRegion_ID=" + this.getC_SalesRegion_ID(), this.get_TrxName());
        }
        this.setSalesRep(this);
        return true;
    }

    private void setSalesRep(MSalesRegion parent) {
        int[] ids;
        if (!parent.isSummary()) {
            return;
        }
        int treeId = MTree.getDefaultTreeIdFromTableId(this.getAD_Client_ID(), this.get_Table_ID());
        String sql = "SELECT tn.Node_ID AS C_SalesRegion_ID FROM AD_Tree t INNER JOIN AD_TreeNode tn ON t.AD_Tree_ID = tn.AD_Tree_ID WHERE t.AD_Tree_ID=? AND tn.Parent_ID =?";
        for (int salesRegionId : ids = DB.getIDsEx(this.get_TrxName(), "SELECT tn.Node_ID AS C_SalesRegion_ID FROM AD_Tree t INNER JOIN AD_TreeNode tn ON t.AD_Tree_ID = tn.AD_Tree_ID WHERE t.AD_Tree_ID=? AND tn.Parent_ID =?", treeId, parent.getC_SalesRegion_ID())) {
            MSalesRegion salesRegion = new MSalesRegion(this.getCtx(), salesRegionId, this.get_TrxName());
            if (salesRegion.getC_SalesRegion_ID() == 0) continue;
            salesRegion.setSalesRep_ID(parent.getSalesRep_ID());
            salesRegion.saveEx();
            if (!salesRegion.isSummary()) continue;
            this.setSalesRep(salesRegion);
        }
    }
}

