/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Rule;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MRule
extends X_AD_Rule {
    private static final long serialVersionUID = -9166262780531877045L;
    public static final String GLOBAL_CONTEXT_PREFIX = "G_";
    public static final String WINDOW_CONTEXT_PREFIX = "W_";
    public static final String ARGUMENTS_PREFIX = "A_";
    public static final String PARAMETERS_PREFIX = "P_";
    public static final String SCRIPT_PREFIX = "@script:";
    private static CCache<Integer, MRule> s_cache = new CCache("AD_Rule", 100);
    private static CLogger s_log = CLogger.getCLogger(MRule.class);
    private ScriptEngineManager factory = null;
    ScriptEngine engine = null;

    public static MRule get(Properties ctx, int AD_Rule_ID) {
        Integer key = new Integer(AD_Rule_ID);
        MRule retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MRule(ctx, AD_Rule_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MRule get(Properties ctx, String ruleValue) {
        if (ruleValue == null) {
            return null;
        }
        for (MRule retValue : s_cache.values()) {
            if (!ruleValue.equals(retValue.getValue())) continue;
            return retValue;
        }
        String whereClause = "Value=?";
        MRule retValue = (MRule)new Query(ctx, "AD_Rule", "Value=?", null).setParameters(ruleValue).setOnlyActiveRecords(true).first();
        if (retValue != null) {
            Integer key = new Integer(retValue.getAD_Rule_ID());
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static List<MRule> getModelValidatorLoginRules(Properties ctx) {
        String whereClause = "EventType=?";
        return new Query(ctx, "AD_Rule", "EventType=?", null).setParameters("L").setOnlyActiveRecords(true).list();
    }

    public MRule(Properties ctx, int AD_Rule_ID, String trxName) {
        super(ctx, AD_Rule_ID, trxName);
    }

    public MRule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String engineName;
        if (this.getRuleType().equals("S") && ((engineName = this.getEngineName()) == null || !engineName.equalsIgnoreCase("groovy") && !engineName.equalsIgnoreCase("jython") && !engineName.equalsIgnoreCase("beanshell"))) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "WrongScriptValue"));
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRule[");
        sb.append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    public ScriptEngine getScriptEngine() {
        this.factory = new ScriptEngineManager();
        String engineName = this.getEngineName();
        if (engineName != null) {
            this.engine = this.factory.getEngineByName(engineName);
        }
        return this.engine;
    }

    public String getEngineName() {
        int colonPosition = this.getValue().indexOf(":");
        if (colonPosition < 0) {
            return null;
        }
        return this.getValue().substring(0, colonPosition);
    }

    public static void setContext(ScriptEngine engine, Properties ctx, int windowNo) {
        Enumeration<Object> en = ctx.keys();
        while (en.hasMoreElements()) {
            Object value;
            String key = en.nextElement().toString();
            if (key == null || key.length() == 0 || key.startsWith("P") || key.indexOf(124) != -1 && !key.startsWith(String.valueOf(windowNo)) || key.indexOf(124) != -1 && key.indexOf(124) != key.lastIndexOf(124) || (value = ctx.get(key)) == null) continue;
            if (value instanceof Boolean) {
                engine.put(MRule.convertKey(key, windowNo), (boolean)((Boolean)value));
                continue;
            }
            if (value instanceof Integer) {
                engine.put(MRule.convertKey(key, windowNo), (int)((Integer)value));
                continue;
            }
            if (value instanceof Double) {
                engine.put(MRule.convertKey(key, windowNo), (double)((Double)value));
                continue;
            }
            engine.put(MRule.convertKey(key, windowNo), value);
        }
    }

    public static String convertKey(String key, int m_windowNo) {
        String k = m_windowNo + "|";
        if (key.startsWith(k)) {
            String retValue = WINDOW_CONTEXT_PREFIX + key.substring(k.length());
            retValue = Util.replace(retValue, "|", "_");
            return retValue;
        }
        String retValue = null;
        retValue = key.startsWith("#") ? GLOBAL_CONTEXT_PREFIX + key.substring(1) : key;
        retValue = Util.replace(retValue, "#", "_");
        return retValue;
    }
}

