/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.I_C_ProjectPhase;
import org.compiere.model.I_C_ProjectTask;
import org.compiere.model.MBPGroup;
import org.compiere.model.MBPartner;
import org.compiere.model.MChangeRequest;
import org.compiere.model.MClient;
import org.compiere.model.MGroup;
import org.compiere.model.MMailText;
import org.compiere.model.MNote;
import org.compiere.model.MRefList;
import org.compiere.model.MRequestAction;
import org.compiere.model.MRequestCategory;
import org.compiere.model.MRequestType;
import org.compiere.model.MRequestUpdate;
import org.compiere.model.MResolution;
import org.compiere.model.MStatus;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_R_Request;
import org.compiere.model.X_R_Status;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.model.MRNoticeTemplate;

public class MRequest
extends X_R_Request {
    private static final long serialVersionUID = -6049674214655497548L;
    private static CLogger s_log = CLogger.getCLogger(MRequest.class);
    private static final String TAG_START = "[Req#";
    private static final String TAG_END = "#ID]";
    private MRequestType requestType = null;
    private boolean m_changed = false;
    private MBPartner m_partner = null;
    private MUser m_user = null;
    private StringBuffer m_emailTo = new StringBuffer();
    public static final String SEPARATOR = "\n---------.----------.----------.----------.----------.----------\n";

    public static int getR_Request_ID(String mailText) {
        if (mailText == null) {
            return 0;
        }
        int indexStart = mailText.indexOf(TAG_START);
        if (indexStart == -1) {
            return 0;
        }
        int indexEnd = mailText.indexOf(TAG_END, indexStart);
        if (indexEnd == -1) {
            return 0;
        }
        String idString = mailText.substring(indexStart += 5, indexEnd);
        int R_Request_ID = 0;
        try {
            R_Request_ID = Integer.parseInt(idString);
        }
        catch (Exception e) {
            s_log.severe("Cannot parse " + idString);
        }
        return R_Request_ID;
    }

    public MRequest(Properties ctx, int R_Request_ID, String trxName) {
        super(ctx, R_Request_ID, trxName);
        if (R_Request_ID == 0) {
            this.setDueType("5");
            this.setConfidentialType("A");
            this.setConfidentialTypeEntry("A");
            this.setProcessed(false);
            this.setRequestAmt(Env.ZERO);
            this.setPriorityUser("7");
            this.setIsEscalated(false);
            this.setIsSelfService(false);
            this.setIsInvoiced(false);
        }
    }

    public MRequest(Properties ctx, int SalesRep_ID, int R_RequestType_ID, String Summary, boolean isSelfService, String trxName) {
        this(ctx, 0, trxName);
        String ct;
        this.set_Value("SalesRep_ID", (Object)new Integer(SalesRep_ID));
        this.set_Value("R_RequestType_ID", (Object)new Integer(R_RequestType_ID));
        this.setSummary(Summary);
        this.setIsSelfService(isSelfService);
        if (this.getRequestType() != null && (ct = this.getRequestType().getConfidentialType()) != null) {
            this.setConfidentialType(ct);
            this.setConfidentialTypeEntry(ct);
        }
    }

    public MRequest(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setR_RequestType_ID() {
        this.requestType = MRequestType.getDefault(this.getCtx());
        if (this.requestType == null) {
            this.log.warning("No default found");
        } else {
            super.setR_RequestType_ID(this.requestType.getR_RequestType_ID());
        }
    }

    public void setR_Status_ID() {
        MStatus status = MStatus.getDefault(this.getCtx(), this.getR_RequestType_ID());
        if (status == null) {
            this.log.warning("No default found");
            if (this.getR_Status_ID() != 0) {
                this.setR_Status_ID(0);
            }
        } else {
            this.setR_Status_ID(status.getR_Status_ID());
        }
    }

    public void addToResult(String Result2) {
        String oldResult = this.getResult();
        if (Result2 != null && Result2.length() != 0) {
            if (oldResult == null || oldResult.length() == 0) {
                this.setResult(Result2);
            } else {
                this.setResult(oldResult + "\n-\n" + Result2);
            }
        }
    }

    public void setDueType() {
        Timestamp due = this.getDateNextAction();
        if (due == null) {
            return;
        }
        Timestamp overdue = TimeUtil.addDays(due, this.getRequestType().getDueDateTolerance());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String DueType = "5";
        if (now.before(due)) {
            DueType = "7";
        } else if (now.after(overdue)) {
            DueType = "3";
        }
        super.setDueType(DueType);
    }

    public MRequestAction[] getActions() {
        String whereClause = "R_Request_ID=?";
        List<MRequestAction> list = new Query(this.getCtx(), "R_RequestAction", "R_Request_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("Created DESC").list();
        return list.toArray(new MRequestAction[list.size()]);
    }

    public MRequestUpdate[] getUpdates(String confidentialType) {
        String whereClause = "R_Request_ID=?";
        List listUpdates = new Query(this.getCtx(), "R_RequestUpdate", "R_Request_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("Created DESC").list();
        ArrayList<MRequestUpdate> list = new ArrayList<MRequestUpdate>();
        for (MRequestUpdate ru : listUpdates) {
            if (confidentialType != null && (ru.getConfidentialTypeEntry().equals("P") && !confidentialType.equals("P") || ru.getConfidentialTypeEntry().equals("I") && (confidentialType.equals("C") || confidentialType.equals("A")) || ru.getConfidentialTypeEntry().equals("C") && confidentialType.equals("A"))) continue;
            list.add(ru);
        }
        MRequestUpdate[] retValue = new MRequestUpdate[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRequestUpdate[] getUpdatesPublic() {
        return this.getUpdates("A");
    }

    public MRequestUpdate[] getUpdatesCustomer() {
        return this.getUpdates("C");
    }

    public MRequestUpdate[] getUpdatesInternal() {
        return this.getUpdates("I");
    }

    public MRequestType getRequestType() {
        if (this.requestType == null) {
            int R_RequestType_ID = this.getR_RequestType_ID();
            if (R_RequestType_ID == 0) {
                this.setR_RequestType_ID();
                R_RequestType_ID = this.getR_RequestType_ID();
            }
            this.requestType = MRequestType.get(this.getCtx(), R_RequestType_ID);
        }
        return this.requestType;
    }

    public String getRequestTypeName() {
        if (this.requestType == null) {
            this.getRequestType();
        }
        if (this.requestType == null) {
            return "??";
        }
        return this.requestType.getName();
    }

    public MRequestCategory getCategory() {
        if (this.getR_Category_ID() == 0) {
            return null;
        }
        return MRequestCategory.get(this.getCtx(), this.getR_Category_ID());
    }

    public String getCategoryName() {
        MRequestCategory cat = this.getCategory();
        if (cat == null) {
            return "";
        }
        return cat.getName();
    }

    public MGroup getGroup() {
        if (this.getR_Group_ID() == 0) {
            return null;
        }
        return MGroup.get(this.getCtx(), this.getR_Group_ID());
    }

    public String getGroupName() {
        MGroup grp = this.getGroup();
        if (grp == null) {
            return "";
        }
        return grp.getName();
    }

    public MStatus getStatus() {
        if (this.getR_Status_ID() == 0) {
            return null;
        }
        return MStatus.get(this.getCtx(), this.getR_Status_ID());
    }

    public String getStatusName() {
        MStatus sta = this.getStatus();
        if (sta == null) {
            return "?";
        }
        return sta.getName();
    }

    public MResolution getResolution() {
        if (this.getR_Resolution_ID() == 0) {
            return null;
        }
        return MResolution.get(this.getCtx(), this.getR_Resolution_ID());
    }

    public String getResolutionName() {
        MResolution res = this.getResolution();
        if (res == null) {
            return "";
        }
        return res.getName();
    }

    public boolean isOverdue() {
        return "3".equals(this.getDueType());
    }

    public boolean isDue() {
        return "5".equals(this.getDueType());
    }

    public String getDueTypeText() {
        return MRefList.getListName(this.getCtx(), 222, this.getDueType());
    }

    public String getPriorityText() {
        return MRefList.getListName(this.getCtx(), 154, this.getPriority());
    }

    public String getPriorityUserText() {
        return MRefList.getListName(this.getCtx(), 154, this.getPriorityUser());
    }

    public String getConfidentialText() {
        return MRefList.getListName(this.getCtx(), 340, this.getConfidentialType());
    }

    public String getConfidentialEntryText() {
        return MRefList.getListName(this.getCtx(), 340, this.getConfidentialTypeEntry());
    }

    public void setDateLastAlert() {
        super.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public MUser getSalesRep() {
        if (this.getSalesRep_ID() == 0) {
            return null;
        }
        return MUser.get(this.getCtx(), this.getSalesRep_ID());
    }

    public String getSalesRepName() {
        MUser sr = this.getSalesRep();
        if (sr == null) {
            return "n/a";
        }
        return sr.getName();
    }

    public String getCreatedByName() {
        MUser user = MUser.get(this.getCtx(), this.getCreatedBy());
        return user.getName();
    }

    public MUser getUser() {
        if (this.getAD_User_ID() == 0) {
            return null;
        }
        if (this.m_user != null && this.m_user.getAD_User_ID() != this.getAD_User_ID()) {
            this.m_user = null;
        }
        if (this.m_user == null) {
            this.m_user = new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
        }
        return this.m_user;
    }

    public MBPartner getBPartner() {
        if (this.getC_BPartner_ID() == 0) {
            return null;
        }
        if (this.m_partner != null && this.m_partner.getC_BPartner_ID() != this.getC_BPartner_ID()) {
            this.m_partner = null;
        }
        if (this.m_partner == null) {
            this.m_partner = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        }
        return this.m_partner;
    }

    public boolean isWebCanUpdate() {
        if (this.isProcessed()) {
            return false;
        }
        if (this.getR_Status_ID() == 0) {
            this.setR_Status_ID();
        }
        if (this.getR_Status_ID() == 0) {
            return false;
        }
        MStatus status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        if (status == null) {
            return false;
        }
        return status.isWebCanUpdate();
    }

    private void setPriority() {
        MBPGroup bpg;
        String prioBase;
        if (this.getPriorityUser() == null) {
            this.setPriorityUser("7");
        }
        if (this.getBPartner() != null && (prioBase = (bpg = MBPGroup.get(this.getCtx(), this.getBPartner().getC_BP_Group_ID())).getPriorityBase()) != null && !prioBase.equals("S")) {
            char targetPrio = this.getPriorityUser().charAt(0);
            targetPrio = prioBase.equals("L") ? (char)(targetPrio + 2) : (char)(targetPrio - 2);
            if (targetPrio < "3".charAt(0)) {
                targetPrio = "3".charAt(0);
            }
            if (targetPrio > "7".charAt(0)) {
                targetPrio = "7".charAt(0);
            }
            if (this.getPriority() == null) {
                this.setPriority(String.valueOf(targetPrio));
            } else if (targetPrio < this.getPriority().charAt(0)) {
                this.setPriority(String.valueOf(targetPrio));
            }
        }
        if (this.getPriority() == null) {
            this.setPriority(this.getPriorityUser());
        }
    }

    @Override
    public void setConfidentialTypeEntry(String ConfidentialTypeEntry) {
        if (ConfidentialTypeEntry == null) {
            ConfidentialTypeEntry = this.getConfidentialType();
        }
        if ("I".equals(this.getConfidentialType())) {
            super.setConfidentialTypeEntry("I");
        } else if ("P".equals(this.getConfidentialType())) {
            if ("I".equals(ConfidentialTypeEntry) || "P".equals(ConfidentialTypeEntry)) {
                super.setConfidentialTypeEntry(ConfidentialTypeEntry);
            } else {
                super.setConfidentialTypeEntry("P");
            }
        } else if ("C".equals(this.getConfidentialType())) {
            if ("I".equals(ConfidentialTypeEntry) || "P".equals(ConfidentialTypeEntry) || "C".equals(ConfidentialTypeEntry)) {
                super.setConfidentialTypeEntry(ConfidentialTypeEntry);
            } else {
                super.setConfidentialTypeEntry("C");
            }
        } else if ("A".equals(this.getConfidentialType())) {
            super.setConfidentialTypeEntry(ConfidentialTypeEntry);
        }
    }

    public boolean webUpdate(String result) {
        MStatus status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        if (!status.isWebCanUpdate()) {
            return false;
        }
        if (status.getUpdate_Status_ID() > 0) {
            this.setR_Status_ID(status.getUpdate_Status_ID());
        }
        this.setResult(result);
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRequest[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append("-").append(this.getSummary()).append("]");
        return sb.toString();
    }

    public File createPDF() {
        return null;
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        I_C_ProjectTask projectTask;
        I_C_ProjectPhase projectPhase;
        if (newRecord || this.is_ValueChanged("R_RequestType_ID")) {
            if (this.getRequestType() != null) {
                if (this.isInvoiced() != this.getRequestType().isInvoiced()) {
                    this.setIsInvoiced(this.getRequestType().isInvoiced());
                }
                if (this.getDateNextAction() == null && this.getRequestType().getAutoDueDateDays() > 0) {
                    this.setDateNextAction(TimeUtil.addDays(new Timestamp(System.currentTimeMillis()), this.getRequestType().getAutoDueDateDays()));
                }
            }
            if (this.getR_Status_ID() != 0) {
                MStatus sta = MStatus.get(this.getCtx(), this.getR_Status_ID());
                MRequestType rt = MRequestType.get(this.getCtx(), this.getR_RequestType_ID());
                if (sta.getR_StatusCategory_ID() != rt.getR_StatusCategory_ID()) {
                    this.setR_Status_ID();
                }
            }
        }
        if (this.isInvoiced()) {
            Optional.ofNullable(this.getResult()).ifPresent(result -> {
                Optional<BigDecimal> maybeQuantityToInvoice = Optional.ofNullable(this.getQtyInvoiced());
                if (maybeQuantityToInvoice.isPresent() && maybeQuantityToInvoice.get().signum() == 0) {
                    throw new AdempiereException("@R_Request_ID@ @IsInvoiced@ @And@ @QtyInvoiced@ @NotFound@");
                }
            });
        }
        if (this.getR_Status_ID() == 0) {
            this.setR_Status_ID();
        }
        this.setDueType();
        MStatus status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        if (status != null) {
            if (status.isOpen()) {
                if (this.getStartDate() == null) {
                    this.setStartDate(new Timestamp(System.currentTimeMillis()));
                }
                if (this.getCloseDate() != null) {
                    this.setCloseDate(null);
                }
            }
            if (status.isClosed() && this.getCloseDate() == null) {
                this.setCloseDate(new Timestamp(System.currentTimeMillis()));
            }
            if (status.isFinalClose()) {
                this.setProcessed(true);
            }
        }
        if (this.getConfidentialType() == null) {
            String ct;
            if (this.getRequestType() != null && (ct = this.getRequestType().getConfidentialType()) != null) {
                this.setConfidentialType(ct);
            }
            if (this.getConfidentialType() == null) {
                this.setConfidentialType("A");
            }
        }
        if (this.getConfidentialTypeEntry() == null) {
            this.setConfidentialTypeEntry(this.getConfidentialType());
        } else {
            this.setConfidentialTypeEntry(this.getConfidentialTypeEntry());
        }
        this.setPriority();
        if (this.getC_ProjectPhase_ID() > 0 && (projectPhase = this.getC_ProjectPhase()) != null && this.getC_Project_ID() <= 0) {
            this.setC_Project_ID(projectPhase.getC_Project_ID());
        }
        if (this.getC_ProjectTask_ID() > 0 && (projectTask = this.getC_ProjectTask()) != null && this.getC_ProjectPhase_ID() <= 0) {
            this.setC_ProjectPhase_ID(projectTask.getC_ProjectPhase_ID());
        }
        if (newRecord) {
            return true;
        }
        this.m_changed = false;
        ArrayList<String> sendInfo = new ArrayList<String>();
        MRequestAction requestAction = new MRequestAction(this, false);
        if (this.checkChange(requestAction, "R_RequestType_ID")) {
            sendInfo.add("R_RequestType_ID");
        }
        if (this.checkChange(requestAction, "R_Group_ID")) {
            sendInfo.add("R_Group_ID");
        }
        if (this.checkChange(requestAction, "R_Category_ID")) {
            sendInfo.add("R_Category_ID");
        }
        if (this.checkChange(requestAction, "R_Status_ID")) {
            sendInfo.add("R_Status_ID");
        }
        if (this.checkChange(requestAction, "R_Resolution_ID")) {
            sendInfo.add("R_Resolution_ID");
        }
        if (this.checkChange(requestAction, "SalesRep_ID")) {
            int AD_User_ID = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
            if (AD_User_ID == 0) {
                AD_User_ID = this.getUpdatedBy();
            }
            Object oo = this.get_ValueOld("SalesRep_ID");
            int oldSalesRep_ID = 0;
            if (oo instanceof Integer) {
                oldSalesRep_ID = (Integer)oo;
            }
            if (oldSalesRep_ID != 0) {
                Object[] args = new Object[]{this.getDocumentNo(), MUser.getNameOfUser(AD_User_ID), MUser.getNameOfUser(oldSalesRep_ID), MUser.getNameOfUser(this.getSalesRep_ID())};
                String msg = Msg.getMsg(this.getCtx(), "RequestActionTransfer", args);
                this.addToResult(msg);
                sendInfo.add("SalesRep_ID");
            }
        }
        this.checkChange(requestAction, "AD_Role_ID");
        this.checkChange(requestAction, "Priority");
        if (this.checkChange(requestAction, "PriorityUser")) {
            sendInfo.add("PriorityUser");
        }
        if (this.checkChange(requestAction, "IsEscalated")) {
            sendInfo.add("IsEscalated");
        }
        this.checkChange(requestAction, "ConfidentialType");
        this.checkChange(requestAction, "Summary");
        this.checkChange(requestAction, "IsSelfService");
        this.checkChange(requestAction, "C_BPartner_ID");
        this.checkChange(requestAction, "AD_User_ID");
        this.checkChange(requestAction, "C_Project_ID");
        this.checkChange(requestAction, "A_Asset_ID");
        this.checkChange(requestAction, "C_Order_ID");
        this.checkChange(requestAction, "C_Invoice_ID");
        this.checkChange(requestAction, "M_Product_ID");
        this.checkChange(requestAction, "C_Payment_ID");
        this.checkChange(requestAction, "M_InOut_ID");
        this.checkChange(requestAction, "M_RMA_ID");
        this.checkChange(requestAction, "C_Campaign_ID");
        this.checkChange(requestAction, "RequestAmt");
        this.checkChange(requestAction, "IsInvoiced");
        this.checkChange(requestAction, "C_Activity_ID");
        this.checkChange(requestAction, "DateNextAction");
        this.checkChange(requestAction, "M_ProductSpent_ID");
        this.checkChange(requestAction, "QtySpent");
        this.checkChange(requestAction, "QtyInvoiced");
        this.checkChange(requestAction, "StartDate");
        this.checkChange(requestAction, "CloseDate");
        this.checkChange(requestAction, "TaskStatus");
        this.checkChange(requestAction, "DateStartPlan");
        this.checkChange(requestAction, "DateCompletePlan");
        if (this.m_changed) {
            requestAction.saveEx();
        }
        MRequestUpdate requestUpdate = new MRequestUpdate(this);
        if (requestAction.getR_RequestAction_ID() > 0) {
            requestUpdate.setR_RequestAction_ID(requestAction.getR_RequestAction_ID());
        }
        if (requestUpdate.isNewInfo()) {
            requestUpdate.saveEx();
        } else {
            requestUpdate = null;
        }
        this.m_emailTo = new StringBuffer();
        if (requestUpdate != null || sendInfo.size() > 0) {
            if (this.checkChange(requestAction, "SalesRep_ID")) {
                this.sendNotices(sendInfo, "SRATR");
            } else if (this.checkChange(requestAction, "Summary")) {
                this.sendNotices(sendInfo, "EULON");
            }
            this.sendNotices(sendInfo, "ATNAN");
            this.setDateLastAction(this.getUpdated());
            this.setLastResult(this.getResult());
            this.setDueType();
            this.setConfidentialTypeEntry(this.getConfidentialType());
            this.setEndTime(null);
            this.setR_StandardResponse_ID(0);
            this.setR_MailText_ID(0);
            this.setResult(null);
        }
        return true;
    }

    private boolean checkChange(MRequestAction requestAction, String columnName) {
        if (this.is_ValueChanged(columnName)) {
            Object value = this.get_ValueOld(columnName);
            if (value == null) {
                requestAction.addNullColumn(columnName);
            } else {
                requestAction.set_ValueNoCheck(columnName, value);
            }
            this.m_changed = true;
            return true;
        }
        return false;
    }

    @Override
    public void setSalesRep_ID(int SalesRep_ID) {
        if (SalesRep_ID != 0) {
            super.setSalesRep_ID(SalesRep_ID);
        } else if (this.getSalesRep_ID() != 0) {
            this.log.warning("Ignored - Tried to set SalesRep_ID to 0 from " + this.getSalesRep_ID());
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord && this.getResult() != null) {
            MRequestUpdate update = new MRequestUpdate(this);
            update.saveEx();
        }
        if (newRecord) {
            this.sendNotices(new ArrayList<String>(), "EUNRN");
        }
        if (this.getM_ChangeRequest_ID() != 0 && this.is_ValueChanged("R_Group_ID")) {
            int oldID = this.get_ValueOldAsInt("R_Group_ID");
            if (this.getR_Group_ID() == 0) {
                this.setM_ChangeRequest_ID(0);
            } else {
                MChangeRequest ecr;
                MGroup oldG = MGroup.get(this.getCtx(), oldID);
                MGroup newG = MGroup.get(this.getCtx(), this.getR_Group_ID());
                if (!(oldG.getPP_Product_BOM_ID() == newG.getPP_Product_BOM_ID() && oldG.getM_ChangeNotice_ID() == newG.getM_ChangeNotice_ID() || (ecr = new MChangeRequest(this.getCtx(), this.getM_ChangeRequest_ID(), this.get_TrxName())).isProcessed() && ecr.getM_FixChangeNotice_ID() != 0)) {
                    ecr.setPP_Product_BOM_ID(newG.getPP_Product_BOM_ID());
                    ecr.setM_ChangeNotice_ID(newG.getM_ChangeNotice_ID());
                    ecr.saveEx();
                }
            }
        }
        if (this.m_emailTo.length() > 0) {
            this.log.saveInfo("RequestActionEMailOK", this.m_emailTo.toString());
        }
        return success;
    }

    public void sendNotices(ArrayList<String> list, String eventType) {
        MMailText mailText;
        String subject = "";
        String message = new String();
        int updatedBy = Env.getAD_User_ID(this.getCtx());
        MUser from = MUser.get(this.getCtx(), updatedBy);
        if (!Util.isEmpty(eventType) && (mailText = MRNoticeTemplate.getMailTemplate(this.getCtx(), "R", eventType)) != null) {
            mailText.setUser(from);
            if (this.getC_BPartner_ID() != 0) {
                mailText.setBPartner(this.getC_BPartner_ID());
            }
            mailText.setPO(this);
            subject = mailText.getMailHeader();
            message = mailText.getMailText(true);
            StringBuffer localMessage = new StringBuffer();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String columnName = list.get(i2);
                localMessage.append(Env.NL).append(Msg.getElement(this.getCtx(), columnName)).append(": ").append(this.get_DisplayValue(columnName, false)).append(" -> ").append(this.get_DisplayValue(columnName, true));
            }
            message = message + localMessage.toString();
        }
        if (Util.isEmpty(subject) && Util.isEmpty(message)) {
            StringBuffer localMessage = new StringBuffer();
            subject = Msg.translate(this.getCtx(), "R_Request_ID") + " " + Msg.getMsg(this.getCtx(), "Updated") + ": " + this.getDocumentNo();
            if (from != null) {
                localMessage.append(Msg.translate(this.getCtx(), "UpdatedBy")).append(": ").append(from.getName());
            }
            if (this.getDateLastAction() != null) {
                localMessage.append("\n").append(Msg.translate(this.getCtx(), "DateLastAction")).append(": ").append(this.getDateLastAction());
            } else {
                localMessage.append("\n").append(Msg.translate(this.getCtx(), "Created")).append(": ").append(this.getCreated());
            }
            for (int i3 = 0; i3 < list.size(); ++i3) {
                String columnName = list.get(i3);
                localMessage.append("\n").append(Msg.getElement(this.getCtx(), columnName)).append(": ").append(this.get_DisplayValue(columnName, false)).append(" -> ").append(this.get_DisplayValue(columnName, true));
            }
            if (this.getDateNextAction() != null) {
                localMessage.append("\n").append(Msg.translate(this.getCtx(), "DateNextAction")).append(": ").append(this.getDateNextAction());
            }
            localMessage.append(SEPARATOR).append(this.getSummary());
            if (this.getResult() != null) {
                localMessage.append("\n----------\n").append(this.getResult());
            }
            localMessage.append(this.getMailTrailer(null));
            message = localMessage.toString();
        }
        File pdf = this.createPDF();
        this.log.finer(message);
        MClient client = MClient.get(this.getCtx());
        if (from.getEMailUser() == null || from.getEMailUserPW() == null) {
            from = null;
        }
        int success = 0;
        int failure = 0;
        int notices = 0;
        ArrayList<Integer> userList = new ArrayList<Integer>();
        String sql = "SELECT u.AD_User_ID, u.NotificationType, u.EMail, u.Name, MAX(r.AD_Role_ID) FROM RV_RequestUpdates_Only ru INNER JOIN AD_User u ON (ru.AD_User_ID=u.AD_User_ID OR u.AD_User_ID=?) LEFT OUTER JOIN AD_User_Roles r ON (u.AD_User_ID=r.AD_User_ID) WHERE ru.R_Request_ID=? GROUP BY u.AD_User_ID, u.NotificationType, u.EMail, u.Name";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT u.AD_User_ID, u.NotificationType, u.EMail, u.Name, MAX(r.AD_Role_ID) FROM RV_RequestUpdates_Only ru INNER JOIN AD_User u ON (ru.AD_User_ID=u.AD_User_ID OR u.AD_User_ID=?) LEFT OUTER JOIN AD_User_Roles r ON (u.AD_User_ID=r.AD_User_ID) WHERE ru.R_Request_ID=? GROUP BY u.AD_User_ID, u.NotificationType, u.EMail, u.Name", this.get_TrxName());
            pstmt.setInt(1, this.getSalesRep_ID());
            pstmt.setInt(2, this.getR_Request_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int userId = rs.getInt(1);
                String notificationType = rs.getString(2);
                if (notificationType == null) {
                    notificationType = "E";
                }
                String email = rs.getString(3);
                String Name2 = rs.getString(4);
                int roleId = rs.getInt(5);
                if (rs.wasNull()) {
                    roleId = -1;
                }
                Boolean isIncludeOwnChanges = false;
                if (from != null) {
                    isIncludeOwnChanges = from.isIncludeOwnChanges();
                }
                if (userId == updatedBy && !isIncludeOwnChanges.booleanValue() || roleId == -1 && (this.getConfidentialTypeEntry().equals("I") || this.getConfidentialTypeEntry().equals("P"))) continue;
                if ("X".equals(notificationType)) {
                    this.log.config("Opt out: " + Name2);
                    continue;
                }
                if (("E".equals(notificationType) || "B".equals(notificationType)) && (email == null || email.length() == 0)) {
                    if (roleId >= 0) {
                        notificationType = "N";
                    } else {
                        this.log.config("No EMail: " + Name2);
                        continue;
                    }
                }
                if ("N".equals(notificationType) && roleId >= 0) {
                    this.log.config("No internal User: " + Name2);
                    continue;
                }
                Integer ii = new Integer(userId);
                if (userList.contains(ii)) continue;
                userList.add(ii);
                MUser to = MUser.get(this.getCtx(), userId);
                if ("E".equals(notificationType) || "B".equals(notificationType)) {
                    if (client.sendEMail(from, to, subject, message, pdf)) {
                        ++success;
                        if (this.m_emailTo.length() > 0) {
                            this.m_emailTo.append(", ");
                        }
                        this.m_emailTo.append(to.getEMail());
                    } else {
                        this.log.warning("Failed: " + Name2);
                        ++failure;
                        notificationType = "N";
                    }
                }
                if (!"N".equals(notificationType) && !"B".equals(notificationType)) continue;
                int AD_Message_ID = 834;
                MNote note = new MNote(this.getCtx(), AD_Message_ID, userId, X_R_Request.Table_ID, this.getR_Request_ID(), subject, message, this.get_TrxName());
                if (!note.save()) continue;
                ++notices;
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, "SELECT u.AD_User_ID, u.NotificationType, u.EMail, u.Name, MAX(r.AD_Role_ID) FROM RV_RequestUpdates_Only ru INNER JOIN AD_User u ON (ru.AD_User_ID=u.AD_User_ID OR u.AD_User_ID=?) LEFT OUTER JOIN AD_User_Roles r ON (u.AD_User_ID=r.AD_User_ID) WHERE ru.R_Request_ID=? GROUP BY u.AD_User_ID, u.NotificationType, u.EMail, u.Name");
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.log.info("EMail Success=" + success + ", Failure=" + failure + " - Notices=" + notices);
    }

    public String getMailTrailer(String serverAddress) {
        StringBuffer sb = new StringBuffer("\n").append(SEPARATOR).append(Msg.translate(this.getCtx(), "R_Request_ID")).append(": ").append(this.getDocumentNo()).append("  ").append(this.getMailTag()).append("\nSent by AdempiereMail");
        if (serverAddress != null) {
            sb.append(" from ").append(serverAddress);
        }
        return sb.toString();
    }

    public String getMailTag() {
        return TAG_START + this.get_ID() + TAG_END;
    }

    public void doClose() {
        MStatus status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        if (!status.isClosed()) {
            MStatus[] closed = MStatus.getClosed(this.getCtx());
            X_R_Status newStatus = null;
            for (int i2 = 0; i2 < closed.length; ++i2) {
                if (closed[i2].isFinalClose()) continue;
                newStatus = closed[i2];
                break;
            }
            if (newStatus == null && closed.length > 0) {
                newStatus = closed[0];
            }
            if (newStatus != null) {
                this.setR_Status_ID(newStatus.getR_Status_ID());
            }
        }
    }

    public void doEscalate(boolean user) {
        if (user) {
            String Importance = this.getPriorityUser();
            if (!"1".equals(Importance)) {
                if ("3".equals(Importance)) {
                    this.setPriorityUser("1");
                } else if ("5".equals(Importance)) {
                    this.setPriorityUser("3");
                } else if ("7".equals(Importance)) {
                    this.setPriorityUser("5");
                } else if ("9".equals(Importance)) {
                    this.setPriorityUser("7");
                }
            }
        } else {
            String Importance = this.getPriority();
            if (!"1".equals(Importance)) {
                if ("3".equals(Importance)) {
                    this.setPriority("1");
                } else if ("5".equals(Importance)) {
                    this.setPriority("3");
                } else if ("7".equals(Importance)) {
                    this.setPriority("5");
                } else if ("9".equals(Importance)) {
                    this.setPriority("7");
                }
            }
        }
    }
}

